/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.GString;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskInputs
implements TaskInputs {
    private final DefaultConfigurableFileCollection inputFiles;
    private final DefaultConfigurableFileCollection sourceFiles;
    private final FileResolver resolver;
    private final TaskMutator taskMutator;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public DefaultTaskInputs(FileResolver resolver, TaskInternal task, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.taskMutator = taskMutator;
        this.inputFiles = new DefaultConfigurableFileCollection(task + " input files", resolver, null, new Object[0]);
        this.sourceFiles = new DefaultConfigurableFileCollection(task + " source files", resolver, null, new Object[0]);
    }

    @Override
    public boolean getHasInputs() {
        return !this.inputFiles.getFrom().isEmpty() || !this.properties.isEmpty() || !this.sourceFiles.getFrom().isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return new UnionFileCollection(this.inputFiles, this.sourceFiles);
    }

    @Override
    public TaskInputs files(final Object ... paths) {
        this.taskMutator.mutate("TaskInputs.files(Object...)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.inputFiles.from(paths);
            }
        });
        return this;
    }

    @Override
    public TaskInputs file(final Object path) {
        this.taskMutator.mutate("TaskInputs.file(Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.inputFiles.from(path);
            }
        });
        return this;
    }

    @Override
    public TaskInputs dir(final Object dirPath) {
        this.taskMutator.mutate("TaskInputs.dir(Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.inputFiles.from(DefaultTaskInputs.this.resolver.resolveFilesAsTree(dirPath));
            }
        });
        return this;
    }

    @Override
    public boolean getHasSourceFiles() {
        return !this.sourceFiles.getFrom().isEmpty();
    }

    @Override
    public FileCollection getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public TaskInputs source(final Object ... paths) {
        this.taskMutator.mutate("TaskInputs.source(Object...)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.sourceFiles.from(paths);
            }
        });
        return this;
    }

    @Override
    public TaskInputs source(final Object path) {
        this.taskMutator.mutate("TaskInputs.source(Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.sourceFiles.from(path);
            }
        });
        return this;
    }

    @Override
    public TaskInputs sourceDir(final Object path) {
        this.taskMutator.mutate("TaskInputs.sourceDir(Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.sourceFiles.from(DefaultTaskInputs.this.resolver.resolveFilesAsTree(path));
            }
        });
        return this;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> actualProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object value = this.prepareValue(entry.getValue());
            actualProperties.put(entry.getKey(), value);
        }
        return actualProperties;
    }

    private Object prepareValue(Object value) {
        while (value instanceof Callable) {
            Callable callable = (Callable)value;
            value = GUtil.uncheckedCall((Callable)callable);
        }
        if (value instanceof FileCollection) {
            FileCollection fileCollection = (FileCollection)value;
            return fileCollection.getFiles();
        }
        return DefaultTaskInputs.avoidGString(value);
    }

    private static Object avoidGString(Object value) {
        return value instanceof GString ? value.toString() : value;
    }

    @Override
    public TaskInputs property(final String name, final Object value) {
        this.taskMutator.mutate("TaskInputs.property(String, Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.properties.put(name, value);
            }
        });
        return this;
    }

    @Override
    public TaskInputs properties(final Map<String, ?> newProps) {
        this.taskMutator.mutate("TaskInputs.properties(Map)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.properties.putAll(newProps);
            }
        });
        return this;
    }
}

