/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;

public class JvmVersionDetector {
    private final Map<JavaInfo, JavaVersion> javaHomeResults = new HashMap<JavaInfo, JavaVersion>();
    private final Map<String, JavaVersion> javaCmdResults = new HashMap<String, JavaVersion>();
    private final ExecHandleFactory execHandleFactory;

    public JvmVersionDetector(ExecHandleFactory execHandleFactory) {
        this.execHandleFactory = execHandleFactory;
        this.javaHomeResults.put((JavaInfo)Jvm.current(), JavaVersion.current());
        this.javaCmdResults.put(Jvm.current().getJavaExecutable().getPath(), JavaVersion.current());
    }

    public JavaVersion getJavaVersion(JavaInfo jvm) {
        JavaVersion version = this.javaHomeResults.get(jvm);
        if (version != null) {
            return version;
        }
        version = this.getJavaVersion(jvm.getJavaExecutable().getPath());
        this.javaHomeResults.put(jvm, version);
        return version;
    }

    public JavaVersion getJavaVersion(String javaCommand) {
        JavaVersion version = this.javaCmdResults.get(javaCommand);
        if (version != null) {
            return version;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ExecHandleBuilder builder = this.execHandleFactory.newExec();
        builder.setWorkingDir((Object)new File(".").getAbsolutePath());
        builder.setCommandLine(new Object[]{javaCommand, "-version"});
        builder.setStandardOutput((OutputStream)new ByteArrayOutputStream());
        builder.setErrorOutput((OutputStream)outputStream);
        builder.build().start().waitForFinish().assertNormalExitValue();
        version = this.parseJavaVersionCommandOutput(javaCommand, new BufferedReader(new InputStreamReader(new ByteArrayInputStream(outputStream.toByteArray()))));
        this.javaCmdResults.put(javaCommand, version);
        return version;
    }

    JavaVersion parseJavaVersionCommandOutput(String javaExecutable, BufferedReader reader) {
        try {
            String versionStr = reader.readLine();
            while (versionStr != null) {
                Matcher matcher = Pattern.compile("(?:java|openjdk) version \"(.+?)\"").matcher(versionStr);
                if (matcher.matches()) {
                    return JavaVersion.toVersion((Object)matcher.group(1));
                }
                versionStr = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        throw new GradleException(String.format("Could not determine Java version using executable %s.", javaExecutable));
    }
}

