/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyDependencyPublisher;
import org.gradle.internal.component.external.model.DefaultIvyModulePublishMetaData;
import org.gradle.internal.component.external.model.IvyModuleArtifactPublishMetaData;
import org.gradle.internal.component.external.model.IvyModulePublishMetaData;
import org.gradle.internal.component.model.IvyArtifactName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIvyDependencyPublisher
implements IvyDependencyPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIvyDependencyPublisher.class);

    @Override
    public void publish(List<ModuleVersionPublisher> publishResolvers, IvyModulePublishMetaData publishMetaData) {
        try {
            DefaultIvyModulePublishMetaData publication = new DefaultIvyModulePublishMetaData(publishMetaData.getId(), publishMetaData.getModuleDescriptor());
            for (IvyModuleArtifactPublishMetaData artifact : publishMetaData.getArtifacts()) {
                this.addPublishedArtifact(artifact, publication);
            }
            for (ModuleVersionPublisher publisher : publishResolvers) {
                LOGGER.info("Publishing to {}", (Object)publisher);
                publisher.publish(publication);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private void addPublishedArtifact(IvyModuleArtifactPublishMetaData artifact, DefaultIvyModulePublishMetaData publication) {
        if (this.checkArtifactFileExists(artifact)) {
            publication.addArtifact(artifact);
        }
    }

    private boolean checkArtifactFileExists(IvyModuleArtifactPublishMetaData artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile.exists()) {
            return true;
        }
        if (!this.isSigningArtifact(artifact.getArtifactName())) {
            throw new PublishException(String.format("Cannot publish artifact '%s' (%s) as it does not exist.", artifact.getId(), artifactFile));
        }
        return false;
    }

    private boolean isSigningArtifact(IvyArtifactName artifact) {
        return artifact.getType().endsWith(".asc") || artifact.getType().endsWith(".sig");
    }
}

