/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.DependencyToConfigurationResolver;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ConfigurationMetaData;
import org.gradle.internal.component.model.DependencyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyToConfigurationResolver
implements DependencyToConfigurationResolver {
    @Override
    public Set<ConfigurationMetaData> resolveTargetConfigurations(DependencyMetaData dependencyMetaData, ConfigurationMetaData fromConfiguration, ComponentResolveMetaData targetComponent) {
        LinkedHashSet<String> targetConfigurationNames = new LinkedHashSet<String>();
        for (String config : dependencyMetaData.getModuleConfigurations()) {
            if (config.equals("*") || config.equals("%")) {
                this.collectTargetConfiguration(dependencyMetaData, fromConfiguration, fromConfiguration.getName(), targetComponent, targetConfigurationNames);
                continue;
            }
            if (!fromConfiguration.getHierarchy().contains(config)) continue;
            this.collectTargetConfiguration(dependencyMetaData, fromConfiguration, config, targetComponent, targetConfigurationNames);
        }
        LinkedHashSet<ConfigurationMetaData> targets = new LinkedHashSet<ConfigurationMetaData>();
        for (String targetConfigurationName : targetConfigurationNames) {
            ConfigurationMetaData targetConfiguration = targetComponent.getConfiguration(targetConfigurationName);
            targets.add(targetConfiguration);
        }
        return targets;
    }

    private void collectTargetConfiguration(DependencyMetaData dependencyDescriptor, ConfigurationMetaData fromConfiguration, String mappingRhs, ComponentResolveMetaData targetModule, Collection<String> targetConfigs) {
        String[] dependencyConfigurations;
        for (String target : dependencyConfigurations = dependencyDescriptor.getDependencyConfigurations(mappingRhs, fromConfiguration.getName())) {
            String candidate = target;
            int startFallback = candidate.indexOf(40);
            if (startFallback >= 0 && candidate.charAt(candidate.length() - 1) == ')') {
                String preferred = candidate.substring(0, startFallback);
                if (targetModule.getConfiguration(preferred) != null) {
                    targetConfigs.add(preferred);
                    continue;
                }
                candidate = candidate.substring(startFallback + 1, candidate.length() - 1);
            }
            if (candidate.equals("*")) {
                for (String configName : targetModule.getConfigurationNames()) {
                    if (!targetModule.getConfiguration(configName).isVisible()) continue;
                    targetConfigs.add(configName);
                }
                continue;
            }
            if (targetModule.getConfiguration(candidate) != null) {
                targetConfigs.add(candidate);
                continue;
            }
            throw new RuntimeException(String.format("Module version %s, configuration '%s' declares a dependency on configuration '%s' which is not declared in the module descriptor for %s", fromConfiguration.getComponent().getId(), fromConfiguration.getName(), target, targetModule.getId()));
        }
    }
}

