/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractCompositeExcludeRuleFilter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExcludeRuleFilter;
import org.gradle.internal.component.model.IvyArtifactName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnionExcludeRuleFilter
extends AbstractCompositeExcludeRuleFilter {
    private final List<AbstractModuleExcludeRuleFilter> filters;

    public UnionExcludeRuleFilter(List<AbstractModuleExcludeRuleFilter> filters) {
        this.filters = filters;
    }

    @Override
    Collection<AbstractModuleExcludeRuleFilter> getFilters() {
        return this.filters;
    }

    @Override
    protected void unpackUnion(Collection<AbstractModuleExcludeRuleFilter> specs) {
        specs.addAll(this.filters);
    }

    @Override
    protected boolean acceptsAllModules() {
        for (AbstractModuleExcludeRuleFilter excludeSpec : this.filters) {
            if (!excludeSpec.acceptsAllModules()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptModule(ModuleIdentifier element) {
        for (AbstractModuleExcludeRuleFilter spec : this.filters) {
            if (!spec.acceptModule(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        for (AbstractModuleExcludeRuleFilter spec : this.filters) {
            if (!spec.acceptArtifact(module, artifact)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAllArtifacts() {
        for (AbstractModuleExcludeRuleFilter spec : this.filters) {
            if (!spec.acceptsAllArtifacts()) continue;
            return true;
        }
        return false;
    }
}

