/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.announce.internal;

import java.awt.GraphicsEnvironment;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.plugins.announce.AnnouncePluginExtension;
import org.gradle.api.plugins.announce.Announcer;
import org.gradle.api.plugins.announce.internal.AnnouncerFactory;
import org.gradle.api.plugins.announce.internal.AnnouncerUnavailableException;
import org.gradle.api.plugins.announce.internal.GrowlNotifyBackedAnnouncer;
import org.gradle.api.plugins.announce.internal.IconProvider;
import org.gradle.api.plugins.announce.internal.IgnoreUnavailableAnnouncer;
import org.gradle.api.plugins.announce.internal.NotifySend;
import org.gradle.api.plugins.announce.internal.Snarl;
import org.gradle.api.plugins.announce.internal.Twitter;
import org.gradle.api.plugins.announce.internal.UnknownAnnouncer;
import org.gradle.api.plugins.announce.internal.jdk6.AppleScriptBackedGrowlAnnouncer;
import org.gradle.internal.os.OperatingSystem;

public class DefaultAnnouncerFactory
implements AnnouncerFactory {
    private final AnnouncePluginExtension announcePluginConvention;
    private final IconProvider iconProvider;
    private final ProcessOperations processOperations;

    public DefaultAnnouncerFactory(AnnouncePluginExtension announcePluginConvention, ProcessOperations processOperations, IconProvider iconProvider) {
        this.announcePluginConvention = announcePluginConvention;
        this.iconProvider = iconProvider;
        this.processOperations = processOperations;
    }

    public Announcer createAnnouncer(String type) {
        Announcer announcer = this.createActualAnnouncer(type);
        return announcer != null ? new IgnoreUnavailableAnnouncer(announcer) : new UnknownAnnouncer();
    }

    private Announcer createActualAnnouncer(String type) {
        if ("local".equals(type)) {
            if (OperatingSystem.current().isWindows()) {
                return this.createActualAnnouncer("snarl");
            }
            if (OperatingSystem.current().isMacOsX()) {
                return this.createActualAnnouncer("growl");
            }
            return this.createActualAnnouncer("notify-send");
        }
        if ("twitter".equals(type)) {
            String username = this.announcePluginConvention.getUsername();
            String password = this.announcePluginConvention.getPassword();
            return new Twitter(username, password);
        }
        if ("notify-send".equals(type)) {
            return new NotifySend(this.processOperations, this.iconProvider);
        }
        if ("snarl".equals(type)) {
            return new Snarl(this.iconProvider);
        }
        if ("growl".equals(type)) {
            if (!GraphicsEnvironment.isHeadless()) {
                try {
                    return new AppleScriptBackedGrowlAnnouncer(this.iconProvider);
                }
                catch (AnnouncerUnavailableException announcerUnavailableException) {
                    // empty catch block
                }
            }
            return new GrowlNotifyBackedAnnouncer(this.processOperations, this.iconProvider);
        }
        return null;
    }
}

