/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.announce.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.plugins.announce.internal.AnnouncerUnavailableException;
import org.gradle.api.plugins.announce.internal.Growl;
import org.gradle.api.plugins.announce.internal.IconProvider;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecSpec;

public class GrowlNotifyBackedAnnouncer
extends Growl {
    private final ProcessOperations processOperations;
    private final IconProvider iconProvider;

    public GrowlNotifyBackedAnnouncer(ProcessOperations processOperations, IconProvider iconProvider) {
        this.processOperations = processOperations;
        this.iconProvider = iconProvider;
    }

    public void send(final String title, final String message) {
        final File exe = OperatingSystem.current().findInPath("growlnotify");
        if (exe == null) {
            throw new AnnouncerUnavailableException("Could not find 'growlnotify' in path.");
        }
        this.processOperations.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.executable((Object)exe);
                execSpec.args(new Object[]{"-m", message});
                File icon = GrowlNotifyBackedAnnouncer.this.iconProvider.getIcon(48, 48);
                if (icon != null) {
                    execSpec.args(new Object[]{"--image", icon.getAbsolutePath()});
                }
                execSpec.args(new Object[]{"-t", title});
            }
        });
    }
}

