/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeBuildContext;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeContextBuilder;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeScopeServices;
import org.gradle.api.logging.LogLevel;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.Cast;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.composite.CompositeBuildActionParameters;
import org.gradle.internal.composite.CompositeBuildActionRunner;
import org.gradle.internal.composite.CompositeBuildController;
import org.gradle.internal.composite.CompositeParameters;
import org.gradle.internal.composite.GradleParticipantBuild;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.launcher.daemon.configuration.DaemonUsage;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.launcher.exec.InProcessBuildActionExecuter;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.provider.BuildActionResult;
import org.gradle.tooling.internal.provider.BuildModelAction;
import org.gradle.tooling.internal.provider.PayloadSerializer;
import org.gradle.tooling.internal.provider.runner.BuildModelActionRunner;
import org.gradle.tooling.internal.provider.runner.BuildModelsActionRunner;
import org.gradle.tooling.internal.provider.runner.SubscribableBuildActionRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeBuildModelActionRunner
implements CompositeBuildActionRunner {
    public void run(BuildAction action, BuildRequestContext requestContext, CompositeBuildActionParameters actionParameters, CompositeBuildController buildController) {
        if (!(action instanceof BuildModelAction)) {
            return;
        }
        BuildModelAction buildModelAction = (BuildModelAction)action;
        List<Object> results = null;
        if (this.isModelRequest(buildModelAction)) {
            results = this.fetchCompositeModelsInProcess(buildModelAction, requestContext, actionParameters.getCompositeParameters(), buildController.getBuildScopeServices());
        } else {
            if (!buildModelAction.isRunTasks()) {
                throw new IllegalStateException("No tasks defined.");
            }
            this.executeTasksInProcess(buildModelAction, actionParameters, requestContext, buildController.getBuildScopeServices());
        }
        PayloadSerializer payloadSerializer = (PayloadSerializer)buildController.getBuildScopeServices().get(PayloadSerializer.class);
        buildController.setResult((Object)new BuildActionResult(payloadSerializer.serialize(results), null));
    }

    private boolean isModelRequest(BuildModelAction action) {
        String requestedModelName = action.getModelName();
        return !requestedModelName.equals(Void.class.getName());
    }

    private List<Object> fetchCompositeModelsInProcess(BuildModelAction modelAction, BuildRequestContext buildRequestContext, CompositeParameters compositeParameters, ServiceRegistry sharedServices) {
        DefaultServiceRegistry compositeServices = this.createCompositeAwareServices(modelAction, buildRequestContext, compositeParameters, sharedServices);
        SubscribableBuildActionRunner runner = new SubscribableBuildActionRunner(new BuildModelsActionRunner());
        InProcessBuildActionExecuter buildActionExecuter = new InProcessBuildActionExecuter((GradleLauncherFactory)sharedServices.get(GradleLauncherFactory.class), (BuildActionRunner)runner);
        ArrayList results = Lists.newArrayList();
        for (GradleParticipantBuild participant : compositeParameters.getBuilds()) {
            DefaultBuildActionParameters actionParameters = new DefaultBuildActionParameters(Collections.EMPTY_MAP, Collections.emptyMap(), participant.getProjectDir(), LogLevel.INFO, DaemonUsage.EXPLICITLY_DISABLED, false, true, ClassPath.EMPTY);
            StartParameter startParameter = modelAction.getStartParameter().newInstance();
            startParameter.setProjectDir(participant.getProjectDir());
            BuildSessionScopeServices buildScopedServices = new BuildSessionScopeServices((ServiceRegistry)compositeServices, startParameter, ClassPath.EMPTY);
            BuildModelAction participantAction = new BuildModelAction(startParameter, modelAction.getModelName(), false, modelAction.getClientSubscriptions());
            try {
                Map result = (Map)Cast.uncheckedCast((Object)buildActionExecuter.execute((BuildAction)participantAction, buildRequestContext, (Object)actionParameters, (ServiceRegistry)buildScopedServices));
                for (Map.Entry e : result.entrySet()) {
                    String projectPath = (String)e.getKey();
                    Object modelValue = e.getValue();
                    results.add(this.compositeModelResult(participant, projectPath, modelValue));
                }
            }
            catch (BuildCancelledException e) {
                InternalBuildCancelledException buildCancelledException = new InternalBuildCancelledException(e.getCause());
                results.add(this.compositeModelResult(participant, null, buildCancelledException));
            }
            catch (ReportedException e) {
                results.add(this.compositeModelResult(participant, null, this.unwrap(e)));
            }
            catch (Exception e) {
                results.add(this.compositeModelResult(participant, null, e));
            }
        }
        return results;
    }

    private void executeTasksInProcess(BuildModelAction compositeAction, CompositeBuildActionParameters actionParameters, BuildRequestContext buildRequestContext, ServiceRegistry sharedServices) {
        GradleLauncherFactory gradleLauncherFactory = (GradleLauncherFactory)sharedServices.get(GradleLauncherFactory.class);
        CompositeParameters compositeParameters = actionParameters.getCompositeParameters();
        DefaultServiceRegistry compositeServices = this.createCompositeAwareServices(compositeAction, buildRequestContext, compositeParameters, sharedServices);
        StartParameter startParameter = compositeAction.getStartParameter().newInstance();
        startParameter.setProjectDir(compositeParameters.getTargetBuild().getProjectDir());
        startParameter.setSearchUpwards(false);
        startParameter.setSystemPropertiesArgs(Collections.singletonMap("org.gradle.resolution.assumeFluidDependencies", "true"));
        SubscribableBuildActionRunner runner = new SubscribableBuildActionRunner(new BuildModelActionRunner());
        InProcessBuildActionExecuter buildActionExecuter = new InProcessBuildActionExecuter(gradleLauncherFactory, (BuildActionRunner)runner);
        BuildModelAction participantAction = new BuildModelAction(startParameter, ModelIdentifier.NULL_MODEL, true, compositeAction.getClientSubscriptions());
        BuildSessionScopeServices buildScopedServices = new BuildSessionScopeServices((ServiceRegistry)compositeServices, startParameter, ClassPath.EMPTY);
        buildActionExecuter.execute((BuildAction)participantAction, buildRequestContext, null, (ServiceRegistry)buildScopedServices);
    }

    private Exception unwrap(ReportedException e) {
        for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
            if (!(t instanceof BuildCancelledException)) continue;
            return new InternalBuildCancelledException(e.getCause());
        }
        return new BuildExceptionVersion1(e.getCause());
    }

    private Object compositeModelResult(GradleParticipantBuild participant, String projectPath, Object modelValue) {
        return new Object[]{participant.getProjectDir(), projectPath, modelValue};
    }

    private DefaultServiceRegistry createCompositeAwareServices(BuildModelAction modelAction, BuildRequestContext buildRequestContext, CompositeParameters compositeParameters, ServiceRegistry sharedServices) {
        boolean propagateFailures = ModelIdentifier.NULL_MODEL.equals(modelAction.getModelName());
        CompositeBuildContext context = this.constructCompositeContext(modelAction, buildRequestContext, compositeParameters, sharedServices, propagateFailures);
        DefaultServiceRegistry compositeServices = (DefaultServiceRegistry)ServiceRegistryBuilder.builder().displayName("Composite services").parent(sharedServices).build();
        compositeServices.add(CompositeBuildContext.class, (Object)context);
        compositeServices.addProvider((Object)new CompositeScopeServices(modelAction.getStartParameter(), (ServiceRegistry)compositeServices));
        return compositeServices;
    }

    private CompositeBuildContext constructCompositeContext(BuildModelAction modelAction, BuildRequestContext buildRequestContext, CompositeParameters compositeParameters, ServiceRegistry sharedServices, boolean propagateFailures) {
        GradleLauncherFactory gradleLauncherFactory = (GradleLauncherFactory)sharedServices.get(GradleLauncherFactory.class);
        CompositeContextBuilder builder = new CompositeContextBuilder(propagateFailures);
        InProcessBuildActionExecuter buildActionExecuter = new InProcessBuildActionExecuter(gradleLauncherFactory, (BuildActionRunner)builder);
        for (GradleParticipantBuild participant : compositeParameters.getBuilds()) {
            StartParameter startParameter = modelAction.getStartParameter().newInstance();
            startParameter.setProjectDir(participant.getProjectDir());
            startParameter.setConfigureOnDemand(false);
            BuildModelAction configureAction = new BuildModelAction(startParameter, ModelIdentifier.NULL_MODEL, false, modelAction.getClientSubscriptions());
            buildActionExecuter.execute((BuildAction)configureAction, buildRequestContext, null, sharedServices);
        }
        return builder.build();
    }
}

