/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.internal;

import java.io.File;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeExecutableFileSpec;
import org.gradle.nativeplatform.NativeInstallationSpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.NativeComponents;
import org.gradle.nativeplatform.internal.configure.NativeBinaryRules;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.NativeTestSuiteSpec;
import org.gradle.nativeplatform.test.internal.NativeTestSuiteBinarySpecInternal;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.ToolChain;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.testing.base.TestSuiteContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeTestSuites {
    public static <S extends NativeTestSuiteBinarySpec> void createNativeTestSuiteBinaries(ModelMap<S> binaries, NativeTestSuiteSpec testSuite, Class<S> testSuiteBinaryClass, String typeString, File buildDir, ServiceRegistry serviceRegistry) {
        for (NativeBinarySpec testedBinary : NativeTestSuites.testedBinariesOf(testSuite)) {
            if (testedBinary instanceof SharedLibraryBinary) continue;
            NativeTestSuites.createNativeTestSuiteBinary(binaries, testSuite, testSuiteBinaryClass, typeString, testedBinary, buildDir, serviceRegistry);
        }
    }

    private static <S extends NativeTestSuiteBinarySpec> void createNativeTestSuiteBinary(ModelMap<S> binaries, NativeTestSuiteSpec testSuite, Class<S> testSuiteBinaryClass, String typeString, final NativeBinarySpec testedBinary, final File buildDir, ServiceRegistry serviceRegistry) {
        final BinaryNamingScheme namingScheme = NativeTestSuites.namingSchemeFor(testSuite, (NativeBinarySpecInternal)testedBinary, typeString);
        final NativeDependencyResolver resolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
        binaries.create(namingScheme.getBinaryName(), testSuiteBinaryClass, new Action<S>(){

            public void execute(S binary) {
                NativeTestSuiteBinarySpecInternal testBinary = (NativeTestSuiteBinarySpecInternal)binary;
                testBinary.setTestedBinary((NativeBinarySpecInternal)testedBinary);
                testBinary.setNamingScheme(namingScheme);
                testBinary.setResolver(resolver);
                testBinary.setToolChain(testedBinary.getToolChain());
                NativeExecutableFileSpec executable = testBinary.getExecutable();
                NativeInstallationSpec installation = testBinary.getInstallation();
                executable.setToolChain((ToolChain)testedBinary.getToolChain());
                executable.setFile(NativeBinaryRules.executableFileFor((NativeBinarySpecInternal)testBinary, (File)buildDir));
                installation.setDirectory(NativeBinaryRules.installationDirFor((NativeBinarySpecInternal)testBinary, (File)buildDir));
                NativeComponents.createInstallTask((NativeBinarySpecInternal)testBinary, (NativeInstallationSpec)installation, (NativeExecutableFileSpec)executable, (BinaryNamingScheme)namingScheme);
                NativeComponents.createExecutableTask((NativeBinarySpecInternal)testBinary, (File)testBinary.getExecutableFile());
                NativeTestSuites.createRunTask(testBinary, namingScheme.getTaskName("run"));
            }
        });
    }

    private static void createRunTask(final NativeTestSuiteBinarySpecInternal testBinary, String name) {
        testBinary.getTasks().create(name, RunTestExecutable.class, (Action)new Action<RunTestExecutable>(){

            public void execute(RunTestExecutable runTask) {
                runTask.setDescription("Runs the " + testBinary);
                testBinary.getTasks().add((Object)runTask);
            }
        });
    }

    public static Collection<NativeBinarySpec> testedBinariesOf(NativeTestSuiteSpec testSuite) {
        return NativeTestSuites.testedBinariesWithType(NativeBinarySpec.class, testSuite);
    }

    public static <S> Collection<S> testedBinariesWithType(Class<S> type, NativeTestSuiteSpec testSuite) {
        VariantComponentSpec spec = (VariantComponentSpec)testSuite.getTestedComponent();
        if (spec == null) {
            throw new InvalidModelException(String.format("Test suite '%s' doesn't declare component under test. Please specify it with `testing $.components.myComponent`.", testSuite.getName()));
        }
        return spec.getBinaries().withType(type).values();
    }

    private static BinaryNamingScheme namingSchemeFor(NativeTestSuiteSpec testSuite, NativeBinarySpecInternal testedBinary, String typeString) {
        return testedBinary.getNamingScheme().withComponentName(testSuite.getBaseName()).withBinaryType(typeString).withRole("executable", true);
    }

    public static <S extends NativeTestSuiteSpec> void createConventionalTestSuites(TestSuiteContainer testSuites, ModelMap<NativeComponentSpec> components, Class<S> testSuiteSpecClass) {
        for (final NativeComponentSpec component : components.values()) {
            String suiteName = component.getName() + "Test";
            testSuites.create(suiteName, testSuiteSpecClass, new Action<S>(){

                public void execute(S testSuite) {
                    testSuite.testing((ComponentSpec)component);
                }
            });
        }
    }
}

