/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.XmlProvider;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.Finalize;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MavenPluginPublishingRules
extends RuleSource {
    public static final String PLUGIN_MARKER_SUFFIX = ".gradle.plugin";

    MavenPluginPublishingRules() {
    }

    @Mutate
    public void addMainPublication(PublishingExtension publishing, GradlePluginDevelopmentExtension pluginDevelopment, ServiceRegistry services) {
        if (!pluginDevelopment.isAutomatedPublishing()) {
            return;
        }
        SoftwareComponentContainer componentContainer = (SoftwareComponentContainer)services.get(SoftwareComponentContainer.class);
        SoftwareComponent component = (SoftwareComponent)componentContainer.getByName("java");
        PublicationContainer publications = publishing.getPublications();
        this.createMavenPluginPublication(component, publications);
    }

    @Finalize
    public void addMarkerPublications(PublishingExtension publishing, GradlePluginDevelopmentExtension pluginDevelopment) {
        if (!pluginDevelopment.isAutomatedPublishing()) {
            return;
        }
        PublicationContainer publications = publishing.getPublications();
        NamedDomainObjectContainer<PluginDeclaration> declaredPlugins = pluginDevelopment.getPlugins();
        for (PluginDeclaration declaration : declaredPlugins) {
            this.createMavenMarkerPublication(declaration, (MavenPublication)publications.getByName("pluginMaven"), publications);
        }
    }

    private void createMavenPluginPublication(SoftwareComponent component, PublicationContainer publications) {
        MavenPublication publication = (MavenPublication)publications.create("pluginMaven", MavenPublication.class);
        publication.from(component);
    }

    private void createMavenMarkerPublication(PluginDeclaration declaration, final MavenPublication coordinates, PublicationContainer publications) {
        String pluginId = declaration.getId();
        MavenPublication publication = (MavenPublication)publications.create(declaration.getName() + "PluginMarkerMaven", MavenPublication.class);
        publication.setArtifactId(pluginId + PLUGIN_MARKER_SUFFIX);
        publication.setGroupId(pluginId);
        publication.getPom().withXml((Action)new Action<XmlProvider>(){

            public void execute(XmlProvider xmlProvider) {
                Element root = xmlProvider.asElement();
                Document document = root.getOwnerDocument();
                Node dependencies = root.appendChild(document.createElement("dependencies"));
                Node dependency = dependencies.appendChild(document.createElement("dependency"));
                Node groupId = dependency.appendChild(document.createElement("groupId"));
                groupId.setTextContent(coordinates.getGroupId());
                Node artifactId = dependency.appendChild(document.createElement("artifactId"));
                artifactId.setTextContent(coordinates.getArtifactId());
                Node version = dependency.appendChild(document.createElement("version"));
                version.setTextContent(coordinates.getVersion());
            }
        });
    }
}

