/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private Iterable<DaemonExpirationStrategy> expirationStrategies;

    public AllDaemonExpirationStrategy(List<DaemonExpirationStrategy> expirationStrategies) {
        this.expirationStrategies = expirationStrategies;
    }

    @Override
    public DaemonExpirationResult checkExpiration(Daemon daemon) {
        DaemonExpirationResult expirationResult = new DaemonExpirationResult(false, null);
        ArrayList reasons = Lists.newArrayList();
        for (DaemonExpirationStrategy expirationStrategy : this.expirationStrategies) {
            expirationResult = expirationStrategy.checkExpiration(daemon);
            if (!expirationResult.isExpired()) {
                return new DaemonExpirationResult(false, null);
            }
            reasons.add(expirationResult.getReason());
        }
        if (!expirationResult.isExpired()) {
            return expirationResult;
        }
        return new DaemonExpirationResult(true, Joiner.on((String)" and ").skipNulls().join((Iterable)reasons));
    }
}

