/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.launcher.daemon.server.api.DaemonStoppedException;
import org.gradle.launcher.daemon.server.api.DaemonUnavailableException;
import org.slf4j.Logger;

public class DaemonStateCoordinator
implements Stoppable,
DaemonStateControl {
    private static final Logger LOGGER = Logging.getLogger(DaemonStateCoordinator.class);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final long cancelTimeoutMs;
    private State state = State.Running;
    private long lastActivityAt = -1L;
    private String currentCommandExecution;
    private Object result;
    private volatile DefaultBuildCancellationToken cancellationToken;
    private final StoppableExecutor executor;
    private final Runnable onStartCommand;
    private final Runnable onFinishCommand;

    public DaemonStateCoordinator(ExecutorFactory executorFactory, Runnable onStartCommand, Runnable onFinishCommand) {
        this(executorFactory, onStartCommand, onFinishCommand, 10000L);
    }

    DaemonStateCoordinator(ExecutorFactory executorFactory, Runnable onStartCommand, Runnable onFinishCommand, long cancelTimeoutMs) {
        this.executor = executorFactory.create("Daemon worker");
        this.onStartCommand = onStartCommand;
        this.onFinishCommand = onFinishCommand;
        this.cancelTimeoutMs = cancelTimeoutMs;
        this.updateActivityTimestamp();
        this.cancellationToken = new DefaultBuildCancellationToken();
    }

    private void setState(State state) {
        this.state = state;
        this.condition.signalAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean awaitStop() {
        this.lock.lock();
        try {
            while (true) {
                switch (this.state) {
                    case Running: {
                        LOGGER.debug("daemon is running. Sleeping until state changes.");
                        this.condition.await();
                        break;
                    }
                    case Broken: {
                        throw new IllegalStateException("This daemon is in a broken state.");
                    }
                    case StopRequested: {
                        LOGGER.debug("daemon stop has been requested. Sleeping until state changes.");
                        this.condition.await();
                        break;
                    }
                    case Stopped: {
                        LOGGER.debug("daemon has stopped.");
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    long getIdleMillis(long currentTimeMillis) {
        if (this.isIdle()) {
            return currentTimeMillis - this.lastActivityAt;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this.lock.lock();
        try {
            LOGGER.debug("Stop as soon as idle requested. The daemon is busy: {}", (Object)this.isBusy());
            if (this.isBusy()) {
                this.beginStopping();
            } else {
                this.stopNow("stop requested and daemon idle");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.stopNow("service stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stopNow(String reason) {
        this.lock.lock();
        try {
            switch (this.state) {
                case Running: 
                case Broken: 
                case StopRequested: {
                    LOGGER.debug("Marking daemon stopped due to {}. The daemon is running a build: {}", (Object)reason, (Object)this.isBusy());
                    this.setState(State.Stopped);
                    return;
                }
                case Stopped: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void beginStopping() {
        switch (this.state) {
            case Running: 
            case Broken: {
                this.setState(State.StopRequested);
                break;
            }
            case StopRequested: 
            case Stopped: {
                break;
            }
            default: {
                throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
            }
        }
    }

    public void requestForcefulStop() {
        LOGGER.debug("Daemon stop requested.");
        this.stopNow("forceful stop requested");
    }

    public BuildCancellationToken getCancellationToken() {
        return this.cancellationToken;
    }

    private void updateCancellationToken() {
        this.cancellationToken = new DefaultBuildCancellationToken();
    }

    /*
     * Exception decompiling
     */
    public void cancelBuild() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommand(final Runnable command, String commandDisplayName) throws DaemonUnavailableException {
        this.onStartCommand(commandDisplayName);
        try {
            this.executor.execute(new Runnable(){

                public void run() {
                    try {
                        command.run();
                        DaemonStateCoordinator.this.onCommandSuccessful();
                    }
                    catch (Throwable t) {
                        DaemonStateCoordinator.this.onCommandFailed(t);
                    }
                }
            });
            this.waitForCommandCompletion();
        }
        finally {
            this.onFinishCommand();
        }
    }

    private void waitForCommandCompletion() {
        this.lock.lock();
        try {
            while ((this.state == State.Running || this.state == State.StopRequested) && this.result == null) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            LOGGER.debug("Command execution: finished waiting for {}. Result {} with state {}", new Object[]{this.currentCommandExecution, this.result, this.state});
            if (this.result instanceof Throwable) {
                throw UncheckedException.throwAsUncheckedException((Throwable)this.result);
            }
            if (this.result != null) {
                return;
            }
            switch (this.state) {
                case Stopped: {
                    throw new DaemonStoppedException();
                }
                case Broken: {
                    throw new DaemonUnavailableException("This daemon is broken and will stop.");
                }
            }
            throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCommandFailed(Throwable failure) {
        this.lock.lock();
        try {
            this.result = failure;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCommandSuccessful() {
        this.lock.lock();
        try {
            this.result = this;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartCommand(String commandDisplayName) {
        this.lock.lock();
        try {
            switch (this.state) {
                case Broken: {
                    throw new DaemonUnavailableException("This daemon is in a broken state and will stop.");
                }
                case StopRequested: {
                    throw new DaemonUnavailableException("This daemon is currently stopping.");
                }
                case Stopped: {
                    throw new DaemonUnavailableException("This daemon has stopped.");
                }
            }
            if (this.currentCommandExecution != null) {
                throw new DaemonUnavailableException(String.format("This daemon is currently executing: %s", this.currentCommandExecution));
            }
            LOGGER.debug("Command execution: started {} after {} minutes of idle", (Object)commandDisplayName, (Object)this.getIdleMinutes());
            try {
                this.onStartCommand.run();
                this.currentCommandExecution = commandDisplayName;
                this.result = null;
                this.updateActivityTimestamp();
                this.updateCancellationToken();
                this.condition.signalAll();
            }
            catch (Throwable throwable) {
                this.setState(State.Broken);
                throw UncheckedException.throwAsUncheckedException(throwable);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onFinishCommand() {
        this.lock.lock();
        try {
            LOGGER.debug("Command execution: completed {}", (Object)this.currentCommandExecution);
            this.currentCommandExecution = null;
            this.result = null;
            this.updateActivityTimestamp();
            switch (this.state) {
                case Running: {
                    try {
                        this.onFinishCommand.run();
                        this.condition.signalAll();
                        return;
                    }
                    catch (Throwable throwable) {
                        this.setState(State.Broken);
                        throw UncheckedException.throwAsUncheckedException(throwable);
                    }
                }
                case StopRequested: {
                    this.stopNow("command completed and stop requested");
                    return;
                }
                case Stopped: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateActivityTimestamp() {
        long now = System.currentTimeMillis();
        LOGGER.debug("updating lastActivityAt to {}", (Object)now);
        this.lastActivityAt = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getIdleMinutes() {
        this.lock.lock();
        try {
            double d = (System.currentTimeMillis() - this.lastActivityAt) / 1000L / 60L;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean isStopped() {
        return this.state == State.Stopped;
    }

    boolean isWillRefuseNewCommands() {
        return this.state != State.Running;
    }

    boolean isIdle() {
        return this.state == State.Running && this.currentCommandExecution == null;
    }

    boolean isBusy() {
        return (this.state == State.Running || this.state == State.StopRequested) && this.currentCommandExecution != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Running,
        StopRequested,
        Stopped,
        Broken;

    }
}

