/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala;

import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.scala.CleaningScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaCompileOptionsInternal;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.api.internal.tasks.scala.ScalaCompilerFactory;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.scala.tasks.AbstractScalaCompile;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaCompile
extends AbstractScalaCompile {
    private FileCollection scalaClasspath;
    private FileCollection zincClasspath;
    private Compiler<ScalaJavaJointCompileSpec> compiler;

    @Inject
    public ScalaCompile() {
        super((BaseScalaCompileOptions)new ScalaCompileOptionsInternal());
    }

    @Nested
    public ScalaCompileOptions getScalaCompileOptions() {
        return (ScalaCompileOptions)super.getScalaCompileOptions();
    }

    @InputFiles
    public FileCollection getScalaClasspath() {
        return this.scalaClasspath;
    }

    public void setScalaClasspath(FileCollection scalaClasspath) {
        this.scalaClasspath = scalaClasspath;
    }

    @InputFiles
    public FileCollection getZincClasspath() {
        return this.zincClasspath;
    }

    public void setZincClasspath(FileCollection zincClasspath) {
        this.zincClasspath = zincClasspath;
    }

    public void setCompiler(Compiler<ScalaJavaJointCompileSpec> compiler) {
        this.compiler = compiler;
    }

    protected Compiler<ScalaJavaJointCompileSpec> getCompiler(ScalaJavaJointCompileSpec spec) {
        this.assertScalaClasspathIsNonEmpty();
        if (this.compiler == null) {
            ProjectInternal projectInternal = (ProjectInternal)this.getProject();
            IsolatedAntBuilder antBuilder = (IsolatedAntBuilder)this.getServices().get(IsolatedAntBuilder.class);
            CompilerDaemonFactory compilerDaemonFactory = (CompilerDaemonFactory)this.getServices().get(CompilerDaemonManager.class);
            JavaCompilerFactory javaCompilerFactory = (JavaCompilerFactory)this.getServices().get(JavaCompilerFactory.class);
            ScalaCompilerFactory scalaCompilerFactory = new ScalaCompilerFactory(projectInternal.getRootProject().getProjectDir(), antBuilder, javaCompilerFactory, compilerDaemonFactory, this.getScalaClasspath(), this.getZincClasspath(), this.getProject().getGradle().getGradleUserHomeDir());
            this.compiler = scalaCompilerFactory.newCompiler(spec);
            if (((ScalaCompileOptionsInternal)this.getScalaCompileOptions()).internalIsUseAnt()) {
                this.compiler = new CleaningScalaCompiler(this.compiler, this.getOutputs());
            }
        }
        return this.compiler;
    }

    protected void configureIncrementalCompilation(ScalaCompileSpec spec) {
        if (((ScalaCompileOptionsInternal)this.getScalaCompileOptions()).internalIsUseAnt()) {
            return;
        }
        super.configureIncrementalCompilation(spec);
    }

    protected void assertScalaClasspathIsNonEmpty() {
        if (this.getScalaClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".scalaClasspath' must not be empty. If a Scala compile dependency is provided, " + "the 'scala-base' plugin will attempt to configure 'scalaClasspath' automatically. Alternatively, you may configure 'scalaClasspath' explicitly.");
        }
    }
}

