/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.listener.ActionBroadcast;
import org.gradle.nativeplatform.toolchain.NativePlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtendableToolChain<T extends NativePlatformToolChain>
implements NativeToolChainInternal {
    private final String name;
    protected final OperatingSystem operatingSystem;
    private final PathToFileResolver fileResolver;
    protected final ActionBroadcast<T> configureActions = new ActionBroadcast();
    protected final BuildOperationProcessor buildOperationProcessor;

    protected ExtendableToolChain(String name, BuildOperationProcessor buildOperationProcessor, OperatingSystem operatingSystem, PathToFileResolver fileResolver) {
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.fileResolver = fileResolver;
        this.buildOperationProcessor = buildOperationProcessor;
    }

    public String getName() {
        return this.name;
    }

    protected abstract String getTypeName();

    public String getDisplayName() {
        return "Tool chain '" + this.getName() + "' (" + this.getTypeName() + ")";
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getOutputType() {
        return this.getName() + "-" + this.operatingSystem.getName();
    }

    public void eachPlatform(Action<? super T> action) {
        this.configureActions.add(action);
    }

    protected File resolve(Object path) {
        return this.fileResolver.resolve(path);
    }
}

