/*
 * Decompiled with CFR 0.152.
 */
package org.grails.taglib;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.io.Writer;
import java.util.Map;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.buffer.StreamCharBuffer;
import org.grails.encoder.Encoder;
import org.grails.taglib.GrailsTagException;
import org.grails.taglib.GroovyPageAttributes;
import org.grails.taglib.GroovyPageTagWriter;
import org.grails.taglib.TagBodyClosure;
import org.grails.taglib.TagLibraryLookup;
import org.grails.taglib.encoder.OutputContext;
import org.grails.taglib.encoder.OutputEncodingStack;
import org.grails.taglib.encoder.OutputEncodingStackAttributes;
import org.grails.taglib.encoder.WithCodecHelper;

public class TagOutput {
    public static final String APPLY_CODEC_TAG_NAME = "applyCodec";
    public static final String ENCODE_AS_ATTRIBUTE_NAME = "encodeAs";
    public static final Closure<?> EMPTY_BODY_CLOSURE = new ConstantClosure("");
    public static final String DEFAULT_NAMESPACE = "g";

    private TagOutput() {
    }

    public static final Object captureTagOutput(TagLibraryLookup gspTagLibraryLookup, String namespace, String tagName, Map attrs, Object body, OutputContext outputContext) {
        GroovyObject tagLib = TagOutput.lookupCachedTagLib(gspTagLibraryLookup, namespace, tagName);
        if (tagLib == null) {
            throw new GrailsTagException("Tag [" + tagName + "] does not exist. No corresponding tag library found.");
        }
        if (!(attrs instanceof GroovyPageAttributes)) {
            attrs = new GroovyPageAttributes((Map)attrs, false);
        }
        ((GroovyPageAttributes)attrs).setGspTagSyntaxCall(false);
        Closure<?> actualBody = TagOutput.createOutputCapturingClosure(tagLib, body, outputContext);
        GroovyPageTagWriter tagOutput = new GroovyPageTagWriter();
        OutputEncodingStack outputStack = null;
        try {
            outputStack = OutputEncodingStack.currentStack(outputContext, false);
            if (outputStack == null) {
                outputStack = OutputEncodingStack.currentStack(outputContext, true, (Writer)((Object)tagOutput), true, true);
            }
            Map<String, Object> defaultEncodeAs = gspTagLibraryLookup.getEncodeAsForTag(namespace, tagName);
            Map<String, Object> codecSettings = TagOutput.createCodecSettings(namespace, tagName, (Map)attrs, defaultEncodeAs);
            OutputEncodingStackAttributes.Builder builder = WithCodecHelper.createOutputStackAttributesBuilder(codecSettings, outputContext.getGrailsApplication());
            builder.topWriter((Writer)((Object)tagOutput));
            outputStack.push(builder.build());
            Object tagLibProp = tagLib.getProperty(tagName);
            if (tagLibProp instanceof Closure) {
                Object bodyResult;
                Closure tag = (Closure)((Closure)tagLibProp).clone();
                switch (tag.getParameterTypes().length) {
                    case 1: {
                        Object bodyResult2;
                        bodyResult = tag.call(new Object[]{attrs});
                        if (actualBody == null || actualBody == EMPTY_BODY_CLOSURE || (bodyResult2 = actualBody.call()) == null) break;
                        if (actualBody instanceof ConstantClosure) {
                            outputStack.getStaticWriter().print(bodyResult2);
                            break;
                        }
                        outputStack.getTaglibWriter().print(bodyResult2);
                        break;
                    }
                    case 2: {
                        bodyResult = tag.call(new Object[]{attrs, actualBody});
                        break;
                    }
                    default: {
                        throw new GrailsTagException("Tag [" + tagName + "] does not specify expected number of params in tag library [" + tagLib.getClass().getName() + "]");
                    }
                }
                Encoder taglibEncoder = outputStack.getTaglibEncoder();
                boolean returnsObject = gspTagLibraryLookup.doesTagReturnObject(namespace, tagName);
                if (returnsObject && bodyResult != null && !(bodyResult instanceof Writer)) {
                    if (taglibEncoder != null) {
                        bodyResult = taglibEncoder.encode(bodyResult);
                    }
                    Object object = bodyResult;
                    return object;
                }
                if (taglibEncoder != null) {
                    Object object = taglibEncoder.encode((Object)tagOutput.getBuffer());
                    return object;
                }
                StreamCharBuffer streamCharBuffer = tagOutput.getBuffer();
                return streamCharBuffer;
            }
            throw new GrailsTagException("Tag [" + tagName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]");
        }
        finally {
            if (outputStack != null) {
                outputStack.pop();
            }
        }
    }

    public static final GroovyObject lookupCachedTagLib(TagLibraryLookup gspTagLibraryLookup, String namespace, String tagName) {
        return gspTagLibraryLookup != null ? gspTagLibraryLookup.lookupTagLibrary(namespace, tagName) : null;
    }

    public static final Closure<?> createOutputCapturingClosure(Object wrappedInstance, Object body1, OutputContext outputContext) {
        if (body1 == null) {
            return EMPTY_BODY_CLOSURE;
        }
        if (body1 instanceof ConstantClosure || body1 instanceof TagBodyClosure) {
            return (Closure)body1;
        }
        if (body1 instanceof Closure) {
            return new TagBodyClosure(wrappedInstance, outputContext, (Closure)body1);
        }
        return new ConstantClosure(body1);
    }

    public static Map<String, Object> createCodecSettings(String namespace, String tagName, Map attrs, Map<String, Object> defaultEncodeAs) {
        Map codecInfo = null;
        if (attrs.containsKey(ENCODE_AS_ATTRIBUTE_NAME)) {
            codecInfo = (Map)attrs.get(ENCODE_AS_ATTRIBUTE_NAME);
        } else if (DEFAULT_NAMESPACE.equals(namespace) && APPLY_CODEC_TAG_NAME.equals(tagName)) {
            codecInfo = attrs;
        }
        Map<String, Object> codecSettings = WithCodecHelper.mergeSettingsAndMakeCanonical(codecInfo, defaultEncodeAs);
        return codecSettings;
    }

    public static final class ConstantClosure
    extends Closure {
        private static final long serialVersionUID = 1L;
        private static final Class[] EMPTY_CLASS_ARR = new Class[0];
        final Object retval;

        public ConstantClosure(Object retval) {
            super(null);
            this.retval = retval;
        }

        public int getMaximumNumberOfParameters() {
            return 0;
        }

        public Class[] getParameterTypes() {
            return EMPTY_CLASS_ARR;
        }

        public Object doCall(Object obj) {
            return this.retval;
        }

        public Object doCall() {
            return this.retval;
        }

        public Object doCall(Object[] args) {
            return this.retval;
        }

        public Object call(Object ... args) {
            return this.retval;
        }

        public boolean asBoolean() {
            return DefaultTypeTransformation.castToBoolean((Object)this.retval);
        }
    }
}

