/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.WMSCachedTileLoaderJob;

public class WMSCachedTileLoader
extends TMSCachedTileLoader {
    public WMSCachedTileLoader(TileLoaderListener tileLoaderListener, ICacheAccess<String, BufferedImageCacheEntry> iCacheAccess, int n, int n2, Map<String, String> map) throws IOException {
        super(tileLoaderListener, iCacheAccess, n, n2, map);
        this.setDownloadExecutor(TMSCachedTileLoader.getNewThreadPoolExecutor("WMS-downloader-%d", THREAD_LIMIT.get()));
    }

    @Override
    public TileJob createTileLoaderJob(Tile tile) {
        return new WMSCachedTileLoaderJob(this.listener, tile, this.cache, this.connectTimeout, this.readTimeout, this.headers, this.getDownloadExecutor());
    }
}

