/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.notes;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.tools.I18n;

public class Note {
    private long id;
    private LatLon latLon;
    private Date createdAt;
    private Date closedAt;
    private State state;
    private List<NoteComment> comments = new ArrayList<NoteComment>();

    public Note(LatLon latLon) {
        this.latLon = latLon;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date date) {
        this.createdAt = date;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date date) {
        this.closedAt = date;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public List<NoteComment> getComments() {
        return this.comments;
    }

    public void addComment(NoteComment noteComment) {
        this.comments.add(noteComment);
    }

    public NoteComment getFirstComment() {
        return this.comments.isEmpty() ? null : this.comments.get(0);
    }

    public void updateWith(Note note) {
        this.comments = note.comments;
        this.createdAt = note.createdAt;
        this.id = note.id;
        this.state = note.state;
        this.latLon = note.latLon;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Note note = (Note)object;
        return this.id == note.id;
    }

    public String toString() {
        return I18n.tr("Note", new Object[0]) + ' ' + this.id + ": " + this.getFirstComment();
    }

    public static enum State {
        OPEN,
        CLOSED;

    }
}

