/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.CommandListMutableTreeNode;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Shortcut;

public class CommandStackDialog
extends ToggleDialog
implements OsmDataLayer.CommandQueueListener {
    private final DefaultTreeModel undoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final DefaultTreeModel redoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final JTree undoTree = new JTree(this.undoTreeModel);
    private final JTree redoTree = new JTree(this.redoTreeModel);
    private final transient UndoRedoSelectionListener undoSelectionListener;
    private final transient UndoRedoSelectionListener redoSelectionListener;
    private final JScrollPane scrollPane;
    private final JSeparator separator = new JSeparator();
    private final Component spacer = Box.createRigidArea(new Dimension(0, 3));
    private UndoRedoType lastOperation = UndoRedoType.UNDO;
    private final SelectAction selectAction = new SelectAction();
    private final SelectAndZoomAction selectAndZoomAction = new SelectAndZoomAction();
    private final transient Set<IEnabledStateUpdating> showNotifyListener = new LinkedHashSet<IEnabledStateUpdating>();

    public CommandStackDialog() {
        super(I18n.tr("Command Stack", new Object[0]), "commandstack", I18n.tr("Open a list of all commands (undo buffer).", new Object[0]), Shortcut.registerShortcut("subwindow:commandstack", I18n.tr("Toggle: {0}", I18n.tr("Command Stack", new Object[0])), 79, 5007), 100);
        this.undoTree.addMouseListener(new MouseEventHandler());
        this.undoTree.setRootVisible(false);
        this.undoTree.getSelectionModel().setSelectionMode(1);
        this.undoTree.setShowsRootHandles(true);
        this.undoTree.expandRow(0);
        this.undoTree.setCellRenderer(new CommandCellRenderer());
        this.undoSelectionListener = new UndoRedoSelectionListener(this.undoTree);
        this.undoTree.getSelectionModel().addTreeSelectionListener(this.undoSelectionListener);
        InputMapUtils.unassignCtrlShiftUpDown(this.undoTree, 0);
        this.redoTree.addMouseListener(new MouseEventHandler());
        this.redoTree.setRootVisible(false);
        this.redoTree.getSelectionModel().setSelectionMode(1);
        this.redoTree.setShowsRootHandles(true);
        this.redoTree.expandRow(0);
        this.redoTree.setCellRenderer(new CommandCellRenderer());
        this.redoSelectionListener = new UndoRedoSelectionListener(this.redoTree);
        this.redoTree.getSelectionModel().addTreeSelectionListener(this.redoSelectionListener);
        InputMapUtils.unassignCtrlShiftUpDown(this.redoTree, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add(this.spacer, GBC.eol());
        this.spacer.setVisible(false);
        jPanel.add((Component)this.undoTree, GBC.eol().fill(2));
        this.separator.setVisible(false);
        jPanel.add((Component)this.separator, GBC.eol().fill(2));
        jPanel.add((Component)this.redoTree, GBC.eol().fill(2));
        jPanel.add(Box.createRigidArea(new Dimension(0, 0)), GBC.std().weight(0.0, 1.0));
        jPanel.setBackground(this.redoTree.getBackground());
        this.wireUpdateEnabledStateUpdater(this.selectAction, this.undoTree);
        this.wireUpdateEnabledStateUpdater(this.selectAction, this.redoTree);
        UndoRedoAction undoRedoAction = new UndoRedoAction(UndoRedoType.UNDO);
        this.wireUpdateEnabledStateUpdater(undoRedoAction, this.undoTree);
        UndoRedoAction undoRedoAction2 = new UndoRedoAction(UndoRedoType.REDO);
        this.wireUpdateEnabledStateUpdater(undoRedoAction2, this.redoTree);
        this.scrollPane = (JScrollPane)this.createLayout(jPanel, true, Arrays.asList(new SideButton(this.selectAction), new SideButton(undoRedoAction), new SideButton(undoRedoAction2)));
        InputMapUtils.addEnterAction(this.undoTree, this.selectAndZoomAction);
        InputMapUtils.addEnterAction(this.redoTree, this.selectAndZoomAction);
    }

    private void updateTitle() {
        int n = this.undoTreeModel.getChildCount(this.undoTreeModel.getRoot());
        int n2 = this.redoTreeModel.getChildCount(this.redoTreeModel.getRoot());
        if (n > 0 || n2 > 0) {
            this.setTitle(I18n.tr("Command Stack: Undo: {0} / Redo: {1}", n, n2));
        } else {
            this.setTitle(I18n.tr("Command Stack", new Object[0]));
        }
    }

    protected void wireUpdateEnabledStateUpdater(final IEnabledStateUpdating iEnabledStateUpdating, JTree jTree) {
        this.addShowNotifyListener(iEnabledStateUpdating);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
        jTree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
                CommandStackDialog.this.updateTitle();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
                CommandStackDialog.this.updateTitle();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
                CommandStackDialog.this.updateTitle();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
                CommandStackDialog.this.updateTitle();
            }
        });
    }

    @Override
    public void showNotify() {
        this.buildTrees();
        for (IEnabledStateUpdating iEnabledStateUpdating : this.showNotifyListener) {
            iEnabledStateUpdating.updateEnabledState();
        }
        Main.main.undoRedo.addCommandQueueListener(this);
    }

    private void addShowNotifyListener(IEnabledStateUpdating iEnabledStateUpdating) {
        this.showNotifyListener.add(iEnabledStateUpdating);
    }

    @Override
    public void hideNotify() {
        this.undoTreeModel.setRoot(new DefaultMutableTreeNode());
        this.redoTreeModel.setRoot(new DefaultMutableTreeNode());
        Main.main.undoRedo.removeCommandQueueListener(this);
    }

    private void buildTrees() {
        this.setTitle(I18n.tr("Command Stack", new Object[0]));
        if (!Main.main.hasEditLayer()) {
            return;
        }
        LinkedList<Command> linkedList = Main.main.undoRedo.commands;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (int i = 0; i < linkedList.size(); ++i) {
            defaultMutableTreeNode.add(this.getNodeForCommand((PseudoCommand)linkedList.get(i), i));
        }
        this.undoTreeModel.setRoot(defaultMutableTreeNode);
        LinkedList<Command> linkedList2 = Main.main.undoRedo.redoCommands;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
        for (int i = 0; i < linkedList2.size(); ++i) {
            defaultMutableTreeNode2.add(this.getNodeForCommand((PseudoCommand)linkedList2.get(i), i));
        }
        this.redoTreeModel.setRoot(defaultMutableTreeNode2);
        if (this.redoTreeModel.getChildCount(defaultMutableTreeNode2) > 0) {
            this.redoTree.scrollRowToVisible(0);
            this.scrollPane.getHorizontalScrollBar().setValue(0);
        }
        this.separator.setVisible(!linkedList.isEmpty() || !linkedList2.isEmpty());
        this.spacer.setVisible(linkedList.isEmpty() && !linkedList2.isEmpty());
        switch (this.lastOperation) {
            case UNDO: {
                if (!linkedList.isEmpty()) break;
                this.lastOperation = UndoRedoType.REDO;
                break;
            }
            case REDO: {
                if (!linkedList2.isEmpty()) break;
                this.lastOperation = UndoRedoType.UNDO;
            }
        }
        switch (this.lastOperation) {
            case UNDO: {
                this.undoTree.setSelectionRow(this.undoTree.getRowCount() - 1);
                break;
            }
            case REDO: {
                this.redoTree.setSelectionRow(0);
            }
        }
        this.undoTree.scrollRowToVisible(this.undoTreeModel.getChildCount(defaultMutableTreeNode) - 1);
        this.scrollPane.getHorizontalScrollBar().setValue(0);
    }

    protected CommandListMutableTreeNode getNodeForCommand(PseudoCommand pseudoCommand, int n) {
        CommandListMutableTreeNode commandListMutableTreeNode = new CommandListMutableTreeNode(pseudoCommand, n);
        if (pseudoCommand.getChildren() != null) {
            ArrayList<PseudoCommand> arrayList = new ArrayList<PseudoCommand>(pseudoCommand.getChildren());
            for (int i = 0; i < arrayList.size(); ++i) {
                commandListMutableTreeNode.add(this.getNodeForCommand((PseudoCommand)arrayList.get(i), i));
            }
        }
        return commandListMutableTreeNode;
    }

    protected static FilteredCollection<? extends OsmPrimitive> getAffectedPrimitives(TreePath treePath) {
        PseudoCommand pseudoCommand = ((CommandListMutableTreeNode)treePath.getLastPathComponent()).getCommand();
        final OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        return new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)pseudoCommand.getParticipatingPrimitives(), new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                OsmPrimitive osmPrimitive2 = osmDataLayer.data.getPrimitiveById(osmPrimitive);
                return osmPrimitive2 != null && osmPrimitive2.isUsable();
            }
        });
    }

    @Override
    public void commandChanged(int n, int n2) {
        if (!this.isVisible()) {
            return;
        }
        this.buildTrees();
    }

    private class CommandStackPopup
    extends JPopupMenu {
        CommandStackPopup() {
            this.add(CommandStackDialog.this.selectAction);
            this.add(CommandStackDialog.this.selectAndZoomAction);
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        MouseEventHandler() {
            super(new CommandStackPopup());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseEventHandler.isDoubleClick(mouseEvent)) {
                CommandStackDialog.this.selectAndZoomAction.actionPerformed(null);
            }
        }
    }

    protected class UndoRedoAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private final UndoRedoType type;
        private final JTree tree;

        public UndoRedoAction(UndoRedoType undoRedoType) {
            this.type = undoRedoType;
            if (UndoRedoType.UNDO == undoRedoType) {
                this.tree = CommandStackDialog.this.undoTree;
                this.putValue("Name", I18n.tr("Undo", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Undo the selected and all later commands", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("undo"));
            } else {
                this.tree = CommandStackDialog.this.redoTree;
                this.putValue("Name", I18n.tr("Redo", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Redo the selected and all earlier commands", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("redo"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommandStackDialog.this.lastOperation = this.type;
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath.getPathCount() != 2) {
                throw new IllegalStateException();
            }
            int n = ((CommandListMutableTreeNode)treePath.getLastPathComponent()).getIndex();
            switch (this.type) {
                case UNDO: {
                    int n2 = ((DefaultMutableTreeNode)CommandStackDialog.this.undoTreeModel.getRoot()).getChildCount() - n;
                    Main.main.undoRedo.undo(n2);
                    break;
                }
                case REDO: {
                    int n3 = n + 1;
                    Main.main.undoRedo.redo(n3);
                }
            }
            Main.map.repaint();
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!this.tree.isSelectionEmpty() && this.tree.getSelectionPath().getPathCount() == 2);
        }
    }

    protected static enum UndoRedoType {
        UNDO,
        REDO;

    }

    public class SelectAndZoomAction
    extends SelectAction {
        public SelectAndZoomAction() {
            this.putValue("Name", I18n.tr("Select and zoom", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Selects the objects that take part in this command (unless currently deleted), then and zooms to it", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            if (!Main.main.hasEditLayer()) {
                return;
            }
            AutoScaleAction.autoScale("selection");
        }
    }

    public class SelectAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public SelectAction() {
            this.putValue("Name", I18n.tr("Select", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Selects the objects that take part in this command (unless currently deleted)", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath;
            if (!CommandStackDialog.this.undoTree.isSelectionEmpty()) {
                treePath = CommandStackDialog.this.undoTree.getSelectionPath();
            } else if (!CommandStackDialog.this.redoTree.isSelectionEmpty()) {
                treePath = CommandStackDialog.this.redoTree.getSelectionPath();
            } else {
                throw new IllegalStateException();
            }
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            if (osmDataLayer == null) {
                return;
            }
            osmDataLayer.data.setSelected(CommandStackDialog.getAffectedPrimitives(treePath));
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!CommandStackDialog.this.undoTree.isSelectionEmpty() || !CommandStackDialog.this.redoTree.isSelectionEmpty());
        }
    }

    protected static interface IEnabledStateUpdating {
        public void updateEnabledState();
    }

    private class UndoRedoSelectionListener
    implements TreeSelectionListener {
        private final JTree source;

        UndoRedoSelectionListener(JTree jTree) {
            this.source = jTree;
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.source == CommandStackDialog.this.undoTree) {
                CommandStackDialog.this.redoTree.getSelectionModel().removeTreeSelectionListener(CommandStackDialog.this.redoSelectionListener);
                CommandStackDialog.this.redoTree.clearSelection();
                CommandStackDialog.this.redoTree.getSelectionModel().addTreeSelectionListener(CommandStackDialog.this.redoSelectionListener);
            }
            if (this.source == CommandStackDialog.this.redoTree) {
                CommandStackDialog.this.undoTree.getSelectionModel().removeTreeSelectionListener(CommandStackDialog.this.undoSelectionListener);
                CommandStackDialog.this.undoTree.clearSelection();
                CommandStackDialog.this.undoTree.getSelectionModel().addTreeSelectionListener(CommandStackDialog.this.undoSelectionListener);
            }
        }
    }

    private static class CommandCellRenderer
    extends DefaultTreeCellRenderer {
        private CommandCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof JLabel) {
                JLabel jLabel = (JLabel)defaultMutableTreeNode.getUserObject();
                this.setIcon(jLabel.getIcon());
                this.setText(jLabel.getText());
            }
            return this;
        }
    }
}

