/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleServiceManager {
    private static final Logger LOG = Logger.getInstance(ModuleServiceManager.class);

    private ModuleServiceManager() {
    }

    @Nullable
    public static <T> T getService(@NotNull Module module, @NotNull Class<T> serviceClass) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleServiceManager", "getService"));
        }
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/openapi/module/ModuleServiceManager", "getService"));
        }
        Object instance = module.getPicoContainer().getComponentInstance(serviceClass.getName());
        if (instance == null && (instance = module.getComponent(serviceClass)) != null) {
            Application app = ApplicationManager.getApplication();
            String message = serviceClass.getName() + " requested as a service, but it is a component - convert it to a service or change call to module.getComponent()";
            if (app.isUnitTestMode()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
        }
        return (T)instance;
    }
}

