/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderDetailedFMeasureListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.cmdline.namefind.TrainingParams;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.namefind.BilouCodec;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinderCrossValidator;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.model.ModelUtil;

public final class TokenNameFinderCrossValidatorTool
extends AbstractCrossValidatorTool<NameSample, CVToolParams> {
    public TokenNameFinderCrossValidatorTool() {
        super(NameSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable Name Finder";
    }

    @Override
    public void run(String format, String[] args) {
        TokenNameFinderCrossValidator validator;
        String sequenceCodecImplName;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), true);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((CVToolParams)this.params).getFeaturegen());
        Map<String, Object> resources = TokenNameFinderTrainerTool.loadResources(((CVToolParams)this.params).getResources(), ((CVToolParams)this.params).getFeaturegen());
        if (((CVToolParams)this.params).getNameTypes() != null) {
            String[] nameTypes = ((CVToolParams)this.params).getNameTypes().split(",");
            this.sampleStream = new NameSampleTypeFilter(nameTypes, (ObjectStream<NameSample>)this.sampleStream);
        }
        LinkedList<TokenNameFinderEvaluationMonitor> listeners = new LinkedList<TokenNameFinderEvaluationMonitor>();
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new NameEvaluationErrorListener());
        }
        TokenNameFinderDetailedFMeasureListener detailedFListener = null;
        if (((CVToolParams)this.params).getDetailedF().booleanValue()) {
            detailedFListener = new TokenNameFinderDetailedFMeasureListener();
            listeners.add(detailedFListener);
        }
        if ("BIO".equals(sequenceCodecImplName = ((CVToolParams)this.params).getSequenceCodec())) {
            sequenceCodecImplName = BioCodec.class.getName();
        } else if ("BILOU".equals(sequenceCodecImplName)) {
            sequenceCodecImplName = BilouCodec.class.getName();
        }
        SequenceCodec<String> sequenceCodec = TokenNameFinderFactory.instantiateSequenceCodec(sequenceCodecImplName);
        TokenNameFinderFactory nameFinderFactory = null;
        try {
            nameFinderFactory = TokenNameFinderFactory.create(((CVToolParams)this.params).getFactory(), featureGeneratorBytes, resources, sequenceCodec);
        }
        catch (InvalidFormatException e) {
            throw new TerminateToolException(-1, e.getMessage(), e);
        }
        try {
            validator = new TokenNameFinderCrossValidator(((CVToolParams)this.params).getLang(), ((CVToolParams)this.params).getType(), this.mlParams, nameFinderFactory, listeners.toArray(new TokenNameFinderEvaluationMonitor[listeners.size()]));
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.out.println("done");
        System.out.println();
        if (detailedFListener == null) {
            System.out.println(validator.getFMeasure());
        } else {
            System.out.println(detailedFListener.toString());
        }
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    DetailedFMeasureEvaluatorParams {
    }
}

