/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XEvent;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XkbAccessXNotifyEvent;
import sun.awt.X11.XkbActionMessageEvent;
import sun.awt.X11.XkbAnyEvent;
import sun.awt.X11.XkbBellNotifyEvent;
import sun.awt.X11.XkbCompatMapNotifyEvent;
import sun.awt.X11.XkbControlsNotifyEvent;
import sun.awt.X11.XkbExtensionDeviceNotifyEvent;
import sun.awt.X11.XkbIndicatorNotifyEvent;
import sun.awt.X11.XkbMapNotifyEvent;
import sun.awt.X11.XkbNamesNotifyEvent;
import sun.awt.X11.XkbNewKeyboardNotifyEvent;
import sun.awt.X11.XkbStateNotifyEvent;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XkbEvent
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 96;
    }

    @Override
    public int getDataSize() {
        return XkbEvent.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XkbEvent(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XkbEvent() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XkbEvent.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_type() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_type(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public XkbAnyEvent get_any() {
        log.finest("");
        return new XkbAnyEvent(this.pData + 0L);
    }

    public XkbNewKeyboardNotifyEvent get_new_kbd() {
        log.finest("");
        return new XkbNewKeyboardNotifyEvent(this.pData + 0L);
    }

    public XkbMapNotifyEvent get_map() {
        log.finest("");
        return new XkbMapNotifyEvent(this.pData + 0L);
    }

    public XkbStateNotifyEvent get_state() {
        log.finest("");
        return new XkbStateNotifyEvent(this.pData + 0L);
    }

    public XkbControlsNotifyEvent get_ctrls() {
        log.finest("");
        return new XkbControlsNotifyEvent(this.pData + 0L);
    }

    public XkbIndicatorNotifyEvent get_indicators() {
        log.finest("");
        return new XkbIndicatorNotifyEvent(this.pData + 0L);
    }

    public XkbNamesNotifyEvent get_names() {
        log.finest("");
        return new XkbNamesNotifyEvent(this.pData + 0L);
    }

    public XkbCompatMapNotifyEvent get_compat() {
        log.finest("");
        return new XkbCompatMapNotifyEvent(this.pData + 0L);
    }

    public XkbBellNotifyEvent get_bell() {
        log.finest("");
        return new XkbBellNotifyEvent(this.pData + 0L);
    }

    public XkbActionMessageEvent get_message() {
        log.finest("");
        return new XkbActionMessageEvent(this.pData + 0L);
    }

    public XkbAccessXNotifyEvent get_accessx() {
        log.finest("");
        return new XkbAccessXNotifyEvent(this.pData + 0L);
    }

    public XkbExtensionDeviceNotifyEvent get_device() {
        log.finest("");
        return new XkbExtensionDeviceNotifyEvent(this.pData + 0L);
    }

    public XEvent get_core() {
        log.finest("");
        return new XEvent(this.pData + 0L);
    }

    @Override
    String getName() {
        return "XkbEvent";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(560);
        ret.append("type = ").append(XlibWrapper.eventToString[this.get_type()]).append(", ");
        ret.append("any = ").append(this.get_any()).append(", ");
        ret.append("new_kbd = ").append(this.get_new_kbd()).append(", ");
        ret.append("map = ").append(this.get_map()).append(", ");
        ret.append("state = ").append(this.get_state()).append(", ");
        ret.append("ctrls = ").append(this.get_ctrls()).append(", ");
        ret.append("indicators = ").append(this.get_indicators()).append(", ");
        ret.append("names = ").append(this.get_names()).append(", ");
        ret.append("compat = ").append(this.get_compat()).append(", ");
        ret.append("bell = ").append(this.get_bell()).append(", ");
        ret.append("message = ").append(this.get_message()).append(", ");
        ret.append("accessx = ").append(this.get_accessx()).append(", ");
        ret.append("device = ").append(this.get_device()).append(", ");
        ret.append("core = ").append(this.get_core()).append(", ");
        return ret.toString();
    }
}

