/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.options;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceContainer;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.host.Host;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Open
extends OptionProcessor {
    private Option openpid = Option.requiredArgument((char)'\uffff', (String)"openpid");
    private Option openid = Option.requiredArgument((char)'\uffff', (String)"openid");
    private static final int TIMEOUT = 5000;
    private static final String ID = "visualvm.id";

    public Open() {
        this.openpid = Option.shortDescription((Option)this.openpid, (String)"com.sun.tools.visualvm.application.options.Bundle", (String)"MSG_OPENPID");
        this.openid = Option.shortDescription((Option)this.openid, (String)"com.sun.tools.visualvm.application.options.Bundle", (String)"MSG_OPENID");
    }

    protected Set<Option> getOptions() {
        HashSet<Option> options = new HashSet<Option>();
        options.add(this.openpid);
        options.add(this.openid);
        return options;
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        DataSourceContainer container;
        Set apps;
        Integer pid = null;
        String id = null;
        String[] pids = optionValues.get(this.openpid);
        String[] ids = optionValues.get(this.openid);
        if (pids != null && pids.length > 0) {
            pid = Integer.valueOf(pids[0]);
        }
        if (ids != null && ids.length > 0) {
            id = "-Dvisualvm.id=" + ids[0];
        }
        if (this.openApplication(id, pid, apps = (container = Host.LOCALHOST.getRepository()).getDataSources(Application.class))) {
            return;
        }
        Listener l = new Listener(id, pid, container);
        container.addDataChangeListener((DataChangeListener)l, Application.class);
    }

    private boolean openApplication(String id, Integer pid, Set<Application> apps) {
        for (Application app : apps) {
            String args;
            Jvm jvm;
            if (pid != null && app.getPid() == pid.intValue()) {
                DataSourceWindowManager.sharedInstance().openDataSource((DataSource)app);
                return true;
            }
            if (id == null || !(jvm = JvmFactory.getJVMFor(app)).isBasicInfoSupported() || (args = jvm.getJvmArgs()) == null || !args.contains(id)) continue;
            DataSourceWindowManager.sharedInstance().openDataSource((DataSource)app);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements DataChangeListener<Application>,
    ActionListener {
        private final Integer pid;
        private final String id;
        private final DataSourceContainer container;
        private volatile boolean removed;
        private final Timer timer;

        private Listener(String i, Integer p, DataSourceContainer c) {
            this.id = i;
            this.pid = p;
            this.container = c;
            this.timer = new Timer(5000, this);
            this.timer.start();
        }

        public synchronized void dataChanged(DataChangeEvent<Application> event) {
            Set added = event.getAdded();
            if (Open.this.openApplication(this.id, this.pid, added) && !this.removed) {
                this.container.removeDataChangeListener((DataChangeListener)this);
                this.removed = true;
                this.timer.stop();
            }
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (!this.removed) {
                this.container.removeDataChangeListener((DataChangeListener)this);
                this.removed = true;
                String msg = "";
                if (this.pid != null) {
                    msg = NbBundle.getMessage(Open.class, (String)"MSG_NO_APP_PID", (Object[])new Object[]{Integer.toString(this.pid)});
                }
                if (this.id != null) {
                    msg = NbBundle.getMessage(Open.class, (String)"MSG_NO_APP_ID");
                }
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 2);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)desc);
            }
        }
    }
}

