/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class IndexedDisk {
    public static final byte HEADER_SIZE_BYTES = 4;
    private final IElementSerializer elementSerializer;
    private static final Log log = LogFactory.getLog(IndexedDisk.class);
    private final String filepath;
    private final FileChannel fc;

    public IndexedDisk(File file, IElementSerializer iElementSerializer) throws FileNotFoundException {
        this.filepath = file.getAbsolutePath();
        this.elementSerializer = iElementSerializer;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.filepath, "rw");
        this.fc = randomAccessFile.getChannel();
    }

    protected <T extends Serializable> T readObject(IndexedDiskElementDescriptor indexedDiskElementDescriptor) throws IOException, ClassNotFoundException {
        ByteBuffer byteBuffer;
        String string = null;
        boolean bl = false;
        long l = this.fc.size();
        if (indexedDiskElementDescriptor.pos > l) {
            bl = true;
            string = "Record " + indexedDiskElementDescriptor + " starts past EOF.";
        } else {
            byteBuffer = ByteBuffer.allocate(4);
            this.fc.read(byteBuffer, indexedDiskElementDescriptor.pos);
            byteBuffer.flip();
            int n = byteBuffer.getInt();
            if (indexedDiskElementDescriptor.len != n) {
                bl = true;
                string = "Record " + indexedDiskElementDescriptor + " does not match data length on disk (" + n + ")";
            } else if (indexedDiskElementDescriptor.pos + (long)indexedDiskElementDescriptor.len > l) {
                bl = true;
                string = "Record " + indexedDiskElementDescriptor + " exceeds file length.";
            }
        }
        if (bl) {
            log.warn("\n The file is corrupt: \n " + string);
            throw new IOException("The File Is Corrupt, need to reset");
        }
        byteBuffer = ByteBuffer.allocate(indexedDiskElementDescriptor.len);
        this.fc.read(byteBuffer, indexedDiskElementDescriptor.pos + 4L);
        byteBuffer.flip();
        return (T)((Serializable)this.elementSerializer.deSerialize(byteBuffer.array(), null));
    }

    protected void move(IndexedDiskElementDescriptor indexedDiskElementDescriptor, long l) throws IOException {
        int n;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        this.fc.read(byteBuffer, indexedDiskElementDescriptor.pos);
        byteBuffer.flip();
        int n2 = byteBuffer.getInt();
        if (n2 != indexedDiskElementDescriptor.len) {
            throw new IOException("Mismatched memory and disk length (" + n2 + ") for " + indexedDiskElementDescriptor);
        }
        long l2 = indexedDiskElementDescriptor.pos;
        long l3 = l;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(16384);
        for (int i = 4 + n2; i > 0; i -= n) {
            n = Math.min(i, byteBuffer2.capacity());
            byteBuffer2.limit(n);
            this.fc.read(byteBuffer2, l2);
            byteBuffer2.flip();
            this.fc.write(byteBuffer2, l3);
            byteBuffer2.clear();
            l3 += (long)n;
            l2 += (long)n;
        }
        indexedDiskElementDescriptor.pos = l;
    }

    protected boolean write(IndexedDiskElementDescriptor indexedDiskElementDescriptor, byte[] byArray) throws IOException {
        long l = indexedDiskElementDescriptor.pos;
        if (log.isTraceEnabled()) {
            log.trace("write> pos=" + l);
            log.trace(this.fc + " -- data.length = " + byArray.length);
        }
        if (byArray.length != indexedDiskElementDescriptor.len) {
            throw new IOException("Mismatched descriptor and data lengths");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + byArray.length);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        int n = this.fc.write(byteBuffer, l);
        return n == byArray.length;
    }

    protected boolean writeObject(Serializable serializable, long l) throws IOException {
        byte[] byArray = this.elementSerializer.serialize(serializable);
        this.write(new IndexedDiskElementDescriptor(l, byArray.length), byArray);
        return true;
    }

    protected long length() throws IOException {
        return this.fc.size();
    }

    protected void close() throws IOException {
        this.fc.close();
    }

    protected synchronized void reset() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Resetting Indexed File [" + this.filepath + "]");
        }
        this.fc.truncate(0L);
        this.fc.force(true);
    }

    protected void truncate(long l) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("Truncating file [" + this.filepath + "] to " + l);
        }
        this.fc.truncate(l);
    }

    protected String getFilePath() {
        return this.filepath;
    }
}

