/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumentable;
import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

final class InstrumentationHandler {
    private static final boolean TRACE = Boolean.getBoolean("truffle.instrumentation.trace");
    private final Map<RootNode, Void> roots = Collections.synchronizedMap(new WeakHashMap());
    private final List<EventBinding<?>> bindings = new ArrayList();
    private final AddBindingsVisitor addAllBindingsVisitor = new AddBindingsVisitor(this.bindings);
    private final Map<Object, AbstractInstrumenter> instrumenterMap = new HashMap<Object, AbstractInstrumenter>();
    private volatile boolean instrumentationInitialized;
    private final OutputStream out;
    private final OutputStream err;
    private final InputStream in;
    private final Map<Class<?>, Set<Class<?>>> cachedProvidedTags = new HashMap();
    static final AccessorInstrumentHandler ACCESSOR = new AccessorInstrumentHandler();

    private InstrumentationHandler(OutputStream out, OutputStream err, InputStream in) {
        this.out = out;
        this.err = err;
        this.in = in;
    }

    void installRootNode(RootNode root) {
        if (!AccessorInstrumentHandler.nodesAccess().isInstrumentable(root)) {
            return;
        }
        if (!this.instrumentationInitialized) {
            this.initializeInstrumentation();
        }
        this.roots.put(root, null);
        this.visitRoot(root, this.addAllBindingsVisitor);
    }

    void addInstrument(Object key, Class<?> clazz) {
        this.addInstrumenter(key, new InstrumentClientInstrumenter(clazz, this.out, this.err, this.in));
    }

    void disposeInstrumenter(Object key, boolean cleanupRequired) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Dispose instrumenter %n", key);
        }
        AbstractInstrumenter disposedInstrumenter = this.instrumenterMap.get(key);
        ArrayList disposedBindings = new ArrayList();
        ListIterator<EventBinding<?>> iterator = this.bindings.listIterator();
        while (iterator.hasNext()) {
            EventBinding binding = (EventBinding)iterator.next();
            if (binding.getInstrumenter() != disposedInstrumenter) continue;
            iterator.remove();
            disposedBindings.add(binding);
        }
        disposedInstrumenter.dispose();
        this.instrumenterMap.remove(key);
        if (cleanupRequired) {
            DisposeBindingsVisitor disposeVisitor = new DisposeBindingsVisitor(disposedBindings);
            for (RootNode root : this.roots.keySet()) {
                this.visitRoot(root, disposeVisitor);
            }
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Disposed instrumenter %n", key);
        }
    }

    Instrumenter forLanguage(TruffleLanguage.Env context, TruffleLanguage<?> language) {
        return new LanguageClientInstrumenter(language, context);
    }

    void detachLanguage(Object context) {
        if (this.instrumenterMap.containsKey(context)) {
            this.disposeInstrumenter(context, false);
        }
    }

    <T> EventBinding<T> addBinding(EventBinding<T> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.bindings.add(binding);
        if (this.instrumentationInitialized) {
            AddBindingVisitor addBindingsVisitor = new AddBindingVisitor(binding);
            for (RootNode root : this.roots.keySet()) {
                this.visitRoot(root, addBindingsVisitor);
            }
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    void disposeBinding(EventBinding<?> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Dispose binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.bindings.remove(binding);
        DisposeBindingVisitor disposeVisitor = new DisposeBindingVisitor(binding);
        for (RootNode root : this.roots.keySet()) {
            this.visitRoot(root, disposeVisitor);
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Disposed binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
    }

    ProbeNode.EventChainNode installBindings(ProbeNode probeNodeImpl) {
        EventContext context = probeNodeImpl.getContext();
        SourceSection sourceSection = context.getInstrumentedSourceSection();
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Lazy update for %s%n", sourceSection);
        }
        RootNode rootNode = probeNodeImpl.getRootNode();
        Node instrumentedNode = probeNodeImpl.findWrapper().getDelegateNode();
        Set<Class<?>> providedTags = this.getProvidedTags(rootNode);
        ProbeNode.EventChainNode root = null;
        ProbeNode.EventChainNode parent = null;
        for (int i = 0; i < this.bindings.size(); ++i) {
            ProbeNode.EventChainNode next;
            EventBinding<?> binding = this.bindings.get(i);
            if (!binding.isInstrumentedFull(providedTags, rootNode, instrumentedNode, sourceSection)) continue;
            if (TRACE) {
                InstrumentationHandler.trace("  Found binding %s, %s%n", binding.getFilter(), binding.getElement());
            }
            if ((next = probeNodeImpl.createEventChainCallback(binding)) == null) continue;
            if (root == null) {
                root = next;
            } else {
                assert (parent != null);
                parent.setNext(next);
            }
            parent = next;
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Lazy updated for %s%n", sourceSection);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeInstrumentation() {
        InstrumentationHandler instrumentationHandler = this;
        synchronized (instrumentationHandler) {
            if (!this.instrumentationInitialized) {
                if (TRACE) {
                    InstrumentationHandler.trace("BEGIN: Initialize instrumentation%n", new Object[0]);
                }
                for (AbstractInstrumenter instrumenter : this.instrumenterMap.values()) {
                    instrumenter.initialize();
                }
                if (TRACE) {
                    InstrumentationHandler.trace("END: Initialized instrumentation%n", new Object[0]);
                }
                this.instrumentationInitialized = true;
            }
        }
    }

    private void addInstrumenter(Object key, AbstractInstrumenter instrumenter) throws AssertionError {
        if (this.instrumenterMap.containsKey(key)) {
            throw new AssertionError((Object)"Instrument already added.");
        }
        if (this.instrumentationInitialized) {
            instrumenter.initialize();
            ArrayList addedBindings = new ArrayList();
            for (EventBinding<?> binding : this.bindings) {
                if (binding.getInstrumenter() != instrumenter) continue;
                addedBindings.add(binding);
            }
            AddBindingsVisitor visitor = new AddBindingsVisitor(addedBindings);
            for (RootNode root : this.roots.keySet()) {
                this.visitRoot(root, visitor);
            }
        }
        this.instrumenterMap.put(key, instrumenter);
    }

    private void insertWrapper(Node instrumentableNode, SourceSection sourceSection) {
        InstrumentableFactory.WrapperNode wrapper;
        Node node = instrumentableNode;
        Node parent = node.getParent();
        if (parent instanceof InstrumentableFactory.WrapperNode) {
            InstrumentationHandler.invalidateWrapperImpl((InstrumentableFactory.WrapperNode)((Object)parent), node);
            return;
        }
        ProbeNode probe = new ProbeNode(this, sourceSection);
        try {
            Class<? extends InstrumentableFactory<? extends Node>> factory = null;
            for (Class<?> currentClass = instrumentableNode.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                Instrumentable instrumentable = currentClass.getAnnotation(Instrumentable.class);
                if (instrumentable == null) continue;
                factory = instrumentable.factory();
                break;
            }
            if (factory == null) {
                if (TRACE) {
                    InstrumentationHandler.trace("No wrapper inserted for %s, section %s. Not annotated with @Instrumentable.%n", node, sourceSection);
                }
                return;
            }
            if (TRACE) {
                InstrumentationHandler.trace("Insert wrapper for %s, section %s%n", node, sourceSection);
            }
            wrapper = ((InstrumentableFactory)factory.newInstance()).createWrapper(instrumentableNode, probe);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create wrapper node. ", e);
        }
        if (!(wrapper instanceof Node)) {
            throw new IllegalStateException(String.format("Implementation of %s must be a subclass of %s.", InstrumentableFactory.WrapperNode.class.getSimpleName(), Node.class.getSimpleName()));
        }
        Node wrapperNode = (Node)((Object)wrapper);
        if (wrapperNode.getParent() != null) {
            throw new IllegalStateException(String.format("Instance of provided %s is already adopted by another parent.", InstrumentableFactory.WrapperNode.class.getSimpleName()));
        }
        if (parent == null) {
            throw new IllegalStateException(String.format("Instance of instrumentable %s is not adopted by a parent.", Node.class.getSimpleName()));
        }
        if (!node.isSafelyReplaceableBy(wrapperNode)) {
            throw new IllegalStateException(String.format("WrapperNode implementation %s cannot be safely replaced in parent node class %s.", wrapperNode.getClass().getName(), parent.getClass().getName()));
        }
        node.replace(wrapperNode);
        if (node.getParent() != wrapperNode) {
            throw new IllegalStateException("InstrumentableNode must have a WrapperNode as parent after createInstrumentationWrappwer is invoked.");
        }
    }

    private <T extends ExecutionEventNodeFactory> EventBinding<T> attachFactory(AbstractInstrumenter instrumenter, SourceSectionFilter filter, T factory) {
        return this.addBinding(new EventBinding<T>(instrumenter, filter, factory));
    }

    private <T extends ExecutionEventListener> EventBinding<T> attachListener(AbstractInstrumenter instrumenter, SourceSectionFilter filter, T listener) {
        return this.addBinding(new EventBinding<T>(instrumenter, filter, listener));
    }

    Set<Class<?>> getProvidedTags(Class<?> language) {
        Set<Class<Object>> tags = this.cachedProvidedTags.get(language);
        if (tags == null) {
            ProvidedTags languageTags = language.getAnnotation(ProvidedTags.class);
            List languageTagsList = languageTags != null ? Arrays.asList(languageTags.value()) : Collections.emptyList();
            tags = Collections.unmodifiableSet(new HashSet(languageTagsList));
            this.cachedProvidedTags.put(language, tags);
        }
        return tags;
    }

    Set<Class<?>> getProvidedTags(RootNode root) {
        Class<? extends TruffleLanguage> language = AccessorInstrumentHandler.nodesAccess().findLanguage(root);
        if (language != null) {
            return this.getProvidedTags(language);
        }
        return Collections.emptySet();
    }

    private static boolean isInstrumentableNode(Node node, SourceSection sourceSection) {
        return !(node instanceof InstrumentableFactory.WrapperNode) && !(node instanceof RootNode) && sourceSection != null;
    }

    private static void trace(String message, Object ... args) {
        PrintStream out = System.out;
        out.printf(message, args);
    }

    private void visitRoot(final RootNode root, final AbstractNodeVisitor visitor) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Visit root %s wrappers for %s%n", visitor, root.toString());
        }
        visitor.root = root;
        visitor.providedTags = this.getProvidedTags(root);
        try {
            if (visitor.shouldVisit()) {
                if (TRACE) {
                    InstrumentationHandler.trace("BEGIN: Traverse root %s wrappers for %s%n", visitor, root.toString());
                }
                root.atomic(new Runnable(){

                    @Override
                    public void run() {
                        root.accept(visitor);
                    }
                });
                if (TRACE) {
                    InstrumentationHandler.trace("END: Traverse root %s wrappers for %s%n", visitor, root.toString());
                }
            }
            if (TRACE) {
                InstrumentationHandler.trace("END: Visited root %s wrappers for %s%n", visitor, root.toString());
            }
        }
        finally {
            visitor.root = null;
            visitor.providedTags = null;
        }
    }

    static void removeWrapper(ProbeNode node) {
        if (TRACE) {
            InstrumentationHandler.trace("Remove wrapper for %s%n", node.getContext().getInstrumentedSourceSection());
        }
        InstrumentableFactory.WrapperNode wrapperNode = node.findWrapper();
        ((Node)((Object)wrapperNode)).replace(wrapperNode.getDelegateNode());
    }

    private static void invalidateWrapper(Node node) {
        Node parent = node.getParent();
        if (!(parent instanceof InstrumentableFactory.WrapperNode)) {
            return;
        }
        InstrumentationHandler.invalidateWrapperImpl((InstrumentableFactory.WrapperNode)((Object)parent), node);
    }

    private static void invalidateWrapperImpl(InstrumentableFactory.WrapperNode parent, Node node) {
        ProbeNode probeNode = parent.getProbeNode();
        if (TRACE) {
            SourceSection section = probeNode.getContext().getInstrumentedSourceSection();
            InstrumentationHandler.trace("Invalidate wrapper for %s, section %s %n", node, section);
        }
        if (probeNode != null) {
            probeNode.invalidate();
        }
    }

    static boolean hasTagImpl(Set<Class<?>> providedTags, Node node, Class<?> tag) {
        if (providedTags.contains(tag)) {
            return AccessorInstrumentHandler.nodesAccess().isTaggedWith(node, tag);
        }
        return false;
    }

    static Instrumentable getInstrumentable(Node node) {
        Instrumentable instrumentable = node.getClass().getAnnotation(Instrumentable.class);
        if (instrumentable != null && !(node instanceof InstrumentableFactory.WrapperNode)) {
            return instrumentable;
        }
        return null;
    }

    private <T> T lookup(Object key, Class<T> type) {
        AbstractInstrumenter value = this.instrumenterMap.get(key);
        return value == null ? null : (T)value.lookup(this, type);
    }

    private static void traceFilterCheck(String result, Set<Class<?>> providedTags, EventBinding<?> binding, Node node, SourceSection sourceSection) {
        Set<Class<?>> tags = binding.getFilter().getReferencedTags();
        HashSet containedTags = new HashSet();
        for (Class<?> tag : tags) {
            if (!InstrumentationHandler.hasTagImpl(providedTags, node, tag)) continue;
            containedTags.add(tag);
        }
        InstrumentationHandler.trace("  Filter %4s %s section:%s tags:%s%n", result, binding.getFilter(), sourceSection, containedTags);
    }

    static final class AccessorInstrumentHandler
    extends Accessor {
        AccessorInstrumentHandler() {
        }

        static Accessor.Nodes nodesAccess() {
            return ACCESSOR.nodes();
        }

        static Accessor.LanguageSupport langAccess() {
            return ACCESSOR.languageSupport();
        }

        static Accessor.EngineSupport engineAccess() {
            return ACCESSOR.engineSupport();
        }

        protected CallTarget parse(Class<? extends TruffleLanguage> languageClass, Source code, Node context, String ... argumentNames) throws IOException {
            TruffleLanguage<?> truffleLanguage = this.engineSupport().findLanguageImpl(null, languageClass, code.getMimeType());
            return AccessorInstrumentHandler.langAccess().parse(truffleLanguage, code, context, argumentNames);
        }

        @Override
        protected Accessor.InstrumentSupport instrumentSupport() {
            return new InstrumentImpl();
        }

        static final class InstrumentImpl
        extends Accessor.InstrumentSupport {
            InstrumentImpl() {
            }

            @Override
            public Object createInstrumentationHandler(Object vm, OutputStream out, OutputStream err, InputStream in) {
                return new InstrumentationHandler(out, err, in);
            }

            @Override
            public void addInstrument(Object instrumentationHandler, Object key, Class<?> instrumentClass) {
                ((InstrumentationHandler)instrumentationHandler).addInstrument(key, instrumentClass);
            }

            @Override
            public void disposeInstrument(Object instrumentationHandler, Object key, boolean cleanupRequired) {
                ((InstrumentationHandler)instrumentationHandler).disposeInstrumenter(key, cleanupRequired);
            }

            @Override
            public void collectEnvServices(Set<Object> collectTo, Object vm, TruffleLanguage<?> impl, TruffleLanguage.Env env) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(vm);
                Instrumenter instrumenter = instrumentationHandler.forLanguage(env, impl);
                collectTo.add(instrumenter);
            }

            @Override
            public <T> T getInstrumentationHandlerService(Object vm, Object key, Class<T> type) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)vm;
                return (T)instrumentationHandler.lookup(key, type);
            }

            @Override
            public void detachLanguageFromInstrumentation(Object vm, TruffleLanguage.Env env) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(vm);
                instrumentationHandler.detachLanguage(AccessorInstrumentHandler.langAccess().findContext(env));
            }

            @Override
            public void onFirstExecution(RootNode rootNode) {
                Object instrumentationHandler = AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(null);
                if (instrumentationHandler != null) {
                    ((InstrumentationHandler)instrumentationHandler).installRootNode(rootNode);
                }
            }
        }
    }

    abstract class AbstractInstrumenter
    extends Instrumenter {
        AbstractInstrumenter() {
        }

        abstract void initialize();

        abstract void dispose();

        abstract <T> T lookup(InstrumentationHandler var1, Class<T> var2);

        void disposeBinding(EventBinding<?> binding) {
            InstrumentationHandler.this.disposeBinding(binding);
        }

        abstract boolean isInstrumentableRoot(RootNode var1);

        final Set<Class<?>> queryTagsImpl(Node node, Class<?> onlyLanguage) {
            SourceSection sourceSection = node.getSourceSection();
            if (!InstrumentationHandler.isInstrumentableNode(node, sourceSection)) {
                return Collections.emptySet();
            }
            RootNode root = node.getRootNode();
            if (root == null) {
                return Collections.emptySet();
            }
            Class<? extends TruffleLanguage> language = AccessorInstrumentHandler.nodesAccess().findLanguage(root);
            if (onlyLanguage != null && language != onlyLanguage) {
                throw new IllegalArgumentException("The language instrumenter cannot query tags of nodes of other languages.");
            }
            Set<Class<?>> providedTags = InstrumentationHandler.this.getProvidedTags(root);
            if (providedTags.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet tags = new HashSet();
            for (Class<?> providedTag : providedTags) {
                if (!InstrumentationHandler.hasTagImpl(providedTags, node, providedTag)) continue;
                tags.add(providedTag);
            }
            return Collections.unmodifiableSet(tags);
        }

        @Override
        public final <T extends ExecutionEventNodeFactory> EventBinding<T> attachFactory(SourceSectionFilter filter, T factory) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachFactory(this, filter, factory);
        }

        @Override
        public final <T extends ExecutionEventListener> EventBinding<T> attachListener(SourceSectionFilter filter, T listener) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachListener(this, filter, listener);
        }

        abstract void verifyFilter(SourceSectionFilter var1);
    }

    final class LanguageClientInstrumenter<T>
    extends AbstractInstrumenter {
        private final TruffleLanguage.Env env;
        private final TruffleLanguage<T> language;

        LanguageClientInstrumenter(TruffleLanguage<T> language, TruffleLanguage.Env env) {
            this.language = language;
            this.env = env;
        }

        @Override
        boolean isInstrumentableRoot(RootNode node) {
            return AccessorInstrumentHandler.nodesAccess().findLanguage(node.getRootNode()) == this.language.getClass();
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, this.language.getClass());
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
            Set<Class<?>> referencedTags;
            Set<Class<Class<?>>> providedTags = InstrumentationHandler.this.getProvidedTags(this.language.getClass());
            if (!providedTags.containsAll(referencedTags = filter.getReferencedTags())) {
                HashSet missingTags = new HashSet(referencedTags);
                missingTags.removeAll(providedTags);
                LinkedHashSet allTags = new LinkedHashSet(providedTags);
                allTags.addAll(missingTags);
                StringBuilder builder = new StringBuilder("{");
                String sep = "";
                for (Class clazz : allTags) {
                    builder.append(sep);
                    builder.append(clazz.getSimpleName());
                    sep = ", ";
                }
                builder.append("}");
                throw new IllegalArgumentException(String.format("The attached filter %s references the following tags %s which are not declared as provided by the language. To fix this annotate the language class %s with @%s(%s).", filter, missingTags, this.language.getClass().getName(), ProvidedTags.class.getSimpleName(), builder));
            }
        }

        @Override
        void initialize() {
        }

        @Override
        void dispose() {
        }

        <S> S lookup(InstrumentationHandler handler, Class<S> type) {
            return null;
        }
    }

    final class InstrumentClientInstrumenter
    extends AbstractInstrumenter {
        private final Class<?> instrumentClass;
        private Object[] services;
        private TruffleInstrument instrument;
        private final TruffleInstrument.Env env;

        InstrumentClientInstrumenter(Class<?> instrumentClass, OutputStream out, OutputStream err, InputStream in) {
            this.instrumentClass = instrumentClass;
            this.env = new TruffleInstrument.Env(this, out, err, in);
        }

        @Override
        boolean isInstrumentableRoot(RootNode rootNode) {
            return true;
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, null);
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
        }

        Class<?> getInstrumentClass() {
            return this.instrumentClass;
        }

        TruffleInstrument.Env getEnv() {
            return this.env;
        }

        @Override
        void initialize() {
            if (TRACE) {
                InstrumentationHandler.trace("Initialize instrument %s class %s %n", new Object[]{this.instrument, this.instrumentClass});
            }
            assert (this.instrument == null);
            try {
                this.instrument = (TruffleInstrument)this.instrumentClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.failInstrumentInitialization(String.format("Failed to create new instrumenter class %s", this.instrumentClass.getName()), e);
                return;
            }
            try {
                this.services = this.env.onCreate(this.instrument);
            }
            catch (Throwable e) {
                this.failInstrumentInitialization(String.format("Failed calling onCreate of instrument class %s", this.instrumentClass.getName()), e);
                return;
            }
            if (TRACE) {
                InstrumentationHandler.trace("Initialized instrument %s class %s %n", new Object[]{this.instrument, this.instrumentClass});
            }
        }

        private void failInstrumentInitialization(String message, Throwable t) {
            Exception exception = new Exception(message, t);
            PrintStream stream = new PrintStream(this.env.err());
            exception.printStackTrace(stream);
        }

        boolean isInitialized() {
            return this.instrument != null;
        }

        TruffleInstrument getInstrument() {
            return this.instrument;
        }

        @Override
        void dispose() {
            if (this.isInitialized()) {
                this.instrument.onDispose(this.env);
            }
        }

        @Override
        <T> T lookup(InstrumentationHandler handler, Class<T> type) {
            if (this.instrument == null) {
                handler.initializeInstrumentation();
            }
            if (this.services != null) {
                for (Object service : this.services) {
                    if (!type.isInstance(service)) continue;
                    return type.cast(service);
                }
            }
            return null;
        }
    }

    private final class DisposeBindingsVisitor
    extends AbstractBindingsVisitor {
        DisposeBindingsVisitor(List<EventBinding<?>> bindings) {
            super(bindings);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.invalidateWrapper(node);
        }
    }

    private final class AddBindingsVisitor
    extends AbstractBindingsVisitor {
        AddBindingsVisitor(List<EventBinding<?>> bindings) {
            super(bindings);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.this.insertWrapper(node, section);
        }
    }

    private final class DisposeBindingVisitor
    extends AbstractBindingVisitor {
        DisposeBindingVisitor(EventBinding<?> binding) {
            super(binding);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.invalidateWrapper(node);
        }
    }

    private final class AddBindingVisitor
    extends AbstractBindingVisitor {
        AddBindingVisitor(EventBinding<?> filter) {
            super(filter);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.this.insertWrapper(node, section);
        }
    }

    private abstract class AbstractBindingsVisitor
    extends AbstractNodeVisitor {
        private final List<EventBinding<?>> bindings;

        AbstractBindingsVisitor(List<EventBinding<?>> bindings) {
            this.bindings = bindings;
        }

        @Override
        boolean shouldVisit() {
            RootNode localRoot = this.root;
            if (localRoot == null) {
                return false;
            }
            SourceSection sourceSection = localRoot.getSourceSection();
            for (int i = 0; i < this.bindings.size(); ++i) {
                EventBinding<?> binding = this.bindings.get(i);
                if (!binding.isInstrumentedRoot(this.providedTags, localRoot, sourceSection)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean visit(Node node) {
            SourceSection sourceSection = node.getSourceSection();
            if (InstrumentationHandler.isInstrumentableNode(node, sourceSection)) {
                List<EventBinding<?>> b = this.bindings;
                for (int i = 0; i < b.size(); ++i) {
                    EventBinding<?> binding = b.get(i);
                    if (binding.isInstrumentedFull(this.providedTags, this.root, node, sourceSection)) {
                        if (TRACE) {
                            InstrumentationHandler.traceFilterCheck("hit", this.providedTags, binding, node, sourceSection);
                        }
                        this.visitInstrumented(node, sourceSection);
                        break;
                    }
                    if (!TRACE) continue;
                    InstrumentationHandler.traceFilterCheck("miss", this.providedTags, binding, node, sourceSection);
                }
            }
            return true;
        }

        protected abstract void visitInstrumented(Node var1, SourceSection var2);
    }

    private abstract class AbstractBindingVisitor
    extends AbstractNodeVisitor {
        protected final EventBinding<?> binding;

        AbstractBindingVisitor(EventBinding<?> binding) {
            this.binding = binding;
        }

        @Override
        boolean shouldVisit() {
            return this.binding.isInstrumentedRoot(this.providedTags, this.root, this.root.getSourceSection());
        }

        @Override
        public final boolean visit(Node node) {
            SourceSection sourceSection = node.getSourceSection();
            if (InstrumentationHandler.isInstrumentableNode(node, sourceSection)) {
                if (this.binding.isInstrumentedLeaf(this.providedTags, node, sourceSection)) {
                    if (TRACE) {
                        InstrumentationHandler.traceFilterCheck("hit", this.providedTags, this.binding, node, sourceSection);
                    }
                    this.visitInstrumented(node, sourceSection);
                } else if (TRACE) {
                    InstrumentationHandler.traceFilterCheck("miss", this.providedTags, this.binding, node, sourceSection);
                }
            }
            return true;
        }

        protected abstract void visitInstrumented(Node var1, SourceSection var2);
    }

    private static abstract class AbstractNodeVisitor
    implements NodeVisitor {
        RootNode root;
        Set<Class<?>> providedTags;

        private AbstractNodeVisitor() {
        }

        abstract boolean shouldVisit();
    }
}

