/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.parser.jruby;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.SuperNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.IsNilNode;
import org.jruby.truffle.core.cast.ArrayCastNode;
import org.jruby.truffle.core.cast.ArrayCastNodeGen;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ReadBlockNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.ShouldDestructureNode;
import org.jruby.truffle.language.control.AndNode;
import org.jruby.truffle.language.control.IfElseNode;
import org.jruby.truffle.language.control.NotNode;
import org.jruby.truffle.language.control.SequenceNode;
import org.jruby.truffle.language.locals.FlipFlopStateNode;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.BlockDefinitionNode;
import org.jruby.truffle.language.methods.CatchForLambdaNode;
import org.jruby.truffle.language.methods.CatchForMethodNode;
import org.jruby.truffle.language.methods.CatchForProcNode;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;
import org.jruby.truffle.language.methods.MethodDefinitionNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.language.parser.jruby.BodyTranslator;
import org.jruby.truffle.language.parser.jruby.LoadArgumentsTranslator;
import org.jruby.truffle.language.parser.jruby.ParameterCollector;
import org.jruby.truffle.language.parser.jruby.ReloadArgumentsTranslator;
import org.jruby.truffle.language.parser.jruby.Translator;
import org.jruby.truffle.language.parser.jruby.TranslatorEnvironment;
import org.jruby.truffle.language.supercall.ReadSuperArgumentsNode;
import org.jruby.truffle.language.supercall.ReadZSuperArgumentsNode;
import org.jruby.truffle.language.supercall.SuperCallNode;
import org.jruby.truffle.language.supercall.ZSuperOutsideMethodNode;

public class MethodTranslator
extends BodyTranslator {
    private final ArgsNode argsNode;
    private boolean isBlock;

    public MethodTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, boolean isBlock, Source source, ArgsNode argsNode) {
        super(currentNode, context, parent, environment, source, false);
        this.isBlock = isBlock;
        this.argsNode = argsNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockDefinitionNode compileBlockNode(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo, ProcType type) {
        Object frameOnStackMarkerSlot;
        RubyNode body;
        RubyNode preludeProc;
        this.declareArguments(sourceSection, methodName, sharedMethodInfo);
        Arity arity = MethodTranslator.getArity(this.argsNode);
        Arity arityForCheck = this.argsNode.getRestArgNode() instanceof UnnamedRestArgNode && !((UnnamedRestArgNode)this.argsNode.getRestArgNode()).isStar() ? arity.withRest(false) : arity;
        boolean isProc = type == ProcType.PROC;
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, isProc, this);
        RubyNode loadArguments = (RubyNode)this.argsNode.accept((NodeVisitor)loadArgumentsTranslator);
        if (this.shouldConsiderDestructuringArrayArg(arity)) {
            ReadPreArgumentNode readArrayNode = new ReadPreArgumentNode(0, MissingArgumentBehavior.RUNTIME_ERROR);
            ArrayCastNode castArrayNode = ArrayCastNodeGen.create(this.context, sourceSection, readArrayNode);
            FrameSlot arraySlot = this.environment.declareVar(this.environment.allocateLocalTemp("destructure"));
            Node[] writeArrayNode = new WriteLocalVariableNode(this.context, sourceSection, arraySlot, castArrayNode);
            LoadArgumentsTranslator destructureArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, isProc, this);
            destructureArgumentsTranslator.pushArraySlot(arraySlot);
            RubyNode newDestructureArguments = (RubyNode)this.argsNode.accept((NodeVisitor)destructureArgumentsTranslator);
            ShouldDestructureNode shouldDestructure = new ShouldDestructureNode(readArrayNode);
            RubyNode arrayWasNotNil = MethodTranslator.sequence(this.context, sourceSection, Arrays.asList(writeArrayNode, new NotNode(this.context, sourceSection, new IsNilNode(this.context, sourceSection, new ReadLocalVariableNode(this.context, sourceSection, LocalVariableType.FRAME_LOCAL, arraySlot)))));
            AndNode shouldDestructureAndArrayWasNotNil = new AndNode(this.context, sourceSection, shouldDestructure, arrayWasNotNil);
            preludeProc = new IfElseNode(this.context, sourceSection, shouldDestructureAndArrayWasNotNil, newDestructureArguments, loadArguments);
        } else {
            preludeProc = loadArguments;
        }
        RubyNode checkArity = Translator.createCheckArityNode(this.context, sourceSection, arityForCheck);
        RubyNode preludeLambda = MethodTranslator.sequence(this.context, sourceSection, Arrays.asList(checkArity, NodeUtil.cloneNode(loadArguments)));
        this.parentSourceSection.push(sourceSection);
        try {
            if (this.argsNode.getBlockLocalVariables() != null && !this.argsNode.getBlockLocalVariables().isEmpty()) {
                for (Node var : this.argsNode.getBlockLocalVariables().children()) {
                    this.environment.declareVar(((INameNode)var).getName());
                }
            }
            body = this.translateNodeOrNil(sourceSection, bodyNode);
        }
        finally {
            this.parentSourceSection.pop();
        }
        CatchForProcNode bodyProc = new CatchForProcNode(this.context, MethodTranslator.enclosing(sourceSection, body.getEncapsulatingSourceSection()), this.composeBody(preludeProc, NodeUtil.cloneNode(body)));
        RubyRootNode newRootNodeForProcs = new RubyRootNode(this.context, MethodTranslator.considerExtendingMethodToCoverEnd(bodyProc.getEncapsulatingSourceSection()), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyProc, this.environment.needsDeclarationFrame());
        RubyNode composed = this.composeBody(preludeLambda, body);
        CatchForLambdaNode bodyLambda = new CatchForLambdaNode(this.context, composed.getEncapsulatingSourceSection(), this.environment.getReturnID(), composed);
        RubyRootNode newRootNodeForLambdas = new RubyRootNode(this.context, MethodTranslator.considerExtendingMethodToCoverEnd(bodyLambda.getEncapsulatingSourceSection()), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyLambda, this.environment.needsDeclarationFrame());
        RootCallTarget callTargetAsLambda = Truffle.getRuntime().createCallTarget(newRootNodeForLambdas);
        RootCallTarget callTargetAsProc = Truffle.getRuntime().createCallTarget(newRootNodeForProcs);
        if (this.frameOnStackMarkerSlotStack.isEmpty()) {
            frameOnStackMarkerSlot = null;
        } else {
            frameOnStackMarkerSlot = this.frameOnStackMarkerSlotStack.peek();
            if (frameOnStackMarkerSlot == BAD_FRAME_SLOT) {
                frameOnStackMarkerSlot = null;
            }
        }
        return new BlockDefinitionNode(this.context, newRootNodeForProcs.getEncapsulatingSourceSection(), type, this.environment.getSharedMethodInfo(), callTargetAsProc, callTargetAsLambda, this.environment.getBreakID(), frameOnStackMarkerSlot);
    }

    private boolean shouldConsiderDestructuringArrayArg(Arity arity) {
        if (arity.hasKeywordsRest()) {
            return true;
        }
        if (!arity.hasRest() && arity.getOptional() == 0 && arity.getRequired() <= 1) {
            return false;
        }
        return !arity.hasRest() || arity.getRequired() != 0;
    }

    private RubyNode composeBody(RubyNode prelude, RubyNode body) {
        SourceSection sourceSection = MethodTranslator.enclosing(prelude.getSourceSection(), body.getSourceSection());
        body = MethodTranslator.sequence(this.context, sourceSection, Arrays.asList(prelude, body));
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = MethodTranslator.sequence(this.context, sourceSection, Arrays.asList(this.initFlipFlopStates(sourceSection), body));
        }
        return body;
    }

    public RubyNode compileMethodBody(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        return this.doCompileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode doCompileMethodBody(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode prelude;
        RubyNode body;
        this.declareArguments(sourceSection, methodName, sharedMethodInfo);
        Arity arity = MethodTranslator.getArity(this.argsNode);
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, false, this);
        RubyNode loadArguments = (RubyNode)this.argsNode.accept((NodeVisitor)loadArgumentsTranslator);
        this.parentSourceSection.push(sourceSection);
        try {
            body = this.translateNodeOrNil(sourceSection, bodyNode);
        }
        finally {
            this.parentSourceSection.pop();
        }
        if (this.usesRubiniusPrimitive) {
            prelude = loadArguments;
        } else {
            RubyNode checkArity = Translator.createCheckArityNode(this.context, sourceSection, arity);
            prelude = MethodTranslator.sequence(this.context, sourceSection, Arrays.asList(checkArity, loadArguments));
        }
        body = MethodTranslator.sequence(this.context, body.getSourceSection(), Arrays.asList(prelude, body));
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = MethodTranslator.sequence(this.context, body.getSourceSection(), Arrays.asList(this.initFlipFlopStates(sourceSection), body));
        }
        body = new CatchForMethodNode(this.context, body.getSourceSection(), this.environment.getReturnID(), body);
        body = new ExceptionTranslatingNode(this.context, body.getSourceSection(), body, UnsupportedOperationBehavior.TYPE_ERROR);
        return body;
    }

    public MethodDefinitionNode compileMethodNode(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode body = this.compileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
        RubyRootNode rootNode = new RubyRootNode(this.context, MethodTranslator.considerExtendingMethodToCoverEnd(body.getSourceSection()), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body, this.environment.needsDeclarationFrame());
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
        return new MethodDefinitionNode(this.context, sourceSection, methodName, this.environment.getSharedMethodInfo(), callTarget);
    }

    private void declareArguments(SourceSection sourceSection, String methodName, SharedMethodInfo sharedMethodInfo) {
        ParameterCollector parameterCollector = new ParameterCollector();
        this.argsNode.accept((NodeVisitor)parameterCollector);
        for (String parameter : parameterCollector.getParameters()) {
            this.environment.declareVar(parameter);
        }
    }

    public static Arity getArity(ArgsNode argsNode) {
        String[] keywordArguments;
        if (argsNode.hasKwargs() && argsNode.getKeywords() != null) {
            Node[] keywordNodes = argsNode.getKeywords().children();
            int keywordsCount = keywordNodes.length;
            keywordArguments = new String[keywordsCount];
            for (int i = 0; i < keywordsCount; ++i) {
                KeywordArgNode kwarg = (KeywordArgNode)keywordNodes[i];
                AssignableNode assignableNode = kwarg.getAssignable();
                if (assignableNode instanceof LocalAsgnNode) {
                    keywordArguments[i] = ((LocalAsgnNode)assignableNode).getName();
                    continue;
                }
                if (assignableNode instanceof DAsgnNode) {
                    keywordArguments[i] = ((DAsgnNode)assignableNode).getName();
                    continue;
                }
                throw new UnsupportedOperationException("unsupported keyword arg " + kwarg);
            }
        } else {
            keywordArguments = Arity.NO_KEYWORDS;
        }
        return new Arity(argsNode.getPreCount(), argsNode.getOptionalArgsCount(), argsNode.hasRestArg(), argsNode.getPostCount(), keywordArguments, argsNode.hasKeyRest());
    }

    public RubyNode visitSuperNode(SuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), node.getArgsNode(), this.environment.getNamedMethodName());
        ReadSuperArgumentsNode arguments = new ReadSuperArgumentsNode(this.context, sourceSection, argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted());
        RubyNode block = this.executeOrInheritBlock(sourceSection, argumentsAndBlock.getBlock());
        return new SuperCallNode(this.context, sourceSection, arguments, block);
    }

    public RubyNode visitZSuperNode(ZSuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.isBlock()) {
            this.environment.setNeedsDeclarationFrame();
        }
        this.currentCallMethodName = this.environment.getNamedMethodName();
        RubyNode blockNode = node.getIterNode() != null ? (RubyNode)node.getIterNode().accept((NodeVisitor)this) : null;
        boolean insideDefineMethod = false;
        MethodTranslator methodArgumentsTranslator = this;
        while (methodArgumentsTranslator.isBlock) {
            if (!(methodArgumentsTranslator.parent instanceof MethodTranslator)) {
                return new ZSuperOutsideMethodNode(this.context, sourceSection, insideDefineMethod);
            }
            if (methodArgumentsTranslator.currentCallMethodName.equals("define_method")) {
                insideDefineMethod = true;
            }
            methodArgumentsTranslator = (MethodTranslator)methodArgumentsTranslator.parent;
        }
        ReloadArgumentsTranslator reloadTranslator = new ReloadArgumentsTranslator(this.currentNode, this.context, this.source, this);
        ArgsNode argsNode = methodArgumentsTranslator.argsNode;
        SequenceNode reloadSequence = (SequenceNode)reloadTranslator.visitArgsNode(argsNode);
        ReadZSuperArgumentsNode arguments = new ReadZSuperArgumentsNode(this.context, sourceSection, reloadTranslator.isSplatted(), reloadSequence.getSequence());
        RubyNode block = this.executeOrInheritBlock(sourceSection, blockNode);
        return new SuperCallNode(this.context, sourceSection, arguments, block);
    }

    private RubyNode executeOrInheritBlock(SourceSection sourceSection, RubyNode blockNode) {
        if (blockNode != null) {
            return blockNode;
        }
        return new ReadBlockNode(this.context.getCoreLibrary().getNilObject());
    }

    @Override
    protected FlipFlopStateNode createFlipFlopState(SourceSection sourceSection, int depth) {
        if (this.isBlock) {
            this.environment.setNeedsDeclarationFrame();
            return this.parent.createFlipFlopState(sourceSection, depth + 1);
        }
        return super.createFlipFlopState(sourceSection, depth);
    }

    public TranslatorState getCurrentState() {
        return new TranslatorState(this.getEnvironment().getLexicalScope(), new ArrayDeque(this.parentSourceSection));
    }

    public void restoreState(TranslatorState state) {
        this.getEnvironment().getParseEnvironment().resetLexicalScope(state.scope);
        this.parentSourceSection = state.parentSourceSection;
    }

    private static SourceSection considerExtendingMethodToCoverEnd(SourceSection sourceSection) {
        if (sourceSection == null) {
            return sourceSection;
        }
        Source source = sourceSection.getSource();
        if (sourceSection.getEndLine() + 1 >= source.getLineCount()) {
            return sourceSection;
        }
        String indentationOnFirstLine = MethodTranslator.indentation(source.getCode(sourceSection.getStartLine()));
        int lineAfter = sourceSection.getEndLine() + 1;
        do {
            String lineAfterString;
            if (!(lineAfterString = source.getCode(lineAfter).replaceAll("\\s+$", "")).equals(indentationOnFirstLine + "end") && !lineAfterString.equals(indentationOnFirstLine + "}")) continue;
            return source.createSection(sourceSection.getIdentifier(), sourceSection.getCharIndex(), sourceSection.getCharLength() + 1 + source.getLineLength(lineAfter));
        } while (++lineAfter < source.getLineCount());
        return sourceSection;
    }

    private static String indentation(String line) {
        for (int n = 0; n < line.length(); ++n) {
            if (Character.isWhitespace(line.charAt(n))) continue;
            return line.substring(0, n);
        }
        return "";
    }

    public static class TranslatorState {
        private final LexicalScope scope;
        private final Deque<SourceSection> parentSourceSection;

        private TranslatorState(LexicalScope scope, Deque<SourceSection> parentSourceSection) {
            this.scope = scope;
            this.parentSourceSection = parentSourceSection;
        }
    }
}

