/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ShortBuffer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJCustomFilter;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.TJTransform;
import org.libjpegturbo.turbojpeg.TJTransformer;

public class TJExample
implements TJCustomFilter {
    public static final String classname = new TJExample().getClass().getName();
    private static final String[] sampName = new String[]{"4:4:4", "4:2:2", "4:2:0", "Grayscale", "4:4:0"};
    static TJScalingFactor[] sf = null;

    private static void usage() throws Exception {
        System.out.println("\nUSAGE: java " + classname + " <Input file> <Output file> [options]\n");
        System.out.println("Input and output files can be any image format that the Java Image I/O");
        System.out.println("extensions understand.  If either filename ends in a .jpg extension, then");
        System.out.println("TurboJPEG will be used to compress or decompress the file.\n");
        System.out.println("Options:\n");
        System.out.println("-scale M/N = if the input image is a JPEG file, scale the width/height of the");
        System.out.print("             output image by a factor of M/N (M/N = ");
        for (int i = 0; i < sf.length; ++i) {
            System.out.print(sf[i].getNum() + "/" + sf[i].getDenom());
            if (sf.length == 2 && i != sf.length - 1) {
                System.out.print(" or ");
                continue;
            }
            if (sf.length <= 2) continue;
            if (i != sf.length - 1) {
                System.out.print(", ");
            }
            if (i != sf.length - 2) continue;
            System.out.print("or ");
        }
        System.out.println(")\n");
        System.out.println("-samp <444|422|420|gray> = If the output image is a JPEG file, this specifies");
        System.out.println("                           the level of chrominance subsampling to use when");
        System.out.println("                           recompressing it.  Default is to use the same level");
        System.out.println("                           of subsampling as the input, if the input is a JPEG");
        System.out.println("                           file, or 4:4:4 otherwise.\n");
        System.out.println("-q <1-100> = If the output image is a JPEG file, this specifies the JPEG");
        System.out.println("             quality to use when recompressing it (default = 95).\n");
        System.out.println("-hflip, -vflip, -transpose, -transverse, -rot90, -rot180, -rot270 =");
        System.out.println("     If the input image is a JPEG file, perform the corresponding lossless");
        System.out.println("     transform prior to decompression (these options are mutually exclusive)\n");
        System.out.println("-grayscale = If the input image is a JPEG file, perform lossless grayscale");
        System.out.println("     conversion prior to decompression (can be combined with the other");
        System.out.println("     transforms above)\n");
        System.out.println("-crop X,Y,WxH = If the input image is a JPEG file, perform lossless cropping");
        System.out.println("     prior to decompression.  X,Y specifies the upper left corner of the");
        System.out.println("     cropping region, and WxH specifies its width and height.  X,Y must be");
        System.out.println("     evenly divible by the MCU block size (8x8 if the source image was");
        System.out.println("     compressed using no subsampling or grayscale, or 16x8 for 4:2:2 or 16x16");
        System.out.println("     for 4:2:0.)\n");
        System.out.println("-display = Display output image (Output file need not be specified in this");
        System.out.println("     case.)\n");
        System.out.println("-fastupsample = Use the fastest chrominance upsampling algorithm available in");
        System.out.println("     the underlying codec\n");
        System.out.println("-fastdct = Use the fastest DCT/IDCT algorithms available in the underlying");
        System.out.println("     codec\n");
        System.out.println("-accuratedct = Use the most accurate DCT/IDCT algorithms available in the");
        System.out.println("     underlying codec\n");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        BufferedImage bufferedImage = null;
        byte[] byArray = null;
        TJTransform tJTransform = new TJTransform();
        int n = 0;
        try {
            int n2;
            Closeable closeable;
            byte[] byArray2;
            String[] stringArray2;
            int n3;
            int n4;
            Object object;
            sf = TJ.getScalingFactors();
            if (stringArray.length < 2) {
                TJExample.usage();
            }
            TJScalingFactor tJScalingFactor = new TJScalingFactor(1, 1);
            String string = "jpg";
            String string2 = "jpg";
            int n5 = -1;
            int n6 = 95;
            boolean bl = false;
            if (stringArray.length > 1) {
                for (int i = 1; i < stringArray.length; ++i) {
                    int n7;
                    if (stringArray[i].length() < 2) continue;
                    if (stringArray[i].length() > 2 && stringArray[i].substring(0, 3).equalsIgnoreCase("-sc")) {
                        n7 = 0;
                        if (i < stringArray.length - 1 && ((String[])(object = stringArray[++i].split("/"))).length == 2) {
                            TJScalingFactor tJScalingFactor2 = new TJScalingFactor(Integer.parseInt(object[0]), Integer.parseInt(object[1]));
                            for (n4 = 0; n4 < sf.length; ++n4) {
                                if (!tJScalingFactor2.equals(sf[n4])) continue;
                                tJScalingFactor = sf[n4];
                                n7 = 1;
                                break;
                            }
                        }
                        if (n7 != 1) {
                            TJExample.usage();
                        }
                    }
                    if (stringArray[i].equalsIgnoreCase("-h") || stringArray[i].equalsIgnoreCase("-?")) {
                        TJExample.usage();
                    }
                    if (stringArray[i].length() > 2 && stringArray[i].substring(0, 3).equalsIgnoreCase("-sa")) {
                        if (i < stringArray.length - 1) {
                            if (stringArray[++i].substring(0, 1).equalsIgnoreCase("g")) {
                                n5 = 3;
                            } else if (stringArray[i].equals("444")) {
                                n5 = 0;
                            } else if (stringArray[i].equals("422")) {
                                n5 = 1;
                            } else if (stringArray[i].equals("420")) {
                                n5 = 2;
                            } else {
                                TJExample.usage();
                            }
                        } else {
                            TJExample.usage();
                        }
                    }
                    if (stringArray[i].substring(0, 2).equalsIgnoreCase("-q")) {
                        if (i < stringArray.length - 1) {
                            if ((n7 = Integer.parseInt(stringArray[++i])) >= 1 && n7 <= 100) {
                                n6 = n7;
                            } else {
                                TJExample.usage();
                            }
                        } else {
                            TJExample.usage();
                        }
                    }
                    if (stringArray[i].substring(0, 2).equalsIgnoreCase("-g")) {
                        tJTransform.options |= 8;
                    }
                    if (stringArray[i].equalsIgnoreCase("-hflip")) {
                        tJTransform.op = 1;
                    }
                    if (stringArray[i].equalsIgnoreCase("-vflip")) {
                        tJTransform.op = 2;
                    }
                    if (stringArray[i].equalsIgnoreCase("-transpose")) {
                        tJTransform.op = 3;
                    }
                    if (stringArray[i].equalsIgnoreCase("-transverse")) {
                        tJTransform.op = 4;
                    }
                    if (stringArray[i].equalsIgnoreCase("-rot90")) {
                        tJTransform.op = 5;
                    }
                    if (stringArray[i].equalsIgnoreCase("-rot180")) {
                        tJTransform.op = 6;
                    }
                    if (stringArray[i].equalsIgnoreCase("-rot270")) {
                        tJTransform.op = 7;
                    }
                    if (stringArray[i].equalsIgnoreCase("-custom")) {
                        tJTransform.cf = new TJExample();
                    } else if (stringArray[i].length() > 2 && stringArray[i].substring(0, 2).equalsIgnoreCase("-c")) {
                        String[] stringArray3;
                        if (i >= stringArray.length - 1) {
                            TJExample.usage();
                        }
                        if ((stringArray3 = stringArray[++i].split(",")).length != 3) {
                            TJExample.usage();
                        }
                        if (((String[])(object = stringArray3[2].split("[xX]"))).length != 2) {
                            TJExample.usage();
                        }
                        int n8 = Integer.parseInt(stringArray3[0]);
                        n4 = Integer.parseInt(stringArray3[1]);
                        int n9 = Integer.parseInt(object[0]);
                        n3 = Integer.parseInt(object[1]);
                        if (n8 < 0 || n4 < 0 || n9 < 0 || n3 < 0) {
                            TJExample.usage();
                        }
                        tJTransform.x = n8;
                        tJTransform.y = n4;
                        tJTransform.width = n9;
                        tJTransform.height = n3;
                        tJTransform.options |= 4;
                    }
                    if (stringArray[i].substring(0, 2).equalsIgnoreCase("-d")) {
                        bl = true;
                    }
                    if (stringArray[i].equalsIgnoreCase("-fastupsample")) {
                        System.out.println("Using fast upsampling code");
                        n |= 0x100;
                    }
                    if (stringArray[i].equalsIgnoreCase("-fastdct")) {
                        System.out.println("Using fastest DCT/IDCT algorithm");
                        n |= 0x800;
                    }
                    if (!stringArray[i].equalsIgnoreCase("-accuratedct")) continue;
                    System.out.println("Using most accurate DCT/IDCT algorithm");
                    n |= 0x1000;
                }
            }
            if ((stringArray2 = stringArray[0].split("\\.")).length > 1) {
                string = stringArray2[stringArray2.length - 1];
            }
            if (bl) {
                string2 = "bmp";
            } else {
                String[] stringArray4 = stringArray[1].split("\\.");
                if (stringArray4.length > 1) {
                    string2 = stringArray4[stringArray4.length - 1];
                }
            }
            object = new File(stringArray[0]);
            if (string.equalsIgnoreCase("jpg")) {
                Object object2;
                FileInputStream fileInputStream = new FileInputStream((File)object);
                n3 = fileInputStream.available();
                if (n3 < 1) {
                    System.out.println("Input file contains no data");
                    System.exit(1);
                }
                byArray2 = new byte[n3];
                fileInputStream.read(byArray2);
                fileInputStream.close();
                if (tJTransform.op != 0 || tJTransform.options != 0 || tJTransform.cf != null) {
                    TJTransformer tJTransformer = new TJTransformer(byArray2);
                    object2 = new TJTransform[]{tJTransform};
                    object2[0].options |= 2;
                    TJDecompressor[] tJDecompressorArray = tJTransformer.transform((TJTransform[])object2, 0);
                    closeable = tJDecompressorArray[0];
                } else {
                    closeable = new TJDecompressor(byArray2);
                }
                n2 = ((TJDecompressor)closeable).getWidth();
                n4 = ((TJDecompressor)closeable).getHeight();
                int n10 = ((TJDecompressor)closeable).getSubsamp();
                System.out.println("Source Image: " + n2 + " x " + n4 + " pixels, " + sampName[n10] + " subsampling");
                if (n5 < 0) {
                    n5 = n10;
                }
                if (string2.equalsIgnoreCase("jpg") && (tJTransform.op != 0 || tJTransform.options != 0) && tJScalingFactor.isOne()) {
                    object = new File(stringArray[1]);
                    object2 = new FileOutputStream((File)object);
                    ((FileOutputStream)object2).write(((TJDecompressor)closeable).getJPEGBuf(), 0, ((TJDecompressor)closeable).getJPEGSize());
                    ((FileOutputStream)object2).close();
                    System.exit(0);
                }
                n2 = tJScalingFactor.getScaled(n2);
                n4 = tJScalingFactor.getScaled(n4);
                if (!string2.equalsIgnoreCase("jpg")) {
                    bufferedImage = ((TJDecompressor)closeable).decompress(n2, n4, 1, n);
                } else {
                    byArray = ((TJDecompressor)closeable).decompress(n2, 0, n4, 3, n);
                }
                ((TJDecompressor)closeable).close();
            } else {
                bufferedImage = ImageIO.read((File)object);
                if (bufferedImage == null) {
                    throw new Exception("Input image type not supported.");
                }
                n2 = bufferedImage.getWidth();
                n4 = bufferedImage.getHeight();
                if (n5 < 0) {
                    n5 = bufferedImage.getType() == 10 ? 3 : 0;
                }
            }
            System.gc();
            if (!bl) {
                System.out.print("Dest. Image (" + string2 + "):  " + n2 + " x " + n4 + " pixels");
            }
            if (bl) {
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                JLabel jLabel = new JLabel(imageIcon, 0);
                JOptionPane.showMessageDialog(null, jLabel, "Output Image", -1);
            } else if (string2.equalsIgnoreCase("jpg")) {
                System.out.println(", " + sampName[n5] + " subsampling, quality = " + n6);
                TJCompressor tJCompressor = new TJCompressor();
                tJCompressor.setSubsamp(n5);
                tJCompressor.setJPEGQuality(n6);
                if (bufferedImage != null) {
                    tJCompressor.setSourceImage(bufferedImage, 0, 0, 0, 0);
                } else {
                    tJCompressor.setSourceImage(byArray, 0, 0, n2, 0, n4, 3);
                }
                byArray2 = tJCompressor.compress(n);
                n3 = tJCompressor.getCompressedSize();
                tJCompressor.close();
                object = new File(stringArray[1]);
                closeable = new FileOutputStream((File)object);
                ((FileOutputStream)closeable).write(byArray2, 0, n3);
                ((FileOutputStream)closeable).close();
            } else {
                System.out.print("\n");
                object = new File(stringArray[1]);
                ImageIO.write((RenderedImage)bufferedImage, string2, (File)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void customFilter(ShortBuffer shortBuffer, Rectangle rectangle, Rectangle rectangle2, int n, int n2, TJTransform tJTransform) throws TJException {
        for (int i = 0; i < rectangle.width * rectangle.height; ++i) {
            shortBuffer.put(i, -shortBuffer.get(i));
        }
    }
}

