import QtQuick 2.0

// This file describes the plugin-supplied types contained in the library.
// It is used for QML tooling purposes only.
//
// This file was auto-generated by:
// 'qmlplugindump -notrelocatable QtBluetooth 5.2'

Module {
    Component {
        name: "QDeclarativeBluetoothDiscoveryModel"
        prototype: "QAbstractListModel"
        exports: [
            "QtBluetooth/BluetoothDiscoveryModel 5.0",
            "QtBluetooth/BluetoothDiscoveryModel 5.2"
        ]
        exportMetaObjectRevisions: [0, 0]
        Enum {
            name: "DiscoveryMode"
            values: {
                "MinimalServiceDiscovery": 0,
                "FullServiceDiscovery": 1,
                "DeviceDiscovery": 2
            }
        }
        Enum {
            name: "Error"
            values: {
                "NoError": 0,
                "InputOutputError": 1,
                "PoweredOffError": 2,
                "UnknownError": 3
            }
        }
        Property { name: "error"; type: "Error"; isReadonly: true }
        Property { name: "discoveryMode"; type: "DiscoveryMode" }
        Property { name: "running"; type: "bool" }
        Property { name: "uuidFilter"; type: "string" }
        Property { name: "remoteAddress"; type: "string" }
        Signal {
            name: "serviceDiscovered"
            Parameter { name: "service"; type: "QDeclarativeBluetoothService"; isPointer: true }
        }
        Signal {
            name: "deviceDiscovered"
            Parameter { name: "device"; type: "string" }
        }
    }
    Component {
        name: "QDeclarativeBluetoothService"
        prototype: "QObject"
        exports: [
            "QtBluetooth/BluetoothService 5.0",
            "QtBluetooth/BluetoothService 5.2"
        ]
        exportMetaObjectRevisions: [0, 0]
        Enum {
            name: "Protocol"
            values: {
                "RfcommProtocol": 2,
                "L2CapProtocol": 1,
                "UnknownProtocol": 0
            }
        }
        Property { name: "deviceName"; type: "string"; isReadonly: true }
        Property { name: "deviceAddress"; type: "string" }
        Property { name: "serviceName"; type: "string" }
        Property { name: "serviceDescription"; type: "string" }
        Property { name: "serviceUuid"; type: "string" }
        Property { name: "serviceProtocol"; type: "Protocol" }
        Property { name: "registered"; type: "bool" }
        Signal { name: "detailsChanged" }
        Signal { name: "newClient" }
        Method { name: "nextClient"; type: "QDeclarativeBluetoothSocket*" }
        Method {
            name: "assignNextClient"
            Parameter { name: "dbs"; type: "QDeclarativeBluetoothSocket"; isPointer: true }
        }
    }
    Component {
        name: "QDeclarativeBluetoothSocket"
        prototype: "QObject"
        exports: [
            "QtBluetooth/BluetoothSocket 5.0",
            "QtBluetooth/BluetoothSocket 5.2"
        ]
        exportMetaObjectRevisions: [0, 0]
        Enum {
            name: "Error"
            values: {
                "NoError": -2,
                "UnknownSocketError": -1,
                "HostNotFoundError": 2,
                "ServiceNotFoundError": 9,
                "NetworkError": 7,
                "UnsupportedProtocolError": 8
            }
        }
        Enum {
            name: "SocketState"
            values: {
                "Unconnected": 0,
                "ServiceLookup": 1,
                "Connecting": 2,
                "Connected": 3,
                "Bound": 4,
                "Closing": 6,
                "Listening": 5,
                "NoServiceSet": 100
            }
        }
        Property { name: "service"; type: "QDeclarativeBluetoothService"; isPointer: true }
        Property { name: "connected"; type: "bool" }
        Property { name: "error"; type: "Error"; isReadonly: true }
        Property { name: "socketState"; type: "SocketState"; isReadonly: true }
        Property { name: "stringData"; type: "string" }
        Signal { name: "stateChanged" }
        Signal { name: "dataAvailable" }
        Method {
            name: "setService"
            Parameter { name: "service"; type: "QDeclarativeBluetoothService"; isPointer: true }
        }
        Method {
            name: "setConnected"
            Parameter { name: "connected"; type: "bool" }
        }
        Method {
            name: "sendStringData"
            Parameter { name: "data"; type: "string" }
        }
    }
}
