/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetaData;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ConfigurationMetaData;
import org.gradle.internal.component.model.DefaultDependencyMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleDescriptorBackedMetaData
implements ComponentResolveMetaData {
    private ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleDescriptor moduleDescriptor;
    private ComponentIdentifier componentIdentifier;
    private ModuleSource moduleSource;
    private boolean changing;
    private String status;
    private List<String> statusScheme = DEFAULT_STATUS_SCHEME;
    private List<DependencyMetaData> dependencies;
    private Map<String, DefaultConfigurationMetaData> configurations = new HashMap<String, DefaultConfigurationMetaData>();

    public AbstractModuleDescriptorBackedMetaData(ModuleVersionIdentifier moduleVersionIdentifier, ModuleDescriptor moduleDescriptor, ComponentIdentifier componentIdentifier) {
        this.moduleVersionIdentifier = moduleVersionIdentifier;
        this.moduleDescriptor = moduleDescriptor;
        this.componentIdentifier = componentIdentifier;
        this.status = moduleDescriptor.getStatus();
    }

    protected void copyTo(AbstractModuleDescriptorBackedMetaData copy) {
        copy.dependencies = this.dependencies;
        copy.changing = this.changing;
        copy.status = this.status;
        copy.statusScheme = this.statusScheme;
        copy.moduleSource = this.moduleSource;
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.moduleVersionIdentifier;
    }

    public void setId(ModuleVersionIdentifier moduleVersionIdentifier) {
        this.moduleVersionIdentifier = moduleVersionIdentifier;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    public void setSource(ModuleSource source) {
        this.moduleSource = source;
    }

    public void setModuleSource(ModuleSource moduleSource) {
        this.moduleSource = moduleSource;
    }

    public ModuleDescriptor getDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    public boolean isGenerated() {
        return this.moduleDescriptor.isDefault();
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    public void setComponentId(ComponentIdentifier componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
    }

    public void setChanging(boolean changing) {
        this.changing = changing;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatusScheme(List<String> statusScheme) {
        this.statusScheme = statusScheme;
    }

    @Override
    public List<DependencyMetaData> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = this.populateDependenciesFromDescriptor();
        }
        return this.dependencies;
    }

    protected List<DependencyMetaData> populateDependenciesFromDescriptor() {
        ArrayList<DependencyMetaData> dependencies = new ArrayList<DependencyMetaData>();
        for (DependencyDescriptor dependencyDescriptor : this.moduleDescriptor.getDependencies()) {
            dependencies.add(new DefaultDependencyMetaData(dependencyDescriptor));
        }
        return dependencies;
    }

    public void setDependencies(Iterable<? extends DependencyMetaData> dependencies) {
        this.dependencies = CollectionUtils.toList(dependencies);
        for (DefaultConfigurationMetaData configuration : this.configurations.values()) {
            configuration.dependencies = null;
        }
    }

    @Override
    public Set<String> getConfigurationNames() {
        return Sets.newHashSet((Object[])this.moduleDescriptor.getConfigurationsNames());
    }

    @Override
    public DefaultConfigurationMetaData getConfiguration(String name) {
        DefaultConfigurationMetaData configuration = this.configurations.get(name);
        if (configuration == null) {
            configuration = this.populateConfigurationFromDescriptor(name);
        }
        return configuration;
    }

    private DefaultConfigurationMetaData populateConfigurationFromDescriptor(String name) {
        Configuration descriptorConfiguration = this.moduleDescriptor.getConfiguration(name);
        if (descriptorConfiguration == null) {
            return null;
        }
        LinkedHashSet<String> hierarchy = new LinkedHashSet<String>();
        hierarchy.add(name);
        for (String parent : descriptorConfiguration.getExtends()) {
            hierarchy.addAll(this.getConfiguration(parent).hierarchy);
        }
        DefaultConfigurationMetaData configuration = new DefaultConfigurationMetaData(name, descriptorConfiguration, hierarchy);
        this.configurations.put(name, configuration);
        return configuration;
    }

    protected abstract Set<ComponentArtifactMetaData> getArtifactsForConfiguration(ConfigurationMetaData var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultConfigurationMetaData
    implements ConfigurationMetaData {
        private final String name;
        private final Configuration descriptor;
        private final Set<String> hierarchy;
        private List<DependencyMetaData> dependencies;
        private Set<ComponentArtifactMetaData> artifacts;
        private LinkedHashSet<ExcludeRule> excludeRules;

        private DefaultConfigurationMetaData(String name, Configuration descriptor, Set<String> hierarchy) {
            this.name = name;
            this.descriptor = descriptor;
            this.hierarchy = hierarchy;
        }

        public String toString() {
            return AbstractModuleDescriptorBackedMetaData.this.componentIdentifier.getDisplayName() + ":" + this.name;
        }

        @Override
        public ComponentResolveMetaData getComponent() {
            return AbstractModuleDescriptorBackedMetaData.this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public boolean isTransitive() {
            return this.descriptor.isTransitive();
        }

        @Override
        public boolean isVisible() {
            return this.descriptor.getVisibility() == Configuration.Visibility.PUBLIC;
        }

        @Override
        public List<DependencyMetaData> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<DependencyMetaData>();
                for (DependencyMetaData dependency : AbstractModuleDescriptorBackedMetaData.this.getDependencies()) {
                    if (!this.include(dependency)) continue;
                    this.dependencies.add(dependency);
                }
            }
            return this.dependencies;
        }

        private boolean include(DependencyMetaData dependency) {
            String[] moduleConfigurations = dependency.getModuleConfigurations();
            for (int i = 0; i < moduleConfigurations.length; ++i) {
                String moduleConfiguration = moduleConfigurations[i];
                if (moduleConfiguration.equals("%") || this.hierarchy.contains(moduleConfiguration)) {
                    return true;
                }
                if (!moduleConfiguration.equals("*")) continue;
                boolean include = true;
                for (int j = i + 1; j < moduleConfigurations.length && moduleConfigurations[j].startsWith("!"); ++j) {
                    if (!moduleConfigurations[j].substring(1).equals(this.getName())) continue;
                    include = false;
                    break;
                }
                if (!include) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<ExcludeRule> getExcludeRules() {
            if (this.excludeRules == null) {
                this.populateExcludeRulesFromDescriptor();
            }
            return this.excludeRules;
        }

        private void populateExcludeRulesFromDescriptor() {
            this.excludeRules = new LinkedHashSet();
            block0: for (ExcludeRule excludeRule : AbstractModuleDescriptorBackedMetaData.this.moduleDescriptor.getAllExcludeRules()) {
                for (String config : excludeRule.getConfigurations()) {
                    if (!this.hierarchy.contains(config)) continue;
                    this.excludeRules.add(excludeRule);
                    continue block0;
                }
            }
        }

        @Override
        public Set<ComponentArtifactMetaData> getArtifacts() {
            if (this.artifacts == null) {
                this.artifacts = AbstractModuleDescriptorBackedMetaData.this.getArtifactsForConfiguration(this);
            }
            return this.artifacts;
        }

        @Override
        public ModuleComponentArtifactMetaData artifact(IvyArtifactName artifact) {
            return new DefaultModuleComponentArtifactMetaData((ModuleComponentIdentifier)AbstractModuleDescriptorBackedMetaData.this.getComponentId(), artifact);
        }
    }
}

