/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.component.Artifact;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.plugins.ide.internal.resolver.DefaultIdeDependencyResolver;
import org.gradle.plugins.ide.internal.resolver.IdeDependencyResolver;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;
import org.gradle.plugins.ide.internal.resolver.model.UnresolvedIdeRepoFileDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeDependenciesExtractor {
    private final IdeDependencyResolver ideDependencyResolver = new DefaultIdeDependencyResolver();

    public Collection<IdeProjectDependency> extractProjectDependencies(Project project, Collection<Configuration> plusConfigurations, Collection<Configuration> minusConfigurations) {
        LinkedHashMap<String, IdeProjectDependency> deps = new LinkedHashMap<String, IdeProjectDependency>();
        for (Configuration plusConfiguration : plusConfigurations) {
            for (IdeProjectDependency dep : this.ideDependencyResolver.getIdeProjectDependencies(plusConfiguration, project)) {
                deps.put(dep.getProjectPath(), dep);
            }
        }
        for (Configuration minusConfiguration : minusConfigurations) {
            for (IdeProjectDependency dep : this.ideDependencyResolver.getIdeProjectDependencies(minusConfiguration, project)) {
                deps.remove(dep.getProjectPath());
            }
        }
        return deps.values();
    }

    public Collection<IdeExtendedRepoFileDependency> extractRepoFileDependencies(DependencyHandler dependencyHandler, Collection<Configuration> plusConfigurations, Collection<Configuration> minusConfigurations, boolean downloadSources, boolean downloadJavadoc) {
        LinkedHashMultimap resolvedDependenciesComponentMap = LinkedHashMultimap.create();
        for (IdeExtendedRepoFileDependency dep : this.resolvedExternalDependencies(plusConfigurations, minusConfigurations)) {
            resolvedDependenciesComponentMap.put((Object)this.toComponentIdentifier(dep.getId()), (Object)dep);
        }
        ArrayList<Class<? extends Artifact>> artifactTypes = new ArrayList<Class<? extends Artifact>>(2);
        if (downloadSources) {
            artifactTypes.add(SourcesArtifact.class);
        }
        if (downloadJavadoc) {
            artifactTypes.add(JavadocArtifact.class);
        }
        IdeDependenciesExtractor.downloadAuxiliaryArtifacts(dependencyHandler, (Multimap<ComponentIdentifier, IdeExtendedRepoFileDependency>)resolvedDependenciesComponentMap, artifactTypes);
        Collection<UnresolvedIdeRepoFileDependency> unresolvedDependencies = this.unresolvedExternalDependencies(plusConfigurations, minusConfigurations);
        Collection resolvedDependencies = resolvedDependenciesComponentMap.values();
        ArrayList<IdeExtendedRepoFileDependency> resolvedAndUnresolved = new ArrayList<IdeExtendedRepoFileDependency>(unresolvedDependencies.size() + resolvedDependencies.size());
        resolvedAndUnresolved.addAll(resolvedDependencies);
        resolvedAndUnresolved.addAll(unresolvedDependencies);
        return resolvedAndUnresolved;
    }

    private ModuleComponentIdentifier toComponentIdentifier(ModuleVersionIdentifier id) {
        return new DefaultModuleComponentIdentifier(id.getGroup(), id.getName(), id.getVersion());
    }

    private static void downloadAuxiliaryArtifacts(DependencyHandler dependencyHandler, Multimap<ComponentIdentifier, IdeExtendedRepoFileDependency> dependencies, List<Class<? extends Artifact>> artifactTypes) {
        if (artifactTypes.isEmpty()) {
            return;
        }
        ArtifactResolutionQuery query = dependencyHandler.createArtifactResolutionQuery();
        query.forComponents((Iterable)dependencies.keySet());
        Class[] artifactTypesArray = artifactTypes.toArray(new Class[0]);
        query.withArtifacts(JvmLibrary.class, artifactTypesArray);
        Set componentResults = query.execute().getResolvedComponents();
        for (ComponentArtifactsResult componentResult : componentResults) {
            for (IdeExtendedRepoFileDependency dependency : dependencies.get((Object)componentResult.getId())) {
                for (ArtifactResult sourcesResult : componentResult.getArtifacts(SourcesArtifact.class)) {
                    if (!(sourcesResult instanceof ResolvedArtifactResult)) continue;
                    dependency.addSourceFile(((ResolvedArtifactResult)sourcesResult).getFile());
                }
                for (ArtifactResult javadocResult : componentResult.getArtifacts(JavadocArtifact.class)) {
                    if (!(javadocResult instanceof ResolvedArtifactResult)) continue;
                    dependency.addJavadocFile(((ResolvedArtifactResult)javadocResult).getFile());
                }
            }
        }
    }

    public Collection<UnresolvedIdeRepoFileDependency> unresolvedExternalDependencies(Iterable<Configuration> plusConfigurations, Iterable<Configuration> minusConfigurations) {
        List<UnresolvedIdeRepoFileDependency> deps;
        LinkedHashMap<File, UnresolvedIdeRepoFileDependency> unresolved = new LinkedHashMap<File, UnresolvedIdeRepoFileDependency>();
        for (Configuration c : plusConfigurations) {
            deps = this.ideDependencyResolver.getUnresolvedIdeRepoFileDependencies(c);
            for (UnresolvedIdeRepoFileDependency dep : deps) {
                unresolved.put(dep.getFile(), dep);
            }
        }
        for (Configuration c : minusConfigurations) {
            deps = this.ideDependencyResolver.getUnresolvedIdeRepoFileDependencies(c);
            for (UnresolvedIdeRepoFileDependency dep : deps) {
                unresolved.remove(dep.getFile());
            }
        }
        return unresolved.values();
    }

    public Collection<IdeLocalFileDependency> extractLocalFileDependencies(Collection<Configuration> plusConfigurations, Collection<Configuration> minusConfigurations) {
        LinkedHashMap<File, IdeLocalFileDependency> fileToConf = new LinkedHashMap<File, IdeLocalFileDependency>();
        if (plusConfigurations != null) {
            for (Configuration plusConfiguration : plusConfigurations) {
                for (IdeLocalFileDependency localFileDependency : this.ideDependencyResolver.getIdeLocalFileDependencies(plusConfiguration)) {
                    fileToConf.put(localFileDependency.getFile(), localFileDependency);
                }
            }
        }
        if (minusConfigurations != null) {
            for (Configuration minusConfiguration : minusConfigurations) {
                for (IdeLocalFileDependency localFileDependency : this.ideDependencyResolver.getIdeLocalFileDependencies(minusConfiguration)) {
                    fileToConf.remove(localFileDependency.getFile());
                }
            }
        }
        return fileToConf.values();
    }

    public Collection<IdeExtendedRepoFileDependency> resolvedExternalDependencies(Collection<Configuration> plusConfigurations, Collection<Configuration> minusConfigurations) {
        LinkedHashMap<File, IdeExtendedRepoFileDependency> out = new LinkedHashMap<File, IdeExtendedRepoFileDependency>();
        if (plusConfigurations != null) {
            for (Configuration plusConfiguration : plusConfigurations) {
                for (IdeExtendedRepoFileDependency artifact : this.ideDependencyResolver.getIdeRepoFileDependencies(plusConfiguration)) {
                    out.put(artifact.getFile(), artifact);
                }
            }
        }
        if (minusConfigurations != null) {
            for (Configuration minusConfiguration : minusConfigurations) {
                for (IdeExtendedRepoFileDependency artifact : this.ideDependencyResolver.getIdeRepoFileDependencies(minusConfiguration)) {
                    out.remove(artifact.getFile());
                }
            }
        }
        return out.values();
    }
}

