#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cryptohash-sha256
version: 0.11.100.1
id: cryptohash-sha256-0.11.100.1-CxymMT87vhE9zOHmyydW84
key: cryptohash-sha256-0.11.100.1-CxymMT87vhE9zOHmyydW84
license: BSD3
copyright: Vincent Hanquez, Herbert Valerio Riedel
maintainer: Herbert Valerio Riedel <hvr@gnu.org>
homepage: https://github.com/hvr/cryptohash-sha256
synopsis: Fast, pure and practical SHA-256 implementation
description:
    A practical incremental and one-pass, pure API to the
    <https://en.wikipedia.org/wiki/SHA-2 SHA-256 hash algorithm>
    (including <https://en.wikipedia.org/wiki/HMAC HMAC> support)
    with performance close to the fastest implementations available in other languages.
    .
    The implementation is made in C with a haskell FFI wrapper that hides the C implementation.
    .
    NOTE: This package has been forked off @cryptohash-0.11.7@ because the @cryptohash@ package has been
    deprecated and so this package continues to satisfy the need for a lightweight package
    providing the SHA256 hash algorithm without any dependencies on packages other than
    @base@ and @bytestring@.
    .
    Consequently, this package can be used as a drop-in replacement for @cryptohash@'\''s
    "Crypto.Hash.SHA256" module, though with a clearly smaller footprint.
category: Data, Cryptography
exposed: True
exposed-modules:
    Crypto.Hash.SHA256
abi: 8101c968c4727fd36492ce9c28eb6f41
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/cryptohash-sha256-0.11.100.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/cryptohash-sha256-0.11.100.1
data-dir: /usr/share/arm-linux-ghc-8.0.1/cryptohash-sha256-0.11.100.1
hs-libraries: HScryptohash-sha256-0.11.100.1-CxymMT87vhE9zOHmyydW84
depends:
    base-4.9.0.0 bytestring-0.10.8.1
haddock-interfaces: /usr/share/doc/haskell-cryptohash-sha256/html/cryptohash-sha256.haddock
haddock-html: /usr/share/doc/haskell-cryptohash-sha256/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
