#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: wai-extra
version: 3.0.15.2
id: wai-extra-3.0.15.2-5kamB4j8CxXJtWL54vp4wE
key: wai-extra-3.0.15.2-5kamB4j8CxXJtWL54vp4wE
license: MIT
maintainer: michael@snoyman.com
stability: Stable
homepage: http://github.com/yesodweb/wai
synopsis: Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:
    .
    * WAI Testing Framework
    .
    Hspec testing facilities and helpers for WAI.
    .
    * Event Source/Event Stream
    .
    Send server events to the client. Compatible with the JavaScript
    EventSource API.
    .
    * Accept Override
    .
    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).
    .
    * Add Headers
    .
    WAI Middleware for adding arbitrary headers to an HTTP request.
    .
    * Clean Path
    .
    Clean a request path to a canonical form.
    .
    * GZip Compression
    .
    Negotiate HTTP payload gzip compression.
    .
    * HTTP Basic Authentication
    .
    WAI Basic Authentication Middleware which uses Authorization header.
    .
    * JSONP
    .
    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.
    .
    * Method Override / Post
    .
    Allows overriding of the HTTP request method via the _method query string
    parameter.
    .
    * Request Logging
    .
    Request logging middleware for development and production environments
    .
    * Request Rewrite
    .
    Rewrite request path info based on a custom conversion rules.
    .
    * Stream Files
    .
    Convert ResponseFile type responses into ResponseStream type.
    .
    * Virtual Host
    .
    Redirect incoming requests to a new host based on custom rules.
    .
    .
    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.
category: Web
author: Michael Snoyman
exposed: True
exposed-modules:
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.Local Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.Gzip Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.StripHeaders
    Network.Wai.Middleware.Vhost Network.Wai.Middleware.HttpAuth
    Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Routed Network.Wai.Parse Network.Wai.Request
    Network.Wai.UrlMap Network.Wai.Test Network.Wai.EventSource
    Network.Wai.EventSource.EventStream
hidden-modules: Network.Wai.Middleware.RequestLogger.Internal
abi: fecc8b2f4200cdb5dd783cbe8492a131
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/wai-extra-3.0.15.2
library-dirs: /usr/lib/ghc-8.0.1/site-local/wai-extra-3.0.15.2
data-dir: /usr/share/arm-linux-ghc-8.0.1/wai-extra-3.0.15.2
hs-libraries: HSwai-extra-3.0.15.2-5kamB4j8CxXJtWL54vp4wE
depends:
    aeson-0.11.2.0-FpCNsdqaa7PINk2PVkQvbE
    ansi-terminal-0.6.2.3-AKTYR0nthhUCHW4HMZvJFX base-4.9.0.0
    base64-bytestring-1.0.0.1-In9M41tLtcS9QYt3QpGpNY
    blaze-builder-0.4.0.2-2VmGHau0mFrAjwd4n28WWF bytestring-0.10.8.1
    case-insensitive-1.2.0.6-I0Jt0nwhqya3cOqVnbSTZ9 containers-0.5.7.1
    cookie-0.4.2-9rHTsgNPvKoHDPvx7iVkqH
    data-default-class-0.1.2.0-6eetmQ6CbQOLoXb6k5kODu deepseq-1.4.2.0
    directory-1.2.6.2 fast-logger-2.4.6-Ko6hpzrohxlG6RfUnE9VNU
    http-types-0.9.1-COSfHHdOet5Sq6KAE7lWN
    iproute-1.7.0-3gBtqYPiXNzAiDCAky7oBX
    lifted-base-0.2.3.6-1j3h4N3dJlkKcS6HOknNA
    network-2.6.2.1-Li0aefQhyJzUSpQ0fLiXL
    old-locale-1.0.0.7-6glXNhHF891B41ZfuI8hU8
    resourcet-1.1.7.4-5MzcrbA8GQD6CRuZwV7nMM
    streaming-commons-0.1.15.5-En1wshFTQl13cuLMoYsaBc
    stringsearch-0.3.6.6-DVhPUcSGzzGLKEmt1U9sof
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ time-1.6.0.1
    transformers-0.5.2.0 unix-2.7.2.0
    unix-compat-0.4.2.0-GNHotEMWE5dJ4oYFhgibIV
    vault-0.3.0.6-F37QKsKodXlCrvmF1zIJca
    void-0.7.1-9oQOb7QWXf9EsxgEg60dJq
    wai-3.2.1.1-FhGbGXgEdLG73fMsfll74t
    wai-logger-2.2.7-9GHIezeKe8i1PVwZYmIpR4
    word8-0.1.2-2E1SgvvAV2fK8vZPDHbRan
    zlib-0.6.1.1-IKN2DpYEe8r3bYFvs7BDUW
haddock-interfaces: /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html: /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
