/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.common;

import com.baselet.control.basics.XValues;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SeparatorLineFacet
extends Facet {
    public static final SeparatorLineFacet INSTANCE = new SeparatorLineFacet();
    private static final String KEY_PREFIX = "-";
    private final Map<String, LineType> variants = new HashMap<String, LineType>();
    private static final double Y_SPACE = 5.0;

    protected SeparatorLineFacet() {
        this.variants.put(KEY_PREFIX, null);
        for (LineType lt : LineType.LT_LIST) {
            this.variants.put(KEY_PREFIX + lt.getValue(), lt);
        }
    }

    @Override
    public void handleLine(String line, PropertiesParserState state) {
        DrawHandler drawer = state.getDrawer();
        LineType ltBefore = drawer.getLineType();
        LineType ltForLine = this.variants.get(line);
        if (ltForLine != null) {
            drawer.setLineType(ltForLine);
        }
        drawer.setLayer(DrawHandler.Layer.Foreground);
        double linePos = state.getTextPrintPosition() - drawer.textHeightMax() + 2.5;
        XValues xPos = state.getXLimits(linePos);
        drawer.drawLine(xPos.getLeft() + 0.5, linePos, xPos.getRight() - 1.0, linePos);
        state.increaseTextPrintPosition(5.0);
        drawer.setLayer(DrawHandler.Layer.Background);
        drawer.setLineType(ltBefore);
    }

    @Override
    public boolean checkStart(String line, PropertiesParserState state) {
        return this.variants.containsKey(line);
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        ArrayList<AutocompletionText> returnList = new ArrayList<AutocompletionText>();
        for (Map.Entry<String, LineType> lt : this.variants.entrySet()) {
            if (lt.getValue() == null) {
                returnList.add(new AutocompletionText(lt.getKey(), "draw horizontal line of current linetype"));
                continue;
            }
            returnList.add(new AutocompletionText(lt.getKey(), "draw " + lt.getValue().getReadableText() + " horizontal line"));
        }
        return returnList;
    }
}

