/*
 * s2mps11.h
 *
 * Copyright (c) 2012 Samsung Electronics Co., Ltd
 *              http://www.samsung.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */

#ifndef __LINUX_MFD_S2MPS13_H
#define __LINUX_MFD_S2MPS13_H

/* S2MPS13 Revision Number */
enum s2mps13_revision_number {
	S2MPS13_REV_0 = 0x00,
	S2MPS13_REV_1 = 0x01,
};

/* S2MPS13 registers */
enum S2MPS13_reg {
	S2MPS13_REG_ID,
	S2MPS13_REG_INT1,
	S2MPS13_REG_INT2,
	S2MPS13_REG_INT3,
	S2MPS13_REG_INT1M,
	S2MPS13_REG_INT2M,
	S2MPS13_REG_INT3M,
	S2MPS13_REG_ST1,
	S2MPS13_REG_ST2,
	S2MPS13_REG_PWRONSRC,
	S2MPS13_REG_OFFSRC,
	S2MPS13_REG_BU_CHG,
	S2MPS13_REG_RTC_BUF,
	S2MPS13_REG_CTRL1,
	S2MPS13_REG_CTRL2,
	S2MPS13_REG_ETC_TEST,
	S2MPS13_REG_OTP_ADRL,
	S2MPS13_REG_OTP_ADRH,
	S2MPS13_REG_OTP_DATA,
	S2MPS13_REG_MON1SEL,
	S2MPS13_REG_MON2SEL,
	S2MPS13_REG_CTRL3,
	S2MPS13_REG_ETC_OTP,
	S2MPS13_REG_UVLO_OTP,
	S2MPS13_REG_LEE,
	S2MPS13_REG_B1CTRL1,
	S2MPS13_REG_B1CTRL2,
	S2MPS13_REG_B2CTRL1,
	S2MPS13_REG_B2CTRL2,
	S2MPS13_REG_B3CTRL1,
	S2MPS13_REG_B3CTRL2,
	S2MPS13_REG_B4CTRL1,
	S2MPS13_REG_B4CTRL2,
	S2MPS13_REG_B5CTRL1,
	S2MPS13_REG_B5CTRL2,
	S2MPS13_REG_B6CTRL1,
	S2MPS13_REG_B6CTRL2,
	S2MPS13_REG_B7CTRL1,
	S2MPS13_REG_B7CTRL_SW,
	S2MPS13_REG_B7CTRL2,
	S2MPS13_REG_B8CTRL1,
	S2MPS13_REG_B8CTRL2,
	S2MPS13_REG_B9CTRL1,
	S2MPS13_REG_B9CTRL2,
	S2MPS13_REG_B10CTRL1,
	S2MPS13_REG_B10CTRL2,
	S2MPS13_REG_BB1CTRL1,
	S2MPS13_REG_BB1CTRL2,
	S2MPS13_REG_BUCK_RAMP1,
	S2MPS13_REG_BUCK_RAMP2,
	S2MPS13_REG_LDO_DVS1,
	S2MPS13_REG_LDO_DVS2,
	S2MPS13_REG_LDO_DVS3,
	S2MPS13_REG_LDO_DVS4,
	S2MPS13_REG_L1CTRL,
	S2MPS13_REG_L2CTRL,
	S2MPS13_REG_L3CTRL,
	S2MPS13_REG_L4CTRL,
	S2MPS13_REG_L5CTRL,
	S2MPS13_REG_L6CTRL,
	S2MPS13_REG_L7CTRL,
	S2MPS13_REG_L8CTRL,
	S2MPS13_REG_L9CTRL,
	S2MPS13_REG_L10CTRL,
	S2MPS13_REG_L11CTRL,
	S2MPS13_REG_L12CTRL,
	S2MPS13_REG_L13CTRL,
	S2MPS13_REG_L14CTRL,
	S2MPS13_REG_L15CTRL,
	S2MPS13_REG_L16CTRL,
	S2MPS13_REG_L17CTRL,
	S2MPS13_REG_L18CTRL,
	S2MPS13_REG_L19CTRL,
	S2MPS13_REG_L20CTRL,
	S2MPS13_REG_L21CTRL,
	S2MPS13_REG_L22CTRL,
	S2MPS13_REG_L23CTRL,
	S2MPS13_REG_L24CTRL,
	S2MPS13_REG_L25CTRL,
	S2MPS13_REG_L26CTRL,
	S2MPS13_REG_L27CTRL,
	S2MPS13_REG_L28CTRL,
	S2MPS13_REG_L29CTRL,
	S2MPS13_REG_L30CTRL,
	S2MPS13_REG_L31CTRL,
	S2MPS13_REG_L32CTRL,
	S2MPS13_REG_L33CTRL,
	S2MPS13_REG_L34CTRL,
	S2MPS13_REG_L35CTRL,
	S2MPS13_REG_L36CTRL,
	S2MPS13_REG_L37CTRL,
	S2MPS13_REG_L38CTRL,
	S2MPS13_REG_L39CTRL,
	S2MPS13_REG_L40CTRL,
	S2MPS13_REG_LDO_DSCH1,
	S2MPS13_REG_LDO_DSCH2,
	S2MPS13_REG_LDO_DSCH3,
	S2MPS13_REG_LDO_DSCH4,
	S2MPS13_REG_LDO_DSCH5,
};

/* S2MPS13 regulator ids */
enum S2MPS13_regulators {
	S2MPS13_LDO1,
	S2MPS13_LDO2,
	S2MPS13_LDO3,
	S2MPS13_LDO4,
	S2MPS13_LDO5,
	S2MPS13_LDO6,
	S2MPS13_LDO7,
	S2MPS13_LDO8,
	S2MPS13_LDO9,
	S2MPS13_LDO10,
	S2MPS13_LDO11,
	S2MPS13_LDO12,
	S2MPS13_LDO13,
	S2MPS13_LDO14,
	S2MPS13_LDO15,
	S2MPS13_LDO16,
	S2MPS13_LDO17,
	S2MPS13_LDO18,
	S2MPS13_LDO19,
	S2MPS13_LDO20,
	S2MPS13_LDO21,
	S2MPS13_LDO22,
	S2MPS13_LDO23,
	S2MPS13_LDO24,
	S2MPS13_LDO25,
	S2MPS13_LDO26,
	S2MPS13_LDO27,
	S2MPS13_LDO28,
	S2MPS13_LDO29,
	S2MPS13_LDO30,
	S2MPS13_LDO31,
	S2MPS13_LDO32,
	S2MPS13_LDO33,
	S2MPS13_LDO34,
	S2MPS13_LDO35,
	S2MPS13_LDO36,
	S2MPS13_LDO37,
	S2MPS13_LDO38,
	S2MPS13_LDO39,
	S2MPS13_LDO40,
	S2MPS13_BUCK1,
	S2MPS13_BUCK2,
	S2MPS13_BUCK3,
	S2MPS13_BUCK4,
	S2MPS13_BUCK5,
	S2MPS13_BUCK6,
	S2MPS13_BUCK7,
	S2MPS13_BUCK7_SW,
	S2MPS13_BUCK8,
	S2MPS13_BUCK9,
	S2MPS13_BUCK10,
	S2MPS13_BB1,
	S2MPS13_AP_EN32KHZ,
	S2MPS13_CP_EN32KHZ,
	S2MPS13_BT_EN32KHZ,

	S2MPS13_REG_MAX,
};

#define S2MPS13_BUCK_MIN1	600000
#define S2MPS13_BUCK_MIN1_REV0	600000
#define S2MPS13_BUCK_MIN1_REV1	400000
#define S2MPS13_BUCK_MIN2	2400000
#define S2MPS13_LDO_MIN1_REV0	600000
#define S2MPS13_LDO_MIN1_REV1	400000
#define S2MPS13_LDO_MIN2	800000
#define S2MPS13_BUCK_STEP1	6250
#define S2MPS13_BUCK_STEP2	12500
#define S2MPS13_LDO_STEP1	12500
#define S2MPS13_LDO_STEP2	25000
#define S2MPS13_LDO_STEP3	50000
#define S2MPS13_LDO_VSEL_MASK	0x3F
#define S2MPS13_BUCK_VSEL_MASK	0xFF
#define S2MPS13_ENABLE_MASK	(0x03 << S2MPS13_ENABLE_SHIFT)
#define S2MPS13_SW_ENABLE_MASK	0x03
#define S2MPS13_RAMP_DELAY	12000

#define S2MPS13_ENABLE_SHIFT	0x06
#define S2MPS13_LDO_N_VOLTAGES	(S2MPS13_LDO_VSEL_MASK + 1)
#define S2MPS13_BUCK_N_VOLTAGES (S2MPS13_BUCK_VSEL_MASK + 1)

#define S2MPS13_PMIC_EN_SHIFT	6
#define S2MPS13_REGULATOR_MAX (S2MPS13_REG_MAX)

#endif /*  __LINUX_MFD_S2MPS13_H */
