/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.pop3;

import gnu.inet.util.BASE64;
import gnu.inet.util.CRLFInputStream;
import gnu.inet.util.CRLFOutputStream;
import gnu.inet.util.EmptyX509TrustManager;
import gnu.inet.util.LineInputStream;
import gnu.inet.util.MessageInputStream;
import gnu.inet.util.SaslCallbackHandler;
import gnu.inet.util.SaslCramMD5;
import gnu.inet.util.SaslInputStream;
import gnu.inet.util.SaslLogin;
import gnu.inet.util.SaslOutputStream;
import gnu.inet.util.SaslPlain;
import gnu.inet.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class POP3Connection {
    public static final Level POP3_TRACE = new TraceLevel("pop3");
    public static final int DEFAULT_PORT = 110;
    private static final String _OK = "+OK";
    private static final String _ERR = "-ERR";
    private static final String _READY = "+ ";
    protected static final String STAT = "STAT";
    protected static final String LIST = "LIST";
    protected static final String RETR = "RETR";
    protected static final String DELE = "DELE";
    protected static final String NOOP = "NOOP";
    protected static final String RSET = "RSET";
    protected static final String QUIT = "QUIT";
    protected static final String TOP = "TOP";
    protected static final String UIDL = "UIDL";
    protected static final String USER = "USER";
    protected static final String PASS = "PASS";
    protected static final String APOP = "APOP";
    protected static final String CAPA = "CAPA";
    protected static final String STLS = "STLS";
    protected static final String AUTH = "AUTH";
    protected static final int OK = 0;
    protected static final int ERR = 1;
    protected static final int READY = 2;
    public static final Logger logger = Logger.getLogger("gnu.inet.pop3");
    protected Socket socket;
    protected LineInputStream in;
    protected CRLFOutputStream out;
    protected String response;
    protected byte[] timestamp;

    public POP3Connection(String string) throws UnknownHostException, IOException {
        this(string, -1, 0, 0, false, null);
    }

    public POP3Connection(String string, int n) throws UnknownHostException, IOException {
        this(string, n, 0, 0, false, null);
    }

    public POP3Connection(String string, int n, int n2, int n3) throws UnknownHostException, IOException {
        this(string, n, n2, n3, false, null);
    }

    public POP3Connection(String string, int n, int n2, int n3, boolean bl, TrustManager trustManager) throws UnknownHostException, IOException {
        this(string, n, n2, n3, bl, trustManager, true);
    }

    public POP3Connection(String string, int n, int n2, int n3, boolean bl, TrustManager trustManager, boolean bl2) throws UnknownHostException, IOException {
        Object object;
        Object object2;
        if (n <= 0) {
            n = 110;
        }
        try {
            this.socket = new Socket();
            object2 = new InetSocketAddress(string, n);
            if (n2 > 0) {
                this.socket.connect((SocketAddress)object2, n2);
            } else {
                this.socket.connect((SocketAddress)object2);
            }
            if (n3 > 0) {
                this.socket.setSoTimeout(n3);
            }
            if (bl) {
                object = this.getSSLSocketFactory(trustManager);
                SSLSocket sSLSocket = (SSLSocket)((SSLSocketFactory)object).createSocket(this.socket, string, n, true);
                String[] stringArray = new String[]{"TLSv1", "SSLv3"};
                sSLSocket.setEnabledProtocols(stringArray);
                sSLSocket.setUseClientMode(true);
                sSLSocket.startHandshake();
                this.socket = sSLSocket;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            IOException iOException = new IOException();
            iOException.initCause(generalSecurityException);
            throw iOException;
        }
        object2 = this.socket.getInputStream();
        object2 = new BufferedInputStream((InputStream)object2);
        object2 = new CRLFInputStream((InputStream)object2);
        this.in = new LineInputStream((InputStream)object2);
        object = this.socket.getOutputStream();
        object = new BufferedOutputStream((OutputStream)object);
        this.out = new CRLFOutputStream((OutputStream)object);
        if (bl2) {
            this.init();
        }
    }

    public void init() throws IOException {
        if (this.getResponse() != 0) {
            throw new ProtocolException("Connect failed: " + this.response);
        }
        this.timestamp = this.parseTimestamp(this.response);
    }

    public boolean auth(String string, String string2, String string3) throws IOException {
        try {
            String[] stringArray = new String[]{string};
            SaslCallbackHandler saslCallbackHandler = new SaslCallbackHandler(string2, string3);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("gnu.crypto.sasl.username", string2);
            hashMap.put("gnu.crypto.sasl.password", string3);
            SaslClient saslClient = Sasl.createSaslClient(stringArray, null, "pop3", this.socket.getInetAddress().getHostName(), hashMap, saslCallbackHandler);
            if (saslClient == null) {
                if ("LOGIN".equalsIgnoreCase(string)) {
                    saslClient = new SaslLogin(string2, string3);
                } else if ("PLAIN".equalsIgnoreCase(string)) {
                    saslClient = new SaslPlain(string2, string3);
                } else if ("CRAM-MD5".equalsIgnoreCase(string)) {
                    saslClient = new SaslCramMD5(string2, string3);
                } else {
                    return false;
                }
            }
            StringBuffer stringBuffer = new StringBuffer(AUTH);
            stringBuffer.append(' ');
            stringBuffer.append(string);
            this.send(stringBuffer.toString());
            switch (this.getResponse()) {
                case 0: {
                    String string4 = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
                    if ("auth-int".equalsIgnoreCase(string4) || "auth-conf".equalsIgnoreCase(string4)) {
                        InputStream inputStream = this.socket.getInputStream();
                        inputStream = new BufferedInputStream(inputStream);
                        inputStream = new SaslInputStream(saslClient, inputStream);
                        inputStream = new CRLFInputStream(inputStream);
                        this.in = new LineInputStream(inputStream);
                        OutputStream outputStream = this.socket.getOutputStream();
                        outputStream = new BufferedOutputStream(outputStream);
                        outputStream = new SaslOutputStream(saslClient, outputStream);
                        this.out = new CRLFOutputStream(outputStream);
                    }
                    return true;
                }
                case 2: {
                    try {
                        byte[] byArray = this.response.getBytes("US-ASCII");
                        byte[] byArray2 = BASE64.decode(byArray);
                        byte[] byArray3 = saslClient.evaluateChallenge(byArray2);
                        byte[] byArray4 = BASE64.encode(byArray3);
                        this.out.write(byArray4);
                        this.out.write(13);
                        this.out.flush();
                        logger.log(POP3_TRACE, "> " + new String(byArray4, "US-ASCII"));
                        break;
                    }
                    catch (SaslException saslException) {
                        this.out.write(42);
                        this.out.write(13);
                        this.out.flush();
                        logger.log(POP3_TRACE, "> *");
                    }
                }
            }
            return false;
        }
        catch (SaslException saslException) {
            logger.log(POP3_TRACE, saslException.getMessage(), saslException);
            return false;
        }
        catch (RuntimeException runtimeException) {
            logger.log(POP3_TRACE, runtimeException.getMessage(), runtimeException);
            return false;
        }
    }

    public boolean apop(String string, String string2) throws IOException {
        if (string == null || string2 == null || this.timestamp == null) {
            return false;
        }
        try {
            byte[] byArray = string2.getBytes("US-ASCII");
            byte[] byArray2 = new byte[this.timestamp.length + byArray.length];
            System.arraycopy(this.timestamp, 0, byArray2, 0, this.timestamp.length);
            System.arraycopy(byArray, 0, byArray2, this.timestamp.length, byArray.length);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = messageDigest.digest(byArray2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray3.length; ++i) {
                int n = byArray3[i];
                if (n < 0) {
                    n += 256;
                }
                stringBuffer.append(Integer.toHexString((n & 0xF0) >> 4));
                stringBuffer.append(Integer.toHexString(n & 0xF));
            }
            String string3 = new StringBuffer(APOP).append(' ').append(string).append(' ').append(stringBuffer.toString()).toString();
            this.send(string3);
            return this.getResponse() == 0;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(POP3_TRACE, "MD5 algorithm not found");
            return false;
        }
    }

    public boolean login(String string, String string2) throws IOException {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = "USER " + string;
        this.send(string3);
        if (this.getResponse() != 0) {
            return false;
        }
        string3 = "PASS " + string2;
        this.send(string3);
        return this.getResponse() == 0;
    }

    protected SSLSocketFactory getSSLSocketFactory(TrustManager trustManager) throws GeneralSecurityException {
        if (trustManager == null) {
            trustManager = new EmptyX509TrustManager();
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
        sSLContext.init(null, trustManagerArray, null);
        return sSLContext.getSocketFactory();
    }

    public boolean stls() throws IOException {
        return this.stls(new EmptyX509TrustManager());
    }

    public boolean stls(TrustManager trustManager) throws IOException {
        try {
            SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory(trustManager);
            this.send(STLS);
            if (this.getResponse() != 0) {
                return false;
            }
            String string = this.socket.getInetAddress().getHostName();
            int n = this.socket.getPort();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, string, n, true);
            String[] stringArray = new String[]{"TLSv1", "SSLv3"};
            sSLSocket.setEnabledProtocols(stringArray);
            sSLSocket.setUseClientMode(true);
            sSLSocket.startHandshake();
            InputStream inputStream = sSLSocket.getInputStream();
            inputStream = new BufferedInputStream(inputStream);
            inputStream = new CRLFInputStream(inputStream);
            this.in = new LineInputStream(inputStream);
            OutputStream outputStream = sSLSocket.getOutputStream();
            outputStream = new BufferedOutputStream(outputStream);
            this.out = new CRLFOutputStream(outputStream);
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    public int stat() throws IOException {
        this.send(STAT);
        if (this.getResponse() != 0) {
            throw new ProtocolException("STAT failed: " + this.response);
        }
        try {
            return Integer.parseInt(this.response.substring(0, this.response.indexOf(32)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Not a number: " + this.response);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ProtocolException("Not a STAT response: " + this.response);
        }
    }

    public int list(int n) throws IOException {
        String string = "LIST " + n;
        this.send(string);
        if (this.getResponse() != 0) {
            throw new ProtocolException("LIST failed: " + this.response);
        }
        try {
            return Integer.parseInt(this.response.substring(this.response.indexOf(32) + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Not a number: " + this.response);
        }
    }

    public InputStream retr(int n) throws IOException {
        String string = "RETR " + n;
        this.send(string);
        if (this.getResponse() != 0) {
            throw new ProtocolException("RETR failed: " + this.response);
        }
        return new MessageInputStream(this.in);
    }

    public void dele(int n) throws IOException {
        String string = "DELE " + n;
        this.send(string);
        if (this.getResponse() != 0) {
            throw new ProtocolException("DELE failed: " + this.response);
        }
    }

    public void noop() throws IOException {
        this.send(NOOP);
        if (this.getResponse() != 0) {
            throw new ProtocolException("NOOP failed: " + this.response);
        }
    }

    public void rset() throws IOException {
        this.send(RSET);
        if (this.getResponse() != 0) {
            throw new ProtocolException("RSET failed: " + this.response);
        }
    }

    public boolean quit() throws IOException {
        this.send(QUIT);
        int n = this.getResponse();
        this.socket.close();
        return n == 0;
    }

    public InputStream top(int n) throws IOException {
        String string = "TOP " + n + ' ' + '0';
        this.send(string);
        if (this.getResponse() != 0) {
            throw new ProtocolException("TOP failed: " + this.response);
        }
        return new MessageInputStream(this.in);
    }

    public String uidl(int n) throws IOException {
        String string = "UIDL " + n;
        this.send(string);
        if (this.getResponse() != 0) {
            throw new ProtocolException("UIDL failed: " + this.response);
        }
        return this.response.substring(this.response.indexOf(32) + 1);
    }

    public Map uidl() throws IOException {
        this.send(UIDL);
        if (this.getResponse() != 0) {
            throw new ProtocolException("UIDL failed: " + this.response);
        }
        LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>();
        String string = this.in.readLine();
        while (string != null && !".".equals(string)) {
            int n = string.indexOf(32);
            if (n < 1) {
                throw new ProtocolException("Invalid UIDL response: " + string);
            }
            try {
                linkedHashMap.put(new Integer(string.substring(0, n)), string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException("Invalid message number: " + string);
            }
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public List capa() throws IOException {
        this.send(CAPA);
        if (this.getResponse() == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = this.in.readLine();
            while (!".".equals(string)) {
                arrayList.add(string);
                string = this.in.readLine();
            }
            return Collections.unmodifiableList(arrayList);
        }
        return null;
    }

    protected void send(String string) throws IOException {
        logger.log(POP3_TRACE, "> " + string);
        this.out.write(string);
        this.out.writeln();
        this.out.flush();
    }

    protected int getResponse() throws IOException {
        this.response = this.in.readLine();
        if (this.response == null) {
            throw new EOFException("unexpected EOF");
        }
        logger.log(POP3_TRACE, "< " + this.response);
        if (this.response.indexOf(_OK) == 0) {
            this.response = this.response.substring(3).trim();
            return 0;
        }
        if (this.response.indexOf(_ERR) == 0) {
            this.response = this.response.substring(4).trim();
            return 1;
        }
        if (this.response.indexOf(_READY) == 0) {
            this.response = this.response.substring(2).trim();
            return 2;
        }
        throw new ProtocolException("Unexpected response: " + this.response);
    }

    byte[] parseTimestamp(String string) throws IOException {
        String string2;
        int n;
        int n2;
        int n3 = string.indexOf(60);
        if (n3 != -1 && (n2 = string.indexOf(62, n3)) != -1 && (n = (string2 = string.substring(n3, n2 + 1)).indexOf(64)) != -1) {
            return string2.getBytes("US-ASCII");
        }
        return null;
    }
}

