/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.provider.model.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;

public class DefaultToolingModelBuilderRegistry
implements ToolingModelBuilderRegistry {
    private final ToolingModelBuilderRegistry parent;
    private final List<ToolingModelBuilder> builders = new ArrayList<ToolingModelBuilder>();

    public DefaultToolingModelBuilderRegistry() {
        this.parent = null;
        this.register(new VoidToolingModelBuilder());
    }

    public DefaultToolingModelBuilderRegistry(ToolingModelBuilderRegistry parent) {
        this.parent = parent;
    }

    public void register(ToolingModelBuilder builder) {
        this.builders.add(builder);
    }

    public ToolingModelBuilder getBuilder(String modelName) throws UnsupportedOperationException {
        ToolingModelBuilder match = null;
        for (ToolingModelBuilder builder : this.builders) {
            if (!builder.canBuild(modelName)) continue;
            if (match != null) {
                throw new UnsupportedOperationException(String.format("Multiple builders are available to build a model of type '%s'.", modelName));
            }
            match = builder;
        }
        if (match != null) {
            return match;
        }
        if (this.parent != null) {
            return this.parent.getBuilder(modelName);
        }
        throw new UnknownModelException(String.format("No builders are available to build a model of type '%s'.", modelName));
    }

    private static class VoidToolingModelBuilder
    implements ToolingModelBuilder {
        private VoidToolingModelBuilder() {
        }

        public boolean canBuild(String modelName) {
            return modelName.equals(Void.class.getName());
        }

        public Object buildAll(String modelName, Project project) {
            return null;
        }
    }
}

