/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericColor;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;

public class CU {
    private static final String[] colorNames = new String[]{"black", "pewhite", "pecyan", "pepurple", "pegreen", "peblue", "peviolet", "pebrown", "pepink", "peyellow", "pedarkgreen", "peorange", "pelightblue", "pedarkcyan", "pedarkgray", "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen", "bluetint", "greenblue", "greentint", "grey", "pinktint", "redorange", "yellowtint"};
    private static final int[] colorArgbs = new int[]{-16777216, -1, -16711681, -3137281, -16711936, -10460929, -32576, -6021080, -10024, -256, -16728064, -20480, -5197569, -16736096, -10461088, -984833, -332841, -16711681, -8388652, -983041, -657956, -6972, -5171, -16776961, -7722014, -5952982, -2180985, -10510688, -8388864, -2987746, -32944, -10185235, -1828, -2354116, -16711681, -16777077, -16741493, -4684277, -5658199, -16751616, -4343957, -7667573, -11179217, -29696, -6737204, -7667712, -1468806, -7357297, -12042869, -13676721, -16724271, -7077677, -60269, -16728065, -9868951, -14774017, -5103070, -1296, -14513374, -65281, -2302756, -460545, -10496, -2448096, -8355712, -16744448, -5374161, -983056, -38476, -3318692, -11861886, -16, -989556, -1644806, -3851, -8586240, -1331, -5383962, -1015680, -2031617, -329006, -7278960, -2894893, -18751, -24454, -14634326, -7876870, -8943463, -5192482, -32, -16711936, -13447886, -331546, -65281, -8388608, -10039894, -16777011, -4565549, -7114533, -12799119, -8689426, -16713062, -12004916, -3730043, -15132304, -655366, -6943, -6987, -8531, -16777088, -133658, -8355840, -9728477, -23296, -47872, -2461482, -1120086, -6751336, -5247250, -2396013, -4139, -9543, -3308225, -16181, -2252579, -5185306, -8388480, -65536, -4419697, -12490271, -7650029, -360334, -744352, -13726889, -2578, -6270419, -4144960, -7876885, -9807155, -9404272, -1286, -16711809, -12156236, -2968436, -16744320, -2572328, -40121, -12525360, -1146130, -663885, -1, -657931, -256, -6632142, -5253121, -13726889, -6750285, -8355712, -21573, -47872, -592267};
    private static final Map<String, Integer> mapJavaScriptColors = new Hashtable<String, Integer>();

    public static String toRGBHexString(GenericColor c) {
        int rgb = c.getRGB();
        if (rgb == 0) {
            return "000000";
        }
        String r = "00" + Integer.toHexString(rgb >> 16 & 0xFF);
        r = r.substring(r.length() - 2);
        String g = "00" + Integer.toHexString(rgb >> 8 & 0xFF);
        g = g.substring(g.length() - 2);
        String b = "00" + Integer.toHexString(rgb & 0xFF);
        b = b.substring(b.length() - 2);
        return r + g + b;
    }

    public static String toCSSString(GenericColor c) {
        int opacity = c.getOpacity255();
        if (opacity == 255) {
            return "#" + CU.toRGBHexString(c);
        }
        int rgb = c.getRGB();
        return "rgba(" + (rgb >> 16 & 0xFF) + "," + (rgb >> 8 & 0xFF) + "," + (rgb & 0xFF) + "," + (float)opacity / 255.0f + ")";
    }

    public static int getArgbFromString(String strColor) {
        int len = 0;
        if (strColor == null || (len = strColor.length()) == 0) {
            return 0;
        }
        if ((strColor = strColor.toLowerCase()).charAt(0) == '[' && strColor.charAt(len - 1) == ']') {
            String check;
            if (strColor.indexOf(",") >= 0) {
                String[] tokens = PT.split(strColor.substring(1, strColor.length() - 1), ",");
                if (tokens.length != 3) {
                    return 0;
                }
                float red = PT.parseFloat(tokens[0]);
                float grn = PT.parseFloat(tokens[1]);
                float blu = PT.parseFloat(tokens[2]);
                return CU.colorTriadToFFRGB(red, grn, blu);
            }
            switch (len) {
                case 9: {
                    check = "x";
                    break;
                }
                case 10: {
                    check = "0x";
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (strColor.indexOf(check) != 1) {
                return 0;
            }
            strColor = "#" + strColor.substring(len - 7, len - 1);
            len = 7;
        }
        if (len == 7 && strColor.charAt(0) == '#') {
            try {
                return PT.parseIntRadix(strColor.substring(1, 7), 16) | 0xFF000000;
            }
            catch (Exception e) {
                return 0;
            }
        }
        Integer boxedArgb = mapJavaScriptColors.get(strColor);
        return boxedArgb == null ? 0 : boxedArgb;
    }

    public static int colorTriadToFFRGB(float x, float y, float z) {
        if (x <= 1.0f && y <= 1.0f && z <= 1.0f) {
            if (x > 0.0f) {
                x = x * 256.0f - 1.0f;
            }
            if (y > 0.0f) {
                y = y * 256.0f - 1.0f;
            }
            if (z > 0.0f) {
                z = z * 256.0f - 1.0f;
            }
        }
        return CU.rgb((int)x, (int)y, (int)z);
    }

    public static int rgb(int red, int grn, int blu) {
        return 0xFF000000 | red << 16 | grn << 8 | blu;
    }

    public static final P3 colorPtFromString(String colorName) {
        return CU.colorPtFromInt(CU.getArgbFromString(colorName), null);
    }

    public static final P3 colorPtFromInt(int color, P3 pt) {
        if (pt == null) {
            pt = new P3();
        }
        pt.set(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
        return pt;
    }

    public static int colorPtToFFRGB(T3 pt) {
        return CU.colorTriadToFFRGB(pt.x, pt.y, pt.z);
    }

    public static void toRGB3f(int c, float[] f) {
        f[0] = (float)(c >> 16 & 0xFF) / 255.0f;
        f[1] = (float)(c >> 8 & 0xFF) / 255.0f;
        f[2] = (float)(c & 0xFF) / 255.0f;
    }

    public static int toFFGGGfromRGB(int rgb) {
        int grey = (2989 * (rgb >> 16 & 0xFF) + 5870 * (rgb >> 8 & 0xFF) + 1140 * (rgb & 0xFF) + 5000) / 10000 & 0xFFFFFF;
        return CU.rgb(grey, grey, grey);
    }

    public static P3 rgbToHSL(P3 rgb, boolean doRound) {
        float r = rgb.x / 255.0f;
        float g = rgb.y / 255.0f;
        float b = rgb.z / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float p = max + min;
        float q = max - min;
        float h = 60.0f * (q == 0.0f ? 0.0f : (max == r ? (g - b) / q + 6.0f : (max == g ? (b - r) / q + 2.0f : (r - g) / q + 4.0f))) % 360.0f;
        float s = q / (q == 0.0f ? 1.0f : (p <= 1.0f ? p : 2.0f - p));
        return doRound ? P3.new3((float)Math.round(h * 10.0f) / 10.0f, (float)Math.round(s * 1000.0f) / 10.0f, (float)Math.round(p * 500.0f) / 10.0f) : P3.new3(h, s * 100.0f, p * 50.0f);
    }

    public static P3 hslToRGB(P3 hsl) {
        float l;
        float h = Math.max(0.0f, Math.min(360.0f, hsl.x)) / 60.0f;
        float s = Math.max(0.0f, Math.min(100.0f, hsl.y)) / 100.0f;
        float p = l - ((double)(l = Math.max(0.0f, Math.min(100.0f, hsl.z)) / 100.0f) < 0.5 ? l : 1.0f - l) * s;
        float q = 2.0f * (l - p);
        float r = CU.toRGB(p, q, h + 2.0f);
        float g = CU.toRGB(p, q, h);
        float b = CU.toRGB(p, q, h - 2.0f);
        return P3.new3(Math.round(r * 255.0f), Math.round(g * 255.0f), Math.round(b * 255.0f));
    }

    private static float toRGB(float p, float q, float h) {
        float f;
        h += (float)(h < 0.0f ? 6 : (h > 6.0f ? -6 : 0));
        return f < 1.0f ? p + q * h : (h < 3.0f ? p + q : (h < 4.0f ? p + q * (4.0f - h) : p));
    }

    static {
        int i = colorNames.length;
        while (--i >= 0) {
            mapJavaScriptColors.put(colorNames[i], colorArgbs[i]);
        }
    }
}

