/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class Command
extends PseudoCommand {
    private Map<OsmPrimitive, PrimitiveData> cloneMap = new HashMap<OsmPrimitive, PrimitiveData>();
    private final OsmDataLayer layer;

    public Command() {
        this.layer = Main.main == null ? null : Main.main.getEditLayer();
    }

    public Command(OsmDataLayer osmDataLayer) {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.layer = osmDataLayer;
    }

    public boolean executeCommand() {
        CloneVisitor cloneVisitor = new CloneVisitor();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        this.fillModifiedData(arrayList, arrayList, arrayList);
        for (OsmPrimitive osmPrimitive : arrayList) {
            osmPrimitive.accept(cloneVisitor);
        }
        this.cloneMap = cloneVisitor.orig;
        return true;
    }

    public void undoCommand() {
        for (Map.Entry<OsmPrimitive, PrimitiveData> entry : this.cloneMap.entrySet()) {
            OsmPrimitive osmPrimitive = entry.getKey();
            if (osmPrimitive.getDataSet() == null) continue;
            entry.getKey().load(entry.getValue());
        }
    }

    public boolean invalidBecauselayerRemoved(Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return this.layer == layer;
    }

    public PrimitiveData getOrig(OsmPrimitive osmPrimitive) {
        return this.cloneMap.get(osmPrimitive);
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public abstract void fillModifiedData(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.cloneMap.keySet();
    }

    public static boolean checkAndConfirmOutlyingOperation(String string, String string2, String string3, String string4, Collection<? extends OsmPrimitive> collection, Collection<? extends OsmPrimitive> collection2) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.isIncomplete()) {
                bl2 = true;
                continue;
            }
            if (!osmPrimitive.isOutsideDownloadArea() || collection2 != null && collection2.contains(osmPrimitive)) continue;
            bl = true;
        }
        if (bl) {
            object = new JPanel(new GridBagLayout());
            ((Container)object).add(new JMultilineLabel("<html>" + string3 + "</html>"));
            boolean bl3 = ConditionalOptionPaneUtil.showConfirmationDialog(string + "_outside_nodes", Main.parent, object, string2, 0, 3, 0);
            if (!bl3) {
                return false;
            }
        }
        if (bl2) {
            object = new JPanel(new GridBagLayout());
            ((Container)object).add(new JMultilineLabel("<html>" + string4 + "</html>"));
            boolean bl4 = ConditionalOptionPaneUtil.showConfirmationDialog(string + "_incomplete", Main.parent, object, string2, 0, 3, 0);
            if (!bl4) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.cloneMap, this.layer);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Command command = (Command)object;
        return Objects.equals(this.cloneMap, command.cloneMap) && Objects.equals(this.layer, command.layer);
    }

    public static class OldNodeState {
        private final LatLon latLon;
        private final EastNorth eastNorth;
        private final boolean modified;

        public OldNodeState(Node node) {
            this.latLon = node.getCoor();
            this.eastNorth = node.getEastNorth();
            this.modified = node.isModified();
        }

        public final LatLon getLatLon() {
            return this.latLon;
        }

        public final EastNorth getEastNorth() {
            return this.eastNorth;
        }

        public final boolean isModified() {
            return this.modified;
        }

        public int hashCode() {
            return Objects.hash(this.latLon, this.eastNorth, this.modified);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            OldNodeState oldNodeState = (OldNodeState)object;
            return this.modified == oldNodeState.modified && Objects.equals(this.latLon, oldNodeState.latLon) && Objects.equals(this.eastNorth, oldNodeState.eastNorth);
        }
    }

    private static final class CloneVisitor
    extends AbstractVisitor {
        public final Map<OsmPrimitive, PrimitiveData> orig = new LinkedHashMap<OsmPrimitive, PrimitiveData>();

        private CloneVisitor() {
        }

        @Override
        public void visit(Node node) {
            this.orig.put(node, node.save());
        }

        @Override
        public void visit(Way way) {
            this.orig.put(way, way.save());
        }

        @Override
        public void visit(Relation relation) {
            this.orig.put(relation, relation.save());
        }
    }
}

