/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.Shortcut;

public final class MultikeyActionsHandler {
    private static final long DIALOG_DELAY = 1000L;
    private static final String STATUS_BAR_ID = "multikeyShortcut";
    private final Map<MultikeyShortcutAction, MyAction> myActions = new HashMap<MultikeyShortcutAction, MyAction>();
    private long lastTimestamp;
    private MyAction lastAction;
    private final Timer timer;
    private static MultikeyActionsHandler instance;

    private MultikeyActionsHandler() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new MyKeyEventDispatcher());
        this.timer = new Timer();
    }

    public static synchronized MultikeyActionsHandler getInstance() {
        if (instance == null) {
            instance = new MultikeyActionsHandler();
        }
        return instance;
    }

    private static String formatMenuText(KeyStroke keyStroke, String string, String string2) {
        String string3 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers()) + '+' + KeyEvent.getKeyText(keyStroke.getKeyCode()) + ',' + string;
        return "<html><i>" + string3 + "</i>&nbsp;&nbsp;&nbsp;&nbsp;" + string2;
    }

    public void addAction(MultikeyShortcutAction multikeyShortcutAction) {
        if (multikeyShortcutAction.getMultikeyShortcut() != null) {
            MyAction myAction = new MyAction(multikeyShortcutAction);
            this.myActions.put(multikeyShortcutAction, myAction);
            Main.registerActionShortcut(myAction, myAction.shortcut);
        }
    }

    public void removeAction(MultikeyShortcutAction multikeyShortcutAction) {
        MyAction myAction = this.myActions.get(multikeyShortcutAction);
        if (myAction != null) {
            Main.unregisterActionShortcut(myAction, myAction.shortcut);
            this.myActions.remove(multikeyShortcutAction);
        }
    }

    private class MyTimerTask
    extends TimerTask {
        private final long lastTimestamp;
        private final MyAction lastAction;

        MyTimerTask(long l, MyAction myAction) {
            this.lastTimestamp = l;
            this.lastAction = myAction;
        }

        @Override
        public void run() {
            if (this.lastTimestamp == MultikeyActionsHandler.this.lastTimestamp && this.lastAction == MultikeyActionsHandler.this.lastAction) {
                SwingUtilities.invokeLater(new ShowLayersPopupWorker(this.lastAction));
                MultikeyActionsHandler.this.lastAction = null;
            }
        }
    }

    private class MyAction
    extends AbstractAction {
        private final transient MultikeyShortcutAction action;
        private final transient Shortcut shortcut;

        MyAction(MultikeyShortcutAction multikeyShortcutAction) {
            this.action = multikeyShortcutAction;
            this.shortcut = multikeyShortcutAction.getMultikeyShortcut();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultikeyActionsHandler.this.lastTimestamp = actionEvent.getWhen();
            MultikeyActionsHandler.this.lastAction = this;
            MultikeyActionsHandler.this.timer.schedule((TimerTask)new MyTimerTask(MultikeyActionsHandler.this.lastTimestamp, MultikeyActionsHandler.this.lastAction), 1000L);
            Main.map.statusLine.setHelpText(MultikeyActionsHandler.STATUS_BAR_ID, I18n.tr("{0}... [please type its number]", (String)this.action.getValue("ShortDescription")));
        }

        public String toString() {
            return "MultikeyAction" + this.action;
        }
    }

    private class MyKeyEventDispatcher
    implements KeyEventDispatcher {
        private MyKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getWhen() == MultikeyActionsHandler.this.lastTimestamp) {
                return false;
            }
            if (MultikeyActionsHandler.this.lastAction != null && keyEvent.getID() == 401) {
                int n = this.getIndex(keyEvent.getKeyCode());
                if (n >= 0) {
                    MultikeyActionsHandler.this.lastAction.action.executeMultikeyAction(n, keyEvent.getKeyCode() == MultikeyActionsHandler.this.lastAction.shortcut.getKeyStroke().getKeyCode());
                }
                MultikeyActionsHandler.this.lastAction = null;
                Main.map.statusLine.resetHelpText(MultikeyActionsHandler.STATUS_BAR_ID);
                return true;
            }
            return false;
        }

        private int getIndex(int n) {
            if (n >= 49 && n <= 57) {
                return n - 49;
            }
            if (n == 48) {
                return 9;
            }
            if (n >= 65 && n <= 90) {
                return n - 65 + 10;
            }
            return -1;
        }
    }

    private static final class ShowLayersPopupWorker
    implements Runnable {
        private final MyAction action;

        private ShowLayersPopupWorker(MyAction myAction) {
            this.action = myAction;
        }

        @Override
        public void run() {
            Object object;
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem((String)this.action.action.getValue("ShortDescription"));
            jMenuItem.setEnabled(false);
            JPanel jPanel = new JPanel();
            jPanel.add(jMenuItem);
            jPopupMenu.add(jPanel);
            char c = (char)this.action.shortcut.getKeyStroke().getKeyCode();
            boolean bl = false;
            Object object2 = this.action.action.getMultikeyCombinations().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (((MultikeyShortcutAction.MultikeyInfo)object).getShortcut() == c) {
                    bl = true;
                }
                JMenuItem jMenuItem2 = new JMenuItem(MultikeyActionsHandler.formatMenuText(this.action.shortcut.getKeyStroke(), String.valueOf(((MultikeyShortcutAction.MultikeyInfo)object).getShortcut()), ((MultikeyShortcutAction.MultikeyInfo)object).getDescription()));
                jMenuItem2.setMnemonic(((MultikeyShortcutAction.MultikeyInfo)object).getShortcut());
                jMenuItem2.addActionListener(new ActionListener((MultikeyShortcutAction.MultikeyInfo)object){
                    final /* synthetic */ MultikeyShortcutAction.MultikeyInfo val$info;
                    {
                        this.val$info = multikeyInfo;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShowLayersPopupWorker.this.action.action.executeMultikeyAction(this.val$info.getIndex(), false);
                    }
                });
                jPopupMenu.add(jMenuItem2);
            }
            if (!bl && (object2 = this.action.action.getLastMultikeyAction()) != null) {
                object = new JMenuItem(MultikeyActionsHandler.formatMenuText(this.action.shortcut.getKeyStroke(), KeyEvent.getKeyText(this.action.shortcut.getKeyStroke().getKeyCode()), "Repeat " + ((MultikeyShortcutAction.MultikeyInfo)object2).getDescription()));
                ((AbstractButton)object).setMnemonic(this.action.shortcut.getKeyStroke().getKeyCode());
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShowLayersPopupWorker.this.action.action.executeMultikeyAction(-1, true);
                    }
                });
                jPopupMenu.add((JMenuItem)object);
            }
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    Main.map.statusLine.resetHelpText(MultikeyActionsHandler.STATUS_BAR_ID);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
            jPopupMenu.show(Main.parent, Integer.MAX_VALUE, Integer.MAX_VALUE);
            jPopupMenu.setLocation(Main.parent.getX() + Main.parent.getWidth() - jPopupMenu.getWidth(), Main.parent.getY() + Main.parent.getHeight() - jPopupMenu.getHeight());
        }
    }
}

