/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.prop.ScriptProperties;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.folded.FoldedDataSet;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.simple.EncogUtility;

public abstract class Cmd {
    private int kfold;
    private final EncogAnalyst analyst;
    private final AnalystScript script;
    private final ScriptProperties properties;

    public Cmd(EncogAnalyst theAnalyst) {
        this.analyst = theAnalyst;
        this.script = this.analyst.getScript();
        this.properties = this.script.getProperties();
    }

    public abstract boolean executeCommand(String var1);

    public EncogAnalyst getAnalyst() {
        return this.analyst;
    }

    public abstract String getName();

    public ScriptProperties getProp() {
        return this.properties;
    }

    public AnalystScript getScript() {
        return this.script;
    }

    public int obtainCross() {
        String cross = this.getProp().getPropertyString("ML:TRAIN_cross");
        if (cross == null || cross.length() == 0) {
            return 0;
        }
        if (cross.toLowerCase().startsWith("kfold:")) {
            String str = cross.substring(6);
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new AnalystError("Invalid kfold :" + str);
            }
        }
        throw new AnalystError("Unknown cross validation: " + cross);
    }

    public MLMethod obtainMethod() {
        String resourceID = this.getProp().getPropertyString("ML:CONFIG_machineLearningFile");
        File resourceFile = this.getScript().resolveFilename(resourceID);
        MLMethod method = (MLMethod)EncogDirectoryPersistence.loadObject(resourceFile);
        if (!(method instanceof MLMethod)) {
            throw new AnalystError("The object to be trained must be an instance of MLMethod. " + method.getClass().getSimpleName());
        }
        return method;
    }

    public MLDataSet obtainTrainingSet() {
        String trainingID = this.getProp().getPropertyString("ML:CONFIG_trainingFile");
        File trainingFile = this.getScript().resolveFilename(trainingID);
        MLDataSet trainingSet = EncogUtility.loadEGB2Memory(trainingFile);
        if (this.kfold > 0) {
            trainingSet = new FoldedDataSet(trainingSet);
        }
        return trainingSet;
    }

    public int getKfold() {
        return this.kfold;
    }

    public void setKfold(int kfold) {
        this.kfold = kfold;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" name=");
        result.append(this.getName());
        result.append("]");
        return result.toString();
    }
}

