/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.data;

import java.util.ArrayList;
import java.util.Iterator;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;

public class EnsembleDataSet
implements MLDataSet {
    private ArrayList<MLDataPair> data;
    private int idealSize;
    private int inputSize;

    public EnsembleDataSet(int inputSize, int idealSize) {
        this.idealSize = idealSize;
        this.inputSize = inputSize;
        this.data = new ArrayList();
    }

    public EnsembleDataSet(MLDataSet mlds) {
        this.idealSize = mlds.getIdealSize();
        this.inputSize = mlds.getInputSize();
        Iterator it = mlds.iterator();
        this.data = new ArrayList();
        while (it.hasNext()) {
            this.data.add((MLDataPair)it.next());
        }
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    @Override
    public boolean isSupervised() {
        return true;
    }

    @Override
    public long getRecordCount() {
        return this.data.size();
    }

    @Override
    public void getRecord(long index, MLDataPair pair) {
        MLDataPair source = this.data.get((int)index);
        pair.setInputArray(source.getInputArray());
        if (pair.getIdealArray() != null) {
            pair.setIdealArray(source.getIdealArray());
        }
    }

    @Override
    public MLDataSet openAdditional() {
        EnsembleDataSet copy = new EnsembleDataSet(this.idealSize, this.inputSize);
        for (MLDataPair line : this.data) {
            BasicMLDataPair newLine = new BasicMLDataPair(line.getInput(), line.getIdeal());
            copy.add(newLine);
        }
        return copy;
    }

    @Override
    public void add(MLData data1) {
        BasicMLDataPair mlP = new BasicMLDataPair(data1);
        this.data.add(mlP);
    }

    @Override
    public void add(MLData inputData, MLData idealData) {
        BasicMLDataPair mlP = new BasicMLDataPair(inputData, idealData);
        this.data.add(mlP);
    }

    @Override
    public void add(MLDataPair inputData) {
        this.data.add(inputData);
    }

    @Override
    public void close() {
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public MLDataPair get(int index) {
        return this.data.get(index);
    }

    @Override
    public Iterator<MLDataPair> iterator() {
        return this.data.iterator();
    }
}

