/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train.strategy;

import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.end.EndTrainingStrategy;

public class StopTrainingStrategy
implements EndTrainingStrategy {
    public static final double DEFAULT_MIN_IMPROVEMENT = 1.0E-7;
    public static final int DEFAULT_TOLERATE_CYCLES = 100;
    private MLTrain train;
    private boolean shouldStop;
    private boolean ready;
    private double lastError;
    private double bestError;
    private final double minImprovement;
    private final int toleratedCycles;
    private int badCycles;

    public StopTrainingStrategy() {
        this(1.0E-7, 100);
    }

    public StopTrainingStrategy(double minImprovement, int toleratedCycles) {
        this.minImprovement = minImprovement;
        this.toleratedCycles = toleratedCycles;
        this.badCycles = 0;
        this.bestError = Double.MAX_VALUE;
    }

    @Override
    public void init(MLTrain train) {
        this.train = train;
        this.shouldStop = false;
        this.ready = false;
    }

    @Override
    public void postIteration() {
        if (this.ready) {
            if (Math.abs(this.bestError - this.train.getError()) < this.minImprovement) {
                ++this.badCycles;
                if (this.badCycles > this.toleratedCycles) {
                    this.shouldStop = true;
                }
            } else {
                this.badCycles = 0;
            }
        } else {
            this.ready = true;
        }
        this.lastError = this.train.getError();
        this.bestError = Math.min(this.lastError, this.bestError);
    }

    @Override
    public void preIteration() {
    }

    @Override
    public boolean shouldStop() {
        return this.shouldStop;
    }
}

