/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.umleditor.application.LauncherView;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.BasePanel;
import ch.softenvironment.view.CommonUserAccess;
import ch.softenvironment.view.ListMenuChoice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import java.util.GregorianCalendar;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LogView
extends BasePanel
implements HyperlinkListener,
ListMenuChoice {
    private StringBuffer body = new StringBuffer();
    private JPanel ivjPnlLog = null;
    private JScrollPane ivjScpLog = null;
    private JTabbedPane ivjTbpLog = null;
    private JEditorPane ivjTxaLog = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JSeparator ivjJSeparator1 = null;
    private JSeparator ivjJSeparator2 = null;
    private JMenuItem ivjMniClear = null;
    private JMenuItem ivjMniSave = null;
    private JMenuItem ivjMniSelectAll = null;
    private JPopupMenu ivjMnpLogMenu = null;
    private JMenuItem ivjMniCopy = null;
    private JSeparator ivjJSeparator3 = null;
    private JMenuItem ivjMniSelectNodeInTree = null;
    private JCheckBoxMenuItem ivjMncWrapLines = null;
    private int currentOffset = -1;
    private String currentLine = null;

    public LogView() {
        this.initialize();
    }

    @Override
    public void adaptUserAction(EventObject event, Object control) {
        boolean isEmpty = this.getTxaLog().getText() != null && this.getTxaLog().getText().length() > 0;
        this.getMniClear().setEnabled(isEmpty);
        this.getMniSelectAll().setEnabled(isEmpty);
        if (this.getTxaLog().getSelectedText() == null) {
            this.getMniCopy().setEnabled(false);
        } else {
            this.getMniCopy().setEnabled(true);
        }
    }

    public void appendText(String logText) {
        this.appendRawText(this.escapeText(logText));
    }

    private String escapeText(String txt) {
        StringBuffer t = new StringBuffer(txt);
        for (int ti = t.length() - 1; ti >= 0; --ti) {
            char c = t.charAt(ti);
            if (c == '<') {
                t.replace(ti, ti + 1, "&lt;");
            }
            if (c == '>') {
                t.replace(ti, ti + 1, "&gt;");
            }
            if (c != '&') continue;
            t.replace(ti, ti + 1, "&amp;");
        }
        return t.toString();
    }

    private void appendRawText(String logText) {
        this.body.append(this.getTime());
        this.body.append(" ");
        this.body.append(logText);
        this.body.append("<br>");
        this.getTxaLog().setText("<body>" + this.body.toString() + "</body>");
    }

    public void appendText(String title, String logText) {
        this.appendRawText(this.escapeText("[" + title + "] " + logText));
    }

    public void appendText(String id, String title, String logText) {
        Tracer.getInstance().debug("ID=" + id + " " + logText);
        this.appendRawText(this.escapeText("[" + title + "] ") + "<a href=\"" + id + "\"> " + this.escapeText(logText) + "</a>");
    }

    public void clear() {
        this.body = new StringBuffer();
        this.getTxaLog().setText(null);
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.clear();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(MouseEvent arg1) {
        try {
            this.currentOffset = this.getTxaLog().viewToModel(arg1.getPoint());
            this.genericPopupDisplay(arg1, this.getMnpLogMenu());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.mniSave();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.mniSelectNodeInTree();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ItemEvent arg1) {
        try {
            this.mncWrapLines();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getMnpLogMenu());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.getTxaLog().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(ActionEvent arg1) {
        try {
            this.getTxaLog().copy();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JSeparator getJSeparator1() {
        if (this.ivjJSeparator1 == null) {
            try {
                this.ivjJSeparator1 = new JSeparator();
                this.ivjJSeparator1.setName("JSeparator1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator1;
    }

    private JSeparator getJSeparator2() {
        if (this.ivjJSeparator2 == null) {
            try {
                this.ivjJSeparator2 = new JSeparator();
                this.ivjJSeparator2.setName("JSeparator2");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator2;
    }

    private JSeparator getJSeparator3() {
        if (this.ivjJSeparator3 == null) {
            try {
                this.ivjJSeparator3 = new JSeparator();
                this.ivjJSeparator3.setName("JSeparator3");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator3;
    }

    private JCheckBoxMenuItem getMncWrapLines() {
        if (this.ivjMncWrapLines == null) {
            try {
                this.ivjMncWrapLines = new JCheckBoxMenuItem();
                this.ivjMncWrapLines.setName("MncWrapLines");
                this.ivjMncWrapLines.setText("Zeilen umbrechen");
                this.ivjMncWrapLines.setText(this.getResourceString("MncWrapLines_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMncWrapLines;
    }

    private JMenuItem getMniClear() {
        if (this.ivjMniClear == null) {
            try {
                this.ivjMniClear = new JMenuItem();
                this.ivjMniClear.setName("MniClear");
                this.ivjMniClear.setText("Log l\u00f6schen");
                this.ivjMniClear.setEnabled(false);
                this.ivjMniClear.setText(this.getResourceString("MniClear_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniClear;
    }

    private JMenuItem getMniCopy() {
        if (this.ivjMniCopy == null) {
            try {
                this.ivjMniCopy = new JMenuItem();
                this.ivjMniCopy.setName("MniCopy");
                this.ivjMniCopy.setText("Kopieren");
                this.ivjMniCopy.setEnabled(false);
                this.ivjMniCopy.setText(CommonUserAccess.getMniEditCopyText());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniCopy;
    }

    private JMenuItem getMniSave() {
        if (this.ivjMniSave == null) {
            try {
                this.ivjMniSave = new JMenuItem();
                this.ivjMniSave.setName("MniSave");
                this.ivjMniSave.setText("Speichern unter...");
                this.ivjMniSave.setEnabled(false);
                this.ivjMniSave.setText(CommonUserAccess.getMniFileSaveText());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniSave;
    }

    private JMenuItem getMniSelectAll() {
        if (this.ivjMniSelectAll == null) {
            try {
                this.ivjMniSelectAll = new JMenuItem();
                this.ivjMniSelectAll.setName("MniSelectAll");
                this.ivjMniSelectAll.setText("Alles markieren");
                this.ivjMniSelectAll.setEnabled(false);
                this.ivjMniSelectAll.setText(CommonUserAccess.getMniEditSelectAllText());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniSelectAll;
    }

    private JMenuItem getMniSelectNodeInTree() {
        if (this.ivjMniSelectNodeInTree == null) {
            try {
                this.ivjMniSelectNodeInTree = new JMenuItem();
                this.ivjMniSelectNodeInTree.setName("MniSelectNodeInTree");
                this.ivjMniSelectNodeInTree.setToolTipText("Knoten in der Navigation selektieren");
                this.ivjMniSelectNodeInTree.setText("Knoten selektieren");
                this.ivjMniSelectNodeInTree.setEnabled(false);
                this.ivjMniSelectNodeInTree.setToolTipText(this.getResourceString("MniSelectNodeInTree_toolTipText"));
                this.ivjMniSelectNodeInTree.setText(this.getResourceString("MniSelectNodeInTree_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMniSelectNodeInTree;
    }

    private JPopupMenu getMnpLogMenu() {
        if (this.ivjMnpLogMenu == null) {
            try {
                this.ivjMnpLogMenu = new JPopupMenu();
                this.ivjMnpLogMenu.setName("MnpLogMenu");
                this.ivjMnpLogMenu.add(this.getMniClear());
                this.ivjMnpLogMenu.add(this.getMniCopy());
                this.ivjMnpLogMenu.add(this.getJSeparator1());
                this.ivjMnpLogMenu.add(this.getMniSelectAll());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMnpLogMenu;
    }

    private JPanel getPnlLog() {
        if (this.ivjPnlLog == null) {
            try {
                this.ivjPnlLog = new JPanel();
                this.ivjPnlLog.setName("PnlLog");
                this.ivjPnlLog.setLayout(new BorderLayout());
                this.getPnlLog().add((Component)this.getScpLog(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlLog;
    }

    private JScrollPane getScpLog() {
        if (this.ivjScpLog == null) {
            try {
                this.ivjScpLog = new JScrollPane();
                this.ivjScpLog.setName("ScpLog");
                this.getScpLog().setViewportView(this.getTxaLog());
                this.ivjScpLog.setVerticalScrollBarPolicy(20);
                this.ivjScpLog.setHorizontalScrollBarPolicy(30);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjScpLog;
    }

    private JTabbedPane getTbpLog() {
        if (this.ivjTbpLog == null) {
            try {
                this.ivjTbpLog = new JTabbedPane();
                this.ivjTbpLog.setName("TbpLog");
                this.ivjTbpLog.insertTab(this.getResourceString("CTLog"), null, this.getPnlLog(), null, 0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbpLog;
    }

    private String getTime() {
        GregorianCalendar now = new GregorianCalendar();
        now.getTime().toString();
        SimpleDateFormat formater = new SimpleDateFormat("HH:mm:ss");
        return formater.format(now.getTime());
    }

    private JEditorPane getTxaLog() {
        if (this.ivjTxaLog == null) {
            try {
                this.ivjTxaLog = new JEditorPane();
                this.ivjTxaLog.setName("TxaLog");
                this.ivjTxaLog.setBounds(0, 0, 160, 120);
                this.ivjTxaLog.setEditable(false);
                this.ivjTxaLog.setContentType("text/html; charset=iso-8859-1");
                this.ivjTxaLog.addHyperlinkListener(this);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxaLog;
    }

    @Override
    protected void handleException(Throwable exception) {
        BaseDialog.showError(this, null, exception.toString(), exception);
    }

    private void initConnections() throws Exception {
        this.getMniClear().addActionListener(this.ivjEventHandler);
        this.getTxaLog().addMouseListener(this.ivjEventHandler);
        this.getMniSelectAll().addActionListener(this.ivjEventHandler);
        this.getMniCopy().addActionListener(this.ivjEventHandler);
        this.getMniSave().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("LogView");
            this.setLayout(new BorderLayout());
            this.setSize(623, 139);
            this.add((Component)this.getTbpLog(), "Center");
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.wrapLines(false);
    }

    private void mncWrapLines() {
        this.wrapLines(this.getMncWrapLines().isSelected());
    }

    private void mniSave() {
        LauncherView.getInstance().nyi("save()");
    }

    private void mniSelectNodeInTree() {
        String sel = this.currentLine;
        int start = sel.indexOf("<ID:");
        if (start == -1) {
            return;
        }
        int end = sel.indexOf(">", start);
        if (end == -1) {
            return;
        }
        String id = sel.substring(start + 4, end).trim();
        ModelElement modelElement = (ModelElement)((Object)LauncherView.getInstance().getModel().deepGetElementById(id));
        LauncherView.getInstance().showSpecification(modelElement);
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    private void wrapLines(boolean wrap) {
        if (wrap) {
            this.getScpLog().setHorizontalScrollBarPolicy(31);
            this.getTxaLog().setAutoscrolls(false);
        } else {
            this.getScpLog().setHorizontalScrollBarPolicy(30);
            this.getTxaLog().setAutoscrolls(true);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Tracer.getInstance().debug("link Activated: " + e.getDescription());
            String id = e.getDescription().toString().trim();
            ModelElement modelElement = (ModelElement)((Object)LauncherView.getInstance().getModel().deepGetElementById(id));
            LauncherView.getInstance().showSpecification(modelElement);
        }
    }

    @Override
    public void changeObjects(Object source) {
    }

    @Override
    public void copyObject(Object source) {
    }

    @Override
    public void newObject(Object source) {
    }

    @Override
    public void removeObjects(Object source) {
    }

    class IvjEventHandler
    implements ActionListener,
    ItemListener,
    MouseListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == LogView.this.getMniClear()) {
                LogView.this.connEtoC1(e);
            }
            if (e.getSource() == LogView.this.getMniSelectAll()) {
                LogView.this.connEtoM1(e);
            }
            if (e.getSource() == LogView.this.getMniCopy()) {
                LogView.this.connEtoM2(e);
            }
            if (e.getSource() == LogView.this.getMniSave()) {
                LogView.this.connEtoC3(e);
            }
            if (e.getSource() == LogView.this.getMniSelectNodeInTree()) {
                LogView.this.connEtoC4(e);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == LogView.this.getMncWrapLines()) {
                LogView.this.connEtoC5(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == LogView.this.getTxaLog()) {
                LogView.this.connEtoC6(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == LogView.this.getTxaLog()) {
                LogView.this.connEtoC2(e);
            }
        }
    }
}

