import builtins 1.0

// This file describes the plugin-supplied types contained in the library.
// It is used for QML tooling purposes only.
//
// This file was auto-generated by:
// 'qmlplugindump -nonrelocatable -builtins'

Module {
    Component {
        name: "QAbstractItemModel"
        prototype: "QObject"
        Enum {
            name: "LayoutChangeHint"
            values: {
                "NoLayoutChangeHint": 0,
                "VerticalSortHint": 1,
                "HorizontalSortHint": 2
            }
        }
        Signal {
            name: "dataChanged"
            Parameter { name: "topLeft"; type: "QModelIndex" }
            Parameter { name: "bottomRight"; type: "QModelIndex" }
            Parameter { name: "roles"; type: "QVector<int>" }
        }
        Signal {
            name: "dataChanged"
            Parameter { name: "topLeft"; type: "QModelIndex" }
            Parameter { name: "bottomRight"; type: "QModelIndex" }
        }
        Signal {
            name: "headerDataChanged"
            Parameter { name: "orientation"; type: "Qt::Orientation" }
            Parameter { name: "first"; type: "int" }
            Parameter { name: "last"; type: "int" }
        }
        Signal {
            name: "layoutChanged"
            Parameter { name: "parents"; type: "QList<QPersistentModelIndex>" }
            Parameter { name: "hint"; type: "QAbstractItemModel::LayoutChangeHint" }
        }
        Signal {
            name: "layoutChanged"
            Parameter { name: "parents"; type: "QList<QPersistentModelIndex>" }
        }
        Signal { name: "layoutChanged" }
        Signal {
            name: "layoutAboutToBeChanged"
            Parameter { name: "parents"; type: "QList<QPersistentModelIndex>" }
            Parameter { name: "hint"; type: "QAbstractItemModel::LayoutChangeHint" }
        }
        Signal {
            name: "layoutAboutToBeChanged"
            Parameter { name: "parents"; type: "QList<QPersistentModelIndex>" }
        }
        Signal { name: "layoutAboutToBeChanged" }
        Signal {
            name: "rowsAboutToBeInserted"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "first"; type: "int" }
            Parameter { name: "last"; type: "int" }
        }
        Signal {
            name: "rowsInserted"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "first"; type: "int" }
            Parameter { name: "last"; type: "int" }
        }
        Signal {
            name: "rowsAboutToBeRemoved"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "first"; type: "int" }
            Parameter { name: "last"; type: "int" }
        }
        Signal {
            name: "rowsRemoved"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "first"; type: "int" }
            Parameter { name: "last"; type: "int" }
        }
        Signal {
            name: "columnsAboutToBeInserted"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "first"; type: "int" }
            Parameter { name: "last"; type: "int" }
        }
        Signal {
            name: "columnsInserted"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "first"; type: "int" }
            Parameter { name: "last"; type: "int" }
        }
        Signal {
            name: "columnsAboutToBeRemoved"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "first"; type: "int" }
            Parameter { name: "last"; type: "int" }
        }
        Signal {
            name: "columnsRemoved"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "first"; type: "int" }
            Parameter { name: "last"; type: "int" }
        }
        Signal { name: "modelAboutToBeReset" }
        Signal { name: "modelReset" }
        Signal {
            name: "rowsAboutToBeMoved"
            Parameter { name: "sourceParent"; type: "QModelIndex" }
            Parameter { name: "sourceStart"; type: "int" }
            Parameter { name: "sourceEnd"; type: "int" }
            Parameter { name: "destinationParent"; type: "QModelIndex" }
            Parameter { name: "destinationRow"; type: "int" }
        }
        Signal {
            name: "rowsMoved"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
            Parameter { name: "destination"; type: "QModelIndex" }
            Parameter { name: "row"; type: "int" }
        }
        Signal {
            name: "columnsAboutToBeMoved"
            Parameter { name: "sourceParent"; type: "QModelIndex" }
            Parameter { name: "sourceStart"; type: "int" }
            Parameter { name: "sourceEnd"; type: "int" }
            Parameter { name: "destinationParent"; type: "QModelIndex" }
            Parameter { name: "destinationColumn"; type: "int" }
        }
        Signal {
            name: "columnsMoved"
            Parameter { name: "parent"; type: "QModelIndex" }
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
            Parameter { name: "destination"; type: "QModelIndex" }
            Parameter { name: "column"; type: "int" }
        }
        Method { name: "submit"; type: "bool" }
        Method { name: "revert" }
    }
    Component { name: "QAbstractListModel"; prototype: "QAbstractItemModel" }
    Component {
        name: "QDoubleValidator"
        prototype: "QValidator"
        Enum {
            name: "Notation"
            values: {
                "StandardNotation": 0,
                "ScientificNotation": 1
            }
        }
        Property { name: "bottom"; type: "double" }
        Property { name: "top"; type: "double" }
        Property { name: "decimals"; type: "int" }
        Property { name: "notation"; type: "Notation" }
        Signal {
            name: "bottomChanged"
            Parameter { name: "bottom"; type: "double" }
        }
        Signal {
            name: "topChanged"
            Parameter { name: "top"; type: "double" }
        }
        Signal {
            name: "decimalsChanged"
            Parameter { name: "decimals"; type: "int" }
        }
        Signal {
            name: "notationChanged"
            Parameter { name: "notation"; type: "QDoubleValidator::Notation" }
        }
    }
    Component {
        name: "QInputMethod"
        prototype: "QObject"
        exports: ["QtQuick/InputMethod 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Action"
            values: {
                "Click": 0,
                "ContextMenu": 1
            }
        }
        Property { name: "cursorRectangle"; type: "QRectF"; isReadonly: true }
        Property { name: "keyboardRectangle"; type: "QRectF"; isReadonly: true }
        Property { name: "visible"; type: "bool"; isReadonly: true }
        Property { name: "animating"; type: "bool"; isReadonly: true }
        Property { name: "locale"; type: "QLocale"; isReadonly: true }
        Property { name: "inputDirection"; type: "Qt::LayoutDirection"; isReadonly: true }
        Signal {
            name: "inputDirectionChanged"
            Parameter { name: "newDirection"; type: "Qt::LayoutDirection" }
        }
        Method { name: "show" }
        Method { name: "hide" }
        Method {
            name: "update"
            Parameter { name: "queries"; type: "Qt::InputMethodQueries" }
        }
        Method { name: "reset" }
        Method { name: "commit" }
        Method {
            name: "invokeAction"
            Parameter { name: "a"; type: "Action" }
            Parameter { name: "cursorPosition"; type: "int" }
        }
    }
    Component {
        name: "QIntValidator"
        prototype: "QValidator"
        Property { name: "bottom"; type: "int" }
        Property { name: "top"; type: "int" }
        Signal {
            name: "bottomChanged"
            Parameter { name: "bottom"; type: "int" }
        }
        Signal {
            name: "topChanged"
            Parameter { name: "top"; type: "int" }
        }
    }
    Component {
        name: "QKeySequence"
        exports: ["QtQuick/StandardKey 2.2"]
        exportMetaObjectRevisions: [2]
        Enum {
            name: "StandardKey"
            values: {
                "UnknownKey": 0,
                "HelpContents": 1,
                "WhatsThis": 2,
                "Open": 3,
                "Close": 4,
                "Save": 5,
                "New": 6,
                "Delete": 7,
                "Cut": 8,
                "Copy": 9,
                "Paste": 10,
                "Undo": 11,
                "Redo": 12,
                "Back": 13,
                "Forward": 14,
                "Refresh": 15,
                "ZoomIn": 16,
                "ZoomOut": 17,
                "Print": 18,
                "AddTab": 19,
                "NextChild": 20,
                "PreviousChild": 21,
                "Find": 22,
                "FindNext": 23,
                "FindPrevious": 24,
                "Replace": 25,
                "SelectAll": 26,
                "Bold": 27,
                "Italic": 28,
                "Underline": 29,
                "MoveToNextChar": 30,
                "MoveToPreviousChar": 31,
                "MoveToNextWord": 32,
                "MoveToPreviousWord": 33,
                "MoveToNextLine": 34,
                "MoveToPreviousLine": 35,
                "MoveToNextPage": 36,
                "MoveToPreviousPage": 37,
                "MoveToStartOfLine": 38,
                "MoveToEndOfLine": 39,
                "MoveToStartOfBlock": 40,
                "MoveToEndOfBlock": 41,
                "MoveToStartOfDocument": 42,
                "MoveToEndOfDocument": 43,
                "SelectNextChar": 44,
                "SelectPreviousChar": 45,
                "SelectNextWord": 46,
                "SelectPreviousWord": 47,
                "SelectNextLine": 48,
                "SelectPreviousLine": 49,
                "SelectNextPage": 50,
                "SelectPreviousPage": 51,
                "SelectStartOfLine": 52,
                "SelectEndOfLine": 53,
                "SelectStartOfBlock": 54,
                "SelectEndOfBlock": 55,
                "SelectStartOfDocument": 56,
                "SelectEndOfDocument": 57,
                "DeleteStartOfWord": 58,
                "DeleteEndOfWord": 59,
                "DeleteEndOfLine": 60,
                "InsertParagraphSeparator": 61,
                "InsertLineSeparator": 62,
                "SaveAs": 63,
                "Preferences": 64,
                "Quit": 65,
                "FullScreen": 66,
                "Deselect": 67,
                "DeleteCompleteLine": 68
            }
        }
    }
    Component {
        name: "QObject"
        exports: ["QtQml/QtObject 2.0", "QtQuick/QtObject 2.0"]
        exportMetaObjectRevisions: [0, 0]
        Property { name: "objectName"; type: "string" }
        Signal {
            name: "objectNameChanged"
            Parameter { name: "objectName"; type: "string" }
        }
        Method { name: "toString" }
        Method { name: "destroy" }
        Method {
            name: "destroy"
            Parameter { name: "delay"; type: "int" }
        }
    }
    Component {
        name: "QQmlApplication"
        prototype: "QObject"
        Property { name: "arguments"; type: "QStringList"; isReadonly: true }
        Property { name: "name"; type: "string" }
        Property { name: "version"; type: "string" }
        Property { name: "organization"; type: "string" }
        Property { name: "domain"; type: "string" }
        Signal { name: "aboutToQuit" }
        Method {
            name: "setName"
            Parameter { name: "arg"; type: "string" }
        }
        Method {
            name: "setVersion"
            Parameter { name: "arg"; type: "string" }
        }
        Method {
            name: "setOrganization"
            Parameter { name: "arg"; type: "string" }
        }
        Method {
            name: "setDomain"
            Parameter { name: "arg"; type: "string" }
        }
    }
    Component {
        name: "QQmlBind"
        prototype: "QObject"
        exports: ["QtQml/Binding 2.0", "QtQuick/Binding 2.0"]
        exportMetaObjectRevisions: [0, 0]
        Property { name: "target"; type: "QObject"; isPointer: true }
        Property { name: "property"; type: "string" }
        Property { name: "value"; type: "QVariant" }
        Property { name: "when"; type: "bool" }
    }
    Component {
        name: "QQmlComponent"
        prototype: "QObject"
        exports: [
            "QML/Component 1.0",
            "QtQml/Component 2.0",
            "QtQuick/Component 2.0"
        ]
        exportMetaObjectRevisions: [0, 0, 0]
        attachedType: "QQmlComponentAttached"
        Enum {
            name: "CompilationMode"
            values: {
                "PreferSynchronous": 0,
                "Asynchronous": 1
            }
        }
        Enum {
            name: "Status"
            values: {
                "Null": 0,
                "Ready": 1,
                "Loading": 2,
                "Error": 3
            }
        }
        Property { name: "progress"; type: "double"; isReadonly: true }
        Property { name: "status"; type: "Status"; isReadonly: true }
        Property { name: "url"; type: "QUrl"; isReadonly: true }
        Signal {
            name: "statusChanged"
            Parameter { type: "QQmlComponent::Status" }
        }
        Signal {
            name: "progressChanged"
            Parameter { type: "double" }
        }
        Signal {
            name: "completed"
        }
        Signal {
            name: "destruction"
        }
        Method {
            name: "loadUrl"
            Parameter { name: "url"; type: "QUrl" }
        }
        Method {
            name: "loadUrl"
            Parameter { name: "url"; type: "QUrl" }
            Parameter { name: "mode"; type: "CompilationMode" }
        }
        Method {
            name: "setData"
            Parameter { type: "QByteArray" }
            Parameter { name: "baseUrl"; type: "QUrl" }
        }
        Method { name: "errorString"; type: "string" }
        Method {
            name: "createObject"
            type: "QtObject"
            Parameter { name: "parent"; type: "Item" }
            Parameter { name: "properties"; type: "QtObject" }
        }
    }
    Component {
        name: "QQmlComponentAttached"
        prototype: "QObject"
        Signal { name: "completed" }
        Signal { name: "destruction" }
    }
    Component {
        name: "QQmlConnections"
        prototype: "QObject"
        exports: ["QtQml/Connections 2.0", "QtQuick/Connections 2.0"]
        exportMetaObjectRevisions: [0, 0]
        Property { name: "target"; type: "QObject"; isPointer: true }
        Property { name: "ignoreUnknownSignals"; type: "bool" }
    }
    Component {
        name: "QQmlDelegateModel"
        defaultProperty: "delegate"
        prototype: "QQmlInstanceModel"
        exports: ["QtQuick/VisualDataModel 2.0"]
        exportMetaObjectRevisions: [0]
        attachedType: "QQmlDelegateModelAttached"
        Property { name: "model"; type: "QVariant" }
        Property { name: "delegate"; type: "QQmlComponent"; isPointer: true }
        Property { name: "filterOnGroup"; type: "string" }
        Property { name: "items"; type: "QQmlDelegateModelGroup"; isReadonly: true; isPointer: true }
        Property {
            name: "persistedItems"
            type: "QQmlDelegateModelGroup"
            isReadonly: true
            isPointer: true
        }
        Property { name: "groups"; type: "QQmlDelegateModelGroup"; isList: true; isReadonly: true }
        Property { name: "parts"; type: "QObject"; isReadonly: true; isPointer: true }
        Property { name: "rootIndex"; type: "QVariant" }
        Signal { name: "filterGroupChanged" }
        Signal { name: "defaultGroupsChanged" }
        Method {
            name: "modelIndex"
            type: "QVariant"
            Parameter { name: "idx"; type: "int" }
        }
        Method { name: "parentModelIndex"; type: "QVariant" }
    }
    Component {
        name: "QQmlDelegateModelAttached"
        prototype: "QObject"
        Property { name: "model"; type: "QQmlDelegateModel"; isReadonly: true; isPointer: true }
        Property { name: "groups"; type: "QStringList" }
        Property { name: "isUnresolved"; type: "bool"; isReadonly: true }
        Signal { name: "unresolvedChanged" }
    }
    Component {
        name: "QQmlDelegateModelGroup"
        prototype: "QObject"
        exports: ["QtQuick/VisualDataGroup 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "count"; type: "int"; isReadonly: true }
        Property { name: "name"; type: "string" }
        Property { name: "includeByDefault"; type: "bool" }
        Signal { name: "defaultIncludeChanged" }
        Signal {
            name: "changed"
            Parameter { name: "removed"; type: "QQmlV4Handle" }
            Parameter { name: "inserted"; type: "QQmlV4Handle" }
        }
        Method {
            name: "insert"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "create"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "resolve"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "remove"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "addGroups"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "removeGroups"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "setGroups"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "move"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "get"
            type: "QQmlV4Handle"
            Parameter { name: "index"; type: "int" }
        }
    }
    Component { name: "QQmlDelegateModelParts"; prototype: "QObject" }
    Component {
        name: "QQmlEasingValueType"
        prototype: "QQmlValueType"
        exports: ["QtQuick/Easing 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Type"
            values: {
                "Linear": 0,
                "InQuad": 1,
                "OutQuad": 2,
                "InOutQuad": 3,
                "OutInQuad": 4,
                "InCubic": 5,
                "OutCubic": 6,
                "InOutCubic": 7,
                "OutInCubic": 8,
                "InQuart": 9,
                "OutQuart": 10,
                "InOutQuart": 11,
                "OutInQuart": 12,
                "InQuint": 13,
                "OutQuint": 14,
                "InOutQuint": 15,
                "OutInQuint": 16,
                "InSine": 17,
                "OutSine": 18,
                "InOutSine": 19,
                "OutInSine": 20,
                "InExpo": 21,
                "OutExpo": 22,
                "InOutExpo": 23,
                "OutInExpo": 24,
                "InCirc": 25,
                "OutCirc": 26,
                "InOutCirc": 27,
                "OutInCirc": 28,
                "InElastic": 29,
                "OutElastic": 30,
                "InOutElastic": 31,
                "OutInElastic": 32,
                "InBack": 33,
                "OutBack": 34,
                "InOutBack": 35,
                "OutInBack": 36,
                "InBounce": 37,
                "OutBounce": 38,
                "InOutBounce": 39,
                "OutInBounce": 40,
                "InCurve": 41,
                "OutCurve": 42,
                "SineCurve": 43,
                "CosineCurve": 44,
                "Bezier": 45
            }
        }
        Property { name: "type"; type: "Type" }
        Property { name: "amplitude"; type: "double" }
        Property { name: "overshoot"; type: "double" }
        Property { name: "period"; type: "double" }
        Property { name: "bezierCurve"; type: "QVariantList" }
    }
    Component {
        name: "QQmlInstanceModel"
        prototype: "QObject"
        Property { name: "count"; type: "int"; isReadonly: true }
        Signal {
            name: "modelUpdated"
            Parameter { name: "changeSet"; type: "QQmlChangeSet" }
            Parameter { name: "reset"; type: "bool" }
        }
        Signal {
            name: "createdItem"
            Parameter { name: "index"; type: "int" }
            Parameter { name: "object"; type: "QObject"; isPointer: true }
        }
        Signal {
            name: "initItem"
            Parameter { name: "index"; type: "int" }
            Parameter { name: "object"; type: "QObject"; isPointer: true }
        }
        Signal {
            name: "destroyingItem"
            Parameter { name: "object"; type: "QObject"; isPointer: true }
        }
    }
    Component {
        name: "QQmlInstantiator"
        defaultProperty: "delegate"
        prototype: "QObject"
        exports: ["QtQml/Instantiator 2.1", "QtQuick/Instantiator 2.1"]
        exportMetaObjectRevisions: [0, 0]
        Property { name: "active"; type: "bool" }
        Property { name: "asynchronous"; type: "bool" }
        Property { name: "model"; type: "QVariant" }
        Property { name: "count"; type: "int"; isReadonly: true }
        Property { name: "delegate"; type: "QQmlComponent"; isPointer: true }
        Property { name: "object"; type: "QObject"; isReadonly: true; isPointer: true }
        Signal {
            name: "objectAdded"
            Parameter { name: "index"; type: "int" }
            Parameter { name: "object"; type: "QObject"; isPointer: true }
        }
        Signal {
            name: "objectRemoved"
            Parameter { name: "index"; type: "int" }
            Parameter { name: "object"; type: "QObject"; isPointer: true }
        }
        Method {
            name: "objectAt"
            type: "QObject*"
            Parameter { name: "index"; type: "int" }
        }
    }
    Component {
        name: "QQmlListElement"
        prototype: "QObject"
        exports: ["QtQuick/ListElement 2.0"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQmlListModel"
        prototype: "QAbstractListModel"
        exports: ["QtQuick/ListModel 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "count"; type: "int"; isReadonly: true }
        Property { name: "dynamicRoles"; type: "bool" }
        Method { name: "clear" }
        Method {
            name: "remove"
            Parameter { name: "args"; type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "append"
            Parameter { name: "args"; type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "insert"
            Parameter { name: "args"; type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "get"
            type: "QQmlV4Handle"
            Parameter { name: "index"; type: "int" }
        }
        Method {
            name: "set"
            Parameter { name: "index"; type: "int" }
            Parameter { type: "QQmlV4Handle" }
        }
        Method {
            name: "setProperty"
            Parameter { name: "index"; type: "int" }
            Parameter { name: "property"; type: "string" }
            Parameter { name: "value"; type: "QVariant" }
        }
        Method {
            name: "move"
            Parameter { name: "from"; type: "int" }
            Parameter { name: "to"; type: "int" }
            Parameter { name: "count"; type: "int" }
        }
        Method { name: "sync" }
    }
    Component {
        name: "QQmlLocale"
        exports: ["QtQml/Locale 2.2", "QtQuick/Locale 2.0"]
        exportMetaObjectRevisions: [0, 0]
        Enum {
            name: "MeasurementSystem"
            values: {
                "MetricSystem": 0,
                "ImperialSystem": 1,
                "ImperialUSSystem": 1,
                "ImperialUKSystem": 2
            }
        }
        Enum {
            name: "FormatType"
            values: {
                "LongFormat": 0,
                "ShortFormat": 1,
                "NarrowFormat": 2
            }
        }
        Enum {
            name: "CurrencySymbolFormat"
            values: {
                "CurrencyIsoCode": 0,
                "CurrencySymbol": 1,
                "CurrencyDisplayName": 2
            }
        }
        Enum {
            name: "DayOfWeek"
            values: {
                "Sunday": 0,
                "Monday": 1,
                "Tuesday": 2,
                "Wednesday": 3,
                "Thursday": 4,
                "Friday": 5,
                "Saturday": 6
            }
        }
    }
    Component {
        name: "QQmlObjectModel"
        defaultProperty: "children"
        prototype: "QQmlInstanceModel"
        exports: ["QtQuick/VisualItemModel 2.0"]
        exportMetaObjectRevisions: [0]
        attachedType: "QQmlObjectModelAttached"
        Property { name: "children"; type: "QObject"; isList: true; isReadonly: true }
    }
    Component {
        name: "QQmlObjectModelAttached"
        prototype: "QObject"
        Property { name: "index"; type: "int"; isReadonly: true }
    }
    Component {
        name: "QQmlTimer"
        prototype: "QObject"
        exports: ["QtQml/Timer 2.0", "QtQuick/Timer 2.0"]
        exportMetaObjectRevisions: [0, 0]
        Property { name: "interval"; type: "int" }
        Property { name: "running"; type: "bool" }
        Property { name: "repeat"; type: "bool" }
        Property { name: "triggeredOnStart"; type: "bool" }
        Property { name: "parent"; type: "QObject"; isReadonly: true; isPointer: true }
        Signal { name: "triggered" }
        Method { name: "start" }
        Method { name: "stop" }
        Method { name: "restart" }
    }
    Component { name: "QQmlValueType"; prototype: "QObject" }
    Component {
        name: "QQuickAbstractAnimation"
        prototype: "QObject"
        exports: ["QtQuick/Animation 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Loops"
            values: {
                "Infinite": -2
            }
        }
        Property { name: "running"; type: "bool" }
        Property { name: "paused"; type: "bool" }
        Property { name: "alwaysRunToEnd"; type: "bool" }
        Property { name: "loops"; type: "int" }
        Signal { name: "started" }
        Signal { name: "stopped" }
        Signal {
            name: "runningChanged"
            Parameter { type: "bool" }
        }
        Signal {
            name: "pausedChanged"
            Parameter { type: "bool" }
        }
        Signal {
            name: "alwaysRunToEndChanged"
            Parameter { type: "bool" }
        }
        Signal {
            name: "loopCountChanged"
            Parameter { type: "int" }
        }
        Method { name: "restart" }
        Method { name: "start" }
        Method { name: "pause" }
        Method { name: "resume" }
        Method { name: "stop" }
        Method { name: "complete" }
    }
    Component {
        name: "QQuickAccessibleAttached"
        prototype: "QObject"
        exports: ["QtQuick/Accessible 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "role"; type: "QAccessible::Role" }
        Property { name: "name"; type: "string" }
        Property { name: "description"; type: "string" }
        Method { name: "valueChanged" }
        Method { name: "cursorPositionChanged" }
    }
    Component {
        name: "QQuickAnchorAnimation"
        prototype: "QQuickAbstractAnimation"
        exports: ["QtQuick/AnchorAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "targets"; type: "QQuickItem"; isList: true; isReadonly: true }
        Property { name: "duration"; type: "int" }
        Property { name: "easing"; type: "QEasingCurve" }
        Signal {
            name: "durationChanged"
            Parameter { type: "int" }
        }
        Signal {
            name: "easingChanged"
            Parameter { type: "QEasingCurve" }
        }
    }
    Component {
        name: "QQuickAnchorChanges"
        prototype: "QQuickStateOperation"
        exports: ["QtQuick/AnchorChanges 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "target"; type: "QQuickItem"; isPointer: true }
        Property { name: "anchors"; type: "QQuickAnchorSet"; isReadonly: true; isPointer: true }
    }
    Component {
        name: "QQuickAnchorLine"
    }
    Component {
        name: "QQuickAnchorSet"
        prototype: "QObject"
        Property { name: "left"; type: "QQmlScriptString" }
        Property { name: "right"; type: "QQmlScriptString" }
        Property { name: "horizontalCenter"; type: "QQmlScriptString" }
        Property { name: "top"; type: "QQmlScriptString" }
        Property { name: "bottom"; type: "QQmlScriptString" }
        Property { name: "verticalCenter"; type: "QQmlScriptString" }
        Property { name: "baseline"; type: "QQmlScriptString" }
    }
    Component {
        name: "QQuickAnchors"
        prototype: "QObject"
        Property { name: "left"; type: "QQuickAnchorLine" }
        Property { name: "right"; type: "QQuickAnchorLine" }
        Property { name: "horizontalCenter"; type: "QQuickAnchorLine" }
        Property { name: "top"; type: "QQuickAnchorLine" }
        Property { name: "bottom"; type: "QQuickAnchorLine" }
        Property { name: "verticalCenter"; type: "QQuickAnchorLine" }
        Property { name: "baseline"; type: "QQuickAnchorLine" }
        Property { name: "margins"; type: "double" }
        Property { name: "leftMargin"; type: "double" }
        Property { name: "rightMargin"; type: "double" }
        Property { name: "horizontalCenterOffset"; type: "double" }
        Property { name: "topMargin"; type: "double" }
        Property { name: "bottomMargin"; type: "double" }
        Property { name: "verticalCenterOffset"; type: "double" }
        Property { name: "baselineOffset"; type: "double" }
        Property { name: "fill"; type: "QQuickItem"; isPointer: true }
        Property { name: "centerIn"; type: "QQuickItem"; isPointer: true }
        Property { name: "alignWhenCentered"; type: "bool" }
        Signal { name: "centerAlignedChanged" }
    }
    Component {
        name: "QQuickAnimatedImage"
        defaultProperty: "data"
        prototype: "QQuickImage"
        exports: ["QtQuick/AnimatedImage 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "playing"; type: "bool" }
        Property { name: "paused"; type: "bool" }
        Property { name: "currentFrame"; type: "int" }
        Property { name: "frameCount"; type: "int"; isReadonly: true }
        Property { name: "sourceSize"; type: "QSize"; isReadonly: true }
        Signal { name: "frameChanged" }
    }
    Component {
        name: "QQuickAnimatedSprite"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/AnimatedSprite 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "LoopParameters"
            values: {
                "Infinite": -1
            }
        }
        Property { name: "running"; type: "bool" }
        Property { name: "interpolate"; type: "bool" }
        Property { name: "source"; type: "QUrl" }
        Property { name: "reverse"; type: "bool" }
        Property { name: "frameSync"; type: "bool" }
        Property { name: "frameCount"; type: "int" }
        Property { name: "frameHeight"; type: "int" }
        Property { name: "frameWidth"; type: "int" }
        Property { name: "frameX"; type: "int" }
        Property { name: "frameY"; type: "int" }
        Property { name: "frameRate"; type: "double" }
        Property { name: "frameDuration"; type: "int" }
        Property { name: "loops"; type: "int" }
        Property { name: "paused"; type: "bool" }
        Property { name: "currentFrame"; type: "int" }
        Signal {
            name: "pausedChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Signal {
            name: "runningChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Signal {
            name: "interpolateChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Signal {
            name: "sourceChanged"
            Parameter { name: "arg"; type: "QUrl" }
        }
        Signal {
            name: "reverseChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Signal {
            name: "frameSyncChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Signal {
            name: "frameCountChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameHeightChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameWidthChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameXChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameYChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameRateChanged"
            Parameter { name: "arg"; type: "double" }
        }
        Signal {
            name: "frameDurationChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "loopsChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "currentFrameChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Method { name: "start" }
        Method { name: "stop" }
        Method { name: "restart" }
        Method {
            name: "advance"
            Parameter { name: "frames"; type: "int" }
        }
        Method { name: "advance" }
        Method { name: "pause" }
        Method { name: "resume" }
        Method {
            name: "setRunning"
            Parameter { name: "arg"; type: "bool" }
        }
        Method {
            name: "setPaused"
            Parameter { name: "arg"; type: "bool" }
        }
        Method {
            name: "setInterpolate"
            Parameter { name: "arg"; type: "bool" }
        }
        Method {
            name: "setSource"
            Parameter { name: "arg"; type: "QUrl" }
        }
        Method {
            name: "setReverse"
            Parameter { name: "arg"; type: "bool" }
        }
        Method {
            name: "setFrameSync"
            Parameter { name: "arg"; type: "bool" }
        }
        Method {
            name: "setFrameCount"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameHeight"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameWidth"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameX"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameY"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameRate"
            Parameter { name: "arg"; type: "double" }
        }
        Method {
            name: "setFrameDuration"
            Parameter { name: "arg"; type: "int" }
        }
        Method { name: "resetFrameRate" }
        Method { name: "resetFrameDuration" }
        Method {
            name: "setLoops"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setCurrentFrame"
            Parameter { name: "arg"; type: "int" }
        }
    }
    Component {
        name: "QQuickAnimationController"
        defaultProperty: "animation"
        prototype: "QObject"
        exports: ["QtQuick/AnimationController 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "progress"; type: "double" }
        Property { name: "animation"; type: "QQuickAbstractAnimation"; isPointer: true }
        Method { name: "reload" }
        Method { name: "completeToBeginning" }
        Method { name: "completeToEnd" }
    }
    Component {
        name: "QQuickAnimationGroup"
        defaultProperty: "animations"
        prototype: "QQuickAbstractAnimation"
        Property { name: "animations"; type: "QQuickAbstractAnimation"; isList: true; isReadonly: true }
    }
    Component {
        name: "QQuickAnimator"
        prototype: "QQuickAbstractAnimation"
        exports: ["QtQuick/Animator 2.2"]
        exportMetaObjectRevisions: [0]
        Property { name: "target"; type: "QQuickItem"; isPointer: true }
        Property { name: "easing"; type: "QEasingCurve" }
        Property { name: "duration"; type: "int" }
        Property { name: "to"; type: "double" }
        Property { name: "from"; type: "double" }
        Signal {
            name: "targetItemChanged"
            Parameter { type: "QQuickItem"; isPointer: true }
        }
        Signal {
            name: "durationChanged"
            Parameter { name: "duration"; type: "int" }
        }
        Signal {
            name: "easingChanged"
            Parameter { name: "curve"; type: "QEasingCurve" }
        }
        Signal {
            name: "toChanged"
            Parameter { name: "to"; type: "double" }
        }
        Signal {
            name: "fromChanged"
            Parameter { name: "from"; type: "double" }
        }
    }
    Component {
        name: "QQuickApplication"
        prototype: "QQmlApplication"
        exports: ["QtQuick/Application 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "active"; type: "bool"; isReadonly: true }
        Property { name: "layoutDirection"; type: "Qt::LayoutDirection"; isReadonly: true }
        Property { name: "supportsMultipleWindows"; type: "bool"; isReadonly: true }
        Property { name: "state"; type: "Qt::ApplicationState"; isReadonly: true }
        Signal {
            name: "stateChanged"
            Parameter { name: "state"; type: "Qt::ApplicationState" }
        }
    }
    Component {
        name: "QQuickBasePositioner"
        defaultProperty: "data"
        prototype: "QQuickImplicitSizeItem"
        exports: ["QtQuick/Positioner 2.0"]
        exportMetaObjectRevisions: [0]
        attachedType: "QQuickPositionerAttached"
        Property { name: "spacing"; type: "double" }
        Property { name: "populate"; type: "QQuickTransition"; isPointer: true }
        Property { name: "move"; type: "QQuickTransition"; isPointer: true }
        Property { name: "add"; type: "QQuickTransition"; isPointer: true }
    }
    Component {
        name: "QQuickBehavior"
        defaultProperty: "animation"
        prototype: "QObject"
        exports: ["QtQuick/Behavior 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "animation"; type: "QQuickAbstractAnimation"; isPointer: true }
        Property { name: "enabled"; type: "bool" }
    }
    Component {
        name: "QQuickBorderImage"
        defaultProperty: "data"
        prototype: "QQuickImageBase"
        exports: ["QtQuick/BorderImage 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "TileMode"
            values: {
                "Stretch": 0,
                "Repeat": 1,
                "Round": 2
            }
        }
        Property { name: "border"; type: "QQuickScaleGrid"; isReadonly: true; isPointer: true }
        Property { name: "horizontalTileMode"; type: "TileMode" }
        Property { name: "verticalTileMode"; type: "TileMode" }
        Property { name: "sourceSize"; type: "QSize"; isReadonly: true }
    }
    Component {
        name: "QQuickCanvasItem"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/Canvas 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "RenderTarget"
            values: {
                "Image": 0,
                "FramebufferObject": 1
            }
        }
        Enum {
            name: "RenderStrategy"
            values: {
                "Immediate": 0,
                "Threaded": 1,
                "Cooperative": 2
            }
        }
        Property { name: "available"; type: "bool"; isReadonly: true }
        Property { name: "contextType"; type: "string" }
        Property { name: "context"; type: "QQmlV4Handle"; isReadonly: true }
        Property { name: "canvasSize"; type: "QSizeF" }
        Property { name: "tileSize"; type: "QSize" }
        Property { name: "canvasWindow"; type: "QRectF" }
        Property { name: "renderTarget"; type: "RenderTarget" }
        Property { name: "renderStrategy"; type: "RenderStrategy" }
        Signal {
            name: "paint"
            Parameter { name: "region"; type: "QRect" }
        }
        Signal { name: "painted" }
        Signal { name: "imageLoaded" }
        Method {
            name: "loadImage"
            Parameter { name: "url"; type: "QUrl" }
        }
        Method {
            name: "unloadImage"
            Parameter { name: "url"; type: "QUrl" }
        }
        Method {
            name: "isImageLoaded"
            type: "bool"
            Parameter { name: "url"; type: "QUrl" }
        }
        Method {
            name: "isImageLoading"
            type: "bool"
            Parameter { name: "url"; type: "QUrl" }
        }
        Method {
            name: "isImageError"
            type: "bool"
            Parameter { name: "url"; type: "QUrl" }
        }
        Method {
            name: "getContext"
            Parameter { name: "args"; type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "requestAnimationFrame"
            Parameter { name: "args"; type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "cancelRequestAnimationFrame"
            Parameter { name: "args"; type: "QQmlV4Function"; isPointer: true }
        }
        Method { name: "requestPaint" }
        Method {
            name: "markDirty"
            Parameter { name: "dirtyRect"; type: "QRectF" }
        }
        Method { name: "markDirty" }
        Method {
            name: "save"
            type: "bool"
            Parameter { name: "filename"; type: "string" }
        }
        Method {
            name: "toDataURL"
            type: "string"
            Parameter { name: "type"; type: "string" }
        }
        Method { name: "toDataURL"; type: "string" }
    }
    Component {
        name: "QQuickColorAnimation"
        prototype: "QQuickPropertyAnimation"
        exports: ["QtQuick/ColorAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "from"; type: "QColor" }
        Property { name: "to"; type: "QColor" }
    }
    Component {
        name: "QQuickColumn"
        defaultProperty: "data"
        prototype: "QQuickBasePositioner"
        exports: ["QtQuick/Column 2.0"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQuickCurve"
        prototype: "QQuickPathElement"
        Property { name: "x"; type: "double" }
        Property { name: "y"; type: "double" }
        Property { name: "relativeX"; type: "double" }
        Property { name: "relativeY"; type: "double" }
    }
    Component {
        name: "QQuickDoubleValidator"
        prototype: "QDoubleValidator"
        exports: ["QtQuick/DoubleValidator 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "locale"; type: "string" }
        Signal { name: "localeNameChanged" }
    }
    Component {
        name: "QQuickDrag"
        prototype: "QObject"
        exports: ["QtQuick/Drag 2.0"]
        exportMetaObjectRevisions: [0]
        attachedType: "QQuickDragAttached"
        Enum {
            name: "DragType"
            values: {
                "None": 0,
                "Automatic": 1,
                "Internal": 2
            }
        }
        Enum {
            name: "Axis"
            values: {
                "XAxis": 1,
                "YAxis": 2,
                "XAndYAxis": 3,
                "XandYAxis": 3
            }
        }
        Property { name: "target"; type: "QQuickItem"; isPointer: true }
        Property { name: "axis"; type: "Axis" }
        Property { name: "minimumX"; type: "double" }
        Property { name: "maximumX"; type: "double" }
        Property { name: "minimumY"; type: "double" }
        Property { name: "maximumY"; type: "double" }
        Property { name: "active"; type: "bool"; isReadonly: true }
        Property { name: "filterChildren"; type: "bool" }
        Property { name: "threshold"; type: "double" }
    }
    Component {
        name: "QQuickDragAttached"
        prototype: "QObject"
        Property { name: "active"; type: "bool" }
        Property { name: "source"; type: "QObject"; isPointer: true }
        Property { name: "target"; type: "QObject"; isReadonly: true; isPointer: true }
        Property { name: "hotSpot"; type: "QPointF" }
        Property { name: "keys"; type: "QStringList" }
        Property { name: "mimeData"; type: "QVariantMap" }
        Property { name: "supportedActions"; type: "Qt::DropActions" }
        Property { name: "proposedAction"; type: "Qt::DropAction" }
        Property { name: "dragType"; type: "QQuickDrag::DragType" }
        Signal { name: "dragStarted" }
        Signal {
            name: "dragFinished"
            Parameter { name: "dropAction"; type: "Qt::DropAction" }
        }
        Method {
            name: "start"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "startDrag"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method { name: "cancel" }
        Method { name: "drop"; type: "int" }
    }
    Component {
        name: "QQuickDropArea"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/DropArea 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "containsDrag"; type: "bool"; isReadonly: true }
        Property { name: "keys"; type: "QStringList" }
        Property { name: "drag"; type: "QQuickDropAreaDrag"; isReadonly: true; isPointer: true }
        Signal { name: "sourceChanged" }
        Signal {
            name: "entered"
            Parameter { name: "drag"; type: "QQuickDropEvent"; isPointer: true }
        }
        Signal { name: "exited" }
        Signal {
            name: "positionChanged"
            Parameter { name: "drag"; type: "QQuickDropEvent"; isPointer: true }
        }
        Signal {
            name: "dropped"
            Parameter { name: "drop"; type: "QQuickDropEvent"; isPointer: true }
        }
    }
    Component {
        name: "QQuickDropAreaDrag"
        prototype: "QObject"
        Property { name: "x"; type: "double"; isReadonly: true }
        Property { name: "y"; type: "double"; isReadonly: true }
        Property { name: "source"; type: "QObject"; isReadonly: true; isPointer: true }
        Signal { name: "positionChanged" }
    }
    Component {
        name: "QQuickFlickable"
        defaultProperty: "flickableData"
        prototype: "QQuickItem"
        exports: ["QtQuick/Flickable 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "BoundsBehavior"
            values: {
                "StopAtBounds": 0,
                "DragOverBounds": 1,
                "DragAndOvershootBounds": 2
            }
        }
        Enum {
            name: "FlickableDirection"
            values: {
                "AutoFlickDirection": 0,
                "HorizontalFlick": 1,
                "VerticalFlick": 2,
                "HorizontalAndVerticalFlick": 3
            }
        }
        Property { name: "contentWidth"; type: "double" }
        Property { name: "contentHeight"; type: "double" }
        Property { name: "contentX"; type: "double" }
        Property { name: "contentY"; type: "double" }
        Property { name: "contentItem"; type: "QQuickItem"; isReadonly: true; isPointer: true }
        Property { name: "topMargin"; type: "double" }
        Property { name: "bottomMargin"; type: "double" }
        Property { name: "originY"; type: "double"; isReadonly: true }
        Property { name: "leftMargin"; type: "double" }
        Property { name: "rightMargin"; type: "double" }
        Property { name: "originX"; type: "double"; isReadonly: true }
        Property { name: "horizontalVelocity"; type: "double"; isReadonly: true }
        Property { name: "verticalVelocity"; type: "double"; isReadonly: true }
        Property { name: "boundsBehavior"; type: "BoundsBehavior" }
        Property { name: "rebound"; type: "QQuickTransition"; isPointer: true }
        Property { name: "maximumFlickVelocity"; type: "double" }
        Property { name: "flickDeceleration"; type: "double" }
        Property { name: "moving"; type: "bool"; isReadonly: true }
        Property { name: "movingHorizontally"; type: "bool"; isReadonly: true }
        Property { name: "movingVertically"; type: "bool"; isReadonly: true }
        Property { name: "flicking"; type: "bool"; isReadonly: true }
        Property { name: "flickingHorizontally"; type: "bool"; isReadonly: true }
        Property { name: "flickingVertically"; type: "bool"; isReadonly: true }
        Property { name: "dragging"; type: "bool"; isReadonly: true }
        Property { name: "draggingHorizontally"; type: "bool"; isReadonly: true }
        Property { name: "draggingVertically"; type: "bool"; isReadonly: true }
        Property { name: "flickableDirection"; type: "FlickableDirection" }
        Property { name: "interactive"; type: "bool" }
        Property { name: "pressDelay"; type: "int" }
        Property { name: "atXEnd"; type: "bool"; isReadonly: true }
        Property { name: "atYEnd"; type: "bool"; isReadonly: true }
        Property { name: "atXBeginning"; type: "bool"; isReadonly: true }
        Property { name: "atYBeginning"; type: "bool"; isReadonly: true }
        Property {
            name: "visibleArea"
            type: "QQuickFlickableVisibleArea"
            isReadonly: true
            isPointer: true
        }
        Property { name: "pixelAligned"; type: "bool" }
        Property { name: "flickableData"; type: "QObject"; isList: true; isReadonly: true }
        Property { name: "flickableChildren"; type: "QQuickItem"; isList: true; isReadonly: true }
        Signal { name: "isAtBoundaryChanged" }
        Signal { name: "movementStarted" }
        Signal { name: "movementEnded" }
        Signal { name: "flickStarted" }
        Signal { name: "flickEnded" }
        Signal { name: "dragStarted" }
        Signal { name: "dragEnded" }
        Method {
            name: "resizeContent"
            Parameter { name: "w"; type: "double" }
            Parameter { name: "h"; type: "double" }
            Parameter { name: "center"; type: "QPointF" }
        }
        Method { name: "returnToBounds" }
        Method {
            name: "flick"
            Parameter { name: "xVelocity"; type: "double" }
            Parameter { name: "yVelocity"; type: "double" }
        }
        Method { name: "cancelFlick" }
    }
    Component {
        name: "QQuickFlickableVisibleArea"
        prototype: "QObject"
        Property { name: "xPosition"; type: "double"; isReadonly: true }
        Property { name: "yPosition"; type: "double"; isReadonly: true }
        Property { name: "widthRatio"; type: "double"; isReadonly: true }
        Property { name: "heightRatio"; type: "double"; isReadonly: true }
        Signal {
            name: "xPositionChanged"
            Parameter { name: "xPosition"; type: "double" }
        }
        Signal {
            name: "yPositionChanged"
            Parameter { name: "yPosition"; type: "double" }
        }
        Signal {
            name: "widthRatioChanged"
            Parameter { name: "widthRatio"; type: "double" }
        }
        Signal {
            name: "heightRatioChanged"
            Parameter { name: "heightRatio"; type: "double" }
        }
    }
    Component {
        name: "QQuickFlipable"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/Flipable 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Side"
            values: {
                "Front": 0,
                "Back": 1
            }
        }
        Property { name: "front"; type: "QQuickItem"; isPointer: true }
        Property { name: "back"; type: "QQuickItem"; isPointer: true }
        Property { name: "side"; type: "Side"; isReadonly: true }
    }
    Component {
        name: "QQuickFlow"
        defaultProperty: "data"
        prototype: "QQuickBasePositioner"
        exports: ["QtQuick/Flow 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Flow"
            values: {
                "LeftToRight": 0,
                "TopToBottom": 1
            }
        }
        Property { name: "flow"; type: "Flow" }
        Property { name: "layoutDirection"; type: "Qt::LayoutDirection" }
        Property { name: "effectiveLayoutDirection"; type: "Qt::LayoutDirection"; isReadonly: true }
    }
    Component {
        name: "QQuickFocusScope"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/FocusScope 2.0"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQuickFontLoader"
        prototype: "QObject"
        exports: ["QtQuick/FontLoader 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Status"
            values: {
                "Null": 0,
                "Ready": 1,
                "Loading": 2,
                "Error": 3
            }
        }
        Property { name: "source"; type: "QUrl" }
        Property { name: "name"; type: "string" }
        Property { name: "status"; type: "Status"; isReadonly: true }
    }
    Component {
        name: "QQuickFontValueType"
        prototype: "QQmlValueType"
        exports: ["QtQuick/Font 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "FontWeight"
            values: {
                "Light": 25,
                "Normal": 50,
                "DemiBold": 63,
                "Bold": 75,
                "Black": 87
            }
        }
        Enum {
            name: "Capitalization"
            values: {
                "MixedCase": 0,
                "AllUppercase": 1,
                "AllLowercase": 2,
                "SmallCaps": 3,
                "Capitalize": 4
            }
        }
        Property { name: "family"; type: "string" }
        Property { name: "bold"; type: "bool" }
        Property { name: "weight"; type: "FontWeight" }
        Property { name: "italic"; type: "bool" }
        Property { name: "underline"; type: "bool" }
        Property { name: "overline"; type: "bool" }
        Property { name: "strikeout"; type: "bool" }
        Property { name: "pointSize"; type: "double" }
        Property { name: "pixelSize"; type: "int" }
        Property { name: "capitalization"; type: "Capitalization" }
        Property { name: "letterSpacing"; type: "double" }
        Property { name: "wordSpacing"; type: "double" }
    }
    Component {
        name: "QQuickGradient"
        defaultProperty: "stops"
        prototype: "QObject"
        exports: ["QtQuick/Gradient 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "stops"; type: "QQuickGradientStop"; isList: true; isReadonly: true }
        Signal { name: "updated" }
    }
    Component {
        name: "QQuickGradientStop"
        prototype: "QObject"
        exports: ["QtQuick/GradientStop 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "position"; type: "double" }
        Property { name: "color"; type: "QColor" }
    }
    Component {
        name: "QQuickGrid"
        defaultProperty: "data"
        prototype: "QQuickBasePositioner"
        exports: ["QtQuick/Grid 2.0", "QtQuick/Grid 2.1"]
        exportMetaObjectRevisions: [0, 1]
        Enum {
            name: "Flow"
            values: {
                "LeftToRight": 0,
                "TopToBottom": 1
            }
        }
        Enum {
            name: "HAlignment"
            values: {
                "AlignLeft": 1,
                "AlignRight": 2,
                "AlignHCenter": 4
            }
        }
        Enum {
            name: "VAlignment"
            values: {
                "AlignTop": 32,
                "AlignBottom": 64,
                "AlignVCenter": 128
            }
        }
        Property { name: "rows"; type: "int" }
        Property { name: "columns"; type: "int" }
        Property { name: "rowSpacing"; type: "double" }
        Property { name: "columnSpacing"; type: "double" }
        Property { name: "flow"; type: "Flow" }
        Property { name: "layoutDirection"; type: "Qt::LayoutDirection" }
        Property { name: "effectiveLayoutDirection"; type: "Qt::LayoutDirection"; isReadonly: true }
        Property { name: "horizontalItemAlignment"; revision: 1; type: "HAlignment" }
        Property {
            name: "effectiveHorizontalItemAlignment"
            revision: 1
            type: "HAlignment"
            isReadonly: true
        }
        Property { name: "verticalItemAlignment"; revision: 1; type: "VAlignment" }
        Signal {
            name: "horizontalAlignmentChanged"
            revision: 1
            Parameter { name: "alignment"; type: "HAlignment" }
        }
        Signal {
            name: "effectiveHorizontalAlignmentChanged"
            revision: 1
            Parameter { name: "alignment"; type: "HAlignment" }
        }
        Signal {
            name: "verticalAlignmentChanged"
            revision: 1
            Parameter { name: "alignment"; type: "VAlignment" }
        }
    }
    Component {
        name: "QQuickGridMesh"
        prototype: "QQuickShaderEffectMesh"
        exports: ["QtQuick/GridMesh 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "resolution"; type: "QSize" }
    }
    Component {
        name: "QQuickGridView"
        defaultProperty: "data"
        prototype: "QQuickItemView"
        exports: ["QtQuick/GridView 2.0", "QtQuick/GridView 2.1"]
        exportMetaObjectRevisions: [0, 1]
        attachedType: "QQuickGridViewAttached"
        Enum {
            name: "Flow"
            values: {
                "FlowLeftToRight": 0,
                "FlowTopToBottom": 2
            }
        }
        Enum {
            name: "SnapMode"
            values: {
                "NoSnap": 0,
                "SnapToRow": 1,
                "SnapOneRow": 2
            }
        }
        Property { name: "flow"; type: "Flow" }
        Property { name: "cellWidth"; type: "double" }
        Property { name: "cellHeight"; type: "double" }
        Property { name: "snapMode"; type: "SnapMode" }
        Signal { name: "highlightMoveDurationChanged" }
        Method { name: "moveCurrentIndexUp" }
        Method { name: "moveCurrentIndexDown" }
        Method { name: "moveCurrentIndexLeft" }
        Method { name: "moveCurrentIndexRight" }
    }
    Component {
        name: "QQuickGridViewAttached"
        prototype: "QQuickItemViewAttached"
        Property { name: "view"; type: "QQuickGridView"; isReadonly: true; isPointer: true }
    }
    Component {
        name: "QQuickImage"
        defaultProperty: "data"
        prototype: "QQuickImageBase"
        exports: ["QtQuick/Image 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "HAlignment"
            values: {
                "AlignLeft": 1,
                "AlignRight": 2,
                "AlignHCenter": 4
            }
        }
        Enum {
            name: "VAlignment"
            values: {
                "AlignTop": 32,
                "AlignBottom": 64,
                "AlignVCenter": 128
            }
        }
        Enum {
            name: "FillMode"
            values: {
                "Stretch": 0,
                "PreserveAspectFit": 1,
                "PreserveAspectCrop": 2,
                "Tile": 3,
                "TileVertically": 4,
                "TileHorizontally": 5,
                "Pad": 6
            }
        }
        Property { name: "fillMode"; type: "FillMode" }
        Property { name: "paintedWidth"; type: "double"; isReadonly: true }
        Property { name: "paintedHeight"; type: "double"; isReadonly: true }
        Property { name: "horizontalAlignment"; type: "HAlignment" }
        Property { name: "verticalAlignment"; type: "VAlignment" }
        Signal { name: "paintedGeometryChanged" }
        Signal {
            name: "horizontalAlignmentChanged"
            Parameter { name: "alignment"; type: "HAlignment" }
        }
        Signal {
            name: "verticalAlignmentChanged"
            Parameter { name: "alignment"; type: "VAlignment" }
        }
    }
    Component {
        name: "QQuickImageBase"
        defaultProperty: "data"
        prototype: "QQuickImplicitSizeItem"
        Enum {
            name: "Status"
            values: {
                "Null": 0,
                "Ready": 1,
                "Loading": 2,
                "Error": 3
            }
        }
        Property { name: "status"; type: "Status"; isReadonly: true }
        Property { name: "source"; type: "QUrl" }
        Property { name: "progress"; type: "double"; isReadonly: true }
        Property { name: "asynchronous"; type: "bool" }
        Property { name: "cache"; type: "bool" }
        Property { name: "sourceSize"; type: "QSize" }
        Property { name: "mirror"; type: "bool" }
        Signal {
            name: "sourceChanged"
            Parameter { type: "QUrl" }
        }
        Signal {
            name: "statusChanged"
            Parameter { type: "QQuickImageBase::Status" }
        }
        Signal {
            name: "progressChanged"
            Parameter { name: "progress"; type: "double" }
        }
    }
    Component {
        name: "QQuickImplicitSizeItem"
        defaultProperty: "data"
        prototype: "QQuickItem"
        Property { name: "implicitWidth"; type: "double"; isReadonly: true }
        Property { name: "implicitHeight"; type: "double"; isReadonly: true }
        Signal { name: "implicitWidthChanged2"; revision: 1 }
        Signal { name: "implicitHeightChanged2"; revision: 1 }
    }
    Component {
        name: "QQuickIntValidator"
        prototype: "QIntValidator"
        exports: ["QtQuick/IntValidator 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "locale"; type: "string" }
        Signal { name: "localeNameChanged" }
    }
    Component {
        name: "QQuickItem"
        defaultProperty: "data"
        prototype: "QObject"
        exports: ["QtQuick/Item 2.0", "QtQuick/Item 2.1"]
        exportMetaObjectRevisions: [0, 1]
        Enum {
            name: "TransformOrigin"
            values: {
                "TopLeft": 0,
                "Top": 1,
                "TopRight": 2,
                "Left": 3,
                "Center": 4,
                "Right": 5,
                "BottomLeft": 6,
                "Bottom": 7,
                "BottomRight": 8
            }
        }
        Property { name: "parent"; type: "QQuickItem"; isPointer: true }
        Property { name: "data"; type: "QObject"; isList: true; isReadonly: true }
        Property { name: "resources"; type: "QObject"; isList: true; isReadonly: true }
        Property { name: "children"; type: "QQuickItem"; isList: true; isReadonly: true }
        Property { name: "x"; type: "double" }
        Property { name: "y"; type: "double" }
        Property { name: "z"; type: "double" }
        Property { name: "width"; type: "double" }
        Property { name: "height"; type: "double" }
        Property { name: "opacity"; type: "double" }
        Property { name: "enabled"; type: "bool" }
        Property { name: "visible"; type: "bool" }
        Property { name: "visibleChildren"; type: "QQuickItem"; isList: true; isReadonly: true }
        Property { name: "states"; type: "QQuickState"; isList: true; isReadonly: true }
        Property { name: "transitions"; type: "QQuickTransition"; isList: true; isReadonly: true }
        Property { name: "state"; type: "string" }
        Property { name: "childrenRect"; type: "QRectF"; isReadonly: true }
        Property { name: "anchors"; type: "QQuickAnchors"; isReadonly: true; isPointer: true }
        Property { name: "left"; type: "QQuickAnchorLine"; isReadonly: true }
        Property { name: "right"; type: "QQuickAnchorLine"; isReadonly: true }
        Property { name: "horizontalCenter"; type: "QQuickAnchorLine"; isReadonly: true }
        Property { name: "top"; type: "QQuickAnchorLine"; isReadonly: true }
        Property { name: "bottom"; type: "QQuickAnchorLine"; isReadonly: true }
        Property { name: "verticalCenter"; type: "QQuickAnchorLine"; isReadonly: true }
        Property { name: "baseline"; type: "QQuickAnchorLine"; isReadonly: true }
        Property { name: "baselineOffset"; type: "double" }
        Property { name: "clip"; type: "bool" }
        Property { name: "focus"; type: "bool" }
        Property { name: "activeFocus"; type: "bool"; isReadonly: true }
        Property { name: "activeFocusOnTab"; revision: 1; type: "bool" }
        Property { name: "rotation"; type: "double" }
        Property { name: "scale"; type: "double" }
        Property { name: "transformOrigin"; type: "TransformOrigin" }
        Property { name: "transformOriginPoint"; type: "QPointF"; isReadonly: true }
        Property { name: "transform"; type: "QQuickTransform"; isList: true; isReadonly: true }
        Property { name: "smooth"; type: "bool" }
        Property { name: "antialiasing"; type: "bool" }
        Property { name: "implicitWidth"; type: "double" }
        Property { name: "implicitHeight"; type: "double" }
        Property { name: "layer"; type: "QQuickItemLayer"; isReadonly: true; isPointer: true }
        Signal {
            name: "childrenRectChanged"
            Parameter { type: "QRectF" }
        }
        Signal {
            name: "baselineOffsetChanged"
            Parameter { type: "double" }
        }
        Signal {
            name: "stateChanged"
            Parameter { type: "string" }
        }
        Signal {
            name: "focusChanged"
            Parameter { type: "bool" }
        }
        Signal {
            name: "activeFocusChanged"
            Parameter { type: "bool" }
        }
        Signal {
            name: "activeFocusOnTabChanged"
            revision: 1
            Parameter { type: "bool" }
        }
        Signal {
            name: "parentChanged"
            Parameter { type: "QQuickItem"; isPointer: true }
        }
        Signal {
            name: "transformOriginChanged"
            Parameter { type: "TransformOrigin" }
        }
        Signal {
            name: "smoothChanged"
            Parameter { type: "bool" }
        }
        Signal {
            name: "antialiasingChanged"
            Parameter { type: "bool" }
        }
        Signal {
            name: "clipChanged"
            Parameter { type: "bool" }
        }
        Signal {
            name: "windowChanged"
            revision: 1
            Parameter { name: "window"; type: "QQuickWindow"; isPointer: true }
        }
        Method { name: "update" }
        Method {
            name: "contains"
            type: "bool"
            Parameter { name: "point"; type: "QPointF" }
        }
        Method {
            name: "mapFromItem"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "mapToItem"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
        Method { name: "forceActiveFocus" }
        Method {
            name: "forceActiveFocus"
            Parameter { name: "reason"; type: "Qt::FocusReason" }
        }
        Method {
            name: "nextItemInFocusChain"
            revision: 1
            type: "QQuickItem*"
            Parameter { name: "forward"; type: "bool" }
        }
        Method { name: "nextItemInFocusChain"; revision: 1; type: "QQuickItem*" }
        Method {
            name: "childAt"
            type: "QQuickItem*"
            Parameter { name: "x"; type: "double" }
            Parameter { name: "y"; type: "double" }
        }
    }
    Component {
        name: "QQuickItemLayer"
        prototype: "QObject"
        Property { name: "enabled"; type: "bool" }
        Property { name: "textureSize"; type: "QSize" }
        Property { name: "sourceRect"; type: "QRectF" }
        Property { name: "mipmap"; type: "bool" }
        Property { name: "smooth"; type: "bool" }
        Property { name: "wrapMode"; type: "QQuickShaderEffectSource::WrapMode" }
        Property { name: "format"; type: "QQuickShaderEffectSource::Format" }
        Property { name: "samplerName"; type: "QByteArray" }
        Property { name: "effect"; type: "QQmlComponent"; isPointer: true }
        Signal {
            name: "enabledChanged"
            Parameter { name: "enabled"; type: "bool" }
        }
        Signal {
            name: "sizeChanged"
            Parameter { name: "size"; type: "QSize" }
        }
        Signal {
            name: "mipmapChanged"
            Parameter { name: "mipmap"; type: "bool" }
        }
        Signal {
            name: "wrapModeChanged"
            Parameter { name: "mode"; type: "QQuickShaderEffectSource::WrapMode" }
        }
        Signal {
            name: "nameChanged"
            Parameter { name: "name"; type: "QByteArray" }
        }
        Signal {
            name: "effectChanged"
            Parameter { name: "component"; type: "QQmlComponent"; isPointer: true }
        }
        Signal {
            name: "smoothChanged"
            Parameter { name: "smooth"; type: "bool" }
        }
        Signal {
            name: "formatChanged"
            Parameter { name: "format"; type: "QQuickShaderEffectSource::Format" }
        }
        Signal {
            name: "sourceRectChanged"
            Parameter { name: "sourceRect"; type: "QRectF" }
        }
    }
    Component {
        name: "QQuickItemView"
        defaultProperty: "flickableData"
        prototype: "QQuickFlickable"
        exports: ["QtQuick/ItemView 2.1"]
        exportMetaObjectRevisions: [1]
        Enum {
            name: "LayoutDirection"
            values: {
                "LeftToRight": 0,
                "RightToLeft": 1,
                "VerticalTopToBottom": 2,
                "VerticalBottomToTop": 3
            }
        }
        Enum {
            name: "VerticalLayoutDirection"
            values: {
                "TopToBottom": 2,
                "BottomToTop": 3
            }
        }
        Enum {
            name: "HighlightRangeMode"
            values: {
                "NoHighlightRange": 0,
                "ApplyRange": 1,
                "StrictlyEnforceRange": 2
            }
        }
        Enum {
            name: "PositionMode"
            values: {
                "Beginning": 0,
                "Center": 1,
                "End": 2,
                "Visible": 3,
                "Contain": 4,
                "SnapPosition": 5
            }
        }
        Property { name: "model"; type: "QVariant" }
        Property { name: "delegate"; type: "QQmlComponent"; isPointer: true }
        Property { name: "count"; type: "int"; isReadonly: true }
        Property { name: "currentIndex"; type: "int" }
        Property { name: "currentItem"; type: "QQuickItem"; isReadonly: true; isPointer: true }
        Property { name: "keyNavigationWraps"; type: "bool" }
        Property { name: "cacheBuffer"; type: "int" }
        Property { name: "layoutDirection"; type: "Qt::LayoutDirection" }
        Property { name: "effectiveLayoutDirection"; type: "Qt::LayoutDirection"; isReadonly: true }
        Property { name: "verticalLayoutDirection"; type: "VerticalLayoutDirection" }
        Property { name: "header"; type: "QQmlComponent"; isPointer: true }
        Property { name: "headerItem"; type: "QQuickItem"; isReadonly: true; isPointer: true }
        Property { name: "footer"; type: "QQmlComponent"; isPointer: true }
        Property { name: "footerItem"; type: "QQuickItem"; isReadonly: true; isPointer: true }
        Property { name: "populate"; type: "QQuickTransition"; isPointer: true }
        Property { name: "add"; type: "QQuickTransition"; isPointer: true }
        Property { name: "addDisplaced"; type: "QQuickTransition"; isPointer: true }
        Property { name: "move"; type: "QQuickTransition"; isPointer: true }
        Property { name: "moveDisplaced"; type: "QQuickTransition"; isPointer: true }
        Property { name: "remove"; type: "QQuickTransition"; isPointer: true }
        Property { name: "removeDisplaced"; type: "QQuickTransition"; isPointer: true }
        Property { name: "displaced"; type: "QQuickTransition"; isPointer: true }
        Property { name: "highlight"; type: "QQmlComponent"; isPointer: true }
        Property { name: "highlightItem"; type: "QQuickItem"; isReadonly: true; isPointer: true }
        Property { name: "highlightFollowsCurrentItem"; type: "bool" }
        Property { name: "highlightRangeMode"; type: "HighlightRangeMode" }
        Property { name: "preferredHighlightBegin"; type: "double" }
        Property { name: "preferredHighlightEnd"; type: "double" }
        Property { name: "highlightMoveDuration"; type: "int" }
        Signal { name: "populateTransitionChanged" }
        Signal { name: "addTransitionChanged" }
        Signal { name: "addDisplacedTransitionChanged" }
        Signal { name: "moveTransitionChanged" }
        Signal { name: "moveDisplacedTransitionChanged" }
        Signal { name: "removeTransitionChanged" }
        Signal { name: "removeDisplacedTransitionChanged" }
        Signal { name: "displacedTransitionChanged" }
        Method {
            name: "positionViewAtIndex"
            Parameter { name: "index"; type: "int" }
            Parameter { name: "mode"; type: "int" }
        }
        Method {
            name: "indexAt"
            type: "int"
            Parameter { name: "x"; type: "double" }
            Parameter { name: "y"; type: "double" }
        }
        Method {
            name: "itemAt"
            type: "QQuickItem*"
            Parameter { name: "x"; type: "double" }
            Parameter { name: "y"; type: "double" }
        }
        Method { name: "positionViewAtBeginning" }
        Method { name: "positionViewAtEnd" }
        Method { name: "forceLayout"; revision: 1 }
    }
    Component {
        name: "QQuickItemViewAttached"
        prototype: "QObject"
        Property { name: "isCurrentItem"; type: "bool"; isReadonly: true }
        Property { name: "delayRemove"; type: "bool" }
        Property { name: "section"; type: "string"; isReadonly: true }
        Property { name: "previousSection"; type: "string"; isReadonly: true }
        Property { name: "nextSection"; type: "string"; isReadonly: true }
        Signal { name: "currentItemChanged" }
        Signal { name: "add" }
        Signal { name: "remove" }
        Signal { name: "prevSectionChanged" }
    }
    Component {
        name: "QQuickKeyNavigationAttached"
        prototype: "QObject"
        exports: ["QtQuick/KeyNavigation 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Priority"
            values: {
                "BeforeItem": 0,
                "AfterItem": 1
            }
        }
        Property { name: "left"; type: "QQuickItem"; isPointer: true }
        Property { name: "right"; type: "QQuickItem"; isPointer: true }
        Property { name: "up"; type: "QQuickItem"; isPointer: true }
        Property { name: "down"; type: "QQuickItem"; isPointer: true }
        Property { name: "tab"; type: "QQuickItem"; isPointer: true }
        Property { name: "backtab"; type: "QQuickItem"; isPointer: true }
        Property { name: "priority"; type: "Priority" }
    }
    Component {
        name: "QQuickKeysAttached"
        prototype: "QObject"
        exports: ["QtQuick/Keys 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Priority"
            values: {
                "BeforeItem": 0,
                "AfterItem": 1
            }
        }
        Property { name: "enabled"; type: "bool" }
        Property { name: "forwardTo"; type: "QQuickItem"; isList: true; isReadonly: true }
        Property { name: "priority"; type: "Priority" }
        Signal {
            name: "pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "released"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit0Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit1Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit2Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit3Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit4Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit5Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit6Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit7Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit8Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "digit9Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "leftPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "rightPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "upPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "downPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "tabPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "backtabPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "asteriskPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "numberSignPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "escapePressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "returnPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "enterPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "deletePressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "spacePressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "backPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "cancelPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "selectPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "yesPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "noPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "context1Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "context2Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "context3Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "context4Pressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "callPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "hangupPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "flipPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "menuPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "volumeUpPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
        Signal {
            name: "volumeDownPressed"
            Parameter { name: "event"; type: "QQuickKeyEvent"; isPointer: true }
        }
    }
    Component {
        name: "QQuickLayoutMirroringAttached"
        prototype: "QObject"
        exports: ["QtQuick/LayoutMirroring 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "enabled"; type: "bool" }
        Property { name: "childrenInherit"; type: "bool" }
    }
    Component {
        name: "QQuickListView"
        defaultProperty: "data"
        prototype: "QQuickItemView"
        exports: ["QtQuick/ListView 2.0", "QtQuick/ListView 2.1"]
        exportMetaObjectRevisions: [0, 1]
        attachedType: "QQuickListViewAttached"
        Enum {
            name: "Orientation"
            values: {
                "Horizontal": 1,
                "Vertical": 2
            }
        }
        Enum {
            name: "SnapMode"
            values: {
                "NoSnap": 0,
                "SnapToItem": 1,
                "SnapOneItem": 2
            }
        }
        Property { name: "highlightMoveVelocity"; type: "double" }
        Property { name: "highlightResizeVelocity"; type: "double" }
        Property { name: "highlightResizeDuration"; type: "int" }
        Property { name: "spacing"; type: "double" }
        Property { name: "orientation"; type: "Orientation" }
        Property { name: "section"; type: "QQuickViewSection"; isReadonly: true; isPointer: true }
        Property { name: "currentSection"; type: "string"; isReadonly: true }
        Property { name: "snapMode"; type: "SnapMode" }
        Method { name: "incrementCurrentIndex" }
        Method { name: "decrementCurrentIndex" }
    }
    Component {
        name: "QQuickListViewAttached"
        prototype: "QQuickItemViewAttached"
        Property { name: "view"; type: "QQuickListView"; isReadonly: true; isPointer: true }
    }
    Component {
        name: "QQuickLoader"
        defaultProperty: "data"
        prototype: "QQuickImplicitSizeItem"
        exports: ["QtQuick/Loader 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Status"
            values: {
                "Null": 0,
                "Ready": 1,
                "Loading": 2,
                "Error": 3
            }
        }
        Property { name: "active"; type: "bool" }
        Property { name: "source"; type: "QUrl" }
        Property { name: "sourceComponent"; type: "QQmlComponent"; isPointer: true }
        Property { name: "item"; type: "QObject"; isReadonly: true; isPointer: true }
        Property { name: "status"; type: "Status"; isReadonly: true }
        Property { name: "progress"; type: "double"; isReadonly: true }
        Property { name: "asynchronous"; type: "bool" }
        Signal { name: "loaded" }
        Method {
            name: "setSource"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
    }
    Component {
        name: "QQuickMouseArea"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/MouseArea 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "mouseX"; type: "double"; isReadonly: true }
        Property { name: "mouseY"; type: "double"; isReadonly: true }
        Property { name: "containsMouse"; type: "bool"; isReadonly: true }
        Property { name: "pressed"; type: "bool"; isReadonly: true }
        Property { name: "enabled"; type: "bool" }
        Property { name: "pressedButtons"; type: "Qt::MouseButtons"; isReadonly: true }
        Property { name: "acceptedButtons"; type: "Qt::MouseButtons" }
        Property { name: "hoverEnabled"; type: "bool" }
        Property { name: "drag"; type: "QQuickDrag"; isReadonly: true; isPointer: true }
        Property { name: "preventStealing"; type: "bool" }
        Property { name: "propagateComposedEvents"; type: "bool" }
        Property { name: "cursorShape"; type: "Qt::CursorShape" }
        Signal { name: "hoveredChanged" }
        Signal {
            name: "positionChanged"
            Parameter { name: "mouse"; type: "QQuickMouseEvent"; isPointer: true }
        }
        Signal {
            name: "mouseXChanged"
            Parameter { name: "mouse"; type: "QQuickMouseEvent"; isPointer: true }
        }
        Signal {
            name: "mouseYChanged"
            Parameter { name: "mouse"; type: "QQuickMouseEvent"; isPointer: true }
        }
        Signal {
            name: "pressed"
            Parameter { name: "mouse"; type: "QQuickMouseEvent"; isPointer: true }
        }
        Signal {
            name: "pressAndHold"
            Parameter { name: "mouse"; type: "QQuickMouseEvent"; isPointer: true }
        }
        Signal {
            name: "released"
            Parameter { name: "mouse"; type: "QQuickMouseEvent"; isPointer: true }
        }
        Signal {
            name: "clicked"
            Parameter { name: "mouse"; type: "QQuickMouseEvent"; isPointer: true }
        }
        Signal {
            name: "doubleClicked"
            Parameter { name: "mouse"; type: "QQuickMouseEvent"; isPointer: true }
        }
        Signal {
            name: "wheel"
            Parameter { name: "wheel"; type: "QQuickWheelEvent"; isPointer: true }
        }
        Signal { name: "entered" }
        Signal { name: "exited" }
        Signal { name: "canceled" }
    }
    Component {
        name: "QQuickMouseEvent"
        prototype: "QObject"
        Property { name: "x"; type: "double"; isReadonly: true }
        Property { name: "y"; type: "double"; isReadonly: true }
        Property { name: "button"; type: "int"; isReadonly: true }
        Property { name: "buttons"; type: "int"; isReadonly: true }
        Property { name: "modifiers"; type: "int"; isReadonly: true }
        Property { name: "wasHeld"; type: "bool"; isReadonly: true }
        Property { name: "isClick"; type: "bool"; isReadonly: true }
        Property { name: "accepted"; type: "bool" }
    }
    Component {
        name: "QQuickMultiPointTouchArea"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/MultiPointTouchArea 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "touchPoints"; type: "QQuickTouchPoint"; isList: true; isReadonly: true }
        Property { name: "minimumTouchPoints"; type: "int" }
        Property { name: "maximumTouchPoints"; type: "int" }
        Signal {
            name: "pressed"
            Parameter { name: "touchPoints"; type: "QList<QObject*>" }
        }
        Signal {
            name: "updated"
            Parameter { name: "touchPoints"; type: "QList<QObject*>" }
        }
        Signal {
            name: "released"
            Parameter { name: "touchPoints"; type: "QList<QObject*>" }
        }
        Signal {
            name: "canceled"
            Parameter { name: "touchPoints"; type: "QList<QObject*>" }
        }
        Signal {
            name: "gestureStarted"
            Parameter { name: "gesture"; type: "QQuickGrabGestureEvent"; isPointer: true }
        }
        Signal {
            name: "touchUpdated"
            Parameter { name: "touchPoints"; type: "QList<QObject*>" }
        }
    }
    Component {
        name: "QQuickNumberAnimation"
        prototype: "QQuickPropertyAnimation"
        exports: ["QtQuick/NumberAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "from"; type: "double" }
        Property { name: "to"; type: "double" }
    }
    Component {
        name: "QQuickOpacityAnimator"
        prototype: "QQuickAnimator"
        exports: ["QtQuick/OpacityAnimator 2.2"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQuickPackage"
        defaultProperty: "data"
        prototype: "QObject"
        exports: ["QtQuick/Package 2.0"]
        exportMetaObjectRevisions: [0]
        attachedType: "QQuickPackageAttached"
        Property { name: "data"; type: "QObject"; isList: true; isReadonly: true }
    }
    Component {
        name: "QQuickPackageAttached"
        prototype: "QObject"
        Property { name: "name"; type: "string" }
    }
    Component {
        name: "QQuickPaintedItem"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/PaintedItem 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "RenderTarget"
            values: {
                "Image": 0,
                "FramebufferObject": 1,
                "InvertedYFramebufferObject": 2
            }
        }
        Property { name: "contentsSize"; type: "QSize" }
        Property { name: "fillColor"; type: "QColor" }
        Property { name: "contentsScale"; type: "double" }
        Property { name: "renderTarget"; type: "RenderTarget" }
    }
    Component {
        name: "QQuickParallelAnimation"
        defaultProperty: "animations"
        prototype: "QQuickAnimationGroup"
        exports: ["QtQuick/ParallelAnimation 2.0"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQuickParentAnimation"
        defaultProperty: "animations"
        prototype: "QQuickAnimationGroup"
        exports: ["QtQuick/ParentAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "target"; type: "QQuickItem"; isPointer: true }
        Property { name: "newParent"; type: "QQuickItem"; isPointer: true }
        Property { name: "via"; type: "QQuickItem"; isPointer: true }
    }
    Component {
        name: "QQuickParentChange"
        prototype: "QQuickStateOperation"
        exports: ["QtQuick/ParentChange 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "target"; type: "QQuickItem"; isPointer: true }
        Property { name: "parent"; type: "QQuickItem"; isPointer: true }
        Property { name: "x"; type: "QQmlScriptString" }
        Property { name: "y"; type: "QQmlScriptString" }
        Property { name: "width"; type: "QQmlScriptString" }
        Property { name: "height"; type: "QQmlScriptString" }
        Property { name: "scale"; type: "QQmlScriptString" }
        Property { name: "rotation"; type: "QQmlScriptString" }
    }
    Component {
        name: "QQuickPath"
        defaultProperty: "pathElements"
        prototype: "QObject"
        exports: ["QtQuick/Path 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "pathElements"; type: "QQuickPathElement"; isList: true; isReadonly: true }
        Property { name: "startX"; type: "double" }
        Property { name: "startY"; type: "double" }
        Property { name: "closed"; type: "bool"; isReadonly: true }
        Signal { name: "changed" }
    }
    Component {
        name: "QQuickPathAnimation"
        prototype: "QQuickAbstractAnimation"
        exports: ["QtQuick/PathAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Orientation"
            values: {
                "Fixed": 0,
                "RightFirst": 1,
                "LeftFirst": 2,
                "BottomFirst": 3,
                "TopFirst": 4
            }
        }
        Property { name: "duration"; type: "int" }
        Property { name: "easing"; type: "QEasingCurve" }
        Property { name: "path"; type: "QQuickPath"; isPointer: true }
        Property { name: "target"; type: "QQuickItem"; isPointer: true }
        Property { name: "orientation"; type: "Orientation" }
        Property { name: "anchorPoint"; type: "QPointF" }
        Property { name: "orientationEntryDuration"; type: "int" }
        Property { name: "orientationExitDuration"; type: "int" }
        Property { name: "endRotation"; type: "double" }
        Signal {
            name: "durationChanged"
            Parameter { type: "int" }
        }
        Signal {
            name: "easingChanged"
            Parameter { type: "QEasingCurve" }
        }
        Signal {
            name: "orientationChanged"
            Parameter { type: "Orientation" }
        }
        Signal {
            name: "anchorPointChanged"
            Parameter { type: "QPointF" }
        }
        Signal {
            name: "orientationEntryDurationChanged"
            Parameter { type: "double" }
        }
        Signal {
            name: "orientationExitDurationChanged"
            Parameter { type: "double" }
        }
        Signal {
            name: "endRotationChanged"
            Parameter { type: "double" }
        }
    }
    Component {
        name: "QQuickPathArc"
        prototype: "QQuickCurve"
        exports: ["QtQuick/PathArc 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "ArcDirection"
            values: {
                "Clockwise": 0,
                "Counterclockwise": 1
            }
        }
        Property { name: "radiusX"; type: "double" }
        Property { name: "radiusY"; type: "double" }
        Property { name: "useLargeArc"; type: "bool" }
        Property { name: "direction"; type: "ArcDirection" }
    }
    Component {
        name: "QQuickPathAttribute"
        prototype: "QQuickPathElement"
        exports: ["QtQuick/PathAttribute 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "name"; type: "string" }
        Property { name: "value"; type: "double" }
    }
    Component {
        name: "QQuickPathCatmullRomCurve"
        prototype: "QQuickCurve"
        exports: ["QtQuick/PathCurve 2.0"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQuickPathCubic"
        prototype: "QQuickCurve"
        exports: ["QtQuick/PathCubic 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "control1X"; type: "double" }
        Property { name: "control1Y"; type: "double" }
        Property { name: "control2X"; type: "double" }
        Property { name: "control2Y"; type: "double" }
        Property { name: "relativeControl1X"; type: "double" }
        Property { name: "relativeControl1Y"; type: "double" }
        Property { name: "relativeControl2X"; type: "double" }
        Property { name: "relativeControl2Y"; type: "double" }
    }
    Component {
        name: "QQuickPathElement"
        prototype: "QObject"
        Signal { name: "changed" }
    }
    Component {
        name: "QQuickPathInterpolator"
        prototype: "QObject"
        exports: ["QtQuick/PathInterpolator 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "path"; type: "QQuickPath"; isPointer: true }
        Property { name: "progress"; type: "double" }
        Property { name: "x"; type: "double"; isReadonly: true }
        Property { name: "y"; type: "double"; isReadonly: true }
        Property { name: "angle"; type: "double"; isReadonly: true }
    }
    Component {
        name: "QQuickPathLine"
        prototype: "QQuickCurve"
        exports: ["QtQuick/PathLine 2.0"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQuickPathPercent"
        prototype: "QQuickPathElement"
        exports: ["QtQuick/PathPercent 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "value"; type: "double" }
    }
    Component {
        name: "QQuickPathQuad"
        prototype: "QQuickCurve"
        exports: ["QtQuick/PathQuad 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "controlX"; type: "double" }
        Property { name: "controlY"; type: "double" }
        Property { name: "relativeControlX"; type: "double" }
        Property { name: "relativeControlY"; type: "double" }
    }
    Component {
        name: "QQuickPathSvg"
        prototype: "QQuickCurve"
        exports: ["QtQuick/PathSvg 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "path"; type: "string" }
    }
    Component {
        name: "QQuickPathView"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/PathView 2.0"]
        exportMetaObjectRevisions: [0]
        attachedType: "QQuickPathViewAttached"
        Enum {
            name: "HighlightRangeMode"
            values: {
                "NoHighlightRange": 0,
                "ApplyRange": 1,
                "StrictlyEnforceRange": 2
            }
        }
        Enum {
            name: "SnapMode"
            values: {
                "NoSnap": 0,
                "SnapToItem": 1,
                "SnapOneItem": 2
            }
        }
        Enum {
            name: "PositionMode"
            values: {
                "Beginning": 0,
                "Center": 1,
                "End": 2,
                "Contain": 4,
                "SnapPosition": 5
            }
        }
        Property { name: "model"; type: "QVariant" }
        Property { name: "path"; type: "QQuickPath"; isPointer: true }
        Property { name: "currentIndex"; type: "int" }
        Property { name: "currentItem"; type: "QQuickItem"; isReadonly: true; isPointer: true }
        Property { name: "offset"; type: "double" }
        Property { name: "highlight"; type: "QQmlComponent"; isPointer: true }
        Property { name: "highlightItem"; type: "QQuickItem"; isReadonly: true; isPointer: true }
        Property { name: "preferredHighlightBegin"; type: "double" }
        Property { name: "preferredHighlightEnd"; type: "double" }
        Property { name: "highlightRangeMode"; type: "HighlightRangeMode" }
        Property { name: "highlightMoveDuration"; type: "int" }
        Property { name: "dragMargin"; type: "double" }
        Property { name: "maximumFlickVelocity"; type: "double" }
        Property { name: "flickDeceleration"; type: "double" }
        Property { name: "interactive"; type: "bool" }
        Property { name: "moving"; type: "bool"; isReadonly: true }
        Property { name: "flicking"; type: "bool"; isReadonly: true }
        Property { name: "dragging"; type: "bool"; isReadonly: true }
        Property { name: "count"; type: "int"; isReadonly: true }
        Property { name: "delegate"; type: "QQmlComponent"; isPointer: true }
        Property { name: "pathItemCount"; type: "int" }
        Property { name: "snapMode"; type: "SnapMode" }
        Property { name: "cacheItemCount"; type: "int" }
        Signal { name: "snapPositionChanged" }
        Signal { name: "movementStarted" }
        Signal { name: "movementEnded" }
        Signal { name: "flickStarted" }
        Signal { name: "flickEnded" }
        Signal { name: "dragStarted" }
        Signal { name: "dragEnded" }
        Method { name: "incrementCurrentIndex" }
        Method { name: "decrementCurrentIndex" }
        Method {
            name: "positionViewAtIndex"
            Parameter { name: "index"; type: "int" }
            Parameter { name: "mode"; type: "int" }
        }
        Method {
            name: "indexAt"
            type: "int"
            Parameter { name: "x"; type: "double" }
            Parameter { name: "y"; type: "double" }
        }
        Method {
            name: "itemAt"
            type: "QQuickItem*"
            Parameter { name: "x"; type: "double" }
            Parameter { name: "y"; type: "double" }
        }
    }
    Component {
        name: "QQuickPathViewAttached"
        prototype: "QObject"
        Property { name: "view"; type: "QQuickPathView"; isReadonly: true; isPointer: true }
        Property { name: "isCurrentItem"; type: "bool"; isReadonly: true }
        Property { name: "onPath"; type: "bool"; isReadonly: true }
        Signal { name: "currentItemChanged" }
        Signal { name: "pathChanged" }
    }
    Component {
        name: "QQuickPauseAnimation"
        prototype: "QQuickAbstractAnimation"
        exports: ["QtQuick/PauseAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "duration"; type: "int" }
        Signal {
            name: "durationChanged"
            Parameter { type: "int" }
        }
    }
    Component {
        name: "QQuickPen"
        prototype: "QObject"
        Property { name: "width"; type: "double" }
        Property { name: "color"; type: "QColor" }
        Property { name: "pixelAligned"; type: "bool" }
        Signal { name: "penChanged" }
    }
    Component {
        name: "QQuickPinch"
        prototype: "QObject"
        exports: ["QtQuick/Pinch 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "Axis"
            values: {
                "NoDrag": 0,
                "XAxis": 1,
                "YAxis": 2,
                "XAndYAxis": 3,
                "XandYAxis": 3
            }
        }
        Property { name: "target"; type: "QQuickItem"; isPointer: true }
        Property { name: "minimumScale"; type: "double" }
        Property { name: "maximumScale"; type: "double" }
        Property { name: "minimumRotation"; type: "double" }
        Property { name: "maximumRotation"; type: "double" }
        Property { name: "dragAxis"; type: "Axis" }
        Property { name: "minimumX"; type: "double" }
        Property { name: "maximumX"; type: "double" }
        Property { name: "minimumY"; type: "double" }
        Property { name: "maximumY"; type: "double" }
        Property { name: "active"; type: "bool"; isReadonly: true }
    }
    Component {
        name: "QQuickPinchArea"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/PinchArea 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "enabled"; type: "bool" }
        Property { name: "pinch"; type: "QQuickPinch"; isReadonly: true; isPointer: true }
        Signal {
            name: "pinchStarted"
            Parameter { name: "pinch"; type: "QQuickPinchEvent"; isPointer: true }
        }
        Signal {
            name: "pinchUpdated"
            Parameter { name: "pinch"; type: "QQuickPinchEvent"; isPointer: true }
        }
        Signal {
            name: "pinchFinished"
            Parameter { name: "pinch"; type: "QQuickPinchEvent"; isPointer: true }
        }
    }
    Component {
        name: "QQuickPositionerAttached"
        prototype: "QObject"
        Property { name: "index"; type: "int"; isReadonly: true }
        Property { name: "isFirstItem"; type: "bool"; isReadonly: true }
        Property { name: "isLastItem"; type: "bool"; isReadonly: true }
    }
    Component {
        name: "QQuickPropertyAction"
        prototype: "QQuickAbstractAnimation"
        exports: ["QtQuick/PropertyAction 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "target"; type: "QObject"; isPointer: true }
        Property { name: "property"; type: "string" }
        Property { name: "properties"; type: "string" }
        Property { name: "targets"; type: "QObject"; isList: true; isReadonly: true }
        Property { name: "exclude"; type: "QObject"; isList: true; isReadonly: true }
        Property { name: "value"; type: "QVariant" }
        Signal {
            name: "valueChanged"
            Parameter { type: "QVariant" }
        }
        Signal {
            name: "propertiesChanged"
            Parameter { type: "string" }
        }
    }
    Component {
        name: "QQuickPropertyAnimation"
        prototype: "QQuickAbstractAnimation"
        exports: ["QtQuick/PropertyAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "duration"; type: "int" }
        Property { name: "from"; type: "QVariant" }
        Property { name: "to"; type: "QVariant" }
        Property { name: "easing"; type: "QEasingCurve" }
        Property { name: "target"; type: "QObject"; isPointer: true }
        Property { name: "property"; type: "string" }
        Property { name: "properties"; type: "string" }
        Property { name: "targets"; type: "QObject"; isList: true; isReadonly: true }
        Property { name: "exclude"; type: "QObject"; isList: true; isReadonly: true }
        Signal {
            name: "durationChanged"
            Parameter { type: "int" }
        }
        Signal {
            name: "fromChanged"
            Parameter { type: "QVariant" }
        }
        Signal {
            name: "toChanged"
            Parameter { type: "QVariant" }
        }
        Signal {
            name: "easingChanged"
            Parameter { type: "QEasingCurve" }
        }
        Signal {
            name: "propertiesChanged"
            Parameter { type: "string" }
        }
    }
    Component {
        name: "QQuickPropertyChanges"
        prototype: "QQuickStateOperation"
        exports: ["QtQuick/PropertyChanges 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "target"; type: "QObject"; isPointer: true }
        Property { name: "restoreEntryValues"; type: "bool" }
        Property { name: "explicit"; type: "bool" }
    }
    Component {
        name: "QQuickRectangle"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/Rectangle 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "color"; type: "QColor" }
        Property { name: "gradient"; type: "QQuickGradient"; isPointer: true }
        Property { name: "border"; type: "QQuickPen"; isReadonly: true; isPointer: true }
        Property { name: "radius"; type: "double" }
    }
    Component {
        name: "QQuickRepeater"
        defaultProperty: "delegate"
        prototype: "QQuickItem"
        exports: ["QtQuick/Repeater 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "model"; type: "QVariant" }
        Property { name: "delegate"; type: "QQmlComponent"; isPointer: true }
        Property { name: "count"; type: "int"; isReadonly: true }
        Signal {
            name: "itemAdded"
            Parameter { name: "index"; type: "int" }
            Parameter { name: "item"; type: "QQuickItem"; isPointer: true }
        }
        Signal {
            name: "itemRemoved"
            Parameter { name: "index"; type: "int" }
            Parameter { name: "item"; type: "QQuickItem"; isPointer: true }
        }
        Method {
            name: "itemAt"
            type: "QQuickItem*"
            Parameter { name: "index"; type: "int" }
        }
    }
    Component {
        name: "QQuickRotation"
        prototype: "QQuickTransform"
        exports: ["QtQuick/Rotation 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "origin"; type: "QVector3D" }
        Property { name: "angle"; type: "double" }
        Property { name: "axis"; type: "QVector3D" }
    }
    Component {
        name: "QQuickRotationAnimation"
        prototype: "QQuickPropertyAnimation"
        exports: ["QtQuick/RotationAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "RotationDirection"
            values: {
                "Numerical": 0,
                "Shortest": 1,
                "Clockwise": 2,
                "Counterclockwise": 3
            }
        }
        Property { name: "from"; type: "double" }
        Property { name: "to"; type: "double" }
        Property { name: "direction"; type: "RotationDirection" }
    }
    Component {
        name: "QQuickRotationAnimator"
        prototype: "QQuickAnimator"
        exports: ["QtQuick/RotationAnimator 2.2"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "RotationDirection"
            values: {
                "Numerical": 0,
                "Shortest": 1,
                "Clockwise": 2,
                "Counterclockwise": 3
            }
        }
        Property { name: "direction"; type: "RotationDirection" }
        Signal {
            name: "directionChanged"
            Parameter { name: "dir"; type: "RotationDirection" }
        }
    }
    Component {
        name: "QQuickRow"
        defaultProperty: "data"
        prototype: "QQuickBasePositioner"
        exports: ["QtQuick/Row 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "layoutDirection"; type: "Qt::LayoutDirection" }
        Property { name: "effectiveLayoutDirection"; type: "Qt::LayoutDirection"; isReadonly: true }
    }
    Component {
        name: "QQuickScale"
        prototype: "QQuickTransform"
        exports: ["QtQuick/Scale 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "origin"; type: "QVector3D" }
        Property { name: "xScale"; type: "double" }
        Property { name: "yScale"; type: "double" }
        Property { name: "zScale"; type: "double" }
        Signal { name: "scaleChanged" }
    }
    Component {
        name: "QQuickScaleAnimator"
        prototype: "QQuickAnimator"
        exports: ["QtQuick/ScaleAnimator 2.2"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQuickScaleGrid"
        prototype: "QObject"
        Property { name: "left"; type: "int" }
        Property { name: "top"; type: "int" }
        Property { name: "right"; type: "int" }
        Property { name: "bottom"; type: "int" }
        Signal { name: "borderChanged" }
    }
    Component {
        name: "QQuickScriptAction"
        prototype: "QQuickAbstractAnimation"
        exports: ["QtQuick/ScriptAction 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "script"; type: "QQmlScriptString" }
        Property { name: "scriptName"; type: "string" }
    }
    Component {
        name: "QQuickSequentialAnimation"
        defaultProperty: "animations"
        prototype: "QQuickAnimationGroup"
        exports: ["QtQuick/SequentialAnimation 2.0"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQuickShaderEffect"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/ShaderEffect 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "CullMode"
            values: {
                "NoCulling": 0,
                "BackFaceCulling": 1,
                "FrontFaceCulling": 2
            }
        }
        Enum {
            name: "Status"
            values: {
                "Compiled": 0,
                "Uncompiled": 1,
                "Error": 2
            }
        }
        Property { name: "fragmentShader"; type: "QByteArray" }
        Property { name: "vertexShader"; type: "QByteArray" }
        Property { name: "blending"; type: "bool" }
        Property { name: "mesh"; type: "QVariant" }
        Property { name: "cullMode"; type: "CullMode" }
        Property { name: "log"; type: "string"; isReadonly: true }
        Property { name: "status"; type: "Status"; isReadonly: true }
    }
    Component {
        name: "QQuickShaderEffectMesh"
        prototype: "QObject"
        exports: ["QtQuick/ShaderEffectMesh 2.0"]
        exportMetaObjectRevisions: [0]
        Signal { name: "geometryChanged" }
    }
    Component {
        name: "QQuickShaderEffectSource"
        defaultProperty: "data"
        prototype: "QQuickItem"
        exports: ["QtQuick/ShaderEffectSource 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "WrapMode"
            values: {
                "ClampToEdge": 0,
                "RepeatHorizontally": 1,
                "RepeatVertically": 2,
                "Repeat": 3
            }
        }
        Enum {
            name: "Format"
            values: {
                "Alpha": 6406,
                "RGB": 6407,
                "RGBA": 6408
            }
        }
        Property { name: "wrapMode"; type: "WrapMode" }
        Property { name: "sourceItem"; type: "QQuickItem"; isPointer: true }
        Property { name: "sourceRect"; type: "QRectF" }
        Property { name: "textureSize"; type: "QSize" }
        Property { name: "format"; type: "Format" }
        Property { name: "live"; type: "bool" }
        Property { name: "hideSource"; type: "bool" }
        Property { name: "mipmap"; type: "bool" }
        Property { name: "recursive"; type: "bool" }
        Signal { name: "scheduledUpdateCompleted" }
        Method { name: "scheduleUpdate" }
    }
    Component {
        name: "QQuickSmoothedAnimation"
        prototype: "QQuickNumberAnimation"
        exports: ["QtQuick/SmoothedAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "ReversingMode"
            values: {
                "Eased": 0,
                "Immediate": 1,
                "Sync": 2
            }
        }
        Property { name: "velocity"; type: "double" }
        Property { name: "reversingMode"; type: "ReversingMode" }
        Property { name: "maximumEasingTime"; type: "double" }
    }
    Component {
        name: "QQuickSpringAnimation"
        prototype: "QQuickNumberAnimation"
        exports: ["QtQuick/SpringAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "velocity"; type: "double" }
        Property { name: "spring"; type: "double" }
        Property { name: "damping"; type: "double" }
        Property { name: "epsilon"; type: "double" }
        Property { name: "modulus"; type: "double" }
        Property { name: "mass"; type: "double" }
        Signal { name: "syncChanged" }
    }
    Component {
        name: "QQuickSprite"
        prototype: "QQuickStochasticState"
        exports: ["QtQuick/Sprite 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "source"; type: "QUrl" }
        Property { name: "reverse"; type: "bool" }
        Property { name: "frameSync"; type: "bool" }
        Property { name: "frames"; type: "int" }
        Property { name: "frameCount"; type: "int" }
        Property { name: "frameHeight"; type: "int" }
        Property { name: "frameWidth"; type: "int" }
        Property { name: "frameX"; type: "int" }
        Property { name: "frameY"; type: "int" }
        Property { name: "frameRate"; type: "double" }
        Property { name: "frameRateVariation"; type: "double" }
        Property { name: "frameDuration"; type: "int" }
        Property { name: "frameDurationVariation"; type: "int" }
        Signal {
            name: "sourceChanged"
            Parameter { name: "arg"; type: "QUrl" }
        }
        Signal {
            name: "frameHeightChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameWidthChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "reverseChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Signal {
            name: "frameCountChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameXChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameYChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameRateChanged"
            Parameter { name: "arg"; type: "double" }
        }
        Signal {
            name: "frameRateVariationChanged"
            Parameter { name: "arg"; type: "double" }
        }
        Signal {
            name: "frameDurationChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameDurationVariationChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "frameSyncChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Method {
            name: "setSource"
            Parameter { name: "arg"; type: "QUrl" }
        }
        Method {
            name: "setFrameHeight"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameWidth"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setReverse"
            Parameter { name: "arg"; type: "bool" }
        }
        Method {
            name: "setFrames"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameCount"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameX"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameY"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameRate"
            Parameter { name: "arg"; type: "double" }
        }
        Method {
            name: "setFrameRateVariation"
            Parameter { name: "arg"; type: "double" }
        }
        Method {
            name: "setFrameDuration"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameDurationVariation"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setFrameSync"
            Parameter { name: "arg"; type: "bool" }
        }
    }
    Component {
        name: "QQuickSpriteSequence"
        defaultProperty: "sprites"
        prototype: "QQuickItem"
        exports: ["QtQuick/SpriteSequence 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "running"; type: "bool" }
        Property { name: "interpolate"; type: "bool" }
        Property { name: "goalSprite"; type: "string" }
        Property { name: "currentSprite"; type: "string"; isReadonly: true }
        Property { name: "sprites"; type: "QQuickSprite"; isList: true; isReadonly: true }
        Signal {
            name: "runningChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Signal {
            name: "interpolateChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Signal {
            name: "goalSpriteChanged"
            Parameter { name: "arg"; type: "string" }
        }
        Signal {
            name: "currentSpriteChanged"
            Parameter { name: "arg"; type: "string" }
        }
        Method {
            name: "jumpTo"
            Parameter { name: "sprite"; type: "string" }
        }
        Method {
            name: "setGoalSprite"
            Parameter { name: "sprite"; type: "string" }
        }
        Method {
            name: "setRunning"
            Parameter { name: "arg"; type: "bool" }
        }
        Method {
            name: "setInterpolate"
            Parameter { name: "arg"; type: "bool" }
        }
    }
    Component {
        name: "QQuickState"
        defaultProperty: "changes"
        prototype: "QObject"
        exports: ["QtQuick/State 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "name"; type: "string" }
        Property { name: "when"; type: "QQmlBinding"; isPointer: true }
        Property { name: "extend"; type: "string" }
        Property { name: "changes"; type: "QQuickStateOperation"; isList: true; isReadonly: true }
        Signal { name: "completed" }
    }
    Component {
        name: "QQuickStateChangeScript"
        prototype: "QQuickStateOperation"
        exports: ["QtQuick/StateChangeScript 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "script"; type: "QQmlScriptString" }
        Property { name: "name"; type: "string" }
    }
    Component {
        name: "QQuickStateGroup"
        prototype: "QObject"
        exports: ["QtQuick/StateGroup 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "state"; type: "string" }
        Property { name: "states"; type: "QQuickState"; isList: true; isReadonly: true }
        Property { name: "transitions"; type: "QQuickTransition"; isList: true; isReadonly: true }
        Signal {
            name: "stateChanged"
            Parameter { type: "string" }
        }
    }
    Component { name: "QQuickStateOperation"; prototype: "QObject" }
    Component {
        name: "QQuickStochasticState"
        prototype: "QObject"
        Property { name: "duration"; type: "int" }
        Property { name: "durationVariation"; type: "int" }
        Property { name: "randomStart"; type: "bool" }
        Property { name: "to"; type: "QVariantMap" }
        Property { name: "name"; type: "string" }
        Signal {
            name: "durationChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal {
            name: "nameChanged"
            Parameter { name: "arg"; type: "string" }
        }
        Signal {
            name: "toChanged"
            Parameter { name: "arg"; type: "QVariantMap" }
        }
        Signal {
            name: "durationVariationChanged"
            Parameter { name: "arg"; type: "int" }
        }
        Signal { name: "entered" }
        Signal {
            name: "randomStartChanged"
            Parameter { name: "arg"; type: "bool" }
        }
        Method {
            name: "setDuration"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setName"
            Parameter { name: "arg"; type: "string" }
        }
        Method {
            name: "setTo"
            Parameter { name: "arg"; type: "QVariantMap" }
        }
        Method {
            name: "setDurationVariation"
            Parameter { name: "arg"; type: "int" }
        }
        Method {
            name: "setRandomStart"
            Parameter { name: "arg"; type: "bool" }
        }
    }
    Component {
        name: "QQuickSystemPalette"
        prototype: "QObject"
        exports: ["QtQuick/SystemPalette 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "ColorGroup"
            values: {
                "Active": 0,
                "Inactive": 2,
                "Disabled": 1
            }
        }
        Property { name: "colorGroup"; type: "QQuickSystemPalette::ColorGroup" }
        Property { name: "window"; type: "QColor"; isReadonly: true }
        Property { name: "windowText"; type: "QColor"; isReadonly: true }
        Property { name: "base"; type: "QColor"; isReadonly: true }
        Property { name: "text"; type: "QColor"; isReadonly: true }
        Property { name: "alternateBase"; type: "QColor"; isReadonly: true }
        Property { name: "button"; type: "QColor"; isReadonly: true }
        Property { name: "buttonText"; type: "QColor"; isReadonly: true }
        Property { name: "light"; type: "QColor"; isReadonly: true }
        Property { name: "midlight"; type: "QColor"; isReadonly: true }
        Property { name: "dark"; type: "QColor"; isReadonly: true }
        Property { name: "mid"; type: "QColor"; isReadonly: true }
        Property { name: "shadow"; type: "QColor"; isReadonly: true }
        Property { name: "highlight"; type: "QColor"; isReadonly: true }
        Property { name: "highlightedText"; type: "QColor"; isReadonly: true }
        Signal { name: "paletteChanged" }
    }
    Component {
        name: "QQuickText"
        defaultProperty: "data"
        prototype: "QQuickImplicitSizeItem"
        exports: ["QtQuick/Text 2.0", "QtQuick/Text 2.2"]
        exportMetaObjectRevisions: [0, 2]
        Enum {
            name: "HAlignment"
            values: {
                "AlignLeft": 1,
                "AlignRight": 2,
                "AlignHCenter": 4,
                "AlignJustify": 8
            }
        }
        Enum {
            name: "VAlignment"
            values: {
                "AlignTop": 32,
                "AlignBottom": 64,
                "AlignVCenter": 128
            }
        }
        Enum {
            name: "TextStyle"
            values: {
                "Normal": 0,
                "Outline": 1,
                "Raised": 2,
                "Sunken": 3
            }
        }
        Enum {
            name: "TextFormat"
            values: {
                "PlainText": 0,
                "RichText": 1,
                "AutoText": 2,
                "StyledText": 4
            }
        }
        Enum {
            name: "TextElideMode"
            values: {
                "ElideLeft": 0,
                "ElideRight": 1,
                "ElideMiddle": 2,
                "ElideNone": 3
            }
        }
        Enum {
            name: "WrapMode"
            values: {
                "NoWrap": 0,
                "WordWrap": 1,
                "WrapAnywhere": 3,
                "WrapAtWordBoundaryOrAnywhere": 4,
                "Wrap": 4
            }
        }
        Enum {
            name: "RenderType"
            values: {
                "QtRendering": 0,
                "NativeRendering": 1
            }
        }
        Enum {
            name: "LineHeightMode"
            values: {
                "ProportionalHeight": 0,
                "FixedHeight": 1
            }
        }
        Enum {
            name: "FontSizeMode"
            values: {
                "FixedSize": 0,
                "HorizontalFit": 1,
                "VerticalFit": 2,
                "Fit": 3
            }
        }
        Property { name: "text"; type: "string" }
        Property { name: "font"; type: "QFont" }
        Property { name: "color"; type: "QColor" }
        Property { name: "linkColor"; type: "QColor" }
        Property { name: "style"; type: "TextStyle" }
        Property { name: "styleColor"; type: "QColor" }
        Property { name: "horizontalAlignment"; type: "HAlignment" }
        Property { name: "effectiveHorizontalAlignment"; type: "HAlignment"; isReadonly: true }
        Property { name: "verticalAlignment"; type: "VAlignment" }
        Property { name: "wrapMode"; type: "WrapMode" }
        Property { name: "lineCount"; type: "int"; isReadonly: true }
        Property { name: "truncated"; type: "bool"; isReadonly: true }
        Property { name: "maximumLineCount"; type: "int" }
        Property { name: "textFormat"; type: "TextFormat" }
        Property { name: "elide"; type: "TextElideMode" }
        Property { name: "contentWidth"; type: "double"; isReadonly: true }
        Property { name: "contentHeight"; type: "double"; isReadonly: true }
        Property { name: "paintedWidth"; type: "double"; isReadonly: true }
        Property { name: "paintedHeight"; type: "double"; isReadonly: true }
        Property { name: "lineHeight"; type: "double" }
        Property { name: "lineHeightMode"; type: "LineHeightMode" }
        Property { name: "baseUrl"; type: "QUrl" }
        Property { name: "minimumPixelSize"; type: "int" }
        Property { name: "minimumPointSize"; type: "int" }
        Property { name: "fontSizeMode"; type: "FontSizeMode" }
        Property { name: "renderType"; type: "RenderType" }
        Property { name: "hoveredLink"; revision: 2; type: "string"; isReadonly: true }
        Signal {
            name: "textChanged"
            Parameter { name: "text"; type: "string" }
        }
        Signal {
            name: "linkActivated"
            Parameter { name: "link"; type: "string" }
        }
        Signal {
            name: "linkHovered"
            revision: 2
            Parameter { name: "link"; type: "string" }
        }
        Signal {
            name: "fontChanged"
            Parameter { name: "font"; type: "QFont" }
        }
        Signal {
            name: "styleChanged"
            Parameter { name: "style"; type: "TextStyle" }
        }
        Signal {
            name: "horizontalAlignmentChanged"
            Parameter { name: "alignment"; type: "HAlignment" }
        }
        Signal {
            name: "verticalAlignmentChanged"
            Parameter { name: "alignment"; type: "VAlignment" }
        }
        Signal {
            name: "textFormatChanged"
            Parameter { name: "textFormat"; type: "TextFormat" }
        }
        Signal {
            name: "elideModeChanged"
            Parameter { name: "mode"; type: "TextElideMode" }
        }
        Signal { name: "contentSizeChanged" }
        Signal {
            name: "lineHeightChanged"
            Parameter { name: "lineHeight"; type: "double" }
        }
        Signal {
            name: "lineHeightModeChanged"
            Parameter { name: "mode"; type: "LineHeightMode" }
        }
        Signal {
            name: "lineLaidOut"
            Parameter { name: "line"; type: "QQuickTextLine"; isPointer: true }
        }
        Method { name: "doLayout" }
    }
    Component { name: "QQuickTextDocument"; prototype: "QObject" }
    Component {
        name: "QQuickTextEdit"
        defaultProperty: "data"
        prototype: "QQuickImplicitSizeItem"
        exports: [
            "QtQuick/TextEdit 2.0",
            "QtQuick/TextEdit 2.1",
            "QtQuick/TextEdit 2.2"
        ]
        exportMetaObjectRevisions: [0, 1, 2]
        Enum {
            name: "HAlignment"
            values: {
                "AlignLeft": 1,
                "AlignRight": 2,
                "AlignHCenter": 4,
                "AlignJustify": 8
            }
        }
        Enum {
            name: "VAlignment"
            values: {
                "AlignTop": 32,
                "AlignBottom": 64,
                "AlignVCenter": 128
            }
        }
        Enum {
            name: "TextFormat"
            values: {
                "PlainText": 0,
                "RichText": 1,
                "AutoText": 2
            }
        }
        Enum {
            name: "WrapMode"
            values: {
                "NoWrap": 0,
                "WordWrap": 1,
                "WrapAnywhere": 3,
                "WrapAtWordBoundaryOrAnywhere": 4,
                "Wrap": 4
            }
        }
        Enum {
            name: "SelectionMode"
            values: {
                "SelectCharacters": 0,
                "SelectWords": 1
            }
        }
        Enum {
            name: "RenderType"
            values: {
                "QtRendering": 0,
                "NativeRendering": 1
            }
        }
        Property { name: "text"; type: "string" }
        Property { name: "color"; type: "QColor" }
        Property { name: "selectionColor"; type: "QColor" }
        Property { name: "selectedTextColor"; type: "QColor" }
        Property { name: "font"; type: "QFont" }
        Property { name: "horizontalAlignment"; type: "HAlignment" }
        Property { name: "effectiveHorizontalAlignment"; type: "HAlignment"; isReadonly: true }
        Property { name: "verticalAlignment"; type: "VAlignment" }
        Property { name: "wrapMode"; type: "WrapMode" }
        Property { name: "lineCount"; type: "int"; isReadonly: true }
        Property { name: "length"; type: "int"; isReadonly: true }
        Property { name: "contentWidth"; type: "double"; isReadonly: true }
        Property { name: "contentHeight"; type: "double"; isReadonly: true }
        Property { name: "paintedWidth"; type: "double"; isReadonly: true }
        Property { name: "paintedHeight"; type: "double"; isReadonly: true }
        Property { name: "textFormat"; type: "TextFormat" }
        Property { name: "readOnly"; type: "bool" }
        Property { name: "cursorVisible"; type: "bool" }
        Property { name: "cursorPosition"; type: "int" }
        Property { name: "cursorRectangle"; type: "QRectF"; isReadonly: true }
        Property { name: "cursorDelegate"; type: "QQmlComponent"; isPointer: true }
        Property { name: "selectionStart"; type: "int"; isReadonly: true }
        Property { name: "selectionEnd"; type: "int"; isReadonly: true }
        Property { name: "selectedText"; type: "string"; isReadonly: true }
        Property { name: "activeFocusOnPress"; type: "bool" }
        Property { name: "persistentSelection"; type: "bool" }
        Property { name: "textMargin"; type: "double" }
        Property { name: "inputMethodHints"; type: "Qt::InputMethodHints" }
        Property { name: "selectByKeyboard"; revision: 1; type: "bool" }
        Property { name: "selectByMouse"; type: "bool" }
        Property { name: "mouseSelectionMode"; type: "SelectionMode" }
        Property { name: "canPaste"; type: "bool"; isReadonly: true }
        Property { name: "canUndo"; type: "bool"; isReadonly: true }
        Property { name: "canRedo"; type: "bool"; isReadonly: true }
        Property { name: "inputMethodComposing"; type: "bool"; isReadonly: true }
        Property { name: "baseUrl"; type: "QUrl" }
        Property { name: "renderType"; type: "RenderType" }
        Property {
            name: "textDocument"
            revision: 1
            type: "QQuickTextDocument"
            isReadonly: true
            isPointer: true
        }
        Property { name: "hoveredLink"; revision: 2; type: "string"; isReadonly: true }
        Signal { name: "contentSizeChanged" }
        Signal {
            name: "colorChanged"
            Parameter { name: "color"; type: "QColor" }
        }
        Signal {
            name: "selectionColorChanged"
            Parameter { name: "color"; type: "QColor" }
        }
        Signal {
            name: "selectedTextColorChanged"
            Parameter { name: "color"; type: "QColor" }
        }
        Signal {
            name: "fontChanged"
            Parameter { name: "font"; type: "QFont" }
        }
        Signal {
            name: "horizontalAlignmentChanged"
            Parameter { name: "alignment"; type: "HAlignment" }
        }
        Signal {
            name: "verticalAlignmentChanged"
            Parameter { name: "alignment"; type: "VAlignment" }
        }
        Signal {
            name: "textFormatChanged"
            Parameter { name: "textFormat"; type: "TextFormat" }
        }
        Signal {
            name: "readOnlyChanged"
            Parameter { name: "isReadOnly"; type: "bool" }
        }
        Signal {
            name: "cursorVisibleChanged"
            Parameter { name: "isCursorVisible"; type: "bool" }
        }
        Signal {
            name: "activeFocusOnPressChanged"
            Parameter { name: "activeFocusOnPressed"; type: "bool" }
        }
        Signal {
            name: "persistentSelectionChanged"
            Parameter { name: "isPersistentSelection"; type: "bool" }
        }
        Signal {
            name: "textMarginChanged"
            Parameter { name: "textMargin"; type: "double" }
        }
        Signal {
            name: "selectByKeyboardChanged"
            revision: 1
            Parameter { name: "selectByKeyboard"; type: "bool" }
        }
        Signal {
            name: "selectByMouseChanged"
            Parameter { name: "selectByMouse"; type: "bool" }
        }
        Signal {
            name: "mouseSelectionModeChanged"
            Parameter { name: "mode"; type: "SelectionMode" }
        }
        Signal {
            name: "linkActivated"
            Parameter { name: "link"; type: "string" }
        }
        Signal {
            name: "linkHovered"
            revision: 2
            Parameter { name: "link"; type: "string" }
        }
        Method { name: "selectAll" }
        Method { name: "selectWord" }
        Method {
            name: "select"
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
        }
        Method { name: "deselect" }
        Method {
            name: "isRightToLeft"
            type: "bool"
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
        }
        Method { name: "cut" }
        Method { name: "copy" }
        Method { name: "paste" }
        Method { name: "undo" }
        Method { name: "redo" }
        Method {
            name: "insert"
            Parameter { name: "position"; type: "int" }
            Parameter { name: "text"; type: "string" }
        }
        Method {
            name: "remove"
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
        }
        Method {
            name: "append"
            revision: 2
            Parameter { name: "text"; type: "string" }
        }
        Method {
            name: "positionToRectangle"
            type: "QRectF"
            Parameter { type: "int" }
        }
        Method {
            name: "positionAt"
            type: "int"
            Parameter { name: "x"; type: "double" }
            Parameter { name: "y"; type: "double" }
        }
        Method {
            name: "moveCursorSelection"
            Parameter { name: "pos"; type: "int" }
        }
        Method {
            name: "moveCursorSelection"
            Parameter { name: "pos"; type: "int" }
            Parameter { name: "mode"; type: "SelectionMode" }
        }
        Method {
            name: "getText"
            type: "string"
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
        }
        Method {
            name: "getFormattedText"
            type: "string"
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
        }
    }
    Component {
        name: "QQuickTextInput"
        defaultProperty: "data"
        prototype: "QQuickImplicitSizeItem"
        exports: ["QtQuick/TextInput 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "EchoMode"
            values: {
                "Normal": 0,
                "NoEcho": 1,
                "Password": 2,
                "PasswordEchoOnEdit": 3
            }
        }
        Enum {
            name: "HAlignment"
            values: {
                "AlignLeft": 1,
                "AlignRight": 2,
                "AlignHCenter": 4
            }
        }
        Enum {
            name: "VAlignment"
            values: {
                "AlignTop": 32,
                "AlignBottom": 64,
                "AlignVCenter": 128
            }
        }
        Enum {
            name: "WrapMode"
            values: {
                "NoWrap": 0,
                "WordWrap": 1,
                "WrapAnywhere": 3,
                "WrapAtWordBoundaryOrAnywhere": 4,
                "Wrap": 4
            }
        }
        Enum {
            name: "SelectionMode"
            values: {
                "SelectCharacters": 0,
                "SelectWords": 1
            }
        }
        Enum {
            name: "CursorPosition"
            values: {
                "CursorBetweenCharacters": 0,
                "CursorOnCharacter": 1
            }
        }
        Enum {
            name: "RenderType"
            values: {
                "QtRendering": 0,
                "NativeRendering": 1
            }
        }
        Property { name: "text"; type: "string" }
        Property { name: "length"; type: "int"; isReadonly: true }
        Property { name: "color"; type: "QColor" }
        Property { name: "selectionColor"; type: "QColor" }
        Property { name: "selectedTextColor"; type: "QColor" }
        Property { name: "font"; type: "QFont" }
        Property { name: "horizontalAlignment"; type: "HAlignment" }
        Property { name: "effectiveHorizontalAlignment"; type: "HAlignment"; isReadonly: true }
        Property { name: "verticalAlignment"; type: "VAlignment" }
        Property { name: "wrapMode"; type: "WrapMode" }
        Property { name: "readOnly"; type: "bool" }
        Property { name: "cursorVisible"; type: "bool" }
        Property { name: "cursorPosition"; type: "int" }
        Property { name: "cursorRectangle"; type: "QRectF"; isReadonly: true }
        Property { name: "cursorDelegate"; type: "QQmlComponent"; isPointer: true }
        Property { name: "selectionStart"; type: "int"; isReadonly: true }
        Property { name: "selectionEnd"; type: "int"; isReadonly: true }
        Property { name: "selectedText"; type: "string"; isReadonly: true }
        Property { name: "maximumLength"; type: "int" }
        Property { name: "validator"; type: "QValidator"; isPointer: true }
        Property { name: "inputMask"; type: "string" }
        Property { name: "inputMethodHints"; type: "Qt::InputMethodHints" }
        Property { name: "acceptableInput"; type: "bool"; isReadonly: true }
        Property { name: "echoMode"; type: "EchoMode" }
        Property { name: "activeFocusOnPress"; type: "bool" }
        Property { name: "passwordCharacter"; type: "string" }
        Property { name: "displayText"; type: "string"; isReadonly: true }
        Property { name: "autoScroll"; type: "bool" }
        Property { name: "selectByMouse"; type: "bool" }
        Property { name: "mouseSelectionMode"; type: "SelectionMode" }
        Property { name: "persistentSelection"; type: "bool" }
        Property { name: "canPaste"; type: "bool"; isReadonly: true }
        Property { name: "canUndo"; type: "bool"; isReadonly: true }
        Property { name: "canRedo"; type: "bool"; isReadonly: true }
        Property { name: "inputMethodComposing"; type: "bool"; isReadonly: true }
        Property { name: "contentWidth"; type: "double"; isReadonly: true }
        Property { name: "contentHeight"; type: "double"; isReadonly: true }
        Property { name: "renderType"; type: "RenderType" }
        Signal { name: "accepted" }
        Signal {
            name: "fontChanged"
            Parameter { name: "font"; type: "QFont" }
        }
        Signal {
            name: "horizontalAlignmentChanged"
            Parameter { name: "alignment"; type: "HAlignment" }
        }
        Signal {
            name: "verticalAlignmentChanged"
            Parameter { name: "alignment"; type: "VAlignment" }
        }
        Signal {
            name: "readOnlyChanged"
            Parameter { name: "isReadOnly"; type: "bool" }
        }
        Signal {
            name: "cursorVisibleChanged"
            Parameter { name: "isCursorVisible"; type: "bool" }
        }
        Signal {
            name: "maximumLengthChanged"
            Parameter { name: "maximumLength"; type: "int" }
        }
        Signal {
            name: "inputMaskChanged"
            Parameter { name: "inputMask"; type: "string" }
        }
        Signal {
            name: "echoModeChanged"
            Parameter { name: "echoMode"; type: "EchoMode" }
        }
        Signal {
            name: "activeFocusOnPressChanged"
            Parameter { name: "activeFocusOnPress"; type: "bool" }
        }
        Signal {
            name: "autoScrollChanged"
            Parameter { name: "autoScroll"; type: "bool" }
        }
        Signal {
            name: "selectByMouseChanged"
            Parameter { name: "selectByMouse"; type: "bool" }
        }
        Signal {
            name: "mouseSelectionModeChanged"
            Parameter { name: "mode"; type: "SelectionMode" }
        }
        Signal { name: "contentSizeChanged" }
        Method { name: "selectAll" }
        Method { name: "selectWord" }
        Method {
            name: "select"
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
        }
        Method { name: "deselect" }
        Method {
            name: "isRightToLeft"
            type: "bool"
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
        }
        Method { name: "cut" }
        Method { name: "copy" }
        Method { name: "paste" }
        Method { name: "undo" }
        Method { name: "redo" }
        Method {
            name: "insert"
            Parameter { name: "position"; type: "int" }
            Parameter { name: "text"; type: "string" }
        }
        Method {
            name: "remove"
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
        }
        Method {
            name: "positionAt"
            Parameter { name: "args"; type: "QQmlV4Function"; isPointer: true }
        }
        Method {
            name: "positionToRectangle"
            type: "QRectF"
            Parameter { name: "pos"; type: "int" }
        }
        Method {
            name: "moveCursorSelection"
            Parameter { name: "pos"; type: "int" }
        }
        Method {
            name: "moveCursorSelection"
            Parameter { name: "pos"; type: "int" }
            Parameter { name: "mode"; type: "SelectionMode" }
        }
        Method {
            name: "getText"
            type: "string"
            Parameter { name: "start"; type: "int" }
            Parameter { name: "end"; type: "int" }
        }
    }
    Component {
        name: "QQuickTouchPoint"
        prototype: "QObject"
        exports: ["QtQuick/TouchPoint 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "pointId"; type: "int"; isReadonly: true }
        Property { name: "pressed"; type: "bool"; isReadonly: true }
        Property { name: "x"; type: "double"; isReadonly: true }
        Property { name: "y"; type: "double"; isReadonly: true }
        Property { name: "pressure"; type: "double"; isReadonly: true }
        Property { name: "velocity"; type: "QVector2D"; isReadonly: true }
        Property { name: "area"; type: "QRectF"; isReadonly: true }
        Property { name: "startX"; type: "double"; isReadonly: true }
        Property { name: "startY"; type: "double"; isReadonly: true }
        Property { name: "previousX"; type: "double"; isReadonly: true }
        Property { name: "previousY"; type: "double"; isReadonly: true }
        Property { name: "sceneX"; type: "double"; isReadonly: true }
        Property { name: "sceneY"; type: "double"; isReadonly: true }
    }
    Component { name: "QQuickTransform"; prototype: "QObject" }
    Component {
        name: "QQuickTransition"
        defaultProperty: "animations"
        prototype: "QObject"
        exports: ["QtQuick/Transition 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "from"; type: "string" }
        Property { name: "to"; type: "string" }
        Property { name: "reversible"; type: "bool" }
        Property { name: "running"; type: "bool"; isReadonly: true }
        Property { name: "animations"; type: "QQuickAbstractAnimation"; isList: true; isReadonly: true }
        Property { name: "enabled"; type: "bool" }
    }
    Component {
        name: "QQuickTranslate"
        prototype: "QQuickTransform"
        exports: ["QtQuick/Translate 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "x"; type: "double" }
        Property { name: "y"; type: "double" }
    }
    Component {
        name: "QQuickUniformAnimator"
        prototype: "QQuickAnimator"
        exports: ["QtQuick/UniformAnimator 2.2"]
        exportMetaObjectRevisions: [0]
        Property { name: "uniform"; type: "string" }
        Signal {
            name: "uniformChanged"
            Parameter { type: "string" }
        }
    }
    Component {
        name: "QQuickVector3dAnimation"
        prototype: "QQuickPropertyAnimation"
        exports: ["QtQuick/Vector3dAnimation 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "from"; type: "QVector3D" }
        Property { name: "to"; type: "QVector3D" }
    }
    Component {
        name: "QQuickViewSection"
        prototype: "QObject"
        exports: ["QtQuick/ViewSection 2.0"]
        exportMetaObjectRevisions: [0]
        Enum {
            name: "SectionCriteria"
            values: {
                "FullString": 0,
                "FirstCharacter": 1
            }
        }
        Enum {
            name: "LabelPositioning"
            values: {
                "InlineLabels": 1,
                "CurrentLabelAtStart": 2,
                "NextLabelAtEnd": 4
            }
        }
        Property { name: "property"; type: "string" }
        Property { name: "criteria"; type: "SectionCriteria" }
        Property { name: "delegate"; type: "QQmlComponent"; isPointer: true }
        Property { name: "labelPositioning"; type: "int" }
        Signal { name: "sectionsChanged" }
    }
    Component {
        name: "QQuickViewTransitionAttached"
        prototype: "QObject"
        exports: ["QtQuick/ViewTransition 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "index"; type: "int"; isReadonly: true }
        Property { name: "item"; type: "QQuickItem"; isReadonly: true; isPointer: true }
        Property { name: "destination"; type: "QPointF"; isReadonly: true }
        Property { name: "targetIndexes"; type: "QList<int>"; isReadonly: true }
        Property { name: "targetItems"; type: "QObject"; isList: true; isReadonly: true }
    }
    Component {
        name: "QQuickWorkerScript"
        prototype: "QObject"
        exports: ["QtQuick/WorkerScript 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "source"; type: "QUrl" }
        Signal {
            name: "message"
            Parameter { name: "messageObject"; type: "QQmlV4Handle" }
        }
        Method {
            name: "sendMessage"
            Parameter { type: "QQmlV4Function"; isPointer: true }
        }
    }
    Component {
        name: "QQuickXAnimator"
        prototype: "QQuickAnimator"
        exports: ["QtQuick/XAnimator 2.2"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QQuickYAnimator"
        prototype: "QQuickAnimator"
        exports: ["QtQuick/YAnimator 2.2"]
        exportMetaObjectRevisions: [0]
    }
    Component {
        name: "QRegExpValidator"
        prototype: "QValidator"
        exports: ["QtQuick/RegExpValidator 2.0"]
        exportMetaObjectRevisions: [0]
        Property { name: "regExp"; type: "QRegExp" }
        Signal {
            name: "regExpChanged"
            Parameter { name: "regExp"; type: "QRegExp" }
        }
    }
    Component {
        name: "QValidator"
        prototype: "QObject"
        Signal { name: "changed" }
    }
    Component {
        name: "Qt"
        Enum {
            name: "GlobalColor"
            values: {
                "color0": 0,
                "color1": 1,
                "black": 2,
                "white": 3,
                "darkGray": 4,
                "gray": 5,
                "lightGray": 6,
                "red": 7,
                "green": 8,
                "blue": 9,
                "cyan": 10,
                "magenta": 11,
                "yellow": 12,
                "darkRed": 13,
                "darkGreen": 14,
                "darkBlue": 15,
                "darkCyan": 16,
                "darkMagenta": 17,
                "darkYellow": 18,
                "transparent": 19
            }
        }
        Enum {
            name: "KeyboardModifiers"
            values: {
                "NoModifier": 0,
                "ShiftModifier": 33554432,
                "ControlModifier": 67108864,
                "AltModifier": 134217728,
                "MetaModifier": 268435456,
                "KeypadModifier": 536870912,
                "GroupSwitchModifier": 1073741824,
                "KeyboardModifierMask": -33554432
            }
        }
        Enum {
            name: "MouseButtons"
            values: {
                "NoButton": 0,
                "LeftButton": 1,
                "RightButton": 2,
                "MidButton": 4,
                "MiddleButton": 4,
                "BackButton": 8,
                "XButton1": 8,
                "ExtraButton1": 8,
                "ForwardButton": 16,
                "XButton2": 16,
                "ExtraButton2": 16,
                "TaskButton": 32,
                "ExtraButton3": 32,
                "ExtraButton4": 64,
                "ExtraButton5": 128,
                "ExtraButton6": 256,
                "ExtraButton7": 512,
                "ExtraButton8": 1024,
                "ExtraButton9": 2048,
                "ExtraButton10": 4096,
                "ExtraButton11": 8192,
                "ExtraButton12": 16384,
                "ExtraButton13": 32768,
                "ExtraButton14": 65536,
                "ExtraButton15": 131072,
                "ExtraButton16": 262144,
                "ExtraButton17": 524288,
                "ExtraButton18": 1048576,
                "ExtraButton19": 2097152,
                "ExtraButton20": 4194304,
                "ExtraButton21": 8388608,
                "ExtraButton22": 16777216,
                "ExtraButton23": 33554432,
                "ExtraButton24": 67108864,
                "AllButtons": 134217727,
                "MaxMouseButton": 67108864,
                "MouseButtonMask": -1
            }
        }
        Enum {
            name: "Orientation"
            values: {
                "Horizontal": 1,
                "Vertical": 2
            }
        }
        Enum {
            name: "Orientations"
            values: {
                "Horizontal": 1,
                "Vertical": 2
            }
        }
        Enum {
            name: "FocusPolicy"
            values: {
                "NoFocus": 0,
                "TabFocus": 1,
                "ClickFocus": 2,
                "StrongFocus": 11,
                "WheelFocus": 15
            }
        }
        Enum {
            name: "SortOrder"
            values: {
                "AscendingOrder": 0,
                "DescendingOrder": 1
            }
        }
        Enum {
            name: "Alignment"
            values: {
                "AlignLeft": 1,
                "AlignLeading": 1,
                "AlignRight": 2,
                "AlignTrailing": 2,
                "AlignHCenter": 4,
                "AlignJustify": 8,
                "AlignAbsolute": 16,
                "AlignHorizontal_Mask": 31,
                "AlignTop": 32,
                "AlignBottom": 64,
                "AlignVCenter": 128,
                "AlignBaseline": 256,
                "AlignVertical_Mask": 480,
                "AlignCenter": 132
            }
        }
        Enum {
            name: "TextElideMode"
            values: {
                "ElideLeft": 0,
                "ElideRight": 1,
                "ElideMiddle": 2,
                "ElideNone": 3
            }
        }
        Enum {
            name: "WindowType"
            values: {
                "Widget": 0,
                "Window": 1,
                "Dialog": 3,
                "Sheet": 5,
                "Drawer": 7,
                "Popup": 9,
                "Tool": 11,
                "ToolTip": 13,
                "SplashScreen": 15,
                "Desktop": 17,
                "SubWindow": 18,
                "ForeignWindow": 33,
                "CoverWindow": 65,
                "WindowType_Mask": 255,
                "MSWindowsFixedSizeDialogHint": 256,
                "MSWindowsOwnDC": 512,
                "BypassWindowManagerHint": 1024,
                "X11BypassWindowManagerHint": 1024,
                "FramelessWindowHint": 2048,
                "WindowTitleHint": 4096,
                "WindowSystemMenuHint": 8192,
                "WindowMinimizeButtonHint": 16384,
                "WindowMaximizeButtonHint": 32768,
                "WindowMinMaxButtonsHint": 49152,
                "WindowContextHelpButtonHint": 65536,
                "WindowShadeButtonHint": 131072,
                "WindowStaysOnTopHint": 262144,
                "WindowTransparentForInput": 524288,
                "WindowOverridesSystemGestures": 1048576,
                "WindowDoesNotAcceptFocus": 2097152,
                "CustomizeWindowHint": 33554432,
                "WindowStaysOnBottomHint": 67108864,
                "WindowCloseButtonHint": 134217728,
                "MacWindowToolBarButtonHint": 268435456,
                "BypassGraphicsProxyWidget": 536870912,
                "WindowOkButtonHint": 524288,
                "WindowCancelButtonHint": 1048576,
                "NoDropShadowWindowHint": 1073741824,
                "WindowFullscreenButtonHint": -2147483648
            }
        }
        Enum {
            name: "WindowFlags"
            values: {
                "Widget": 0,
                "Window": 1,
                "Dialog": 3,
                "Sheet": 5,
                "Drawer": 7,
                "Popup": 9,
                "Tool": 11,
                "ToolTip": 13,
                "SplashScreen": 15,
                "Desktop": 17,
                "SubWindow": 18,
                "ForeignWindow": 33,
                "CoverWindow": 65,
                "WindowType_Mask": 255,
                "MSWindowsFixedSizeDialogHint": 256,
                "MSWindowsOwnDC": 512,
                "BypassWindowManagerHint": 1024,
                "X11BypassWindowManagerHint": 1024,
                "FramelessWindowHint": 2048,
                "WindowTitleHint": 4096,
                "WindowSystemMenuHint": 8192,
                "WindowMinimizeButtonHint": 16384,
                "WindowMaximizeButtonHint": 32768,
                "WindowMinMaxButtonsHint": 49152,
                "WindowContextHelpButtonHint": 65536,
                "WindowShadeButtonHint": 131072,
                "WindowStaysOnTopHint": 262144,
                "WindowTransparentForInput": 524288,
                "WindowOverridesSystemGestures": 1048576,
                "WindowDoesNotAcceptFocus": 2097152,
                "CustomizeWindowHint": 33554432,
                "WindowStaysOnBottomHint": 67108864,
                "WindowCloseButtonHint": 134217728,
                "MacWindowToolBarButtonHint": 268435456,
                "BypassGraphicsProxyWidget": 536870912,
                "WindowOkButtonHint": 524288,
                "WindowCancelButtonHint": 1048576,
                "NoDropShadowWindowHint": 1073741824,
                "WindowFullscreenButtonHint": -2147483648
            }
        }
        Enum {
            name: "WindowState"
            values: {
                "WindowNoState": 0,
                "WindowMinimized": 1,
                "WindowMaximized": 2,
                "WindowFullScreen": 4,
                "WindowActive": 8
            }
        }
        Enum {
            name: "WindowStates"
            values: {
                "WindowNoState": 0,
                "WindowMinimized": 1,
                "WindowMaximized": 2,
                "WindowFullScreen": 4,
                "WindowActive": 8
            }
        }
        Enum {
            name: "ApplicationState"
            values: {
                "ApplicationSuspended": 0,
                "ApplicationHidden": 1,
                "ApplicationInactive": 2,
                "ApplicationActive": 4
            }
        }
        Enum {
            name: "ScreenOrientation"
            values: {
                "PrimaryOrientation": 0,
                "PortraitOrientation": 1,
                "LandscapeOrientation": 2,
                "InvertedPortraitOrientation": 4,
                "InvertedLandscapeOrientation": 8
            }
        }
        Enum {
            name: "ScreenOrientations"
            values: {
                "PrimaryOrientation": 0,
                "PortraitOrientation": 1,
                "LandscapeOrientation": 2,
                "InvertedPortraitOrientation": 4,
                "InvertedLandscapeOrientation": 8
            }
        }
        Enum {
            name: "WidgetAttribute"
            values: {
                "WA_Disabled": 0,
                "WA_UnderMouse": 1,
                "WA_MouseTracking": 2,
                "WA_ContentsPropagated": 3,
                "WA_OpaquePaintEvent": 4,
                "WA_NoBackground": 4,
                "WA_StaticContents": 5,
                "WA_LaidOut": 7,
                "WA_PaintOnScreen": 8,
                "WA_NoSystemBackground": 9,
                "WA_UpdatesDisabled": 10,
                "WA_Mapped": 11,
                "WA_MacNoClickThrough": 12,
                "WA_InputMethodEnabled": 14,
                "WA_WState_Visible": 15,
                "WA_WState_Hidden": 16,
                "WA_ForceDisabled": 32,
                "WA_KeyCompression": 33,
                "WA_PendingMoveEvent": 34,
                "WA_PendingResizeEvent": 35,
                "WA_SetPalette": 36,
                "WA_SetFont": 37,
                "WA_SetCursor": 38,
                "WA_NoChildEventsFromChildren": 39,
                "WA_WindowModified": 41,
                "WA_Resized": 42,
                "WA_Moved": 43,
                "WA_PendingUpdate": 44,
                "WA_InvalidSize": 45,
                "WA_MacBrushedMetal": 46,
                "WA_MacMetalStyle": 46,
                "WA_CustomWhatsThis": 47,
                "WA_LayoutOnEntireRect": 48,
                "WA_OutsideWSRange": 49,
                "WA_GrabbedShortcut": 50,
                "WA_TransparentForMouseEvents": 51,
                "WA_PaintUnclipped": 52,
                "WA_SetWindowIcon": 53,
                "WA_NoMouseReplay": 54,
                "WA_DeleteOnClose": 55,
                "WA_RightToLeft": 56,
                "WA_SetLayoutDirection": 57,
                "WA_NoChildEventsForParent": 58,
                "WA_ForceUpdatesDisabled": 59,
                "WA_WState_Created": 60,
                "WA_WState_CompressKeys": 61,
                "WA_WState_InPaintEvent": 62,
                "WA_WState_Reparented": 63,
                "WA_WState_ConfigPending": 64,
                "WA_WState_Polished": 66,
                "WA_WState_DND": 67,
                "WA_WState_OwnSizePolicy": 68,
                "WA_WState_ExplicitShowHide": 69,
                "WA_ShowModal": 70,
                "WA_MouseNoMask": 71,
                "WA_GroupLeader": 72,
                "WA_NoMousePropagation": 73,
                "WA_Hover": 74,
                "WA_InputMethodTransparent": 75,
                "WA_QuitOnClose": 76,
                "WA_KeyboardFocusChange": 77,
                "WA_AcceptDrops": 78,
                "WA_DropSiteRegistered": 79,
                "WA_ForceAcceptDrops": 79,
                "WA_WindowPropagation": 80,
                "WA_NoX11EventCompression": 81,
                "WA_TintedBackground": 82,
                "WA_X11OpenGLOverlay": 83,
                "WA_AlwaysShowToolTips": 84,
                "WA_MacOpaqueSizeGrip": 85,
                "WA_SetStyle": 86,
                "WA_SetLocale": 87,
                "WA_MacShowFocusRect": 88,
                "WA_MacNormalSize": 89,
                "WA_MacSmallSize": 90,
                "WA_MacMiniSize": 91,
                "WA_LayoutUsesWidgetRect": 92,
                "WA_StyledBackground": 93,
                "WA_MSWindowsUseDirect3D": 94,
                "WA_CanHostQMdiSubWindowTitleBar": 95,
                "WA_MacAlwaysShowToolWindow": 96,
                "WA_StyleSheet": 97,
                "WA_ShowWithoutActivating": 98,
                "WA_X11BypassTransientForHint": 99,
                "WA_NativeWindow": 100,
                "WA_DontCreateNativeAncestors": 101,
                "WA_MacVariableSize": 102,
                "WA_DontShowOnScreen": 103,
                "WA_X11NetWmWindowTypeDesktop": 104,
                "WA_X11NetWmWindowTypeDock": 105,
                "WA_X11NetWmWindowTypeToolBar": 106,
                "WA_X11NetWmWindowTypeMenu": 107,
                "WA_X11NetWmWindowTypeUtility": 108,
                "WA_X11NetWmWindowTypeSplash": 109,
                "WA_X11NetWmWindowTypeDialog": 110,
                "WA_X11NetWmWindowTypeDropDownMenu": 111,
                "WA_X11NetWmWindowTypePopupMenu": 112,
                "WA_X11NetWmWindowTypeToolTip": 113,
                "WA_X11NetWmWindowTypeNotification": 114,
                "WA_X11NetWmWindowTypeCombo": 115,
                "WA_X11NetWmWindowTypeDND": 116,
                "WA_MacFrameworkScaled": 117,
                "WA_SetWindowModality": 118,
                "WA_WState_WindowOpacitySet": 119,
                "WA_TranslucentBackground": 120,
                "WA_AcceptTouchEvents": 121,
                "WA_WState_AcceptedTouchBeginEvent": 122,
                "WA_TouchPadAcceptSingleTouchEvents": 123,
                "WA_X11DoNotAcceptFocus": 126,
                "WA_MacNoShadow": 127,
                "WA_AttributeCount": 128
            }
        }
        Enum {
            name: "ApplicationAttribute"
            values: {
                "AA_ImmediateWidgetCreation": 0,
                "AA_MSWindowsUseDirect3DByDefault": 1,
                "AA_DontShowIconsInMenus": 2,
                "AA_NativeWindows": 3,
                "AA_DontCreateNativeWidgetSiblings": 4,
                "AA_MacPluginApplication": 5,
                "AA_DontUseNativeMenuBar": 6,
                "AA_MacDontSwapCtrlAndMeta": 7,
                "AA_Use96Dpi": 8,
                "AA_X11InitThreads": 10,
                "AA_SynthesizeTouchForUnhandledMouseEvents": 11,
                "AA_SynthesizeMouseForUnhandledTouchEvents": 12,
                "AA_UseHighDpiPixmaps": 13,
                "AA_AttributeCount": 14
            }
        }
        Enum {
            name: "ImageConversionFlags"
            values: {
                "ColorMode_Mask": 3,
                "AutoColor": 0,
                "ColorOnly": 3,
                "MonoOnly": 2,
                "AlphaDither_Mask": 12,
                "ThresholdAlphaDither": 0,
                "OrderedAlphaDither": 4,
                "DiffuseAlphaDither": 8,
                "NoAlpha": 12,
                "Dither_Mask": 48,
                "DiffuseDither": 0,
                "OrderedDither": 16,
                "ThresholdDither": 32,
                "DitherMode_Mask": 192,
                "AutoDither": 0,
                "PreferDither": 64,
                "AvoidDither": 128,
                "NoOpaqueDetection": 256,
                "NoFormatConversion": 512
            }
        }
        Enum {
            name: "BGMode"
            values: {
                "TransparentMode": 0,
                "OpaqueMode": 1
            }
        }
        Enum {
            name: "Key"
            values: {
                "Key_Escape": 16777216,
                "Key_Tab": 16777217,
                "Key_Backtab": 16777218,
                "Key_Backspace": 16777219,
                "Key_Return": 16777220,
                "Key_Enter": 16777221,
                "Key_Insert": 16777222,
                "Key_Delete": 16777223,
                "Key_Pause": 16777224,
                "Key_Print": 16777225,
                "Key_SysReq": 16777226,
                "Key_Clear": 16777227,
                "Key_Home": 16777232,
                "Key_End": 16777233,
                "Key_Left": 16777234,
                "Key_Up": 16777235,
                "Key_Right": 16777236,
                "Key_Down": 16777237,
                "Key_PageUp": 16777238,
                "Key_PageDown": 16777239,
                "Key_Shift": 16777248,
                "Key_Control": 16777249,
                "Key_Meta": 16777250,
                "Key_Alt": 16777251,
                "Key_CapsLock": 16777252,
                "Key_NumLock": 16777253,
                "Key_ScrollLock": 16777254,
                "Key_F1": 16777264,
                "Key_F2": 16777265,
                "Key_F3": 16777266,
                "Key_F4": 16777267,
                "Key_F5": 16777268,
                "Key_F6": 16777269,
                "Key_F7": 16777270,
                "Key_F8": 16777271,
                "Key_F9": 16777272,
                "Key_F10": 16777273,
                "Key_F11": 16777274,
                "Key_F12": 16777275,
                "Key_F13": 16777276,
                "Key_F14": 16777277,
                "Key_F15": 16777278,
                "Key_F16": 16777279,
                "Key_F17": 16777280,
                "Key_F18": 16777281,
                "Key_F19": 16777282,
                "Key_F20": 16777283,
                "Key_F21": 16777284,
                "Key_F22": 16777285,
                "Key_F23": 16777286,
                "Key_F24": 16777287,
                "Key_F25": 16777288,
                "Key_F26": 16777289,
                "Key_F27": 16777290,
                "Key_F28": 16777291,
                "Key_F29": 16777292,
                "Key_F30": 16777293,
                "Key_F31": 16777294,
                "Key_F32": 16777295,
                "Key_F33": 16777296,
                "Key_F34": 16777297,
                "Key_F35": 16777298,
                "Key_Super_L": 16777299,
                "Key_Super_R": 16777300,
                "Key_Menu": 16777301,
                "Key_Hyper_L": 16777302,
                "Key_Hyper_R": 16777303,
                "Key_Help": 16777304,
                "Key_Direction_L": 16777305,
                "Key_Direction_R": 16777312,
                "Key_Space": 32,
                "Key_Any": 32,
                "Key_Exclam": 33,
                "Key_QuoteDbl": 34,
                "Key_NumberSign": 35,
                "Key_Dollar": 36,
                "Key_Percent": 37,
                "Key_Ampersand": 38,
                "Key_Apostrophe": 39,
                "Key_ParenLeft": 40,
                "Key_ParenRight": 41,
                "Key_Asterisk": 42,
                "Key_Plus": 43,
                "Key_Comma": 44,
                "Key_Minus": 45,
                "Key_Period": 46,
                "Key_Slash": 47,
                "Key_0": 48,
                "Key_1": 49,
                "Key_2": 50,
                "Key_3": 51,
                "Key_4": 52,
                "Key_5": 53,
                "Key_6": 54,
                "Key_7": 55,
                "Key_8": 56,
                "Key_9": 57,
                "Key_Colon": 58,
                "Key_Semicolon": 59,
                "Key_Less": 60,
                "Key_Equal": 61,
                "Key_Greater": 62,
                "Key_Question": 63,
                "Key_At": 64,
                "Key_A": 65,
                "Key_B": 66,
                "Key_C": 67,
                "Key_D": 68,
                "Key_E": 69,
                "Key_F": 70,
                "Key_G": 71,
                "Key_H": 72,
                "Key_I": 73,
                "Key_J": 74,
                "Key_K": 75,
                "Key_L": 76,
                "Key_M": 77,
                "Key_N": 78,
                "Key_O": 79,
                "Key_P": 80,
                "Key_Q": 81,
                "Key_R": 82,
                "Key_S": 83,
                "Key_T": 84,
                "Key_U": 85,
                "Key_V": 86,
                "Key_W": 87,
                "Key_X": 88,
                "Key_Y": 89,
                "Key_Z": 90,
                "Key_BracketLeft": 91,
                "Key_Backslash": 92,
                "Key_BracketRight": 93,
                "Key_AsciiCircum": 94,
                "Key_Underscore": 95,
                "Key_QuoteLeft": 96,
                "Key_BraceLeft": 123,
                "Key_Bar": 124,
                "Key_BraceRight": 125,
                "Key_AsciiTilde": 126,
                "Key_nobreakspace": 160,
                "Key_exclamdown": 161,
                "Key_cent": 162,
                "Key_sterling": 163,
                "Key_currency": 164,
                "Key_yen": 165,
                "Key_brokenbar": 166,
                "Key_section": 167,
                "Key_diaeresis": 168,
                "Key_copyright": 169,
                "Key_ordfeminine": 170,
                "Key_guillemotleft": 171,
                "Key_notsign": 172,
                "Key_hyphen": 173,
                "Key_registered": 174,
                "Key_macron": 175,
                "Key_degree": 176,
                "Key_plusminus": 177,
                "Key_twosuperior": 178,
                "Key_threesuperior": 179,
                "Key_acute": 180,
                "Key_mu": 181,
                "Key_paragraph": 182,
                "Key_periodcentered": 183,
                "Key_cedilla": 184,
                "Key_onesuperior": 185,
                "Key_masculine": 186,
                "Key_guillemotright": 187,
                "Key_onequarter": 188,
                "Key_onehalf": 189,
                "Key_threequarters": 190,
                "Key_questiondown": 191,
                "Key_Agrave": 192,
                "Key_Aacute": 193,
                "Key_Acircumflex": 194,
                "Key_Atilde": 195,
                "Key_Adiaeresis": 196,
                "Key_Aring": 197,
                "Key_AE": 198,
                "Key_Ccedilla": 199,
                "Key_Egrave": 200,
                "Key_Eacute": 201,
                "Key_Ecircumflex": 202,
                "Key_Ediaeresis": 203,
                "Key_Igrave": 204,
                "Key_Iacute": 205,
                "Key_Icircumflex": 206,
                "Key_Idiaeresis": 207,
                "Key_ETH": 208,
                "Key_Ntilde": 209,
                "Key_Ograve": 210,
                "Key_Oacute": 211,
                "Key_Ocircumflex": 212,
                "Key_Otilde": 213,
                "Key_Odiaeresis": 214,
                "Key_multiply": 215,
                "Key_Ooblique": 216,
                "Key_Ugrave": 217,
                "Key_Uacute": 218,
                "Key_Ucircumflex": 219,
                "Key_Udiaeresis": 220,
                "Key_Yacute": 221,
                "Key_THORN": 222,
                "Key_ssharp": 223,
                "Key_division": 247,
                "Key_ydiaeresis": 255,
                "Key_AltGr": 16781571,
                "Key_Multi_key": 16781600,
                "Key_Codeinput": 16781623,
                "Key_SingleCandidate": 16781628,
                "Key_MultipleCandidate": 16781629,
                "Key_PreviousCandidate": 16781630,
                "Key_Mode_switch": 16781694,
                "Key_Kanji": 16781601,
                "Key_Muhenkan": 16781602,
                "Key_Henkan": 16781603,
                "Key_Romaji": 16781604,
                "Key_Hiragana": 16781605,
                "Key_Katakana": 16781606,
                "Key_Hiragana_Katakana": 16781607,
                "Key_Zenkaku": 16781608,
                "Key_Hankaku": 16781609,
                "Key_Zenkaku_Hankaku": 16781610,
                "Key_Touroku": 16781611,
                "Key_Massyo": 16781612,
                "Key_Kana_Lock": 16781613,
                "Key_Kana_Shift": 16781614,
                "Key_Eisu_Shift": 16781615,
                "Key_Eisu_toggle": 16781616,
                "Key_Hangul": 16781617,
                "Key_Hangul_Start": 16781618,
                "Key_Hangul_End": 16781619,
                "Key_Hangul_Hanja": 16781620,
                "Key_Hangul_Jamo": 16781621,
                "Key_Hangul_Romaja": 16781622,
                "Key_Hangul_Jeonja": 16781624,
                "Key_Hangul_Banja": 16781625,
                "Key_Hangul_PreHanja": 16781626,
                "Key_Hangul_PostHanja": 16781627,
                "Key_Hangul_Special": 16781631,
                "Key_Dead_Grave": 16781904,
                "Key_Dead_Acute": 16781905,
                "Key_Dead_Circumflex": 16781906,
                "Key_Dead_Tilde": 16781907,
                "Key_Dead_Macron": 16781908,
                "Key_Dead_Breve": 16781909,
                "Key_Dead_Abovedot": 16781910,
                "Key_Dead_Diaeresis": 16781911,
                "Key_Dead_Abovering": 16781912,
                "Key_Dead_Doubleacute": 16781913,
                "Key_Dead_Caron": 16781914,
                "Key_Dead_Cedilla": 16781915,
                "Key_Dead_Ogonek": 16781916,
                "Key_Dead_Iota": 16781917,
                "Key_Dead_Voiced_Sound": 16781918,
                "Key_Dead_Semivoiced_Sound": 16781919,
                "Key_Dead_Belowdot": 16781920,
                "Key_Dead_Hook": 16781921,
                "Key_Dead_Horn": 16781922,
                "Key_Back": 16777313,
                "Key_Forward": 16777314,
                "Key_Stop": 16777315,
                "Key_Refresh": 16777316,
                "Key_VolumeDown": 16777328,
                "Key_VolumeMute": 16777329,
                "Key_VolumeUp": 16777330,
                "Key_BassBoost": 16777331,
                "Key_BassUp": 16777332,
                "Key_BassDown": 16777333,
                "Key_TrebleUp": 16777334,
                "Key_TrebleDown": 16777335,
                "Key_MediaPlay": 16777344,
                "Key_MediaStop": 16777345,
                "Key_MediaPrevious": 16777346,
                "Key_MediaNext": 16777347,
                "Key_MediaRecord": 16777348,
                "Key_MediaPause": 16777349,
                "Key_MediaTogglePlayPause": 16777350,
                "Key_HomePage": 16777360,
                "Key_Favorites": 16777361,
                "Key_Search": 16777362,
                "Key_Standby": 16777363,
                "Key_OpenUrl": 16777364,
                "Key_LaunchMail": 16777376,
                "Key_LaunchMedia": 16777377,
                "Key_Launch0": 16777378,
                "Key_Launch1": 16777379,
                "Key_Launch2": 16777380,
                "Key_Launch3": 16777381,
                "Key_Launch4": 16777382,
                "Key_Launch5": 16777383,
                "Key_Launch6": 16777384,
                "Key_Launch7": 16777385,
                "Key_Launch8": 16777386,
                "Key_Launch9": 16777387,
                "Key_LaunchA": 16777388,
                "Key_LaunchB": 16777389,
                "Key_LaunchC": 16777390,
                "Key_LaunchD": 16777391,
                "Key_LaunchE": 16777392,
                "Key_LaunchF": 16777393,
                "Key_MonBrightnessUp": 16777394,
                "Key_MonBrightnessDown": 16777395,
                "Key_KeyboardLightOnOff": 16777396,
                "Key_KeyboardBrightnessUp": 16777397,
                "Key_KeyboardBrightnessDown": 16777398,
                "Key_PowerOff": 16777399,
                "Key_WakeUp": 16777400,
                "Key_Eject": 16777401,
                "Key_ScreenSaver": 16777402,
                "Key_WWW": 16777403,
                "Key_Memo": 16777404,
                "Key_LightBulb": 16777405,
                "Key_Shop": 16777406,
                "Key_History": 16777407,
                "Key_AddFavorite": 16777408,
                "Key_HotLinks": 16777409,
                "Key_BrightnessAdjust": 16777410,
                "Key_Finance": 16777411,
                "Key_Community": 16777412,
                "Key_AudioRewind": 16777413,
                "Key_BackForward": 16777414,
                "Key_ApplicationLeft": 16777415,
                "Key_ApplicationRight": 16777416,
                "Key_Book": 16777417,
                "Key_CD": 16777418,
                "Key_Calculator": 16777419,
                "Key_ToDoList": 16777420,
                "Key_ClearGrab": 16777421,
                "Key_Close": 16777422,
                "Key_Copy": 16777423,
                "Key_Cut": 16777424,
                "Key_Display": 16777425,
                "Key_DOS": 16777426,
                "Key_Documents": 16777427,
                "Key_Excel": 16777428,
                "Key_Explorer": 16777429,
                "Key_Game": 16777430,
                "Key_Go": 16777431,
                "Key_iTouch": 16777432,
                "Key_LogOff": 16777433,
                "Key_Market": 16777434,
                "Key_Meeting": 16777435,
                "Key_MenuKB": 16777436,
                "Key_MenuPB": 16777437,
                "Key_MySites": 16777438,
                "Key_News": 16777439,
                "Key_OfficeHome": 16777440,
                "Key_Option": 16777441,
                "Key_Paste": 16777442,
                "Key_Phone": 16777443,
                "Key_Calendar": 16777444,
                "Key_Reply": 16777445,
                "Key_Reload": 16777446,
                "Key_RotateWindows": 16777447,
                "Key_RotationPB": 16777448,
                "Key_RotationKB": 16777449,
                "Key_Save": 16777450,
                "Key_Send": 16777451,
                "Key_Spell": 16777452,
                "Key_SplitScreen": 16777453,
                "Key_Support": 16777454,
                "Key_TaskPane": 16777455,
                "Key_Terminal": 16777456,
                "Key_Tools": 16777457,
                "Key_Travel": 16777458,
                "Key_Video": 16777459,
                "Key_Word": 16777460,
                "Key_Xfer": 16777461,
                "Key_ZoomIn": 16777462,
                "Key_ZoomOut": 16777463,
                "Key_Away": 16777464,
                "Key_Messenger": 16777465,
                "Key_WebCam": 16777466,
                "Key_MailForward": 16777467,
                "Key_Pictures": 16777468,
                "Key_Music": 16777469,
                "Key_Battery": 16777470,
                "Key_Bluetooth": 16777471,
                "Key_WLAN": 16777472,
                "Key_UWB": 16777473,
                "Key_AudioForward": 16777474,
                "Key_AudioRepeat": 16777475,
                "Key_AudioRandomPlay": 16777476,
                "Key_Subtitle": 16777477,
                "Key_AudioCycleTrack": 16777478,
                "Key_Time": 16777479,
                "Key_Hibernate": 16777480,
                "Key_View": 16777481,
                "Key_TopMenu": 16777482,
                "Key_PowerDown": 16777483,
                "Key_Suspend": 16777484,
                "Key_ContrastAdjust": 16777485,
                "Key_LaunchG": 16777486,
                "Key_LaunchH": 16777487,
                "Key_TouchpadToggle": 16777488,
                "Key_TouchpadOn": 16777489,
                "Key_TouchpadOff": 16777490,
                "Key_MicMute": 16777491,
                "Key_Red": 16777492,
                "Key_Green": 16777493,
                "Key_Yellow": 16777494,
                "Key_Blue": 16777495,
                "Key_ChannelUp": 16777496,
                "Key_ChannelDown": 16777497,
                "Key_MediaLast": 16842751,
                "Key_Select": 16842752,
                "Key_Yes": 16842753,
                "Key_No": 16842754,
                "Key_Cancel": 16908289,
                "Key_Printer": 16908290,
                "Key_Execute": 16908291,
                "Key_Sleep": 16908292,
                "Key_Play": 16908293,
                "Key_Zoom": 16908294,
                "Key_Context1": 17825792,
                "Key_Context2": 17825793,
                "Key_Context3": 17825794,
                "Key_Context4": 17825795,
                "Key_Call": 17825796,
                "Key_Hangup": 17825797,
                "Key_Flip": 17825798,
                "Key_ToggleCallHangup": 17825799,
                "Key_VoiceDial": 17825800,
                "Key_LastNumberRedial": 17825801,
                "Key_Camera": 17825824,
                "Key_CameraFocus": 17825825,
                "Key_unknown": 33554431
            }
        }
        Enum {
            name: "ArrowType"
            values: {
                "NoArrow": 0,
                "UpArrow": 1,
                "DownArrow": 2,
                "LeftArrow": 3,
                "RightArrow": 4
            }
        }
        Enum {
            name: "PenStyle"
            values: {
                "NoPen": 0,
                "SolidLine": 1,
                "DashLine": 2,
                "DotLine": 3,
                "DashDotLine": 4,
                "DashDotDotLine": 5,
                "CustomDashLine": 6
            }
        }
        Enum {
            name: "PenCapStyle"
            values: {
                "FlatCap": 0,
                "SquareCap": 16,
                "RoundCap": 32,
                "MPenCapStyle": 48
            }
        }
        Enum {
            name: "PenJoinStyle"
            values: {
                "MiterJoin": 0,
                "BevelJoin": 64,
                "RoundJoin": 128,
                "SvgMiterJoin": 256,
                "MPenJoinStyle": 448
            }
        }
        Enum {
            name: "BrushStyle"
            values: {
                "NoBrush": 0,
                "SolidPattern": 1,
                "Dense1Pattern": 2,
                "Dense2Pattern": 3,
                "Dense3Pattern": 4,
                "Dense4Pattern": 5,
                "Dense5Pattern": 6,
                "Dense6Pattern": 7,
                "Dense7Pattern": 8,
                "HorPattern": 9,
                "VerPattern": 10,
                "CrossPattern": 11,
                "BDiagPattern": 12,
                "FDiagPattern": 13,
                "DiagCrossPattern": 14,
                "LinearGradientPattern": 15,
                "RadialGradientPattern": 16,
                "ConicalGradientPattern": 17,
                "TexturePattern": 24
            }
        }
        Enum {
            name: "SizeMode"
            values: {
                "AbsoluteSize": 0,
                "RelativeSize": 1
            }
        }
        Enum {
            name: "CursorShape"
            values: {
                "ArrowCursor": 0,
                "UpArrowCursor": 1,
                "CrossCursor": 2,
                "WaitCursor": 3,
                "IBeamCursor": 4,
                "SizeVerCursor": 5,
                "SizeHorCursor": 6,
                "SizeBDiagCursor": 7,
                "SizeFDiagCursor": 8,
                "SizeAllCursor": 9,
                "BlankCursor": 10,
                "SplitVCursor": 11,
                "SplitHCursor": 12,
                "PointingHandCursor": 13,
                "ForbiddenCursor": 14,
                "WhatsThisCursor": 15,
                "BusyCursor": 16,
                "OpenHandCursor": 17,
                "ClosedHandCursor": 18,
                "DragCopyCursor": 19,
                "DragMoveCursor": 20,
                "DragLinkCursor": 21,
                "LastCursor": 21,
                "BitmapCursor": 24,
                "CustomCursor": 25
            }
        }
        Enum {
            name: "TextFormat"
            values: {
                "PlainText": 0,
                "RichText": 1,
                "AutoText": 2
            }
        }
        Enum {
            name: "AspectRatioMode"
            values: {
                "IgnoreAspectRatio": 0,
                "KeepAspectRatio": 1,
                "KeepAspectRatioByExpanding": 2
            }
        }
        Enum {
            name: "DockWidgetArea"
            values: {
                "LeftDockWidgetArea": 1,
                "RightDockWidgetArea": 2,
                "TopDockWidgetArea": 4,
                "BottomDockWidgetArea": 8,
                "DockWidgetArea_Mask": 15,
                "AllDockWidgetAreas": 15,
                "NoDockWidgetArea": 0
            }
        }
        Enum {
            name: "DockWidgetAreas"
            values: {
                "LeftDockWidgetArea": 1,
                "RightDockWidgetArea": 2,
                "TopDockWidgetArea": 4,
                "BottomDockWidgetArea": 8,
                "DockWidgetArea_Mask": 15,
                "AllDockWidgetAreas": 15,
                "NoDockWidgetArea": 0
            }
        }
        Enum {
            name: "ToolBarArea"
            values: {
                "LeftToolBarArea": 1,
                "RightToolBarArea": 2,
                "TopToolBarArea": 4,
                "BottomToolBarArea": 8,
                "ToolBarArea_Mask": 15,
                "AllToolBarAreas": 15,
                "NoToolBarArea": 0
            }
        }
        Enum {
            name: "ToolBarAreas"
            values: {
                "LeftToolBarArea": 1,
                "RightToolBarArea": 2,
                "TopToolBarArea": 4,
                "BottomToolBarArea": 8,
                "ToolBarArea_Mask": 15,
                "AllToolBarAreas": 15,
                "NoToolBarArea": 0
            }
        }
        Enum {
            name: "DateFormat"
            values: {
                "TextDate": 0,
                "ISODate": 1,
                "SystemLocaleDate": 2,
                "LocalDate": 2,
                "LocaleDate": 3,
                "SystemLocaleShortDate": 4,
                "SystemLocaleLongDate": 5,
                "DefaultLocaleShortDate": 6,
                "DefaultLocaleLongDate": 7,
                "RFC2822Date": 8
            }
        }
        Enum {
            name: "TimeSpec"
            values: {
                "LocalTime": 0,
                "UTC": 1,
                "OffsetFromUTC": 2,
                "TimeZone": 3
            }
        }
        Enum {
            name: "DayOfWeek"
            values: {
                "Monday": 1,
                "Tuesday": 2,
                "Wednesday": 3,
                "Thursday": 4,
                "Friday": 5,
                "Saturday": 6,
                "Sunday": 7
            }
        }
        Enum {
            name: "ScrollBarPolicy"
            values: {
                "ScrollBarAsNeeded": 0,
                "ScrollBarAlwaysOff": 1,
                "ScrollBarAlwaysOn": 2
            }
        }
        Enum {
            name: "CaseSensitivity"
            values: {
                "CaseInsensitive": 0,
                "CaseSensitive": 1
            }
        }
        Enum {
            name: "Corner"
            values: {
                "TopLeftCorner": 0,
                "TopRightCorner": 1,
                "BottomLeftCorner": 2,
                "BottomRightCorner": 3
            }
        }
        Enum {
            name: "Edge"
            values: {
                "TopEdge": 1,
                "LeftEdge": 2,
                "RightEdge": 4,
                "BottomEdge": 8
            }
        }
        Enum {
            name: "ConnectionType"
            values: {
                "AutoConnection": 0,
                "DirectConnection": 1,
                "QueuedConnection": 2,
                "BlockingQueuedConnection": 3,
                "UniqueConnection": 128
            }
        }
        Enum {
            name: "ShortcutContext"
            values: {
                "WidgetShortcut": 0,
                "WindowShortcut": 1,
                "ApplicationShortcut": 2,
                "WidgetWithChildrenShortcut": 3
            }
        }
        Enum {
            name: "FillRule"
            values: {
                "OddEvenFill": 0,
                "WindingFill": 1
            }
        }
        Enum {
            name: "MaskMode"
            values: {
                "MaskInColor": 0,
                "MaskOutColor": 1
            }
        }
        Enum {
            name: "ClipOperation"
            values: {
                "NoClip": 0,
                "ReplaceClip": 1,
                "IntersectClip": 2
            }
        }
        Enum {
            name: "ItemSelectionMode"
            values: {
                "ContainsItemShape": 0,
                "IntersectsItemShape": 1,
                "ContainsItemBoundingRect": 2,
                "IntersectsItemBoundingRect": 3
            }
        }
        Enum {
            name: "TransformationMode"
            values: {
                "FastTransformation": 0,
                "SmoothTransformation": 1
            }
        }
        Enum {
            name: "Axis"
            values: {
                "XAxis": 0,
                "YAxis": 1,
                "ZAxis": 2
            }
        }
        Enum {
            name: "ContextMenuPolicy"
            values: {
                "NoContextMenu": 0,
                "DefaultContextMenu": 1,
                "ActionsContextMenu": 2,
                "CustomContextMenu": 3,
                "PreventContextMenu": 4
            }
        }
        Enum {
            name: "InputMethodQuery"
            values: {
                "ImEnabled": 1,
                "ImCursorRectangle": 2,
                "ImMicroFocus": 2,
                "ImFont": 4,
                "ImCursorPosition": 8,
                "ImSurroundingText": 16,
                "ImCurrentSelection": 32,
                "ImMaximumTextLength": 64,
                "ImAnchorPosition": 128,
                "ImHints": 256,
                "ImPreferredLanguage": 512,
                "ImPlatformData": -2147483648,
                "ImQueryInput": 186,
                "ImQueryAll": -1
            }
        }
        Enum {
            name: "InputMethodQueries"
            values: {
                "ImEnabled": 1,
                "ImCursorRectangle": 2,
                "ImMicroFocus": 2,
                "ImFont": 4,
                "ImCursorPosition": 8,
                "ImSurroundingText": 16,
                "ImCurrentSelection": 32,
                "ImMaximumTextLength": 64,
                "ImAnchorPosition": 128,
                "ImHints": 256,
                "ImPreferredLanguage": 512,
                "ImPlatformData": -2147483648,
                "ImQueryInput": 186,
                "ImQueryAll": -1
            }
        }
        Enum {
            name: "InputMethodHint"
            values: {
                "ImhNone": 0,
                "ImhHiddenText": 1,
                "ImhSensitiveData": 2,
                "ImhNoAutoUppercase": 4,
                "ImhPreferNumbers": 8,
                "ImhPreferUppercase": 16,
                "ImhPreferLowercase": 32,
                "ImhNoPredictiveText": 64,
                "ImhDate": 128,
                "ImhTime": 256,
                "ImhPreferLatin": 512,
                "ImhMultiLine": 1024,
                "ImhDigitsOnly": 65536,
                "ImhFormattedNumbersOnly": 131072,
                "ImhUppercaseOnly": 262144,
                "ImhLowercaseOnly": 524288,
                "ImhDialableCharactersOnly": 1048576,
                "ImhEmailCharactersOnly": 2097152,
                "ImhUrlCharactersOnly": 4194304,
                "ImhLatinOnly": 8388608,
                "ImhExclusiveInputMask": -65536
            }
        }
        Enum {
            name: "InputMethodHints"
            values: {
                "ImhNone": 0,
                "ImhHiddenText": 1,
                "ImhSensitiveData": 2,
                "ImhNoAutoUppercase": 4,
                "ImhPreferNumbers": 8,
                "ImhPreferUppercase": 16,
                "ImhPreferLowercase": 32,
                "ImhNoPredictiveText": 64,
                "ImhDate": 128,
                "ImhTime": 256,
                "ImhPreferLatin": 512,
                "ImhMultiLine": 1024,
                "ImhDigitsOnly": 65536,
                "ImhFormattedNumbersOnly": 131072,
                "ImhUppercaseOnly": 262144,
                "ImhLowercaseOnly": 524288,
                "ImhDialableCharactersOnly": 1048576,
                "ImhEmailCharactersOnly": 2097152,
                "ImhUrlCharactersOnly": 4194304,
                "ImhLatinOnly": 8388608,
                "ImhExclusiveInputMask": -65536
            }
        }
        Enum {
            name: "ToolButtonStyle"
            values: {
                "ToolButtonIconOnly": 0,
                "ToolButtonTextOnly": 1,
                "ToolButtonTextBesideIcon": 2,
                "ToolButtonTextUnderIcon": 3,
                "ToolButtonFollowStyle": 4
            }
        }
        Enum {
            name: "LayoutDirection"
            values: {
                "LeftToRight": 0,
                "RightToLeft": 1,
                "LayoutDirectionAuto": 2
            }
        }
        Enum {
            name: "DropAction"
            values: {
                "CopyAction": 1,
                "MoveAction": 2,
                "LinkAction": 4,
                "ActionMask": 255,
                "TargetMoveAction": 32770,
                "IgnoreAction": 0
            }
        }
        Enum {
            name: "DropActions"
            values: {
                "CopyAction": 1,
                "MoveAction": 2,
                "LinkAction": 4,
                "ActionMask": 255,
                "TargetMoveAction": 32770,
                "IgnoreAction": 0
            }
        }
        Enum {
            name: "CheckState"
            values: {
                "Unchecked": 0,
                "PartiallyChecked": 1,
                "Checked": 2
            }
        }
        Enum {
            name: "ItemFlags"
            values: {
                "NoItemFlags": 0,
                "ItemIsSelectable": 1,
                "ItemIsEditable": 2,
                "ItemIsDragEnabled": 4,
                "ItemIsDropEnabled": 8,
                "ItemIsUserCheckable": 16,
                "ItemIsEnabled": 32,
                "ItemIsTristate": 64,
                "ItemNeverHasChildren": 128
            }
        }
        Enum {
            name: "MatchFlags"
            values: {
                "MatchExactly": 0,
                "MatchContains": 1,
                "MatchStartsWith": 2,
                "MatchEndsWith": 3,
                "MatchRegExp": 4,
                "MatchWildcard": 5,
                "MatchFixedString": 8,
                "MatchCaseSensitive": 16,
                "MatchWrap": 32,
                "MatchRecursive": 64
            }
        }
        Enum {
            name: "WindowModality"
            values: {
                "NonModal": 0,
                "WindowModal": 1,
                "ApplicationModal": 2
            }
        }
        Enum {
            name: "TextInteractionFlag"
            values: {
                "NoTextInteraction": 0,
                "TextSelectableByMouse": 1,
                "TextSelectableByKeyboard": 2,
                "LinksAccessibleByMouse": 4,
                "LinksAccessibleByKeyboard": 8,
                "TextEditable": 16,
                "TextEditorInteraction": 19,
                "TextBrowserInteraction": 13
            }
        }
        Enum {
            name: "TextInteractionFlags"
            values: {
                "NoTextInteraction": 0,
                "TextSelectableByMouse": 1,
                "TextSelectableByKeyboard": 2,
                "LinksAccessibleByMouse": 4,
                "LinksAccessibleByKeyboard": 8,
                "TextEditable": 16,
                "TextEditorInteraction": 19,
                "TextBrowserInteraction": 13
            }
        }
        Enum {
            name: "SizeHint"
            values: {
                "MinimumSize": 0,
                "PreferredSize": 1,
                "MaximumSize": 2,
                "MinimumDescent": 3,
                "NSizeHints": 4
            }
        }
        Enum {
            name: "GestureState"
            values: {
                "NoGesture": 0,
                "GestureStarted": 1,
                "GestureUpdated": 2,
                "GestureFinished": 3,
                "GestureCanceled": 4
            }
        }
        Enum {
            name: "GestureType"
            values: {
                "TapGesture": 1,
                "TapAndHoldGesture": 2,
                "PanGesture": 3,
                "PinchGesture": 4,
                "SwipeGesture": 5,
                "CustomGesture": 256,
                "LastGestureType": -1
            }
        }
        Enum {
            name: "CursorMoveStyle"
            values: {
                "LogicalMoveStyle": 0,
                "VisualMoveStyle": 1
            }
        }
        Enum {
            name: "TimerType"
            values: {
                "PreciseTimer": 0,
                "CoarseTimer": 1,
                "VeryCoarseTimer": 2
            }
        }
        Enum {
            name: "ScrollPhase"
            values: {
                "ScrollBegin": 1,
                "ScrollUpdate": 2,
                "ScrollEnd": 3
            }
        }
        Method {
            name: "atob"
            type: "string"
            Parameter  { name: "data"; type: "string" }
        }
        Method {
            name: "binding"
            type: "QQmlScriptString"
            Parameter { name: "binding"; type: "QQmlScriptString" }
        }
        Method {
            name: "btoa"
            type: "string"
            Parameter  { name: "data"; type: "string" }
        }
        Method {
            name: "colorEqual"
            type: "color"
            Parameter { name: "lhs"; type: "color" }
            Parameter { name: "rhs"; type: "color" }
        }
        Method {
            name: "createComponent"
            type: "Component"
            Parameter { name: "url"; type: "string" }
        }
        Method {
            name: "createQmlObject"
            type: "Component"
            Parameter { name: "qml"; type: "string" }
            Parameter { name: "parent"; type: "QObject" }
            Parameter { name: "filePath"; type: "string" }
        }
        Method {
            name: "darker"
            type: "color"
            Parameter { name: "baseColor"; type: "color" }
            Parameter { name: "factor"; type: "real" }
        }
        Method {
            name: "font"
            type: "Font"
            Parameter { name: "fontSpecified"; type: "QObject" }
        }
        Method {
            name: "fontFamilies"
            type: "variant"
        }
        Method {
            name: "formatDate"
            type: "string"
            Parameter { name: "date"; type: "date" }
            Parameter { name: "format"; type: "variant" }
        }
        Method {
            name: "formatDateTime"
            type: "string"
            Parameter { name: "datetime"; type: "date" }
            Parameter { name: "format"; type: "variant" }
        }
        Method {
            name: "formatTime"
            type: "string"
            Parameter { name: "time"; type: "time" }
            Parameter { name: "format"; type: "variant" }
        }
        Method {
            name: "hsla"
            type: "color"
            Parameter { name: "hue"; type: "real" }
            Parameter { name: "saturation"; type: "real" }
            Parameter { name: "lightness"; type: "real" }
            Parameter { name: "alpha"; type: "real" }
        }
        Method {
            name: "include"
            type: "Component"
            Parameter { name: "url"; type: "string" }
            Parameter { name: "callback"; type: "ScriptAction" }
        }
        Method {
            name: "isQtObject"
            type: "bool"
            Parameter { name: "object"; type: "variant" }
        }
        Method {
            name: "lighter"
            type: "color"
            Parameter { name: "baseColor"; type: "color" }
            Parameter { name: "factor"; type: "real" }
        }
        Method {
            name: "locale"
            type: "Locale"
            Parameter { name: "name"; type: "string" }
        }
        Method {
            name: "md5"
            type: "string"
            Parameter { name: "data"; type: "variant" }
        }
        Method {
            name: "matrix4x4"
            type: "QObject"
            Parameter { name: "m11"; type: "real" }
            Parameter { name: "m12"; type: "real" }
            Parameter { name: "m13"; type: "real" }
            Parameter { name: "m14"; type: "real" }
            Parameter { name: "m21"; type: "real" }
            Parameter { name: "m22"; type: "real" }
            Parameter { name: "m23"; type: "real" }
            Parameter { name: "m24"; type: "real" }
            Parameter { name: "m31"; type: "real" }
            Parameter { name: "m32"; type: "real" }
            Parameter { name: "m33"; type: "real" }
            Parameter { name: "m34"; type: "real" }
            Parameter { name: "m41"; type: "real" }
            Parameter { name: "m42"; type: "real" }
            Parameter { name: "m43"; type: "real" }
            Parameter { name: "m44"; type: "real" }
        }
        Method {
            name: "openUrlExternally"
            type: "bool"
            Parameter { name: "target"; type: "url" }
        }
        Method {
            name: "point"
            type: "builtins1.0::point"
            Parameter { name: "x"; type: "int" }
            Parameter { name: "y"; type: "int" }
        }
        Method {
            name: "qsTr"
            type: "string"
            Parameter { name: "sourceText"; type: "string" }
            Parameter { name: "disambiguation"; type: "string" }
            Parameter { name: "n"; type: "int" }
        }
        Method {
            name: "qsTrId"
            type: "string"
            Parameter { name: "id"; type: "string" }
            Parameter { name: "n"; type: "int" }
        }
        Method {
            name: "qsTrIdNoOp"
            type: "string"
            Parameter { name: "id"; type: "string" }
        }
        Method {
            name: "qsTrNoOp"
            type: "string"
            Parameter { name: "sourceText"; type: "string" }
            Parameter { name: "disambiguation"; type: "string" }
        }
        Method {
            name: "qsTranslate"
            type: "string"
            Parameter { name: "context"; type: "string" }
            Parameter { name: "sourceText"; type: "string" }
            Parameter { name: "disambiguation"; type: "string" }
            Parameter { name: "n"; type: "int" }
        }
        Method {
            name: "qsTranslateNoOp"
            type: "string"
            Parameter { name: "context"; type: "string" }
            Parameter { name: "sourceText"; type: "string" }
            Parameter { name: "disambiguation"; type: "string" }
        }
        Method {
            name: "quaternion"
            type: "builtins1.0::quaternion"
            Parameter { name: "scalar"; type: "real" }
            Parameter { name: "x"; type: "real" }
            Parameter { name: "y"; type: "real" }
            Parameter { name: "z"; type: "real" }
        }
        Method {
            name: "quit"
            type: "void"
        }
        Method {
            name: "rect"
            type: "builtins1.0::rect"
            Parameter { name: "x"; type: "int" }
            Parameter { name: "y"; type: "int" }
            Parameter { name: "width"; type: "int" }
            Parameter { name: "height"; type: "int" }
        }
        Method {
            name: "resolvedUrl"
            type: "url"
            Parameter { name: "url"; type: "url" }
        }
        Method {
            name: "rgba"
            type: "color"
            Parameter { name: "red"; type: "real" }
            Parameter { name: "green"; type: "real" }
            Parameter { name: "blue"; type: "real" }
            Parameter { name: "alpha"; type: "real" }
        }
        Method {
            name: "size"
            type: "builtins1.0::size"
            Parameter { name: "width"; type: "int" }
            Parameter { name: "height"; type: "int" }
        }
        Method {
            name: "tint"
            type: "color"
            Parameter { name: "baseColor"; type: "color" }
            Parameter { name: "tintColor"; type: "color" }
        }
        Method {
            name: "vector2d"
            type: "builtins1.0::vector2d"
            Parameter { name: "x"; type: "int" }
            Parameter { name: "y"; type: "int" }
        }
        Method {
            name: "vector3d"
            type: "builtins1.0::vector3d"
            Parameter { name: "x"; type: "int" }
            Parameter { name: "y"; type: "int" }
            Parameter { name: "z"; type: "int" }
        }
        Method {
            name: "vector4d"
            type: "builtins1.0::vector3d"
            Parameter { name: "x"; type: "int" }
            Parameter { name: "y"; type: "int" }
            Parameter { name: "z"; type: "int" }
            Parameter { name: "w"; type: "int" }
        }
    }
    Component { name: "QEasingCurve"; prototype: "QQmlEasingValueType" }
}
