/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.percolator.PercolatorIndex;

class MultiDocumentPercolatorIndex
implements PercolatorIndex {
    private final CloseableThreadLocal<MemoryIndex> cache;

    MultiDocumentPercolatorIndex(CloseableThreadLocal<MemoryIndex> cache) {
        this.cache = cache;
    }

    @Override
    public void prepare(PercolateContext context, ParsedDocument parsedDocument) {
        IndexReader[] memoryIndices = new IndexReader[parsedDocument.docs().size()];
        List<ParseContext.Document> docs = parsedDocument.docs();
        int rootDocIndex = docs.size() - 1;
        assert (rootDocIndex > 0);
        MemoryIndex rootDocMemoryIndex = null;
        for (int i = 0; i < docs.size(); ++i) {
            ParseContext.Document d = docs.get(i);
            MemoryIndex memoryIndex = rootDocIndex == i ? (rootDocMemoryIndex = (MemoryIndex)this.cache.get()) : new MemoryIndex(true);
            Analyzer analyzer = context.mapperService().documentMapper(parsedDocument.type()).mappers().indexAnalyzer();
            memoryIndices[i] = this.indexDoc(d, analyzer, memoryIndex).createSearcher().getIndexReader();
        }
        try {
            MultiReader mReader = new MultiReader(memoryIndices, true);
            LeafReader slowReader = SlowCompositeReaderWrapper.wrap((IndexReader)mReader);
            IndexSearcher slowSearcher = new IndexSearcher((IndexReader)slowReader);
            slowSearcher.setQueryCache(null);
            DocSearcher docSearcher = new DocSearcher(slowSearcher, rootDocMemoryIndex);
            context.initialize(docSearcher, parsedDocument);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to create index for percolator with nested document ", (Throwable)e, new Object[0]);
        }
    }

    MemoryIndex indexDoc(ParseContext.Document d, Analyzer analyzer, MemoryIndex memoryIndex) {
        for (IndexableField field : d.getFields()) {
            if (field.fieldType().indexOptions() == IndexOptions.NONE && field.name().equals("_uid")) continue;
            try {
                TokenStream tokenStream = field.tokenStream(analyzer, null);
                Throwable throwable = null;
                try {
                    if (tokenStream == null) continue;
                    memoryIndex.addField(field.name(), tokenStream, field.boost());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tokenStream == null) continue;
                    if (throwable != null) {
                        try {
                            tokenStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tokenStream.close();
                }
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to create token stream", (Throwable)e, new Object[0]);
            }
        }
        return memoryIndex;
    }

    private class DocSearcher
    extends Engine.Searcher {
        private final MemoryIndex rootDocMemoryIndex;

        private DocSearcher(IndexSearcher searcher, MemoryIndex rootDocMemoryIndex) {
            super("percolate", searcher);
            this.rootDocMemoryIndex = rootDocMemoryIndex;
        }

        @Override
        public void close() {
            try {
                this.reader().close();
                this.rootDocMemoryIndex.reset();
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to close IndexReader in percolator with nested doc", (Throwable)e, new Object[0]);
            }
        }
    }
}

