/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.Set;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public abstract class BaseRestHandler
extends AbstractComponent
implements RestHandler {
    private final RestController controller;
    private final Client client;
    protected final ParseFieldMatcher parseFieldMatcher;

    protected BaseRestHandler(Settings settings, RestController controller, Client client) {
        super(settings);
        this.controller = controller;
        this.client = client;
        this.parseFieldMatcher = new ParseFieldMatcher(settings);
    }

    @Override
    public final void handleRequest(RestRequest request, RestChannel channel) throws Exception {
        this.handleRequest(request, channel, new HeadersAndContextCopyClient(this.client, request, (Set<String>)this.controller.relevantHeaders()));
    }

    protected abstract void handleRequest(RestRequest var1, RestChannel var2, Client var3) throws Exception;

    static final class HeadersAndContextCopyClient
    extends FilterClient {
        private final RestRequest restRequest;
        private final Set<String> headers;

        HeadersAndContextCopyClient(Client in, RestRequest restRequest, Set<String> headers) {
            super(in);
            this.restRequest = restRequest;
            this.headers = headers;
        }

        private static void copyHeadersAndContext(ActionRequest actionRequest, RestRequest restRequest, Set<String> headers) {
            for (String usefulHeader : headers) {
                String headerValue = restRequest.header(usefulHeader);
                if (headerValue == null) continue;
                actionRequest.putHeader(usefulHeader, headerValue);
            }
            actionRequest.copyContextFrom(restRequest);
        }

        @Override
        protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
            HeadersAndContextCopyClient.copyHeadersAndContext(request, this.restRequest, this.headers);
            super.doExecute(action, request, listener);
        }
    }
}

