/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;

public class BuildingDetailPanel
extends ColopediaGameObjectTypePanel<BuildingType> {
    public BuildingDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.BUILDINGS.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        ArrayList<BuildingType> buildingTypes = new ArrayList<BuildingType>();
        HashMap<BuildingType, DefaultMutableTreeNode> buildingHash = new HashMap<BuildingType, DefaultMutableTreeNode>();
        for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
            if (buildingType.getUpgradesFrom() == null) {
                String name = Messages.getName(buildingType);
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(this, buildingType.getId(), name, new ImageIcon(ImageLibrary.getBuildingImage(buildingType, new Dimension(-1, ImageLibrary.ICON_SIZE.height)))));
                buildingHash.put(buildingType, item);
                parent.add(item);
                continue;
            }
            buildingTypes.add(buildingType);
        }
        while (!buildingTypes.isEmpty()) {
            Iterator iterator = buildingTypes.iterator();
            while (iterator.hasNext()) {
                BuildingType buildingType;
                buildingType = (BuildingType)iterator.next();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)buildingHash.get(buildingType.getUpgradesFrom());
                if (node == null) continue;
                String name = Messages.getName(buildingType);
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(this, buildingType.getId(), name, new ImageIcon(ImageLibrary.getBuildingImage(buildingType, new Dimension(-1, ImageLibrary.ICON_SIZE.height)))));
                node.add(item);
                buildingHash.put(buildingType, item);
                iterator.remove();
            }
        }
        root.add(parent);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        JComponent component2;
        if (this.getId().equals(id)) {
            return;
        }
        BuildingType buildingType = this.getSpecification().getBuildingType(id);
        panel.setLayout(new MigLayout("wrap 7, gapx 20", "", ""));
        JLabel name = Utility.localizedHeaderLabel(buildingType, FontLibrary.FontSize.SMALL);
        panel.add((Component)name, "span, align center, wrap 40");
        JTextPane textPane = Utility.getDefaultTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        try {
            if (buildingType.getUpgradesFrom() != null) {
                StyleConstants.setComponent(doc.getStyle("button"), this.getButton(buildingType.getUpgradesFrom()));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
            }
            if (buildingType.getRequiredPopulation() > 0) {
                StringTemplate template = StringTemplate.template("colopedia.buildings.requiredPopulation").addAmount("%number%", buildingType.getRequiredPopulation());
                doc.insertString(doc.getLength(), Messages.message(template) + "\n", doc.getStyle("regular"));
            }
            this.appendRequiredAbilities(doc, buildingType);
            panel.add((Component)Utility.localizedLabel("colopedia.buildings.requires"), "top");
            panel.add((Component)textPane, "span, growx");
        }
        catch (BadLocationException template) {
            // empty catch block
        }
        panel.add(Utility.localizedLabel("colopedia.buildings.cost"));
        if (!buildingType.needsGoodsToBuild()) {
            panel.add((Component)Utility.localizedLabel("colopedia.buildings.autoBuilt"), "span");
        } else {
            List<AbstractGoods> required = buildingType.getRequiredGoods();
            Object goodsRequired = required.get(0);
            if (required.size() > 1) {
                panel.add((Component)this.getGoodsButton(((AbstractGoods)goodsRequired).getType(), ((AbstractGoods)goodsRequired).getAmount()), "span, split " + required.size());
                for (int index = 1; index < required.size(); ++index) {
                    goodsRequired = required.get(index);
                    panel.add(this.getGoodsButton(((AbstractGoods)goodsRequired).getType(), ((AbstractGoods)goodsRequired).getAmount()));
                }
            } else {
                panel.add((Component)this.getGoodsButton(((AbstractGoods)goodsRequired).getType(), ((AbstractGoods)goodsRequired).getAmount()), "span");
            }
        }
        if (buildingType.hasAbility("model.ability.teach")) {
            panel.add((Component)Utility.localizedLabel("colopedia.buildings.teaches"), "newline, top");
            int count = 0;
            for (UnitType unitType2 : this.getSpecification().getUnitTypeList()) {
                if (!buildingType.canAdd(unitType2)) continue;
                if (count > 0 && count % 3 == 0) {
                    panel.add((Component)this.getButton(unitType2), "skip, span 2");
                } else {
                    panel.add((Component)this.getButton(unitType2), "span 2");
                }
                ++count;
            }
        } else {
            for (ProductionType pt : buildingType.getAvailableProductionTypes(false)) {
                List<AbstractGoods> inputs = pt.getInputs();
                List<AbstractGoods> outputs = pt.getOutputs();
                panel.add((Component)Utility.localizedLabel("colopedia.buildings.production"), "newline");
                if (!inputs.isEmpty()) {
                    panel.add((Component)this.getGoodsButton(inputs.get(0)), "span, split 3");
                    JLabel arrow = new JLabel("\u2192");
                    arrow.setFont(FontLibrary.createFont(FontLibrary.FontType.SIMPLE, FontLibrary.FontSize.SMALL, 1));
                    panel.add(arrow);
                }
                if (outputs.isEmpty()) continue;
                panel.add(this.getGoodsButton(outputs.get(0)));
            }
        }
        int workplaces = buildingType.getWorkPlaces();
        panel.add((Component)Utility.localizedLabel("colopedia.buildings.workplaces"), "newline");
        panel.add((Component)new JLabel(Integer.toString(workplaces)), "span");
        if (workplaces > 0) {
            panel.add((Component)Utility.localizedLabel("colopedia.buildings.specialist"), "newline");
            UnitType unitType = this.getSpecification().getExpertForProducing(buildingType.getProducedGoodsType());
            if (unitType == null) {
                panel.add((Component)Utility.localizedLabel("none"), "span");
            } else {
                panel.add((Component)this.getUnitButton(unitType), "span");
            }
        }
        ArrayList<JComponent> labels = new ArrayList<JComponent>();
        for (Modifier productionBonus : buildingType.getModifiers()) {
            component2 = this.getModifierComponent(productionBonus);
            if (component2 instanceof JButton) {
                labels.add(0, component2);
                continue;
            }
            labels.add(component2);
        }
        for (Ability ability : buildingType.getAbilities()) {
            component2 = this.getAbilityComponent(ability);
            if (component2 == null) continue;
            labels.add(component2);
        }
        if (!labels.isEmpty()) {
            panel.add((Component)Utility.localizedLabel(StringTemplate.template("colopedia.buildings.modifiers").addAmount("%number%", labels.size())), "newline, top");
            int count = 0;
            for (JComponent component2 : labels) {
                if (count > 0 && count % 2 == 0) {
                    panel.add((Component)component2, "skip, span 3");
                } else {
                    panel.add((Component)component2, "span 3");
                }
                ++count;
            }
        }
        panel.add((Component)Utility.localizedLabel("colopedia.buildings.notes"), "newline 20, top");
        panel.add((Component)Utility.localizedTextArea(Messages.descriptionKey(buildingType)), "span, growx");
    }
}

