/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class SetGoodsLevelsMessage
extends DOMMessage {
    private final String colonyId;
    private final ExportData data;

    public SetGoodsLevelsMessage(Colony colony, ExportData data) {
        super(SetGoodsLevelsMessage.getXMLElementTagName());
        this.colonyId = colony.getId();
        this.data = data;
    }

    public SetGoodsLevelsMessage(Game game, Element element) {
        super(SetGoodsLevelsMessage.getXMLElementTagName());
        this.colonyId = element.getAttribute("colony");
        this.data = new ExportData((Element)element.getChildNodes().item(0));
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            colony = player.getOurFreeColGameObject(this.colonyId, Colony.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().setGoodsLevels(serverPlayer, colony, this.data);
    }

    @Override
    public Element toXMLElement() {
        Element result = SetGoodsLevelsMessage.createMessage(SetGoodsLevelsMessage.getXMLElementTagName(), "colony", this.colonyId);
        result.appendChild(this.data.toXMLElement(result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "setGoodsLevels";
    }
}

