/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.IJadxArgs;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.core.clsp.ClspGraph;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.files.InputFile;
import jadx.core.xmlgen.ResTableParser;
import jadx.core.xmlgen.ResourceStorage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootNode {
    private static final Logger LOG = LoggerFactory.getLogger(RootNode.class);
    private final ErrorsCounter errorsCounter = new ErrorsCounter();
    private final IJadxArgs args;
    private List<DexNode> dexNodes;
    private Map<Integer, String> resourcesNames = new HashMap<Integer, String>();
    @Nullable
    private String appPackage;
    private ClassNode appResClass;
    private ClspGraph clsp;

    public RootNode(IJadxArgs args) {
        this.args = args;
    }

    public void load(List<InputFile> dexFiles) throws DecodeException {
        this.dexNodes = new ArrayList<DexNode>(dexFiles.size());
        for (InputFile dex : dexFiles) {
            DexNode dexNode;
            try {
                dexNode = new DexNode(this, dex);
            }
            catch (Exception e) {
                throw new DecodeException("Error decode file: " + dex, e);
            }
            this.dexNodes.add(dexNode);
        }
        for (DexNode dexNode : this.dexNodes) {
            dexNode.loadClasses();
        }
        this.initInnerClasses();
    }

    public void loadResources(List<ResourceFile> resources) {
        ResourceFile arsc = null;
        for (ResourceFile rf : resources) {
            if (rf.getType() != ResourceType.ARSC) continue;
            arsc = rf;
            break;
        }
        if (arsc == null) {
            LOG.debug("'.arsc' file not found");
            return;
        }
        final ResTableParser parser = new ResTableParser();
        try {
            ResourcesLoader.decodeStream(arsc, new ResourcesLoader.ResourceDecoder(){

                @Override
                public Object decode(long size, InputStream is) throws IOException {
                    parser.decode(is);
                    return null;
                }
            });
        }
        catch (JadxException e) {
            LOG.error("Failed to parse '.arsc' file", (Throwable)e);
            return;
        }
        ResourceStorage resStorage = parser.getResStorage();
        this.resourcesNames = resStorage.getResourcesNames();
        this.appPackage = resStorage.getAppPackage();
    }

    public void initAppResClass() {
        if (this.appPackage == null) {
            this.appResClass = this.makeClass("R");
            return;
        }
        String fullName = this.appPackage + ".R";
        ClassNode resCls = this.searchClassByName(fullName);
        this.appResClass = resCls != null ? resCls : this.makeClass(fullName);
    }

    private ClassNode makeClass(String clsName) {
        DexNode firstDex = this.dexNodes.get(0);
        ClassInfo r = ClassInfo.fromName(firstDex, clsName);
        return new ClassNode(firstDex, r);
    }

    public void initClassPath() throws DecodeException {
        try {
            if (this.clsp == null) {
                ClspGraph clsp = new ClspGraph();
                clsp.load();
                ArrayList<ClassNode> classes = new ArrayList<ClassNode>();
                for (DexNode dexNode : this.dexNodes) {
                    classes.addAll(dexNode.getClasses());
                }
                clsp.addApp(classes);
                this.clsp = clsp;
            }
        }
        catch (IOException e) {
            throw new DecodeException("Error loading classpath", e);
        }
    }

    private void initInnerClasses() {
        for (DexNode dexNode : this.dexNodes) {
            dexNode.initInnerClasses();
        }
    }

    public List<ClassNode> getClasses(boolean includeInner) {
        ArrayList<ClassNode> classes = new ArrayList<ClassNode>();
        for (DexNode dex : this.dexNodes) {
            if (includeInner) {
                classes.addAll(dex.getClasses());
                continue;
            }
            for (ClassNode cls : dex.getClasses()) {
                if (cls.getClassInfo().isInner()) continue;
                classes.add(cls);
            }
        }
        return classes;
    }

    public ClassNode searchClassByName(String fullName) {
        for (DexNode dexNode : this.dexNodes) {
            ClassInfo clsInfo;
            ClassNode cls = dexNode.resolveClass(clsInfo = ClassInfo.fromName(dexNode, fullName));
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    public List<DexNode> getDexNodes() {
        return this.dexNodes;
    }

    public ClspGraph getClsp() {
        return this.clsp;
    }

    public ErrorsCounter getErrorsCounter() {
        return this.errorsCounter;
    }

    public Map<Integer, String> getResourcesNames() {
        return this.resourcesNames;
    }

    @Nullable
    public String getAppPackage() {
        return this.appPackage;
    }

    public ClassNode getAppResClass() {
        return this.appResClass;
    }

    public IJadxArgs getArgs() {
        return this.args;
    }
}

