/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.fitness;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.EncogError;
import org.encog.ml.CalculateScore;
import org.encog.ml.MLMethod;
import org.encog.ml.fitness.FitnessObjective;

public class MultiObjectiveFitness
implements CalculateScore,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<FitnessObjective> objectives = new ArrayList<FitnessObjective>();
    private boolean min;

    public void addObjective(double weight, CalculateScore fitnessFunction) {
        if (this.objectives.size() == 0) {
            this.min = fitnessFunction.shouldMinimize();
        } else if (fitnessFunction.shouldMinimize() != this.min) {
            throw new EncogError("Multi-objective mismatch, some objectives are min and some are max.");
        }
        this.objectives.add(new FitnessObjective(weight, fitnessFunction));
    }

    @Override
    public double calculateScore(MLMethod method) {
        double result = 0.0;
        for (FitnessObjective obj : this.objectives) {
            result += obj.getScore().calculateScore(method) * obj.getWeight();
        }
        return result;
    }

    @Override
    public boolean shouldMinimize() {
        return this.min;
    }

    @Override
    public boolean requireSingleThreaded() {
        for (FitnessObjective obj : this.objectives) {
            if (!obj.getScore().requireSingleThreaded()) continue;
            return true;
        }
        return false;
    }
}

