/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.svm.training;

import org.encog.EncogError;
import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.svm.KernelType;
import org.encog.ml.svm.SVM;
import org.encog.ml.svm.training.SVMTrain;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.networks.training.propagation.TrainingContinuation;

public class SVMSearchTrain
extends BasicTraining {
    public static final double DEFAULT_CONST_BEGIN = 1.0;
    public static final double DEFAULT_CONST_END = 15.0;
    public static final double DEFAULT_CONST_STEP = 2.0;
    public static final double DEFAULT_GAMMA_BEGIN = 1.0;
    public static final double DEFAULT_GAMMA_END = 10.0;
    public static final double DEFAULT_GAMMA_STEP = 1.0;
    private final SVM network;
    private int fold = 0;
    private double constBegin = 1.0;
    private double constStep = 2.0;
    private double constEnd = 15.0;
    private double gammaBegin = 1.0;
    private double gammaEnd = 10.0;
    private double gammaStep = 1.0;
    private double bestConst;
    private double bestGamma;
    private double bestError;
    private double currentConst;
    private double currentGamma;
    private boolean isSetup;
    private boolean trainingDone;
    private final SVMTrain internalTrain;

    public SVMSearchTrain(SVM method, MLDataSet training) {
        super(TrainingImplementationType.Iterative);
        this.network = method;
        this.setTraining(training);
        this.isSetup = false;
        this.trainingDone = false;
        this.internalTrain = new SVMTrain(this.network, training);
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    @Override
    public void finishTraining() {
        this.internalTrain.setGamma(this.bestGamma);
        this.internalTrain.setC(this.bestConst);
        this.internalTrain.iteration();
    }

    public double getConstBegin() {
        return this.constBegin;
    }

    public double getConstEnd() {
        return this.constEnd;
    }

    public double getConstStep() {
        return this.constStep;
    }

    public int getFold() {
        return this.fold;
    }

    public double getGammaBegin() {
        return this.gammaBegin;
    }

    public double getGammaEnd() {
        return this.gammaEnd;
    }

    public double getGammaStep() {
        return this.gammaStep;
    }

    @Override
    public MLMethod getMethod() {
        return this.network;
    }

    @Override
    public boolean isTrainingDone() {
        return this.trainingDone;
    }

    @Override
    public void iteration() {
        if (!this.trainingDone) {
            if (!this.isSetup) {
                this.setup();
            }
            this.preIteration();
            this.internalTrain.setFold(this.fold);
            if (this.network.getKernelType() == KernelType.RadialBasisFunction) {
                this.internalTrain.setGamma(this.currentGamma);
                this.internalTrain.setC(this.currentConst);
                double e = 0.0;
                this.internalTrain.iteration();
                e = this.internalTrain.getError();
                if (!Double.isNaN(e) && e < this.bestError) {
                    this.bestConst = this.currentConst;
                    this.bestGamma = this.currentGamma;
                    this.bestError = e;
                }
                this.currentConst += this.constStep;
                if (this.currentConst > this.constEnd) {
                    this.currentConst = this.constBegin;
                    this.currentGamma += this.gammaStep;
                    if (this.currentGamma > this.gammaEnd) {
                        this.trainingDone = true;
                    }
                }
                this.setError(this.bestError);
            } else {
                this.internalTrain.setGamma(this.currentGamma);
                this.internalTrain.setC(this.currentConst);
                this.internalTrain.iteration();
            }
            this.postIteration();
        }
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }

    public void setConstBegin(double theConstBegin) {
        this.constBegin = theConstBegin;
    }

    public void setConstEnd(double theConstEnd) {
        this.constEnd = theConstEnd;
    }

    public void setConstStep(double theConstStep) {
        this.constStep = theConstStep;
    }

    public void setFold(int theFold) {
        this.fold = theFold;
    }

    public void setGammaBegin(double theGammaBegin) {
        this.gammaBegin = theGammaBegin;
    }

    public final void setGammaEnd(double theGammaEnd) {
        this.gammaEnd = theGammaEnd;
    }

    public final void setGammaStep(double theGammaStep) {
        this.gammaStep = theGammaStep;
    }

    private void setup() {
        this.currentConst = this.constBegin;
        this.currentGamma = this.gammaBegin;
        this.bestError = Double.POSITIVE_INFINITY;
        this.isSetup = true;
        if (this.currentGamma <= 0.0 || this.currentGamma < 1.0E-13) {
            throw new EncogError("SVM search training cannot use a gamma value less than zero.");
        }
        if (this.currentConst <= 0.0 || this.currentConst < 1.0E-13) {
            throw new EncogError("SVM search training cannot use a const value less than zero.");
        }
        if (this.gammaStep < 0.0) {
            throw new EncogError("SVM search gamma step cannot use a const value less than zero.");
        }
        if (this.constStep < 0.0) {
            throw new EncogError("SVM search const step cannot use a const value less than zero.");
        }
    }

    public double getBestConst() {
        return this.bestConst;
    }

    public void setBestConst(double bestConst) {
        this.bestConst = bestConst;
    }

    public double getBestGamma() {
        return this.bestGamma;
    }

    public void setBestGamma(double bestGamma) {
        this.bestGamma = bestGamma;
    }
}

